/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate.dao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dao.ICalculateBalanceDao;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceInitOrAnti;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class CalculateBalanceDao
implements ICalculateBalanceDao {
    private static final Log logger = LogFactory.getLog(CalculateBalanceDao.class);
    private static final String balanceProperties = "id, org, account, currency, monthstart, monthbalance, startdate, year, month, enddate, payamount, revenueamount, stroke, isreset, isupgrade, yearstart, yearbalance, yearpayamount, yearrecamount";
    private static final String balanceLogProperties = "id, org, bankacct, cashacct, currency, bizdate, amount, isdebit, sourcebillid, sourcebillno, count, isdo, operatetype, balancetype";

    public static CalculateBalanceDao getInstance() {
        return Singleton.INSTANCE;
    }

    @Override
    public Map<String, BalanceData> getDataSource(Set<Long> orgIds, String tableName, String entityName) {
        QFilter qFilter = new QFilter("org", "in", orgIds);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject[] dataSet = BusinessDataServiceHelper.load((String)entityName, (String)balanceProperties, (QFilter[])qFilters);
        return this.dealDateSource(dataSet, tableName);
    }

    @Override
    public Map<String, BalanceData> getDataSource(Set<Long> orgIds, Set<Long> accountIds, Set<Long> currencyIds, String tableName, String entityName, Date minStartDate, Date maxEndDate) {
        QFilter qFilter = new QFilter("enddate", "<=", (Object)maxEndDate);
        if (orgIds != null && orgIds.size() > 0) {
            qFilter.and(new QFilter("org", "in", orgIds));
        }
        if (accountIds != null && accountIds.size() > 0) {
            qFilter.and("account", "in", accountIds);
        }
        if (currencyIds != null && currencyIds.size() > 0) {
            qFilter.and("currency", "in", currencyIds);
        }
        logger.info("getDataSource_filter_formId:{};filter:{}", (Object)entityName, (Object)qFilter.toString());
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject[] dataSet = BusinessDataServiceHelper.load((String)entityName, (String)balanceProperties, (QFilter[])qFilters);
        return this.dealDateSource(dataSet, tableName);
    }

    @Override
    public Set<Long> getUndoBalanceLogIds() throws Exception {
        DynamicObject[] undoBalanceLog = BusinessDataServiceHelper.load((String)"cas_balancelog_occur", (String)"id", (QFilter[])new QFilter[]{new QFilter("isdo", "=", (Object)"0")});
        Set<Long> undoBalanceLogIds = Arrays.stream(undoBalanceLog).map(o -> o.getLong("id")).collect(Collectors.toSet());
        return undoBalanceLogIds;
    }

    private Map<String, BalanceData> dealDateSource(DynamicObject[] dataSet, String tableName) {
        HashMap<String, BalanceData> dataSourceBalances = new HashMap<String, BalanceData>(32);
        for (DynamicObject data : dataSet) {
            Long orgId = null;
            DynamicObject org = data.getDynamicObject("org");
            String orgName = "";
            if (org != null && EmptyUtil.isNoEmpty((DynamicObject)org)) {
                orgId = org.getLong("id");
                orgName = org.getString("name");
            } else {
                orgId = data.getLong("org_id");
            }
            DynamicObject account = data.getDynamicObject("account");
            Long accountId = null;
            accountId = account != null && EmptyUtil.isNoEmpty((DynamicObject)account) ? Long.valueOf(account.getLong("id")) : Long.valueOf(data.getLong("account_id"));
            if (accountId == null) {
                logger.error("do dealDateSource method , the org:{}, table name:{}, accountId is null .....", (Object)orgId, (Object)tableName);
                continue;
            }
            Long currencyId = null;
            String currencyName = null;
            DynamicObject currency = data.getDynamicObject("currency");
            if (currency != null && EmptyUtil.isNoEmpty((DynamicObject)currency)) {
                currencyId = currency.getLong("id");
                currencyName = currency.getString("name");
            } else {
                currencyId = data.getLong("currency_id");
                ArrayList<String> curNameList = new ArrayList<String>(10);
                Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currencyId)});
                if (currencyMap != null && currencyMap.size() > 0) {
                    for (DynamicObject cur : currencyMap.values()) {
                        curNameList.add(cur.getString("name"));
                    }
                }
                if (curNameList.size() > 0) {
                    currencyName = (String)curNameList.get(0);
                }
            }
            if (currencyId == null) {
                logger.error("do dealDateSource method , the org:{}, table name:{}, currencyId is null .....", (Object)orgId, (Object)tableName);
                continue;
            }
            String latKey = this.getFindKey(orgId, accountId, currencyId);
            BalanceData balanceData = (BalanceData)dataSourceBalances.get(latKey);
            if (balanceData == null) {
                balanceData = new BalanceData();
                dataSourceBalances.put(latKey, balanceData);
            }
            Date startDate = data.getDate("startdate");
            balanceData.setStartDate(startDate);
            Balance balance = new Balance();
            balance.setBalanceTableName(tableName);
            balance.setBalanceKey(latKey);
            balance.setId(data.getLong("id"));
            balance.setOrgId(orgId);
            balance.setOrgName(orgName);
            balance.setAccountId(accountId);
            balance.setCurrencyId(currencyId);
            balance.setCurrencyName(currencyName);
            balance.setMonthStart(data.getBigDecimal("monthstart"));
            balance.setMonthBalance(data.getBigDecimal("monthbalance"));
            balance.setStartDate(startDate);
            balance.setEndDate(data.getDate("enddate"));
            balance.setYear(data.getInt("year"));
            balance.setMonth(data.getInt("month"));
            balance.setPayAmount(data.getBigDecimal("payamount"));
            balance.setRevenueAmount(data.getBigDecimal("revenueamount"));
            balance.setStroke(data.getInt("stroke"));
            balance.setReset(data.getBoolean("isreset"));
            balance.setYearPayAmount(data.getBigDecimal("yearpayamount"));
            balance.setYearRecAmount(data.getBigDecimal("yearrecamount"));
            balance.setYearStart(BalanceUtil.dealBigDecimal(data.getBigDecimal("yearstart")));
            balance.setYearBalance(BalanceUtil.dealBigDecimal(data.getBigDecimal("yearbalance")));
            balance.setState(BalanceUtil.isState(tableName));
            balanceData.setBalance(balance);
            balanceData.setEndDate(data.getDate("enddate"));
            balanceData.setOrgId(orgId);
        }
        return dataSourceBalances;
    }

    private String getFindKey(Long orgId, Long acctId, Long currencyId) {
        return StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgId, acctId, currencyId});
    }

    @Override
    public Map<String, BalanceData> balanceData4Daily(RequestBalanceParameter requestBalanceParameter, String type, String balanceTableName) {
        Set<Long> orgIds = requestBalanceParameter.getOrgIds();
        Long orgId = orgIds.iterator().next();
        Set<Long> accountIds = requestBalanceParameter.getAccountIds();
        Set<Long> currencyIds = requestBalanceParameter.getCurrencyIds();
        Date queryStartDate = requestBalanceParameter.getStartDate();
        Date queryEndDate = requestBalanceParameter.getEndDate();
        boolean computeCurrent = requestBalanceParameter.getRecomputeCurrent();
        Map<Long, DynamicObject> startInitState = null;
        Map<String, Boolean> resetJournals = null;
        if (BalanceType.STATE.getValue().equals(type)) {
            startInitState = requestBalanceParameter.getStartInitState();
        } else {
            resetJournals = requestBalanceParameter.getResetJournals();
        }
        QFilter qFilter = new QFilter("org", "in", orgIds);
        if (currencyIds != null && currencyIds.size() > 0) {
            qFilter.and(new QFilter("currency", "in", currencyIds));
        }
        if (computeCurrent) {
            if (BalanceType.STATE.getValue().equals(type)) {
                qFilter.and(new QFilter("bizdate", ">=", (Object)queryStartDate)).and(new QFilter("bizdate", "<=", (Object)queryEndDate));
            } else {
                qFilter.and(new QFilter("bookdate", ">=", (Object)queryStartDate)).and(new QFilter("bookdate", "<=", (Object)queryEndDate));
            }
        } else if (BalanceType.STATE.getValue().equals(type)) {
            qFilter.and(new QFilter("bizdate", ">=", (Object)queryStartDate));
        } else {
            qFilter.and(new QFilter("bookdate", ">=", (Object)queryStartDate));
        }
        if (accountIds != null && accountIds.size() > 0) {
            ArrayList<Long> accountListIds = new ArrayList<Long>(accountIds.size());
            accountListIds.addAll(accountIds);
            if (BalanceType.CASH.getValue().equals(type)) {
                qFilter.and(new QFilter("accountcash", "in", accountListIds));
            } else {
                qFilter.and(new QFilter("accountbank", "in", accountListIds));
            }
        }
        String properties = "";
        properties = BalanceType.CASH.getValue().equals(type) ? "id, org, accountcash, currency, bookdate, debitamount, creditamount" : (BalanceType.JOURNAL.getValue().equals(type) ? "id, org, accountbank, currency, bookdate, debitamount, creditamount" : "id, org, accountbank, currency, bizdate, debitamount, creditamount");
        String tableName = "";
        if (BalanceType.CASH.getValue().equals(type)) {
            tableName = "cas_cashjournal";
        } else if (BalanceType.JOURNAL.getValue().equals(type)) {
            tableName = "cas_bankjournal";
        } else if (BalanceType.STATE.getValue().equals(type)) {
            tableName = "cas_bankstatement";
        }
        DynamicObject[] dataSet = BusinessDataServiceHelper.load((String)tableName, (String)properties, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, BalanceData> dailyBalances = new HashMap<String, BalanceData>(32);
        for (DynamicObject data : dataSet) {
            Long periodId;
            String strKey;
            Long periodId2;
            Long initStartPeriodId;
            DynamicObject initStartPeriod;
            Long orgID = null;
            DynamicObject org = data.getDynamicObject("org");
            if (org != null && EmptyUtil.isNoEmpty((DynamicObject)org)) {
                orgID = org.getLong("id");
            } else {
                logger.warn("do method of balanceData4Daily ,the org is null, so get org_id, org:{}, type:{}", (Object)orgId, (Object)type);
                orgID = data.getLong("org_id");
            }
            Long acctId = null;
            DynamicObject account = null;
            if (BalanceType.CASH.getValue().equals(type)) {
                account = data.getDynamicObject("accountcash");
                if (account != null && EmptyUtil.isNoEmpty((DynamicObject)account)) {
                    acctId = account.getLong("id");
                } else {
                    logger.warn("do method of balanceData4Daily ,the account is null, so get accountcash_id, org:{}, type:{}", (Object)orgId, (Object)type);
                    acctId = data.getLong("accountcash_id");
                }
            } else {
                account = data.getDynamicObject("accountbank");
                if (account != null && EmptyUtil.isNoEmpty((DynamicObject)account)) {
                    acctId = account.getLong("id");
                } else {
                    logger.warn("do method of balanceData4Daily ,the account null, so get accountbank_id, org:{}, type:{}", (Object)orgId, (Object)type);
                    acctId = data.getLong("accountbank_id");
                }
            }
            if (acctId == null) {
                logger.error("do method of balanceData4Daily ,the acctId is null, org:{}, type:{}", (Object)orgId, (Object)type);
                continue;
            }
            DynamicObject currencyObject = data.getDynamicObject("currency");
            Long currencyId = null;
            currencyId = currencyObject != null && EmptyUtil.isNoEmpty((DynamicObject)currencyObject) ? Long.valueOf(currencyObject.getLong("id")) : Long.valueOf(data.getLong("currency_id"));
            if (currencyId == null) {
                logger.warn("do method of balanceData4Daily ,the currencyId is null, org:{}, type:{}", (Object)orgId, (Object)type);
                continue;
            }
            Date date = null;
            date = BalanceType.STATE.getValue().equals(type) ? data.getDate("bizdate") : data.getDate("bookdate");
            DynamicObject period = PeriodHelper.getPeriodByDate((long)orgID, (Date)date);
            Date startDate = period.getDate("begindate");
            String latKey = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgID, acctId, currencyId});
            BalanceData balanceData = (BalanceData)dailyBalances.get(latKey);
            if (balanceData == null) {
                balanceData = new BalanceData();
                dailyBalances.put(latKey, balanceData);
            }
            BigDecimal debitAmount = data.getBigDecimal("debitamount");
            BigDecimal creditAmount = data.getBigDecimal("creditamount");
            BigDecimal amount = BigDecimal.ZERO;
            if (BalanceType.STATE.getValue().equals(type)) {
                if (BigDecimal.ZERO.compareTo(debitAmount) != 0) {
                    amount = amount.subtract(debitAmount);
                }
                if (BigDecimal.ZERO.compareTo(creditAmount) != 0) {
                    amount = amount.add(creditAmount);
                }
            } else {
                if (BigDecimal.ZERO.compareTo(debitAmount) != 0) {
                    amount = amount.add(debitAmount);
                }
                if (BigDecimal.ZERO.compareTo(creditAmount) != 0) {
                    amount = amount.subtract(creditAmount);
                }
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal receiveAmount = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(debitAmount) != 0) {
                if (BalanceType.STATE.getValue().equals(type)) {
                    payAmount = debitAmount;
                } else {
                    receiveAmount = debitAmount;
                }
            }
            if (BigDecimal.ZERO.compareTo(creditAmount) != 0) {
                if (BalanceType.STATE.getValue().equals(type)) {
                    receiveAmount = creditAmount;
                } else {
                    payAmount = creditAmount;
                }
            }
            Balance balance = new Balance();
            balance.setBalanceTableName(balanceTableName);
            balance.setOrgId(orgID);
            balance.setAccountId(acctId);
            balance.setCurrencyId(currencyId);
            balance.setMonthBalance(amount);
            balance.setPayAmount(payAmount);
            balance.setRevenueAmount(receiveAmount);
            balance.setStartDate(startDate);
            balance.setEndDate(period.getDate("enddate"));
            balance.setYear(period.getInt("periodyear"));
            balance.setMonth(period.getInt("periodnumber"));
            balance.setStroke(1);
            balance.setReset(false);
            balance.setYearPayAmount(payAmount);
            balance.setYearRecAmount(receiveAmount);
            if (startInitState != null && startInitState.size() > 0 && (initStartPeriod = startInitState.get(orgID)) != null && EmptyUtil.isNoEmpty((DynamicObject)initStartPeriod) && (initStartPeriodId = Long.valueOf(initStartPeriod.getLong("id"))).compareTo(periodId2 = Long.valueOf(period.getLong("id"))) == 0) {
                balance.setReset(true);
            }
            if (resetJournals != null && resetJournals.size() > 0 && resetJournals.get(strKey = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{type, orgID, acctId, currencyId, periodId = Long.valueOf(period.getLong("id"))})) != null && resetJournals.get(strKey).booleanValue()) {
                balance.setReset(true);
            }
            balanceData.setBalance(balance);
            balanceData.setStartDate(startDate);
        }
        return dailyBalances;
    }

    @Override
    public Map<String, BalanceData> balanceData4Log(String type, String tableName, Set<Long> orgIds) {
        QFilter qFilter = new QFilter("balancetype", "=", (Object)type).and(new QFilter("isdo", "=", (Object)"0"));
        DynamicObject[] dataSet = BusinessDataServiceHelper.load((String)"cas_balancelog_occur", (String)balanceLogProperties, (QFilter[])new QFilter[]{qFilter});
        HashMap<String, BalanceData> logModelBalances = new HashMap<String, BalanceData>(32);
        for (DynamicObject data : dataSet) {
            DynamicObject bank;
            DynamicObject cash;
            Long orgId = null;
            DynamicObject org = data.getDynamicObject("org");
            orgId = org != null && EmptyUtil.isNoEmpty((DynamicObject)org) ? Long.valueOf(org.getLong("id")) : Long.valueOf(data.getLong("org_id"));
            orgIds.add(orgId);
            Long accountId = null;
            accountId = BalanceType.CASH.getValue().equals(type) ? ((cash = data.getDynamicObject("cashacct")) != null && EmptyUtil.isNoEmpty((DynamicObject)cash) ? Long.valueOf(cash.getLong("id")) : Long.valueOf(data.getLong("cashacct_id"))) : ((bank = data.getDynamicObject("bankacct")) != null && EmptyUtil.isNoEmpty((DynamicObject)bank) ? Long.valueOf(bank.getLong("id")) : Long.valueOf(data.getLong("bankacct_id")));
            if (accountId == null) {
                logger.error("do balanceData4Log accountId is null, org:{}, type:{}", (Object)orgId, (Object)type);
                continue;
            }
            Long currencyId = null;
            DynamicObject currency = data.getDynamicObject("currency");
            currencyId = currency != null && EmptyUtil.isNoEmpty((DynamicObject)currency) ? Long.valueOf(currency.getLong("id")) : Long.valueOf(data.getLong("currency_id"));
            if (currencyId == null) {
                logger.error("do balanceData4Log currencyId is null, org:{}, type:{}", (Object)orgId, (Object)type);
                continue;
            }
            String latKey = StringUtils.joinKeyString((String)"_", (Object[])new Object[]{orgId, accountId, currencyId});
            BalanceData balanceData = (BalanceData)logModelBalances.get(latKey);
            if (balanceData == null) {
                balanceData = new BalanceData();
                logModelBalances.put(latKey, balanceData);
            }
            Date date = data.getDate("bizdate");
            DynamicObject period = PeriodHelper.getPeriodByDate((long)orgId, (Date)date);
            Date startDate = period.getDate("begindate");
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal revenueAmount = BigDecimal.ZERO;
            boolean isDebit = data.getBoolean("isdebit");
            BigDecimal fAmount = data.getBigDecimal("amount");
            if (BalanceType.STATE.getValue().equals(type)) {
                if (isDebit) {
                    payAmount = fAmount.negate();
                } else {
                    revenueAmount = fAmount;
                }
            } else if (isDebit) {
                revenueAmount = fAmount;
            } else {
                payAmount = fAmount.negate();
            }
            HashSet<Long> balanceLogIds = new HashSet<Long>(2);
            balanceLogIds.add(data.getLong("id"));
            Balance balance = new Balance();
            balance.setBalanceTableName(tableName);
            balance.setAccountId(accountId);
            balance.setOrgId(orgId);
            balance.setCurrencyId(currencyId);
            balance.setStartDate(startDate);
            balance.setEndDate(period.getDate("enddate"));
            balance.setMonthBalance(fAmount);
            balance.setPayAmount(payAmount);
            balance.setRevenueAmount(revenueAmount);
            balance.setYear(period.getInt("periodyear"));
            balance.setMonth(period.getInt("periodnumber"));
            balance.setReset(false);
            balance.setStroke(data.getInt("count"));
            balance.setBalanceLogIds(balanceLogIds);
            balance.setYearPayAmount(payAmount);
            balance.setYearRecAmount(revenueAmount);
            balanceData.setBalance(balance);
            balanceData.setStartDate(startDate);
        }
        return logModelBalances;
    }

    @Override
    public BalanceInitOrAnti balance4InitORAnti() {
        DynamicObject[] initOrAntiInits = BusinessDataServiceHelper.load((String)"cas_balancelog_init", (String)"id, org, bankacct, cashacct, currency, amount, isdo, balancetype, period, formtype, creatdate, yeardebit, yearcredit", (QFilter[])new QFilter[]{new QFilter("isdo", "=", (Object)"0")}, (String)"id ASC");
        BalanceInitOrAnti balanceInitOrAnti = new BalanceInitOrAnti();
        for (DynamicObject initOrAntiInit : initOrAntiInits) {
            BalanceInitOrAnti.BalanceInitOrAntiInit bai = new BalanceInitOrAnti.BalanceInitOrAntiInit();
            bai.setId(initOrAntiInit.getLong("id"));
            bai.setOrg(initOrAntiInit.getDynamicObject("org"));
            bai.setBankAcct(initOrAntiInit.getDynamicObject("bankacct"));
            bai.setCashAcct(initOrAntiInit.getDynamicObject("cashacct"));
            bai.setCurrency(initOrAntiInit.getDynamicObject("currency"));
            bai.setAmount(initOrAntiInit.getBigDecimal("amount"));
            bai.setBalanceType(initOrAntiInit.getString("balancetype"));
            bai.setPeriod(initOrAntiInit.getDynamicObject("period"));
            bai.setFormType(initOrAntiInit.getString("formtype"));
            bai.setCreateDate(initOrAntiInit.getDate("creatdate"));
            BigDecimal yearCredit = initOrAntiInit.getBigDecimal("yearcredit");
            BigDecimal yearDebit = initOrAntiInit.getBigDecimal("yeardebit");
            bai.setYearCredit(yearCredit == null ? BigDecimal.ZERO : yearCredit);
            bai.setYearDebit(yearDebit == null ? BigDecimal.ZERO : yearDebit);
            balanceInitOrAnti.addBalanceInitOrAnti(bai);
        }
        return balanceInitOrAnti;
    }

    static class Singleton {
        private static final CalculateBalanceDao INSTANCE = new CalculateBalanceDao();

        Singleton() {
        }
    }
}

