/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.calculate.dao;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dao.PersistBalanceInfo;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.util.BalanceUtil;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.TmcBusinessBaseHelper;
import kd.fi.cas.util.EmptyUtil;

public class PersistBalanceData {
    private static final Log logger = LogFactory.getLog(PersistBalanceData.class);
    private Set<Long> balanceLogIds = new HashSet<Long>(32);
    private Set<Long> initLogIds = new HashSet<Long>(32);
    Map<String, PersistBalanceInfo> updateData = new HashMap<String, PersistBalanceInfo>(32);
    Map<String, PersistBalanceInfo> saveData = new HashMap<String, PersistBalanceInfo>(32);

    public void updateBalance(Balance data) throws Exception {
        try (TXHandle tx = TX.required();){
            try {
                String tableName = data.getBalanceTableName();
                PersistBalanceInfo persistBalanceInfo = this.updateData.get(tableName);
                Timestamp startTime = new Timestamp(data.getStartDate().getTime());
                if (persistBalanceInfo == null || EmptyUtil.isEmpty((Object)persistBalanceInfo)) {
                    ArrayList<Object[]> batchParam = new ArrayList<Object[]>(24);
                    String sql = " UPDATE " + data.getBalanceTableName() + " SET  FMonthStart = ?, FMonthBalance=?, fpayamount=?, frevenueamount=?, fstroke=?, fisreset=?, fyearstart=?, fyearbalance=?, fyearpayamount=?, fyearrecamount=? WHERE forgid=? AND faccountid=? AND FCurrencyID=? AND fstartdate=to_date(?) ";
                    batchParam.add(new Object[]{data.getMonthStart(), data.getMonthBalance(), data.getPayAmount(), data.getRevenueAmount(), data.getStroke(), data.isReset(), BalanceUtil.dealBigDecimal(data.getYearStart()), BalanceUtil.dealBigDecimal(data.getYearBalance()), BalanceUtil.dealBigDecimal(data.getYearPayAmount()), BalanceUtil.dealBigDecimal(data.getYearRecAmount()), data.getOrgId(), data.getAccountId(), data.getCurrencyId(), startTime});
                    PersistBalanceInfo pbi = new PersistBalanceInfo(sql, batchParam);
                    this.updateData.put(tableName, pbi);
                } else {
                    List<Object[]> batchParam = persistBalanceInfo.getParameters();
                    batchParam.add(new Object[]{data.getMonthStart(), data.getMonthBalance(), data.getPayAmount(), data.getRevenueAmount(), data.getStroke(), data.isReset(), BalanceUtil.dealBigDecimal(data.getYearStart()), BalanceUtil.dealBigDecimal(data.getYearBalance()), BalanceUtil.dealBigDecimal(data.getYearPayAmount()), BalanceUtil.dealBigDecimal(data.getYearRecAmount()), data.getOrgId(), data.getAccountId(), data.getCurrencyId(), startTime});
                }
                if (data.getBalanceLogIds() != null && data.getBalanceLogIds().size() > 0) {
                    this.balanceLogIds.addAll(data.getBalanceLogIds());
                }
                if (data.getInitLogIds() != null && data.getInitLogIds().size() > 0) {
                    this.initLogIds.addAll(data.getInitLogIds());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("error:", (Throwable)e);
                throw e;
            }
        }
    }

    public void saveBalance(Balance data) throws Exception {
        try (TXHandle tx = TX.required();){
            try {
                String tableName = data.getBalanceTableName();
                PersistBalanceInfo persistBalanceInfo = this.saveData.get(tableName);
                Timestamp startTime = new Timestamp(data.getStartDate().getTime());
                Timestamp endTime = new Timestamp(data.getEndDate().getTime());
                if (persistBalanceInfo == null || EmptyUtil.isEmpty((Object)persistBalanceInfo)) {
                    long[] ids = DBServiceHelper.genLongIds((String)data.getBalanceTableName(), (int)1);
                    String sql = " INSERT INTO " + data.getBalanceTableName() + "(fid, forgid, FCurrencyID, FMonthStart, FMonthBalance, fstartdate, fenddate,  fyear, fmonth,  fpayamount, frevenueamount, fstroke, faccountid, fisreset, fyearstart, fyearbalance, fyearpayamount, fyearrecamount)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    ArrayList<Object[]> batchParam = new ArrayList<Object[]>(24);
                    batchParam.add(new Object[]{ids[0], data.getOrgId(), data.getCurrencyId(), data.getMonthStart(), data.getMonthBalance(), startTime, endTime, data.getYear(), data.getMonth(), data.getPayAmount(), data.getRevenueAmount(), data.getStroke(), data.getAccountId(), data.getReset(), BalanceUtil.dealBigDecimal(data.getYearStart()), BalanceUtil.dealBigDecimal(data.getYearBalance()), BalanceUtil.dealBigDecimal(data.getYearPayAmount()), BalanceUtil.dealBigDecimal(data.getYearRecAmount())});
                    PersistBalanceInfo pbi = new PersistBalanceInfo(sql, batchParam);
                    this.saveData.put(tableName, pbi);
                } else {
                    List<Object[]> batchParam = persistBalanceInfo.getParameters();
                    long[] ids = DBServiceHelper.genLongIds((String)data.getBalanceTableName(), (int)1);
                    batchParam.add(new Object[]{ids[0], data.getOrgId(), data.getCurrencyId(), data.getMonthStart(), data.getMonthBalance(), startTime, endTime, data.getYear(), data.getMonth(), data.getPayAmount(), data.getRevenueAmount(), data.getStroke(), data.getAccountId(), data.getReset(), BalanceUtil.dealBigDecimal(data.getYearStart()), BalanceUtil.dealBigDecimal(data.getYearBalance()), BalanceUtil.dealBigDecimal(data.getYearPayAmount()), BalanceUtil.dealBigDecimal(data.getYearRecAmount())});
                }
                if (data.getBalanceLogIds() != null && data.getBalanceLogIds().size() > 0) {
                    this.balanceLogIds.addAll(data.getBalanceLogIds());
                }
                if (data.getInitLogIds() != null && data.getInitLogIds().size() > 0) {
                    this.initLogIds.addAll(data.getInitLogIds());
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("error:", (Throwable)e);
                throw e;
            }
        }
    }

    public void flush() throws Exception {
        try (TXHandle tx = TX.required();){
            try {
                this.persistBalanceData();
                this.updateBalanceLog();
                this.updateIniLog();
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("error:", (Throwable)e);
                throw e;
            }
        }
        this.clear();
    }

    private void persistBalanceData() throws Exception {
        try (TXHandle tx = TX.required();){
            try {
                if (this.saveData.size() > 0) {
                    for (PersistBalanceInfo pbi : this.saveData.values()) {
                        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)pbi.getSql(), pbi.getParameters());
                    }
                }
                if (this.updateData.size() > 0) {
                    for (PersistBalanceInfo pbi : this.updateData.values()) {
                        DB.executeBatch((DBRoute)DBRouteConst.cas, (String)pbi.getSql(), pbi.getParameters());
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("error:", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateBalanceLog() throws Exception {
        if (this.balanceLogIds.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                ArrayList<Long> listIds = new ArrayList<Long>(this.balanceLogIds.size());
                listIds.addAll(this.balanceLogIds);
                String sql = "UPDATE t_cas_balancelog  SET fisdo = 1  WHERE fid IN(" + TmcBusinessBaseHelper.idListToString(listIds) + ")";
                DB.execute((DBRoute)DBRouteConst.cas, (String)sql);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("error:", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateIniLog() throws Exception {
        if (this.initLogIds.size() == 0) {
            return;
        }
        try (TXHandle tx = TX.required();){
            try {
                ArrayList<Long> listIds = new ArrayList<Long>(this.initLogIds.size());
                listIds.addAll(this.initLogIds);
                String sql = "UPDATE t_cas_balancelog_init  SET fisdo = 1  WHERE fid IN(" + TmcBusinessBaseHelper.idListToString(listIds) + ")";
                DB.execute((DBRoute)DBRouteConst.cas, (String)sql);
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("error:", (Throwable)e);
                throw e;
            }
        }
    }

    public void clear() {
        this.saveData.clear();
        this.updateData.clear();
        this.balanceLogIds.clear();
        this.initLogIds.clear();
    }

    public void setBalanceLogIds(Set<Long> balanceLogIds) {
        this.balanceLogIds.addAll(balanceLogIds);
    }
}

