/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.log.type;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.balancemodel.log.bean.BillDataInfo;
import kd.fi.cas.business.balancemodel.log.bean.OccurDataInfo;
import kd.fi.cas.util.DateUtils;

public class BalanceModelLogUtil {
    private static final Log log = LogFactory.getLog(BalanceModelLogUtil.class);

    public static String getInsertSql(String table, List<String> fields) {
        String fieldstr = StringUtils.join((Object[])fields.toArray(), (String)",");
        ArrayList values = new ArrayList(fields.size());
        fields.forEach(e -> values.add("?"));
        return StringUtils.join((Object[])new String[]{"insert into ", table, " (", fieldstr, ")  values (", StringUtils.join((Object[])values.toArray(), (String)" , "), ")"});
    }

    public static void executeBatch(DBRoute dbRoute, String table, String sql, List<Object[]> values) {
        if (CollectionUtils.isEmpty(values) || values.size() == 0) {
            return;
        }
        log.info("{}executeBatch.values.size:{}", (Object)"casBalanceModelLog:", (Object)values.size());
        BalanceModelLogUtil.doInsertObjFID(table, values);
        if (values.size() > 0 && !values.isEmpty()) {
            values.forEach(e -> BalanceModelLogUtil.executeSql(dbRoute, sql, e));
        }
    }

    private static void executeSql(DBRoute route, String sql, Object[] sqlvalue) {
        boolean result;
        if (sqlvalue != null && sqlvalue.length > 0 && !(result = DB.execute((DBRoute)route, (String)sql, (Object[])sqlvalue))) {
            log.info("{}executeSql.sqlvalue.sql:{},values:{}", new Object[]{"casBalanceModelLog:", sql, Arrays.toString(sqlvalue)});
            throw new KDBizException(ResManager.loadKDString((String)"sql\u6267\u884c\u9519\u8bef,\u8bb0\u5f55\u4f59\u989d\u53d8\u66f4\u65e5\u5fd7\u5931\u8d25\u3002", (String)"BalanceModelLogUtil_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private static void doInsertObjFID(String table, List<Object[]> values) {
        if (values != null && values.size() > 0) {
            long[] globalIds = DBServiceHelper.genLongIds((String)table, (int)values.size());
            for (int i = 0; i < values.size(); ++i) {
                if (CollectionUtils.isEmpty(values)) continue;
                values.get((int)i)[0] = globalIds[i];
            }
        }
    }

    public static String getTable(String billType) {
        return EntityMetadataCache.getDataEntityType((String)billType).getAlias();
    }

    public static void lock(String formid, DBRoute dbRoute, Collection<BillDataInfo> bills) {
        if (bills.size() == 0) {
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>(bills.size());
        for (BillDataInfo bill : bills) {
            ids.add(bill.getBillid());
        }
        BalanceModelLogUtil.lockBills(formid, dbRoute, ids);
    }

    private static void lockBills(String formid, DBRoute dbRoute, List<Long> bills) {
        if (bills.size() == 0) {
            return;
        }
        if (bills.size() > 999) {
            log.warn("casBalanceModelLog:bill locked size: " + bills.size());
        }
        Lists.partition(bills, (int)999).forEach(subBills -> {
            StringBuilder sql = new StringBuilder(String.format("update %1$s set fmodifytime = now() where fid in ", BalanceModelLogUtil.getTable(formid)));
            ArrayList ids = new ArrayList(subBills.size());
            for (int i = 0; i < subBills.size(); ++i) {
                sql.append(i > 0 ? (char)',' : (char)'(').append('?');
                ids.add(subBills.get(i));
            }
            DB.execute((DBRoute)dbRoute, (String)sql.append(')').toString(), (Object[])ids.toArray(new Long[0]));
        });
    }

    public static String getFilter(List<Long> ids) {
        return ids.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public static BillDataInfo buildDataInfo(long billid, String billNo, long orgid, long acctId, long currencyId, BigDecimal debitAmount, BigDecimal creditAmount, Date bizDate, Long period, boolean fromDatabase) {
        BillDataInfo datainfo = new BillDataInfo();
        datainfo.setBillid(billid);
        datainfo.setBillNo(billNo);
        datainfo.setOrgid(orgid);
        datainfo.setAcctid(acctId);
        datainfo.setCurrencyid(currencyId);
        datainfo.setCreditamount(creditAmount);
        datainfo.setDebitamount(debitAmount);
        datainfo.setBookdate(bizDate);
        datainfo.setPeriod(period);
        datainfo.setFromDatabase(fromDatabase);
        return datainfo;
    }

    public static OccurDataInfo buildDataInfo(long billid, String billNo, long orgid, long acctId, long currencyId, BigDecimal debitAmount, BigDecimal creditAmount, Date bizDate, boolean fromDatabase, Date startDate, Date endDate, int count) {
        OccurDataInfo datainfo = new OccurDataInfo();
        datainfo.setBillid(billid);
        datainfo.setBillNo(billNo);
        datainfo.setOrgid(orgid);
        datainfo.setAcctid(acctId);
        datainfo.setCurrencyid(currencyId);
        datainfo.setCreditamount(creditAmount);
        datainfo.setDebitamount(debitAmount);
        datainfo.setBookdate(bizDate);
        datainfo.setFromDatabase(fromDatabase);
        datainfo.setStartDate(startDate);
        datainfo.setEndDate(endDate);
        datainfo.setCount(count);
        return datainfo;
    }

    public static Date getNextDay(Date day) {
        return DateUtils.getNextDay((Date)day, (int)1);
    }
}

