/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.check.BalanceModelCheckHelper;
import kd.fi.cas.business.balancemodel.log.bean.OccurDataInfo;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.log.type.BalanceModelLogUtil;
import kd.fi.cas.util.DateUtils;

public class BalanceOccurDataService {
    protected static final Log log = LogFactory.getLog(BalanceOccurDataService.class);

    public static BalanceOccurDataService getInstance() {
        return Singleton.instance;
    }

    public List<OccurDataInfo> buildOccurDatas(List<RequestBalanceParameter> balanceParams) {
        ArrayList<OccurDataInfo> returns = new ArrayList<OccurDataInfo>();
        for (RequestBalanceParameter balanceParam : balanceParams) {
            DataSet datas = this.queryOccurDatas(balanceParam);
            Throwable throwable = null;
            try {
                for (Row row : datas) {
                    OccurDataInfo info = this.getInfoObj(row, balanceParam);
                    info.setType(this.getBalanceType(balanceParam.getType()));
                    returns.add(info);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (datas == null) continue;
                if (throwable != null) {
                    try {
                        datas.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                datas.close();
            }
        }
        return returns;
    }

    private BalanceType getBalanceType(String type) {
        switch (type) {
            case "1": {
                return BalanceType.CASH;
            }
            case "2": {
                return BalanceType.JOURNAL;
            }
            case "3": {
                return BalanceType.STATE;
            }
            case "4": {
                return BalanceType.BEI;
            }
        }
        return null;
    }

    public Map<String, OccurDataInfo> sumOccurDatas(List<OccurDataInfo> occurDatas) {
        Map occurObjs = occurDatas.stream().collect(Collectors.groupingBy(e -> BalanceModelCheckHelper.getKey(e), Collectors.mapping(o -> o, Collectors.toSet())));
        HashMap<String, OccurDataInfo> returns = new HashMap<String, OccurDataInfo>(occurObjs.size());
        for (Map.Entry entry : occurObjs.entrySet()) {
            OccurDataInfo sumdata = new OccurDataInfo();
            Set datas = entry.getValue();
            OccurDataInfo _data = (OccurDataInfo)datas.iterator().next();
            sumdata.setOrgid(_data.getOrgid());
            sumdata.setAcctid(_data.getAcctid());
            sumdata.setCurrencyid(_data.getCurrencyid());
            sumdata.setCount(0);
            sumdata.setType(_data.getType());
            sumdata.setStartDate(_data.getStartDate());
            sumdata.setEndDate(_data.getEndDate());
            for (OccurDataInfo data : datas) {
                sumdata.setCreditamount(sumdata.getCreditamount().add(data.getCreditamount()));
                sumdata.setDebitamount(sumdata.getDebitamount().add(data.getDebitamount()));
                sumdata.setCount(sumdata.getCount() + 1);
            }
            returns.put(entry.getKey(), sumdata);
        }
        return returns;
    }

    private DataSet queryOccurDatas(RequestBalanceParameter balanceParam) {
        switch (balanceParam.getType()) {
            case "1": {
                return this.queryJournal(balanceParam, "cas_cashjournal", "accountcash", "bookdate", "id billid ,billno billno ,org orgid,accountcash acctid,currency currencyid,debitamount debitamount, creditamount creditamount,bookdate bizdate, 0 period ");
            }
            case "2": {
                return this.queryJournal(balanceParam, "cas_bankjournal", "accountbank", "bookdate", "id billid ,billno billno ,org orgid,accountbank acctid,currency currencyid,debitamount debitamount, creditamount creditamount,bookdate bizdate, 0 period ");
            }
            case "3": {
                return this.queryJournal(balanceParam, "cas_bankstatement", "accountbank", "bizdate", "id billid ,billno billno ,org orgid,accountbank acctid,currency currencyid,debitamount debitamount, creditamount creditamount,bizdate bizdate, 0 period ");
            }
            case "10": {
                return this.queryBei(balanceParam, "id billid ,billno billno ,company orgid,accountbank acctid,currency currencyid,creditamount debitamount, debitamount creditamount,bizdate bizdate, 0 period ");
            }
        }
        return null;
    }

    private DataSet queryJournal(RequestBalanceParameter balanceParam, String formId, String accountField, String dataField, String selectFields) {
        QFilter filters = new QFilter("org", "in", balanceParam.getOrgIds());
        if (EmptyUtil.isNoEmpty(balanceParam.getAccountIds())) {
            filters.and(new QFilter(accountField, "in", balanceParam.getAccountIds()));
        }
        if (EmptyUtil.isNoEmpty(balanceParam.getCurrencyIds())) {
            filters.and(new QFilter("currency", "in", balanceParam.getCurrencyIds()));
        }
        filters.and(new QFilter(dataField, ">=", (Object)balanceParam.getStartDate()));
        filters.and(new QFilter(dataField, "<", (Object)BalanceModelLogUtil.getNextDay(DateUtils.truncateDate((Date)balanceParam.getEndDate()))));
        filters.and(new QFilter("period", ">", (Object)0L));
        log.info("queryJournal_formID:{}, filter:{}", (Object)formId, (Object)filters.toString());
        return QueryServiceHelper.queryDataSet((String)"queryCash", (String)formId, (String)selectFields, (QFilter[])filters.toArray(), null);
    }

    private OccurDataInfo getInfoObj(Row row, RequestBalanceParameter balanceParam) {
        return BalanceModelLogUtil.buildDataInfo(row.getLong("billid"), row.getString("billno"), row.getLong("orgid"), row.getLong("acctid"), row.getLong("currencyid"), row.getBigDecimal("debitamount"), row.getBigDecimal("creditamount"), row.getDate("bizdate"), true, balanceParam.getStartDate(), balanceParam.getEndDate(), 1);
    }

    private DataSet queryBei(RequestBalanceParameter balanceParam, String selectFields) {
        QFilter filters = new QFilter("company.id", "in", balanceParam.getOrgIds());
        if (EmptyUtil.isNoEmpty(balanceParam.getAccountIds())) {
            filters.and(new QFilter("accountbank.id", "in", balanceParam.getAccountIds()));
        }
        if (EmptyUtil.isNoEmpty(balanceParam.getCurrencyIds())) {
            filters.and(new QFilter("currency.id", "in", balanceParam.getCurrencyIds()));
        }
        filters.and(new QFilter("bizdate", ">=", (Object)balanceParam.getStartDate()));
        filters.and(new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)DateUtils.truncateDate((Date)balanceParam.getEndDate()), (int)1)));
        String formId = "bei_transdetail";
        log.info("queryBei_formID:{}, filter:{}", (Object)formId, (Object)filters.toString());
        return QueryServiceHelper.queryDataSet((String)"queryBei", (String)formId, (String)selectFields, (QFilter[])filters.toArray(), null);
    }

    static class Singleton {
        private static BalanceOccurDataService instance = new BalanceOccurDataService();

        Singleton() {
        }
    }
}

