/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.balance;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.dto.DateRangeBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.log.bean.OccurDataInfo;
import kd.fi.cas.business.balancemodel.service.balance.BalanceOldData;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public class BalanceBei
extends BalanceOldData {
    private static final String balanceProperties = "id,company.id as org,currency.id as currency,accountbank.id as account,amount as monthstart, amount as monthbalance, bizdate as startdate, 0 as year, 0 as month, bizdate as enddate,0 as payamount, 0 as revenueamount, 0 as stroke, 0 as isreset, 0 as isupgrade, 0 as yearstart, 0 as yearbalance, 0 as yearpayamount, 0 as yearrecamount";

    @Override
    protected Map<String, BalanceData> getDataSource(Set<Long> orgIds, Set<Long> accountIds, Set<Long> currencyIds, String type, Date minStartDate, Date maxEndDate, RequestBalanceParameter balParams) {
        log.info("BalanceBei.getDataSource.begin.");
        QFilter qFilters = this.getFilter(orgIds, accountIds, currencyIds);
        qFilters.and(new QFilter("bizdate", "<", (Object)maxEndDate));
        String entityName = "bei_bankbalance";
        log.info("BalanceBei.getDataSource_filter_formId:{};filter:{}", (Object)entityName, (Object)qFilters.toString());
        DynamicObjectCollection dataSet = QueryServiceHelper.query((String)this.getClass().getName(), (String)entityName, (String)balanceProperties, (QFilter[])qFilters.toArray(), (String)"");
        this.convertBalDate(dataSet, balParams);
        return this.dealDateSource(dataSet, "t_bei_bankbalance");
    }

    private Map<String, Set<Date>> getBalDates(DynamicObjectCollection bals) {
        HashMap<String, Set<Date>> returns = new HashMap<String, Set<Date>>(bals.size());
        for (DynamicObject bal : bals) {
            Long orgId = bal.getLong("org");
            Long accountId = bal.getLong("account");
            Long currencyId = bal.getLong("currency");
            String latKey = this.getFindKey(orgId, accountId, currencyId);
            Set dates = returns.computeIfAbsent(latKey, k -> new HashSet(16));
            dates.add(bal.getDate("startdate"));
        }
        return returns;
    }

    private Date getMinDate(DynamicObjectCollection bals) {
        Date min = null;
        for (DynamicObject bal : bals) {
            Date sdate_bal = bal.getDate("startdate");
            if (min != null && min.compareTo(sdate_bal) <= 0) continue;
            min = sdate_bal;
        }
        return min;
    }

    private void removeNoNeedBal(DynamicObjectCollection bals, RequestBalanceParameter balParam) {
        if (bals == null || bals.size() == 0) {
            return;
        }
        Map<String, Set<Date>> dateMaps = this.getBalDates(bals);
        Iterator iterator = bals.iterator();
        while (iterator.hasNext()) {
            List periodRanges;
            Long currencyId;
            Long accountId;
            DynamicObject next = (DynamicObject)iterator.next();
            Long orgId = next.getLong("org");
            String latKey = this.getFindKey(orgId, accountId = Long.valueOf(next.getLong("account")), currencyId = Long.valueOf(next.getLong("currency")));
            Set<Date> dates = dateMaps.get(latKey);
            if (dates == null || dates.size() == 0 || (periodRanges = (List)this.periodDates.get(orgId)) == null || periodRanges.size() == 0) continue;
            Date date_bal = next.getDate("startdate");
            for (DateRangeBalance periodRange : periodRanges) {
                dates.add(balParam.getStartDate());
                Date preDate = DateUtils.preDate(dates, (Date)balParam.getStartDate());
                if (preDate.compareTo(date_bal) == 0) continue;
                iterator.remove();
            }
        }
    }

    private void convertBalDate(DynamicObjectCollection bals, RequestBalanceParameter balParam) {
        this.removeNoNeedBal(bals, balParam);
        if (bals == null || bals.size() == 0) {
            return;
        }
        Date sDate = DateUtils.getPreMonth((Date)this.getMinDate(bals), (int)1);
        Date eDate = DateUtils.getPreMonth((Date)balParam.getEndDate(), (int)-1);
        Map<Long, List<DateRangeBalance>> periodDates = this.buildDateRangBalanceByOrgDate(balParam.getOrgIds(), sDate, eDate);
        block0: for (DynamicObject bal : bals) {
            Long orgId = bal.getLong("org");
            List<DateRangeBalance> periods = periodDates.get(orgId);
            if (periods == null) continue;
            for (DateRangeBalance period : periods) {
                if (bal.getDate("startdate").compareTo(period.getStartDate()) < 0 || bal.getDate("enddate").compareTo(period.getEndDate()) > 0) continue;
                bal.set("startdate", (Object)period.getStartDate());
                bal.set("enddate", (Object)period.getEndDate());
                continue block0;
            }
        }
    }

    @Override
    protected void addDatas(Balance balance, OccurDataInfo occurData) {
        this.addMonthBalance(balance, occurData);
        this.addMonthOccur(balance, occurData);
        this.addYearBalance(balance, occurData);
        this.addYearOccur(balance, occurData);
    }

    private void addMonthBalance(Balance balance, OccurDataInfo occurData) {
    }

    private void addMonthOccur(Balance balance, OccurDataInfo occurData) {
        boolean isOccurBigQuery;
        Date queryPeriod_sDate = balance.getStartDate();
        Date occur_sDate = occurData.getStartDate();
        boolean bl = isOccurBigQuery = occur_sDate.compareTo(queryPeriod_sDate) == 0;
        if (isOccurBigQuery) {
            balance.setPayAmount(balance.getPayAmount().add(occurData.getCreditamount()));
            balance.setRevenueAmount(balance.getRevenueAmount().add(occurData.getDebitamount()));
            balance.setMonthBalance(balance.getMonthBalance().add(occurData.getDebitamount()).subtract(occurData.getCreditamount()));
        }
    }

    private void addYearBalance(Balance balance, OccurDataInfo occurData) {
    }

    private void addYearOccur(Balance balance, OccurDataInfo occurData) {
        Date occur_sDate;
        boolean isQueryBigOccur;
        Date queryPeriod_sDate = balance.getStartDate();
        boolean bl = isQueryBigOccur = queryPeriod_sDate.compareTo(occur_sDate = occurData.getStartDate()) >= 0;
        if (isQueryBigOccur) {
            boolean isCrossYear;
            boolean bl2 = isCrossYear = DateUtils.getYear((Date)queryPeriod_sDate) > DateUtils.getYear((Date)occur_sDate);
            if (!isCrossYear) {
                balance.setYearPayAmount(balance.getYearPayAmount().add(occurData.getCreditamount()));
                balance.setYearRecAmount(balance.getYearRecAmount().add(occurData.getDebitamount()));
            }
        }
    }

    @Override
    protected List<RequestBalanceParameter> getOccur2BalanceParams(RequestBalanceParameter balParam) {
        return Collections.singletonList(this.buildOccurParam(this.getOccurStartDate(balParam), balParam.getEndDate(), balParam));
    }

    private RequestBalanceParameter buildOccurParam(Date begin, Date end, RequestBalanceParameter balParam) {
        RequestBalanceParameter param = new RequestBalanceParameter();
        param.setStartDate(begin);
        param.setEndDate(end);
        param.setType(balParam.getType());
        param.setOrgIds(balParam.getOrgIds());
        return param;
    }

    private Date getOccurStartDate(RequestBalanceParameter balParam) {
        log.info("BalanceBei.getOccurStartDate.");
        if (balParam.isQueryByPeriod()) {
            return this.getMinYearStartDate(balParam);
        }
        return balParam.getStartDate();
    }

    private Date getMinYearStartDate(RequestBalanceParameter balParam) {
        log.info("BalanceBei.getMinYearStartDate.");
        Map<Long, List<DateRangeBalance>> periodDates = this.buildDateRangBalanceByOrgDate(balParam.getOrgIds(), balParam.getStartDate(), DateUtils.getNextDay((Date)balParam.getEndDate(), (int)1));
        DateRangeBalance periodDate = periodDates.values().iterator().next().get(0);
        if (periodDate != null) {
            DynamicObject yearFirstPeriod = PeriodHelper.getPeriodByYearAndNumber((long)periodDate.getPeriodTypeId(), (int)periodDate.getYear(), (int)1);
            if (yearFirstPeriod == null) {
                log.info("BalanceBei.getPeriodParam_type:{}_year:{}.", (Object)periodDate.getPeriodTypeId(), (Object)periodDate.getYear());
                throw new KDBizException("The first period is not exist.");
            }
            return DateUtils.truncateDate((Date)yearFirstPeriod.getDate("begindate"));
        }
        log.info("BalanceBei.getMinYearStartDate:sDate:{},eDate:{},orgs:{}.", new Object[]{balParam.getStartDate(), balParam.getEndDate(), balParam.getOrgIds().toString()});
        throw new KDBizException("The query Date has not peirod.");
    }

    private QFilter getFilter(Set<Long> orgIds, Set<Long> acctIds, Set<Long> currencyIds) {
        QFilter filters = new QFilter("company.id", "in", orgIds);
        if (acctIds != null && acctIds.size() > 0) {
            filters.and(new QFilter("accountbank.id", "in", acctIds));
        }
        if (currencyIds != null && currencyIds.size() > 0) {
            filters.and(new QFilter("currency.id", "in", currencyIds));
        }
        return filters;
    }
}

