/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.balance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.BalanceData;
import kd.fi.cas.business.balancemodel.calculate.dto.DateRangeBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalance;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.check.BalanceModelCheckHelper;
import kd.fi.cas.business.balancemodel.log.bean.OccurDataInfo;
import kd.fi.cas.business.balancemodel.service.BalanceOccurDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public abstract class BalanceDataAbstract {
    protected static Log log = LogFactory.getLog(BalanceDataAbstract.class);
    protected Map<Long, List<DateRangeBalance>> periodDates;

    public List<ResponseBalances> getBalances(RequestBalanceParameter balParam, BalanceQueryType queryType) throws Exception {
        ArrayList<ResponseBalances> returns = new ArrayList<ResponseBalances>(16);
        log.info("{}.getBalances.begin.", (Object)this.getClass().getName());
        List<ResponseBalances> balanceDatas = this.getBalancesData(balParam);
        returns.addAll(this.addBalance(balParam, queryType, balanceDatas));
        log.info("{}.getBalances.end.", (Object)this.getClass().getName());
        return returns;
    }

    private List<ResponseBalances> addBalance(RequestBalanceParameter balParam, BalanceQueryType queryType, List<ResponseBalances> balanceDatas) {
        if (balParam.isQueryByPeriod()) {
            return balanceDatas;
        }
        return this.getBalances_occur(balanceDatas, balParam, queryType);
    }

    private List<ResponseBalances> getBalances_occur(List<ResponseBalances> balanceDatas, RequestBalanceParameter balParam, BalanceQueryType queryType) {
        ArrayList<ResponseBalances> returns = new ArrayList<ResponseBalances>(16);
        log.info("{}.getBalances_occur.begin.", (Object)this.getClass().getName());
        Map balanceDataMap = balanceDatas.stream().collect(Collectors.groupingBy(e -> this.getOccurKey(e.getStartDate(), e.getEndDate()), Collectors.mapping(o -> o, Collectors.toList())));
        Date paramDate_begin = this.getQueryBeginDate(balParam, queryType);
        ArrayList<RequestBalanceParameter> occurParams = new ArrayList<RequestBalanceParameter>(16);
        ArrayList<RequestBalanceParameter> occurParams_alone = new ArrayList<RequestBalanceParameter>(16);
        for (Map.Entry balanceData : balanceDataMap.entrySet()) {
            List<ResponseBalances> balances = balanceData.getValue();
            ResponseBalances anyBalance = (ResponseBalances)balances.get(0);
            Date period_begin = DateUtils.truncateDate((Date)anyBalance.getStartDate());
            Date period_end = DateUtils.truncateDate((Date)anyBalance.getEndDate());
            this.addOccur(paramDate_begin, period_begin, period_end, occurParams, occurParams_alone, balances, queryType, returns, balParam);
        }
        this.doHasNoBalance(paramDate_begin, balanceDatas, occurParams, occurParams_alone, queryType, returns, balParam);
        log.info("occurParams:{}", (Object)occurParams.size());
        List<OccurDataInfo> occurDatas = BalanceOccurDataService.getInstance().buildOccurDatas(this.paramSumOrg(occurParams, balParam, true));
        this.mixBalanceAndOccur(returns, occurDatas, true, queryType);
        log.info("mixBalanceAndOccur_1:");
        this.doLogBalance((List<ResponseBalances>)returns);
        if (BalanceQueryType.BEGINDATE_ENDOCCUR == queryType || BalanceQueryType.ENDDATE == queryType) {
            log.info("occurParams_alone:{}", (Object)occurParams_alone.size());
            List<OccurDataInfo> occurDatas_alone = BalanceOccurDataService.getInstance().buildOccurDatas(this.paramSumOrg(occurParams_alone, balParam, false));
            log.info("occurDatas_alone:{}", (Object)occurDatas_alone.size());
            this.mixBalanceAndOccur(returns, occurDatas_alone, false, queryType);
        }
        return returns;
    }

    private void addOccur(Date paramDate_begin, Date period_begin, Date period_end, List<RequestBalanceParameter> occurParams, List<RequestBalanceParameter> occurParams_alone, List<ResponseBalances> balances, BalanceQueryType queryType, List<ResponseBalances> returns, RequestBalanceParameter balParam) {
        log.info("addOccur:{};{};{}.", new Object[]{paramDate_begin, period_begin, period_end});
        if (DateUtils.isSameDay((Date)paramDate_begin, (Date)period_begin)) {
            occurParams_alone.addAll(this.doSameBeginDate(returns, balances, balParam, queryType, period_begin, period_end));
        } else if (paramDate_begin.compareTo(period_begin) > 0 && paramDate_begin.compareTo(period_end) <= 0) {
            occurParams_alone.addAll(this.doBetweenDate(returns, balances, balParam, queryType, period_begin, paramDate_begin));
            occurParams.add(this.buildOccurParam(period_begin, paramDate_begin, balParam));
        }
    }

    private void doHasNoBalance(Date paramDate_begin, List<ResponseBalances> balanceDatas, List<RequestBalanceParameter> occurParams, List<RequestBalanceParameter> occurParams_alone, BalanceQueryType queryType, List<ResponseBalances> returns, RequestBalanceParameter balParam) {
        if ((balanceDatas == null || balanceDatas.size() == 0) && this.periodDates != null && this.periodDates.size() > 0) {
            DateRangeBalance range = this.periodDates.values().iterator().next().get(0);
            this.addOccur(paramDate_begin, range.getStartDate(), range.getEndDate(), occurParams, occurParams_alone, new ArrayList<ResponseBalances>(0), queryType, returns, balParam);
        }
    }

    private List<RequestBalanceParameter> doBetweenDate(List<ResponseBalances> returns, List<ResponseBalances> balances, RequestBalanceParameter balParam, BalanceQueryType queryType, Date period_begin, Date paramDate_begin) {
        this.setOccurZero(balances);
        returns.addAll(balances);
        ArrayList<RequestBalanceParameter> occur_alone = new ArrayList<RequestBalanceParameter>(16);
        if (BalanceQueryType.BEGINDATE_ENDOCCUR == queryType || BalanceQueryType.ENDDATE == queryType) {
            Date paramDate_end = balParam.getEndDate();
            occur_alone.add(this.buildOccurParam(paramDate_begin, paramDate_end, balParam));
        }
        return occur_alone;
    }

    private List<RequestBalanceParameter> doSameEndDate(List<ResponseBalances> returns, List<ResponseBalances> balances, RequestBalanceParameter balParam, BalanceQueryType queryType, Date period_begin, Date period_end) {
        this.setOccurZero(balances);
        balances.forEach(e -> e.getBalance().setMonthStart(e.getBalance().getMonthBalance()));
        returns.addAll(balances);
        ArrayList<RequestBalanceParameter> occur_alone = new ArrayList<RequestBalanceParameter>(16);
        if (BalanceQueryType.BEGINDATE_ENDOCCUR == queryType || BalanceQueryType.ENDDATE == queryType) {
            Date paramDate_end = balParam.getEndDate();
            occur_alone.add(this.buildOccurParam(period_end, paramDate_end, balParam));
        }
        return occur_alone;
    }

    private List<RequestBalanceParameter> doSameBeginDate(List<ResponseBalances> returns, List<ResponseBalances> balances, RequestBalanceParameter balParam, BalanceQueryType queryType, Date period_begin, Date period_end) {
        Date paramDate_end;
        returns.addAll(balances);
        ArrayList<RequestBalanceParameter> occur_alone = new ArrayList<RequestBalanceParameter>(16);
        if (!(BalanceQueryType.BEGINDATE_ENDOCCUR != queryType && BalanceQueryType.ENDDATE != queryType || DateUtils.isSameDay((Date)(paramDate_end = balParam.getEndDate()), (Date)period_end))) {
            this.setOccurZero(balances);
            occur_alone.add(this.buildOccurParam(period_begin, paramDate_end, balParam));
        }
        return occur_alone;
    }

    private Date getQueryBeginDate(RequestBalanceParameter balParam, BalanceQueryType queryType) {
        switch (queryType) {
            case BEGINDATE: 
            case BEGINDATE_ENDOCCUR: {
                return DateUtils.truncateDate((Date)balParam.getStartDate());
            }
            case ENDDATE: {
                return DateUtils.truncateDate((Date)balParam.getEndDate());
            }
        }
        return DateUtils.truncateDate((Date)balParam.getStartDate());
    }

    private void setOccurZero(List<ResponseBalances> balanceDatas) {
        balanceDatas.forEach(e -> e.getBalance().setPayAmount(BigDecimal.ZERO));
        balanceDatas.forEach(e -> e.getBalance().setRevenueAmount(BigDecimal.ZERO));
    }

    private void mixBalanceAndOccur(List<ResponseBalances> balanceDatas, List<OccurDataInfo> occurDatas, boolean isBalance, BalanceQueryType queryType) {
        log.info("{}.mixBalanceAndOccur.begin.isBalance:{}.", (Object)this.getClass().getName(), (Object)(isBalance ? "1" : "0"));
        if (occurDatas == null || occurDatas.size() == 0) {
            return;
        }
        Map<String, OccurDataInfo> occurDatasMap = BalanceOccurDataService.getInstance().sumOccurDatas(occurDatas);
        for (ResponseBalances responseBalances : balanceDatas) {
            String balanceKey = this.getKey(responseBalances);
            OccurDataInfo occurData = occurDatasMap.get(balanceKey);
            if (occurData == null) continue;
            BigDecimal balance = responseBalances.getBalance().getMonthStart();
            BigDecimal creditAmt = occurData.getCreditamount();
            BigDecimal debitAmt = occurData.getDebitamount();
            if (isBalance || BalanceQueryType.ENDDATE == queryType) {
                responseBalances.getBalance().setMonthStart(balance.add(debitAmt).subtract(creditAmt));
            } else {
                responseBalances.getBalance().setPayAmount(creditAmt);
                responseBalances.getBalance().setRevenueAmount(debitAmt);
            }
            occurDatasMap.remove(balanceKey);
        }
        for (Map.Entry entry : occurDatasMap.entrySet()) {
            OccurDataInfo occur = (OccurDataInfo)entry.getValue();
            ResponseBalances _occur = new ResponseBalances();
            _occur.setType(occur.getType().getValue());
            _occur.setOrgId(occur.getOrgid());
            _occur.setAccountId(occur.getAcctid());
            _occur.setCurrencyId(occur.getCurrencyid());
            _occur.setStartDate(occur.getStartDate());
            _occur.setEndDate(occur.getEndDate());
            Balance bal = new Balance();
            bal.setOrgId(occur.getOrgid());
            bal.setAccountId(occur.getAcctid());
            bal.setCurrencyId(occur.getCurrencyid());
            if (isBalance || BalanceQueryType.ENDDATE == queryType) {
                bal.setMonthStart(occur.getDebitamount().subtract(occur.getCreditamount()));
            } else {
                bal.setPayAmount(occur.getCreditamount());
                bal.setRevenueAmount(occur.getDebitamount());
            }
            _occur.setBalance(bal);
            balanceDatas.add(_occur);
        }
    }

    private String getKey(ResponseBalances balanceData) {
        return BalanceModelCheckHelper.getKey(balanceData.getStartDate(), balanceData.getOrgId(), balanceData.getAccountId(), balanceData.getCurrencyId());
    }

    protected List<RequestBalanceParameter> paramSumOrg(List<RequestBalanceParameter> occurParams, RequestBalanceParameter balParam, boolean isBalance) {
        ArrayList<RequestBalanceParameter> returns = new ArrayList<RequestBalanceParameter>(occurParams.size());
        Map occurParamsMap = occurParams.stream().collect(Collectors.groupingBy(e -> this.getOccurKey(e.getStartDate(), e.getEndDate()), Collectors.mapping(o -> o, Collectors.toList())));
        for (Map.Entry balanceData : occurParamsMap.entrySet()) {
            List<RequestBalanceParameter> params = balanceData.getValue();
            RequestBalanceParameter anyParam = (RequestBalanceParameter)params.get(0);
            RequestBalanceParameter orgSum = new RequestBalanceParameter();
            orgSum.setOrgIds(this.getOccurQueryOrgIds(params, balParam, isBalance));
            orgSum.setAccountIds(balParam.getAccountIds());
            orgSum.setCurrencyIds(balParam.getCurrencyIds());
            orgSum.setStartDate(anyParam.getStartDate());
            orgSum.setEndDate(isBalance ? DateUtils.getLastDay((Date)anyParam.getEndDate(), (int)1) : anyParam.getEndDate());
            orgSum.setType(anyParam.getType());
            returns.add(orgSum);
        }
        log.info("BalanceDataAbstract.paramSumOrg;");
        this.doLogParams(isBalance, returns);
        return returns;
    }

    private RequestBalanceParameter buildOccurParam(Date begin, Date end, RequestBalanceParameter balParam) {
        RequestBalanceParameter param = new RequestBalanceParameter();
        param.setStartDate(begin);
        param.setEndDate(end);
        param.setType(balParam.getType());
        param.setOrgIds(balParam.getOrgIds());
        return param;
    }

    private List<ResponseBalances> getBalancesData(RequestBalanceParameter balParam) throws Exception {
        try {
            Set<Long> orgIds = balParam.getOrgIds();
            Set<Long> accountIds = balParam.getAccountIds();
            Set<Long> currencyIds = balParam.getCurrencyIds();
            Date paStartDate = balParam.getStartDate();
            Date paEndDate = balParam.getEndDate();
            Map orgPeriodsStart = PeriodHelper.getPeriodByOrgsDate(new ArrayList<Long>(orgIds), (Date)paStartDate);
            Date startDate = null;
            Date endDate = null;
            for (Object period : orgPeriodsStart.values()) {
                if (period == null) continue;
                Date start = period.getDate("begindate");
                if (startDate != null && startDate.getTime() <= start.getTime()) continue;
                startDate = start;
            }
            if (startDate == null) {
                return new ArrayList<ResponseBalances>();
            }
            Map orgPeriodsEnd = PeriodHelper.getPeriodByOrgsDate(new ArrayList<Long>(orgIds), (Date)paEndDate);
            for (DynamicObject period : orgPeriodsEnd.values()) {
                if (period == null) continue;
                Date end = period.getDate("enddate");
                if (endDate != null && endDate.getTime() >= end.getTime()) continue;
                endDate = end;
            }
            if (endDate == null) {
                return new ArrayList<ResponseBalances>();
            }
            this.periodDates = this.buildDateRangBalanceByOrgDate(orgIds, startDate, endDate);
            String type = balParam.getType();
            Map<String, BalanceData> dataSourceBalances = this.getDataSource(orgIds, accountIds, currencyIds, type, startDate, endDate, balParam);
            return this.convertBalances(this.getDealBalances(dataSourceBalances, balParam), type);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
    }

    protected Map<Long, List<DateRangeBalance>> buildDateRangBalanceByOrgDate(Set<Long> orgIds, Date startDate, Date endDate) {
        ArrayList<Long> orgIdList = new ArrayList<Long>(orgIds.size());
        orgIdList.addAll(orgIds);
        Map periodTypeMap = PeriodHelper.getBatchPeriodTypeId(orgIdList);
        if (periodTypeMap == null || periodTypeMap.size() == 0) {
            return new HashMap<Long, List<DateRangeBalance>>();
        }
        QFilter filters = new QFilter("begindate", ">=", (Object)startDate);
        filters.and(new QFilter("enddate", "<=", (Object)endDate));
        filters.and(new QFilter("periodtype", "in", periodTypeMap.values().stream().distinct().collect(Collectors.toList())));
        filters.and(new QFilter("isadjustperiod", "=", (Object)"0"));
        log.info("buildDateRangBalanceByOrgDate_formId:{};filter:{}", (Object)"bd_period", (Object)filters.toString());
        DynamicObjectCollection period = QueryServiceHelper.query((String)"bd_period", (String)"periodtype.id,id, periodyear,begindate, enddate,periodnumber", (QFilter[])filters.toArray(), (String)"begindate");
        HashMap<Long, ArrayList<DateRangeBalance>> periodTypeRanges = new HashMap<Long, ArrayList<DateRangeBalance>>(32);
        HashSet<String> alreadys = new HashSet<String>(12);
        for (DynamicObject dynamicValue : period) {
            Long periodTypeId = dynamicValue.getLong("periodtype.id");
            int year = dynamicValue.getInt("periodyear");
            int month = dynamicValue.getInt("periodnumber");
            Date sDate = dynamicValue.getDate("begindate");
            Date eDate = dynamicValue.getDate("enddate");
            if (!alreadys.add(periodTypeId + "" + year + month)) continue;
            ArrayList<DateRangeBalance> dateRangeBalances = (ArrayList<DateRangeBalance>)periodTypeRanges.get(periodTypeId);
            if (dateRangeBalances == null) {
                dateRangeBalances = new ArrayList<DateRangeBalance>(16);
                periodTypeRanges.put(periodTypeId, dateRangeBalances);
            }
            dateRangeBalances.add(new DateRangeBalance(sDate, eDate, year, periodTypeId));
        }
        HashMap<Long, List<DateRangeBalance>> periodDateRanges = new HashMap<Long, List<DateRangeBalance>>(32);
        for (Long orgId : orgIdList) {
            Long periodTypeId = (Long)periodTypeMap.get(orgId);
            if (periodTypeMap == null) continue;
            List dateRangeBalances = (List)periodTypeRanges.get(periodTypeId);
            periodDateRanges.put(orgId, dateRangeBalances);
        }
        return periodDateRanges;
    }

    protected Map<String, ResponseBalance> getDealBalances(Map<String, BalanceData> dataSourceBalances, RequestBalanceParameter balParam) throws Exception {
        HashMap<String, ResponseBalance> responseBalances = new HashMap<String, ResponseBalance>(32);
        log.info("BalanceDataService.getDealBalances.begin.");
        try {
            if (dataSourceBalances.size() == 0) {
                return new HashMap<String, ResponseBalance>(2);
            }
            for (Map.Entry<String, BalanceData> dataSourceBalance : dataSourceBalances.entrySet()) {
                Long orgId;
                List<DateRangeBalance> dateRangeBalances;
                String latKeys = dataSourceBalance.getKey();
                BalanceData balanceData = dataSourceBalance.getValue();
                Set<Date> startDates = balanceData.getStartDates();
                List<Balance> balances = balanceData.getBalances();
                if (balances.size() == 0 || (dateRangeBalances = this.periodDates.get(orgId = balanceData.getOrgId())) == null || dateRangeBalances.size() == 0) continue;
                ResponseBalance responseBalance = (ResponseBalance)responseBalances.get(latKeys);
                if (responseBalance == null) {
                    responseBalance = new ResponseBalance();
                    responseBalances.put(latKeys, responseBalance);
                }
                for (DateRangeBalance dateRangeBalance : dateRangeBalances) {
                    Date sDate = dateRangeBalance.getStartDate();
                    Date eDate = dateRangeBalance.getEndDate();
                    Balance balance = balanceData.getBalance(sDate);
                    int year = dateRangeBalance.getYear();
                    if (balance != null) {
                        responseBalance.setBalances(balance);
                        responseBalance.setStartDates(sDate);
                        responseBalance.setEndDates(eDate);
                        continue;
                    }
                    startDates.add(sDate);
                    Date preDate = DateUtils.preDate(startDates, (Date)sDate);
                    balance = balanceData.getBalance(preDate);
                    if (preDate.getTime() == sDate.getTime() || balance == null) {
                        Balance bal = balanceData.getBalances().get(0);
                        balance = new Balance();
                        balance.setYear(year);
                        balance.setStartDate(sDate);
                        balance.setEndDate(eDate);
                        balance.setMonthStart(BigDecimal.ZERO);
                        balance.setMonthBalance(BigDecimal.ZERO);
                        balance.setPayAmount(BigDecimal.ZERO);
                        balance.setRevenueAmount(BigDecimal.ZERO);
                        balance.setStroke(0);
                        balance.setOrgId(bal.getOrgId());
                        balance.setAccountId(bal.getAccountId());
                        balance.setCurrencyId(bal.getCurrencyId());
                        balance.setYearBalance(BigDecimal.ZERO);
                        balance.setYearCredit(BigDecimal.ZERO);
                        balance.setYearDebit(BigDecimal.ZERO);
                        balance.setYearPayAmount(BigDecimal.ZERO);
                        balance.setYearRecAmount(BigDecimal.ZERO);
                        balance.setYearStart(BigDecimal.ZERO);
                        balanceData.setBalance(balance);
                        responseBalance.setBalances(balance);
                        responseBalance.setStartDates(sDate);
                        responseBalance.setEndDates(eDate);
                        continue;
                    }
                    Balance nBalance = new Balance();
                    nBalance.setYear(year);
                    nBalance.setId(balance.getId());
                    nBalance.setOrgId(balance.getOrgId());
                    nBalance.setOrgName(balance.getOrgName());
                    nBalance.setAccountId(balance.getAccountId());
                    nBalance.setCurrencyId(balance.getCurrencyId());
                    nBalance.setCurrencyName(balance.getCurrencyName());
                    nBalance.setStartDate(sDate);
                    nBalance.setEndDate(eDate);
                    nBalance.setMonthStart(balance.getMonthBalance());
                    nBalance.setMonthBalance(balance.getMonthBalance());
                    nBalance.setPayAmount(BigDecimal.ZERO);
                    nBalance.setRevenueAmount(BigDecimal.ZERO);
                    nBalance.setStroke(0);
                    if (year > balance.getYear()) {
                        nBalance.setYearStart(balance.getYearBalance());
                        nBalance.setYearCredit(BigDecimal.ZERO);
                        nBalance.setYearDebit(BigDecimal.ZERO);
                        nBalance.setYearPayAmount(BigDecimal.ZERO);
                        nBalance.setYearRecAmount(BigDecimal.ZERO);
                        nBalance.setYearBalance(balance.getYearBalance());
                    } else {
                        nBalance.setYearStart(balance.getYearStart());
                        nBalance.setYearCredit(balance.getYearCredit());
                        nBalance.setYearDebit(balance.getYearDebit());
                        nBalance.setYearPayAmount(balance.getYearPayAmount());
                        nBalance.setYearRecAmount(balance.getYearRecAmount());
                        nBalance.setYearBalance(balance.getYearBalance());
                    }
                    balanceData.setBalance(nBalance);
                    responseBalance.setBalances(nBalance);
                    responseBalance.setStartDates(sDate);
                    responseBalance.setEndDates(eDate);
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw e;
        }
        return responseBalances;
    }

    private List<ResponseBalances> convertBalances(Map<String, ResponseBalance> balanceMap, String type) {
        ArrayList<ResponseBalances> result = new ArrayList<ResponseBalances>(64);
        log.info("BalanceDataService.convertBalances.begin.type:{}", (Object)type);
        for (Map.Entry<String, ResponseBalance> balanceEntry : balanceMap.entrySet()) {
            List<Balance> balances;
            ResponseBalance responseBalance = balanceEntry.getValue();
            if (responseBalance == null || (balances = responseBalance.getBalances()) == null || balances.size() == 0) continue;
            for (Balance balance : balances) {
                ResponseBalances responseBalances = new ResponseBalances();
                responseBalances.setOrgId(balance.getOrgId());
                responseBalances.setAccountId(balance.getAccountId());
                responseBalances.setCurrencyId(balance.getCurrencyId());
                responseBalances.setStartDate(balance.getStartDate());
                responseBalances.setEndDate(balance.getEndDate());
                responseBalances.setType(type);
                responseBalances.setBalance(balance);
                result.add(responseBalances);
            }
        }
        return result;
    }

    protected Map<String, BalanceData> getDataSource(Set<Long> orgIds, Set<Long> accountIds, Set<Long> currencyIds, String type, Date minStartDate, Date maxEndDate, RequestBalanceParameter balParams) {
        return null;
    }

    protected String getOccurKey(Date begin, Date end) {
        return DateUtils.getMonthDay((Date)begin);
    }

    protected Set<Long> getOccurQueryOrgIds(List<RequestBalanceParameter> params, RequestBalanceParameter balParam, boolean isBalance) {
        return balParam.getOrgIds();
    }

    protected void doLogParams(boolean isBalance, List<RequestBalanceParameter> params) {
        if (params == null || params.size() == 0) {
            log.info("doLogParams.doLog:{};params is null.", (Object)(isBalance ? "1" : "0"));
            return;
        }
        log.info("doLogParams.doLog:{}.", (Object)(isBalance ? "1" : "0"));
        StringBuilder sq = new StringBuilder();
        for (RequestBalanceParameter param : params) {
            sq.append("type:").append(param.getType()).append(";startDate:").append(param.getStartDate()).append(";endtDate:").append(param.getEndDate()).append("\r\n");
        }
        log.info("doLogParams.doLog:{};{}", (Object)(isBalance ? "1" : "0"), (Object)sq.toString());
    }

    protected void doLogBalance(Collection<ResponseBalance> balances) {
        if (!this.isNeedLog()) {
            return;
        }
        if (balances == null || balances.size() == 0) {
            log.info("BalanceOldData.doLog: balances is null.");
            return;
        }
        StringBuilder sq = new StringBuilder();
        for (ResponseBalance balance : balances) {
            Set<Date> startDates = balance.getStartDates();
            for (Date startDate : startDates) {
                Balance bal = balance.getBalance(startDate);
                sq.append("sdate:").append(startDate).append(";orgid:").append(bal.getOrgId()).append(";monthStart:").append(bal.getMonthStart()).append(";monthBalance:").append(bal.getMonthBalance()).append(";payAmount:").append(bal.getPayAmount()).append(";revenueAmount:").append(bal.getRevenueAmount()).append("\r\n");
            }
        }
        log.info("BalanceOldData.doLog:{}", (Object)sq.toString());
    }

    protected void doLogBalance(List<ResponseBalances> balances) {
        if (!this.isNeedLog()) {
            return;
        }
        if (balances == null || balances.size() == 0) {
            log.info("BalanceOldData.doLog: balances is null.");
            return;
        }
        StringBuilder sq = new StringBuilder();
        for (ResponseBalances balance : balances) {
            Balance bal = balance.getBalance();
            sq.append("sdate:").append(balance.getStartDate()).append(";orgid:").append(balance.getOrgId()).append(";monthStart:").append(bal.getMonthStart()).append(";monthBalance:").append(bal.getMonthBalance()).append(";payAmount:").append(bal.getPayAmount()).append(";revenueAmount:").append(bal.getRevenueAmount()).append("\r\n");
        }
        log.info("doLogBalance_2.doLog:{}", (Object)sq.toString());
    }

    private boolean isNeedLog() {
        QFilter config = new QFilter("number", "=", (Object)"fi.cas.report.log");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObject logConfig = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)"configvalue", (QFilter[])new QFilter[]{config, enable});
        return logConfig != null && "true".equals(logConfig.getString("configvalue"));
    }
}

