/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class ExchangeRateService {
    private static final String FIELD_CURRENCYID = "fcurrencyid";

    public DataSet getExchgRateDs(DataSet ds, Long rptCurrencyID, Long exchageTableId, Date conversionDate, boolean isQing) {
        DataSet currencySet = ds.copy().groupBy(new String[]{FIELD_CURRENCYID}).finish();
        ArrayList<Long> currencyIdList = new ArrayList<Long>(10);
        currencySet.iterator().forEachRemaining(v -> currencyIdList.add(v.getLong(FIELD_CURRENCYID)));
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(currencyIdList.size());
        if (EmptyUtil.isNoEmpty((Long)exchageTableId)) {
            rateMap.putAll(ExchangeRateService.getExchageRateBatchByTable(exchageTableId, currencyIdList, rptCurrencyID, conversionDate));
        }
        currencyIdList.removeAll(rateMap.keySet());
        if (!isQing && currencyIdList.size() > 0) {
            DynamicObject targetCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)rptCurrencyID, (String)"bd_currency", (String)"name");
            DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache(currencyIdList.get(0), (String)"bd_currency", (String)"name");
            DynamicObject exchageTable = BusinessDataServiceHelper.loadSingleFromCache((Object)exchageTableId, (String)"bd_exratetable", (String)"name");
            throw new KDBizException(String.format(ExchangeRateService.getReportExChangeRate(), EmptyUtil.isNoEmpty((DynamicObject)exchageTable) ? exchageTable.getString("name") : null, EmptyUtil.isNoEmpty((DynamicObject)currency) ? currency.getString("name") : null, EmptyUtil.isNoEmpty((DynamicObject)targetCurrency) ? targetCurrency.getString("name") : null));
        }
        ArrayList<Field> field = new ArrayList<Field>(10);
        field.add(new Field(FIELD_CURRENCYID, (DataType)DataType.LongType));
        field.add(new Field("fexchgRate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"cas_getExchgRateDs");
        DataSetBuilder dsBuilder = algo.createDataSetBuilder(rowMeta);
        for (Map.Entry entry : rateMap.entrySet()) {
            Long key = (Long)entry.getKey();
            BigDecimal value = (BigDecimal)entry.getValue();
            Object[] obj = new Object[]{key, value};
            dsBuilder.append(obj);
        }
        return dsBuilder.build();
    }

    private static String getReportExChangeRate() {
        return ResManager.loadKDString((String)"%1$s\u4e0d\u5b58\u5728%2$s\u5151%3$s\u6c47\u7387\u3002", (String)"ExchangeRateService_0", (String)"fi-cas-business", (Object[])new Object[0]);
    }

    private static Map<Long, BigDecimal> getExchageRateBatchByTable(Long exchangeTableID, List<Long> sourceCurrencyIDs, Long targetCurrencyID, Date date) {
        HashMap<Long, BigDecimal> rateMap = new HashMap<Long, BigDecimal>(sourceCurrencyIDs.size());
        ArrayList<Pair> currencyGroups = new ArrayList<Pair>(sourceCurrencyIDs.size());
        for (Long sourceCurrencyID : sourceCurrencyIDs) {
            if (sourceCurrencyID.equals(targetCurrencyID)) {
                rateMap.put(sourceCurrencyID, BigDecimal.ONE);
                continue;
            }
            currencyGroups.add(Pair.of((Object)(sourceCurrencyID + "_" + targetCurrencyID), (Object)(targetCurrencyID + "_" + sourceCurrencyID)));
        }
        ArrayList<Long> currencyIDs = new ArrayList<Long>(sourceCurrencyIDs.size() + 1);
        currencyIDs.addAll(sourceCurrencyIDs);
        if (!currencyIDs.contains(targetCurrencyID)) {
            currencyIDs.add(targetCurrencyID);
        }
        QFilter filter = new QFilter("orgcur", "in", currencyIDs);
        filter.and("cur", "in", currencyIDs);
        filter.and("enable", "=", (Object)"1");
        if (date != null) {
            filter.and("effectdate", "<=", (Object)date);
        }
        QFilter qFilterTable = new QFilter("exctable", "=", (Object)exchangeTableID);
        if (kd.bos.servicehelper.basedata.ExchangeRateService.isEnableExchangeRateExpiryDate((Long)exchangeTableID)) {
            qFilterTable.and("expirydate", ">=", (Object)date);
        }
        List<DynamicObject> list = ExchangeRateService.queryExrateTree(new QFilter[]{filter, qFilterTable});
        LinkedHashMap collect = list.stream().collect(Collectors.groupingBy(e -> e.get("orgcur") + "_" + e.get("cur"), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        for (Pair currencyGroup : currencyGroups) {
            DynamicObject rate;
            ArrayList rates;
            if (collect.containsKey(currencyGroup.getLeft())) {
                rates = (ArrayList)collect.get(currencyGroup.getLeft());
                rate = (DynamicObject)rates.get(0);
                rateMap.put(rate.getLong("orgcur"), rate.getBigDecimal("excval"));
                continue;
            }
            if (!collect.containsKey(currencyGroup.getRight())) continue;
            rates = (ArrayList)collect.get(currencyGroup.getRight());
            rate = (DynamicObject)rates.get(0);
            rateMap.put(rate.getLong("cur"), rate.getBigDecimal("indirectexrate"));
        }
        return rateMap;
    }

    private static List<DynamicObject> queryExrateTree(QFilter[] qFilters) {
        ORM orm = ORM.create();
        return orm.query("bd_exrate_tree", "id,orgcur,cur,excval,indirectexrate,effectdate", qFilters, "effectdate desc");
    }
}

