/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.report.reportbalance;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.service.report.DealDsUtil;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.BalanceQueryParam;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.PeriodParam;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public class ReportBalanceBei {
    private static Log log = LogFactory.getLog(ReportBalanceBei.class);

    public DataSet getReportBalanceDs(BalanceQueryParam queryParam) throws Exception {
        log.info("ReportBalanceBei.getBalances.");
        DataSet bei_bal = this.bei_getBalance(queryParam);
        DataSet bei_occur = this.bei_getOccur(queryParam);
        bei_bal = bei_bal.union(bei_occur);
        DataSet rs = null;
        log.info("ReportBalanceBei.getBalances.end");
        rs = bei_bal.groupBy(new String[]{"fperiod", "fperiodname", "fstartdate", "forgid", "ftype", "facctid", "fcurrencyid", "sumlevel"}).sum("fbalance").sum("fdebitamount").sum("fcreditamount").sum("fyearbalance").sum("fyeardebitamount").sum("fyearcreditamount").finish();
        DealDsUtil.closeDs(bei_bal, bei_occur);
        return rs;
    }

    private DataSet bei_sum(DataSet rs) {
        if (rs == null) {
            return DealDsUtil.newDs();
        }
        DataSet returns = rs.groupBy(new String[]{"fyear", "fperiod", "fperiodname", "forgid", "ftype", "facctid", "fcurrencyid", "sumlevel", "fstartdate"}).sum("fbalance").sum("fdebitamount").sum("fcreditamount").sum("fyearbalance").sum("fyeardebitamount").sum("fyearcreditamount").finish();
        return returns;
    }

    private DataSet bei_dsGroupBy(DataSet ds) {
        ds = ds.groupBy(new String[]{"ftype", "forgid", "facctid", "fcurrencyid"}).max("fstartdate").finish();
        return ds;
    }

    private DataSet bei_getBalance(BalanceQueryParam queryParam) {
        log.info("ReportBalanceBei.bei_getBalance.");
        DataSet ds_bei = this.bei_queryBalance(queryParam);
        if (queryParam.getTimeType() == TimeTypeEnum.BYDATE) {
            Date startDate = queryParam.getStartDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date bDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
            DataSet ds = this.bei_getMaxDataRowDs(ds_bei);
            ds = ds.select(new String[]{"ftype", "forgid", "facctid", "fcurrencyid", "to_date('" + sdf.format(bDate) + "','yyyy-MM-dd') as fstartdate", "fbalance", "0 as fdebitamount", "0 as fcreditamount", "0 as sumlevel", "0 as fyearbalance", "0 as fyeardebitamount", "0 as fyearcreditamount", "0 as fperiod", "'' as fperiodname"});
            return ds;
        }
        return this.bei_dsAddData(ds_bei, queryParam, false);
    }

    private DataSet bei_dsAddData(DataSet ds, BalanceQueryParam queryParam, boolean isOccur) {
        DataSet ds_Period = this.bei_addPeriodData(ds, queryParam, isOccur);
        DataSet ds_Year = this.bei_addYearData(ds, queryParam, isOccur);
        DataSet ds_all = null;
        ds_all = isOccur ? ds_Period.union(ds_Year) : ds_Period.fullJoin(ds_Year).on("ftype", "ftype").on("forgid", "forgid").on("facctid", "facctid").on("fcurrencyid", "fcurrencyid").on("fyear", "fyear").select(new String[]{"ftype", "forgid", "facctid", "fcurrencyid", "fstartdate", "fperiod", "fperiodname", "sumlevel", "fyear", "fbalance", "fdebitamount", "fcreditamount"}, new String[]{"fyearbalance", "fyeardebitamount", "fyearcreditamount"}).finish();
        ds_all = ds_all.select(new String[]{"ftype", "forgid", "facctid", "fcurrencyid", "fstartdate", "fperiod", "fperiodname", "sumlevel", "fbalance", "fdebitamount", "fcreditamount", "case when fyearbalance = null then 0 else fyearbalance end as fyearbalance", "case when fyeardebitamount = null then 0 else fyeardebitamount end as fyeardebitamount", "case when fyearcreditamount = null then 0 else fyearcreditamount end as fyearcreditamount"});
        DealDsUtil.closeDs(ds_Year, ds_Period);
        return ds_all;
    }

    private String getFilter_periodData(PeriodParam periodParam, boolean isOccur) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (isOccur) {
            Date bDate = DateUtils.getDataFormat((Date)periodParam.getStartDate_period(), (boolean)true);
            Date eDate = DateUtils.getDataFormat((Date)periodParam.getEndDate_period(), (boolean)false);
            return String.format("fstartdate >= to_date('%1$s','yyyy-MM-dd') and fstartdate <= to_date('%2$s','yyyy-MM-dd HH:mm:ss.SSS')", sdf.format(bDate), sdf.format(eDate));
        }
        Date bDate = DateUtils.getDataFormat((Date)periodParam.getStartDate_period(), (boolean)true);
        return String.format("fstartdate < to_date('%1$s','yyyy-MM-dd')", sdf.format(bDate));
    }

    private String getFilter_yearData(PeriodParam periodParam, boolean isOccur) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date bDate = DateUtils.getDataFormat((Date)periodParam.getStartDate_year(), (boolean)false);
        if (isOccur) {
            Date eDate = DateUtils.getDataFormat((Date)periodParam.getEndDate_period(), (boolean)false);
            return String.format("to_date(fstartdate,'yyyy-MM-dd') >= to_date('%1$s','yyyy-MM-dd') and fstartdate < to_date('%2$s','yyyy-MM-dd HH:mm:ss.SSS')", sdf.format(bDate), sdf.format(eDate));
        }
        return String.format("to_date(fstartdate,'yyyy-MM-dd') < to_date('%1$s','yyyy-MM-dd')", sdf.format(bDate));
    }

    private String[] getSelField_periodData(PeriodParam periodParam, Map<Integer, PeriodParam> periodMap, boolean isOccur) {
        Date startDate = periodParam.getStartDate_period();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date bDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
        if (isOccur) {
            return new String[]{periodParam.getYear() + " as fyear", "ftype", "forgid", "facctid", "fcurrencyid", "0 as sumlevel", "to_date('" + sdf.format(bDate) + "','yyyy-MM-dd') as fstartdate", "0 as fbalance", "fdebitamount", "fcreditamount", "0 as fyearbalance", "0 as fyeardebitamount", "0 as fyearcreditamount", this.getPeriod(periodMap, startDate) + " as fperiod", "'" + this.getPeriodName(periodMap, startDate) + "' as fperiodname"};
        }
        return new String[]{periodParam.getYear() + " as fyear", "ftype", "forgid", "facctid", "fcurrencyid", "0 as sumlevel", "to_date('" + sdf.format(bDate) + "','yyyy-MM-dd') as fstartdate", "fbalance", "0 as fdebitamount", "0 as fcreditamount", "0 as fyearbalance", "0 as fyeardebitamount", "0 as fyearcreditamount", this.getPeriod(periodMap, startDate) + " as fperiod", "'" + this.getPeriodName(periodMap, startDate) + "' as fperiodname"};
    }

    private String[] getSelField_yearData(PeriodParam periodParam, Map<Integer, PeriodParam> periodMap, boolean isOccur) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        if (isOccur) {
            Date startDate = periodParam.getStartDate_period();
            Date bDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
            return new String[]{periodParam.getYear() + " as fyear", "ftype", "forgid", "facctid", "fcurrencyid", "0 as sumlevel", "to_date('" + sdf.format(bDate) + "','yyyy-MM-dd') as fstartdate", "0 as fbalance", "0 as fdebitamount", "0 as fcreditamount", "0 as fyearbalance", "fdebitamount as fyeardebitamount", "fcreditamount as fyearcreditamount", this.getPeriod(periodMap, startDate) + " as fperiod", "'" + this.getPeriodName(periodMap, startDate) + "' as fperiodname"};
        }
        Date startDate = periodParam.getStartDate_year();
        Date bDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
        return new String[]{periodParam.getYear() + " as fyear", "ftype", "forgid", "facctid", "fcurrencyid", "0 as sumlevel", "to_date('" + sdf.format(bDate) + "','yyyy-MM-dd') as fstartdate", "0 as fbalance", "0 as fdebitamount", "0 as fcreditamount", "fbalance as fyearbalance", "0 as fyeardebitamount", "0 as fyearcreditamount", "0 as fperiod", "'' as fperiodname"};
    }

    private DataSet bei_addPeriodData(DataSet ds, BalanceQueryParam queryParam, boolean isOccur) {
        log.info("ReportBalanceBei.bei_addPeriodData.");
        Map<Integer, PeriodParam> periodParam = this.getPeriodMap(queryParam);
        if (periodParam == null || periodParam.size() == 0) {
            return ds;
        }
        DataSet ds_periods = null;
        Collection<PeriodParam> periodPara = periodParam.values();
        for (PeriodParam periodP : periodPara) {
            String filter = this.getFilter_periodData(periodP, isOccur);
            DataSet ds_period = ds.copy().filter(filter);
            if (!isOccur) {
                ds_period = this.bei_getMaxDataRowDs(ds_period);
            }
            ds_period = ds_period.select(this.getSelField_periodData(periodP, periodParam, isOccur));
            ds_periods = ds_periods == null ? ds_period.copy() : ds_periods.union(ds_period);
            DealDsUtil.closeDs(ds_period);
        }
        log.info("ReportBalanceBei.bei_addPeriodData.end");
        return this.bei_sum(ds_periods);
    }

    private DataSet bei_addYearData(DataSet ds, BalanceQueryParam queryParam, boolean isOccur) {
        log.info("ReportBalanceBei.bei_addYearData.");
        Map<Integer, PeriodParam> periodParam = this.getPeriodMap(queryParam);
        if (periodParam == null || periodParam.size() == 0) {
            return ds;
        }
        DataSet ds_periods = null;
        Collection<PeriodParam> periodPara = periodParam.values();
        HashSet<Integer> year_dones = new HashSet<Integer>(16);
        for (PeriodParam periodP : periodPara) {
            int year = periodP.getYear();
            if (!isOccur && (isOccur || !year_dones.add(year))) continue;
            String filter = this.getFilter_yearData(periodP, isOccur);
            DataSet ds_period = ds.copy().filter(filter);
            if (!isOccur) {
                ds_period = this.bei_getMaxDataRowDs(ds_period);
            }
            ds_period = ds_period.select(this.getSelField_yearData(periodP, periodParam, isOccur));
            ds_periods = ds_periods == null ? ds_period.copy() : ds_periods.union(ds_period);
            DealDsUtil.closeDs(ds_period);
        }
        log.info("ReportBalanceBei.bei_addYearData.end");
        return this.bei_sum(ds_periods);
    }

    private DataSet bei_queryBalance(BalanceQueryParam queryParam) {
        log.info("ReportBalanceBei.bei_getBal.");
        String selFileds = "'2' as ftype,company.id as forgid,accountbank.id as facctid,currency.id as fcurrencyid,bizdate as fstartdate,amount as fbalance";
        QFilter filters = this.getFilter(queryParam);
        filters.and(new QFilter("bizdate", "<", (Object)DateUtils.truncateDate((Date)this.getBalEndDate(queryParam))));
        log.info("ReportBalanceBei.bei_getBal.filter:{}", (Object)filters.toString());
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bei_bankbalance", (String)selFileds, (QFilter[])filters.toArray(), null);
    }

    private DataSet bei_getMaxDataRowDs(DataSet ds) {
        DataSet ds_groupby = this.bei_dsGroupBy(ds);
        ds = ds.join(ds_groupby).on("ftype", "ftype").on("forgid", "forgid").on("facctid", "facctid").on("fcurrencyid", "fcurrencyid").on("fstartdate", "fstartdate").select(new String[]{"ftype", "forgid", "facctid", "fcurrencyid", "fstartdate", "fbalance"}).finish();
        DealDsUtil.closeDs(ds_groupby);
        return ds;
    }

    private DataSet bei_getOccur(BalanceQueryParam queryParam) {
        log.info("BeiBalance.bei_getBalance.");
        DataSet ds = this.bei_queryOccur(queryParam);
        if (queryParam.getTimeType() == TimeTypeEnum.BYDATE) {
            Date startDate = queryParam.getStartDate();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            Date bDate = DateUtils.getDataFormat((Date)startDate, (boolean)true);
            ds = ds.select(new String[]{"ftype", "forgid", "facctid", "fcurrencyid", "to_date('" + sdf.format(bDate) + "','yyyy-MM-dd') as fstartdate", "0 as fbalance", "fdebitamount", "fcreditamount", "0 as sumlevel", "0 as fyearbalance", "0 as fyeardebitamount", "0 as fyearcreditamount", "0 as fperiod", "'' as fperiodname"});
            return ds;
        }
        return this.bei_dsAddData(ds, queryParam, true);
    }

    private DataSet bei_queryOccur(BalanceQueryParam queryParam) {
        log.info("ReportBalanceBei.bei_getOccur.");
        String selFileds = "'2' as ftype,company.id as forgid,accountbank.id as facctid,currency.id as fcurrencyid, bizdate as fstartdate,debitamount as fcreditamount,creditamount as fdebitamount";
        QFilter filters = this.getFilter(queryParam);
        filters.and(new QFilter("bizdate", ">=", (Object)DateUtils.truncateDate((Date)this.getOccurStartDate(queryParam))));
        filters.and(new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)DateUtils.truncateDate((Date)queryParam.getEndDate()), (int)1)));
        log.info("ReportBalanceBei.bei_getOccur.filter:{}", (Object)filters.toString());
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bei_transdetail", (String)selFileds, (QFilter[])filters.toArray(), null);
    }

    private Date getOccurStartDate(BalanceQueryParam queryParam) {
        log.info("ReportBalanceBei.getOccurStartDate.");
        if (queryParam.getTimeType() == TimeTypeEnum.BYDATE) {
            return queryParam.getStartDate();
        }
        return this.getMinYearStartDate(queryParam);
    }

    private Date getBalEndDate(BalanceQueryParam queryParam) {
        log.info("ReportBalanceBei.getBalEndDate.");
        if (queryParam.getTimeType() == TimeTypeEnum.BYPERIOD) {
            Map<Integer, PeriodParam> periodParam = this.getPeriodMap(queryParam);
            if (periodParam == null) {
                return queryParam.getStartDate();
            }
            Collection<PeriodParam> periods = periodParam.values();
            for (PeriodParam period : periods) {
                if (!period.getPeriodId().equals(queryParam.getPeriodTo())) continue;
                return period.getStartDate_period();
            }
        }
        return queryParam.getStartDate();
    }

    private Date getMinYearStartDate(BalanceQueryParam queryParam) {
        log.info("ReportBalanceBei.getMinYearStartDate.");
        Map<Integer, PeriodParam> periodParam = this.getPeriodMap(queryParam);
        if (periodParam == null || periodParam.size() == 0) {
            return null;
        }
        int yearMin = 9999;
        Date yearMin_StartDate = null;
        Collection<PeriodParam> periodPara = periodParam.values();
        for (PeriodParam periodP : periodPara) {
            int year = periodP.getYear();
            if (year >= yearMin) continue;
            yearMin = year;
            yearMin_StartDate = periodP.getStartDate_year();
        }
        return yearMin_StartDate;
    }

    private QFilter getFilter(BalanceQueryParam queryParam) {
        Set<Long> currencyIds;
        log.info("ReportBalanceBei.getFilter.");
        QFilter filters = new QFilter("company.id", "in", queryParam.getOrgIds());
        Set<Long> acctIds = queryParam.getBankAcctIds();
        if (acctIds != null && acctIds.size() > 0) {
            filters.and(new QFilter("accountbank.id", "in", acctIds));
        }
        if ((currencyIds = queryParam.getCurrencyIds()) != null && currencyIds.size() > 0) {
            filters.and(new QFilter("currency.id", "in", currencyIds));
        }
        return filters;
    }

    private int getYearPeriod(Date date) {
        return this.getYearPeriod(DateUtils.getYear((Date)date), DateUtils.getMonth((Date)date));
    }

    private long getPeriod(Map<Integer, PeriodParam> periodMap, Date date) {
        return periodMap == null || periodMap.size() == 0 || periodMap.get(this.getYearPeriod(date)) == null ? 0L : periodMap.get(this.getYearPeriod(date)).getPeriodId();
    }

    private String getPeriodName(Map<Integer, PeriodParam> periodMap, Date date) {
        return periodMap == null || periodMap.size() == 0 ? "" : DateUtils.formatString((Date)date, (String)"YYYY.MM");
    }

    private Map<Integer, PeriodParam> getPeriodMap(BalanceQueryParam queryParam) {
        log.info("ReportBalanceService.getPeriodMap.");
        if (TimeTypeEnum.BYPERIOD != queryParam.getTimeType()) {
            return null;
        }
        DynamicObject periodFrom = PeriodHelper.getPeriodById((long)queryParam.getPeriodFrom());
        DynamicObject periodTo = PeriodHelper.getPeriodById((long)queryParam.getPeriodTo());
        queryParam.setStartDate(DateUtils.truncateDate((Date)periodFrom.getDate("begindate")));
        queryParam.setEndDate(DateUtils.truncateDate((Date)periodTo.getDate("enddate")));
        int yearPeriodFrom = this.getYearPeriod(periodFrom);
        int yearPeriodTo = this.getYearPeriod(periodTo);
        Long periodFromId = periodFrom.getLong("id");
        HashMap<Integer, PeriodParam> periodMap = new HashMap<Integer, PeriodParam>(16);
        while (yearPeriodFrom <= yearPeriodTo) {
            PeriodParam periodParam = this.getPeriodParam(periodFrom);
            periodMap.put(this.getYearPeriod(periodFrom), periodParam);
            periodFrom = PeriodHelper.getNextPeriod((long)periodFromId);
            periodFromId = periodFrom.getLong("id");
            yearPeriodFrom = this.getYearPeriod(periodFrom);
        }
        return periodMap;
    }

    private PeriodParam getPeriodParam(DynamicObject period) {
        PeriodParam periodParam = new PeriodParam();
        periodParam.setYear(period.getInt("periodyear"));
        periodParam.setPeriodId(period.getLong("id"));
        periodParam.setPeriod(period.getInt("periodnumber"));
        periodParam.setPeriodNumber(period.getString("number"));
        periodParam.setStartDate_period(DateUtils.truncateDate((Date)period.getDate("begindate")));
        periodParam.setEndDate_period(DateUtils.getNextDay((Date)period.getDate("enddate"), (int)0));
        DynamicObject yearFirstPeriod = PeriodHelper.getPeriodByYearAndNumber((long)period.getLong("periodtype.id"), (int)period.getInt("periodyear"), (int)1);
        if (yearFirstPeriod == null) {
            log.info("ReportBalanceService.getPeriodParam_type:{}_year:{}.", (Object)period.getLong("periodtype.id"), (Object)period.getInt("periodyear"));
            throw new KDBizException("the first period is not exist.");
        }
        periodParam.setStartDate_year(DateUtils.truncateDate((Date)yearFirstPeriod.getDate("begindate")));
        return periodParam;
    }

    private int getYearPeriod(DynamicObject period) {
        if (period == null) {
            throw new KDBizException("period is not exist.");
        }
        return this.getYearPeriod(period.getInt("periodyear"), period.getInt("periodnumber"));
    }

    private int getYearPeriod(int year, int month) {
        return year * 100 + month;
    }
}

