/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.service.report.reportbalance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.ext.tmc.balancemodel.BalanceValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.balancemodel.calculate.dto.Balance;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.service.BalanceDataService;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.BuildDataSet;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.BalanceQueryParam;
import kd.fi.cas.business.balancemodel.service.report.reportbalance.entity.PeriodParam;
import kd.fi.cas.enums.TimeTypeEnum;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public class ReportBalanceImpl {
    private static final int iniSize = 16;
    private static Log log = LogFactory.getLog(ReportBalanceImpl.class);

    public DataSet getReportBalanceDs(BalanceQueryParam queryParam) throws Exception {
        DataSetBuilder dsBuilder = new BuildDataSet().createDsBuilder();
        log.info("ReportBalanceJournal.getBalance.");
        List<RequestBalanceParameter> balanceParams = this.getBalParams(queryParam);
        List<ResponseBalances> balanceDatas = BalanceDataService.getInstance().getBalances(balanceParams, queryParam.getBalanceQueryType());
        this.putDataToBuilder(dsBuilder, balanceDatas, queryParam);
        log.info("ReportBalanceJournal.getBalanceDs_ds.");
        DataSet ds = dsBuilder.build().groupBy(new String[]{"fperiod", "fperiodname", "fstartdate", "forgid", "ftype", "facctid", "fcurrencyid", "sumlevel"}).sum("fbalance").sum("fdebitamount").sum("fcreditamount").sum("fyearbalance").sum("fyeardebitamount").sum("fyearcreditamount").finish();
        return ds;
    }

    private void putDataToBuilder(DataSetBuilder dsBuilder, List<ResponseBalances> balanceDatas, BalanceQueryParam queryParam) throws Exception {
        Map<Integer, PeriodParam> periodMap = this.getPeriodMap(queryParam);
        log.info("ReportBalanceJournal.putDataToBuilder.");
        BuildDataSet buildDs = new BuildDataSet();
        for (ResponseBalances balanceData : balanceDatas) {
            Balance bal = balanceData.getBalance();
            dsBuilder.append(buildDs.buildRowData(balanceData.getOrgId(), balanceData.getType(), balanceData.getAccountId(), balanceData.getCurrencyId(), this.getStartDate(queryParam, balanceData.getStartDate(), periodMap), bal.getMonthStart(), bal.getRevenueAmount(), bal.getPayAmount(), this.getPeriod(periodMap, balanceData.getStartDate()), this.getPeriodName(periodMap, balanceData.getStartDate()), bal.getYearStart(), bal.getYearRecAmount(), bal.getYearPayAmount()).toArray(new Object[0]));
        }
    }

    private Date getStartDate(BalanceQueryParam queryParam, Date date, Map<Integer, PeriodParam> periodMap) {
        return periodMap == null || periodMap.size() == 0 || periodMap.get(this.getYearPeriod(date)) == null ? queryParam.getStartDate() : periodMap.get(this.getYearPeriod(date)).getStartDate_period();
    }

    private void setBalanceDatabyPeriod(BalanceQueryParam queryParam, RequestBalanceParameter balParam) {
        DynamicObject periodFrom = PeriodHelper.getPeriodById((long)queryParam.getPeriodFrom());
        balParam.setStartDate(DateUtils.truncateDate((Date)periodFrom.getDate("begindate")));
        DynamicObject periodTo = PeriodHelper.getPeriodById((long)queryParam.getPeriodTo());
        balParam.setEndDate(DateUtils.truncateDate((Date)periodTo.getDate("enddate")));
    }

    private List<RequestBalanceParameter> getBalParams(BalanceQueryParam queryParam) {
        log.info("ReportBalanceJournal.getBalParams.");
        ArrayList<RequestBalanceParameter> returns = new ArrayList<RequestBalanceParameter>(16);
        returns.addAll(this.getBalParams_data(queryParam));
        if (TimeTypeEnum.BYPERIOD == queryParam.getTimeType()) {
            for (RequestBalanceParameter balparam : returns) {
                balparam.setQueryByPeriod(true);
                this.setBalanceDatabyPeriod(queryParam, balparam);
            }
        }
        return returns;
    }

    private List<RequestBalanceParameter> getBalParams_data(BalanceQueryParam queryParam) {
        ArrayList<RequestBalanceParameter> returns = new ArrayList<RequestBalanceParameter>(16);
        log.info("ReportBalanceJournal.getBalParams_data.");
        switch (queryParam.getBalanceType()) {
            case CASH: {
                returns.add(this.buildBalParam(queryParam, queryParam.getCashAcctIds(), BalanceType.CASH));
                break;
            }
            case BANK: {
                returns.add(this.buildBalParam(queryParam, queryParam.getBankAcctIds(), BalanceType.JOURNAL));
                break;
            }
            case CASHANDBANK: {
                returns.add(this.buildBalParam(queryParam, queryParam.getCashAcctIds(), BalanceType.CASH));
                returns.add(this.buildBalParam(queryParam, queryParam.getBankAcctIds(), BalanceType.JOURNAL));
                break;
            }
            case BEI: {
                returns.add(this.buildBalParam(queryParam, queryParam.getBankAcctIds(), BalanceType.BEI));
                break;
            }
        }
        return returns;
    }

    private RequestBalanceParameter buildBalParam(BalanceQueryParam queryParam, Set<Long> acctIds, BalanceType balanceType) {
        RequestBalanceParameter balanceParam = new RequestBalanceParameter();
        balanceParam.setType(balanceType.getValue());
        balanceParam.setOrgIds(queryParam.getOrgIds());
        balanceParam.setAccountIds(acctIds);
        balanceParam.setCurrencyIds(queryParam.getCurrencyIds());
        balanceParam.setStartDate(DateUtils.truncateDate((Date)queryParam.getStartDate()));
        balanceParam.setEndDate(DateUtils.truncateDate((Date)queryParam.getEndDate()));
        return balanceParam;
    }

    public List<BalanceValue> getBalanceValues(BalanceQueryParam queryParam) throws Exception {
        log.info("ReportBalanceJournal.getDsRecords.");
        List<RequestBalanceParameter> balanceParams = this.getBalParams(queryParam);
        List<ResponseBalances> balanceDatas = BalanceDataService.getInstance().getBalances(balanceParams, queryParam.getBalanceQueryType());
        Map<Integer, PeriodParam> periodMap = this.getPeriodMap(queryParam);
        ArrayList<BalanceValue> returns = new ArrayList<BalanceValue>(balanceDatas.size());
        for (ResponseBalances balanceData : balanceDatas) {
            Balance bal = balanceData.getBalance();
            BalanceValue value = this.buildBalanceValue(balanceData.getOrgId(), balanceData.getType(), balanceData.getAccountId(), balanceData.getCurrencyId(), this.getStartDate(queryParam, balanceData.getStartDate(), periodMap), bal.getMonthStart(), bal.getRevenueAmount(), bal.getPayAmount(), this.getPeriod(periodMap, balanceData.getStartDate()), this.getPeriodName(periodMap, balanceData.getStartDate()), bal.getYearStart(), bal.getYearRecAmount(), bal.getYearPayAmount());
            returns.add(value);
        }
        return returns;
    }

    private BalanceValue buildBalanceValue(Long orgId, String type, Long accountId, Long currencyId, Date startDate, BigDecimal monthStart, BigDecimal revenueAmount, BigDecimal payAmount, Long periodId, String periodName, BigDecimal yearStart, BigDecimal yearRecAmount, BigDecimal yearPayAmount) {
        BalanceValue returns = new BalanceValue();
        returns.setOrgId(orgId);
        returns.setType(type);
        returns.setAccountId(accountId);
        returns.setCurrencyId(currencyId);
        returns.setStartDate(startDate);
        returns.setMonthStart(monthStart);
        returns.setRevenueAmount(revenueAmount);
        returns.setPayAmount(payAmount);
        returns.setPeriodId(periodId);
        returns.setPeriodName(periodName);
        returns.setYearStart(yearStart);
        returns.setYearRecAmount(yearRecAmount);
        returns.setYearPayAmount(yearPayAmount);
        return returns;
    }

    private int getYearPeriod(DynamicObject period) {
        if (period == null) {
            throw new KDBizException("period is not exist.");
        }
        return this.getYearPeriod(period.getInt("periodyear"), period.getInt("periodnumber"));
    }

    private int getYearPeriod(int year, int month) {
        return year * 100 + month;
    }

    private int getYearPeriod(Date date) {
        return this.getYearPeriod(DateUtils.getYear((Date)date), DateUtils.getMonth((Date)date));
    }

    private long getPeriod(Map<Integer, PeriodParam> periodMap, Date date) {
        return periodMap == null || periodMap.size() == 0 || periodMap.get(this.getYearPeriod(date)) == null ? 0L : periodMap.get(this.getYearPeriod(date)).getPeriodId();
    }

    private String getPeriodName(Map<Integer, PeriodParam> periodMap, Date date) {
        return periodMap == null || periodMap.size() == 0 ? "" : DateUtils.formatString((Date)date, (String)"YYYY.MM");
    }

    private Map<Integer, PeriodParam> getPeriodMap(BalanceQueryParam queryParam) {
        log.info("ReportBalanceService.getPeriodMap.");
        if (TimeTypeEnum.BYPERIOD != queryParam.getTimeType()) {
            return null;
        }
        DynamicObject periodFrom = PeriodHelper.getPeriodById((long)queryParam.getPeriodFrom());
        DynamicObject periodTo = PeriodHelper.getPeriodById((long)queryParam.getPeriodTo());
        queryParam.setStartDate(DateUtils.truncateDate((Date)periodFrom.getDate("begindate")));
        queryParam.setEndDate(DateUtils.truncateDate((Date)periodTo.getDate("enddate")));
        int yearPeriodFrom = this.getYearPeriod(periodFrom);
        int yearPeriodTo = this.getYearPeriod(periodTo);
        Long periodFromId = periodFrom.getLong("id");
        HashMap<Integer, PeriodParam> periodMap = new HashMap<Integer, PeriodParam>(16);
        while (yearPeriodFrom <= yearPeriodTo) {
            PeriodParam periodParam = this.getPeriodParam(periodFrom);
            periodMap.put(this.getYearPeriod(periodFrom), periodParam);
            periodFrom = PeriodHelper.getNextPeriod((long)periodFromId);
            if (periodFrom == null) break;
            periodFromId = periodFrom.getLong("id");
            yearPeriodFrom = this.getYearPeriod(periodFrom);
        }
        return periodMap;
    }

    private PeriodParam getPeriodParam(DynamicObject period) {
        PeriodParam periodParam = new PeriodParam();
        periodParam.setYear(period.getInt("periodyear"));
        periodParam.setPeriodId(period.getLong("id"));
        periodParam.setPeriod(period.getInt("periodnumber"));
        periodParam.setPeriodNumber(period.getString("number"));
        periodParam.setStartDate_period(DateUtils.truncateDate((Date)period.getDate("begindate")));
        periodParam.setEndDate_period(DateUtils.getNextDay((Date)period.getDate("enddate"), (int)0));
        return periodParam;
    }
}

