/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.balancemodel.up;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.enums.BalanceModelMeta;
import kd.fi.cas.business.balancemodel.calculate.service.CalculateBalanceServiceService;
import kd.fi.cas.business.balancemodel.log.helper.BalanceModelBalanceHelper;
import kd.fi.cas.business.balancemodel.up.HisBalanceModelUpService;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.ExtendConfigHelper;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.TmcBusinessBaseHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class BalanceModelUpService {
    private static Log logger = LogFactory.getLog(BalanceModelUpService.class);
    private static final String TYPE_CASH = "1";
    private static final String TYPE_JOURNAL = "2";
    private static final String TYPE_STATE = "3";
    private static final String SPLIT = "_";

    public void doUpgrade(String type, Set<Long> orgIds, Map<Long, DynamicObject> orgPeriods) throws Exception {
        boolean useBalanceModel = ExtendConfigHelper.useBalanceModel();
        if (!useBalanceModel) {
            return;
        }
        Set<Long> existOrgIds = this.searchExistUpgrade(type);
        orgIds.removeAll(existOrgIds);
        this.moveOld2Upgrade(existOrgIds, type, orgIds);
        HashMap<Long, DynamicObject> startStates = new HashMap<Long, DynamicObject>(64);
        HashMap<String, Boolean> resetJournals = new HashMap<String, Boolean>(64);
        this.upgradeData(type, startStates, resetJournals);
        this.reCalculate(type, startStates, resetJournals);
        this.reCalculateWaitUp(type, orgPeriods);
        this.reset(type);
    }

    private Set<Long> searchExistUpgrade(String type) {
        String sqlUpgrade = "SELECT forgid FROM t_cas_balance_upgrade WHERE ftype = ?";
        HashSet<Long> existOrgIds = new HashSet<Long>(64);
        try (DataSet queryDataSet = DB.queryDataSet((String)"selectUpgradeBalance", (DBRoute)DBRoute.of((String)"fi"), (String)sqlUpgrade, (Object[])new Object[]{type});){
            for (Row row : queryDataSet) {
                Long orgId = row.getLong("forgid");
                existOrgIds.add(orgId);
            }
        }
        return existOrgIds;
    }

    private void moveOld2Upgrade(Set<Long> existOrgIds, String type, Set<Long> orgIds) {
        ArrayList<SqlParameter[]> batchParameters = new ArrayList<SqlParameter[]>(64);
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(4);
        String sqlBalance = "SELECT distinct forgid from T_CAS_JournalBalance WHERE ftype=?";
        HashSet<Long> balanceOrgIds = new HashSet<Long>(64);
        try (DataSet queryDataSet = DB.queryDataSet((String)"selectOldBalance", (DBRoute)DBRoute.of((String)"fi"), (String)sqlBalance, (Object[])new Object[]{type});){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long orgId = row.getLong("forgid");
                if (orgId == null || orgId.equals(0L)) continue;
                balanceOrgIds.add(orgId);
                long[] ids = DBServiceHelper.genLongIds((String)"t_cas_balance_upgrade", (int)1);
                if (existOrgIds.contains(orgId)) continue;
                sqlParams.clear();
                sqlParams.add(new SqlParameter(":FID", -5, (Object)ids[0]));
                sqlParams.add(new SqlParameter(":FORGID", -5, (Object)orgId));
                sqlParams.add(new SqlParameter(":FSTATUS", -15, (Object)"0"));
                sqlParams.add(new SqlParameter(":FCREATEDATE", 91, (Object)new Date()));
                sqlParams.add(new SqlParameter(":FTYPE", -15, (Object)type));
                sqlParams.add(new SqlParameter(":FCOMEBALANCE", -15, (Object)TYPE_CASH));
                batchParameters.add(sqlParams.toArray(new SqlParameter[sqlParams.size()]));
            }
        }
        orgIds.removeAll(balanceOrgIds);
        if (orgIds.size() > 0) {
            for (Long orgId : orgIds) {
                if (orgId.equals(0L)) continue;
                sqlParams.clear();
                long[] ids = DBServiceHelper.genLongIds((String)"t_cas_balance_upgrade", (int)1);
                sqlParams.add(new SqlParameter(":FID", -5, (Object)ids[0]));
                sqlParams.add(new SqlParameter(":FORGID", -5, (Object)orgId));
                sqlParams.add(new SqlParameter(":FSTATUS", -15, (Object)"0"));
                sqlParams.add(new SqlParameter(":FCREATEDATE", 91, (Object)new Date()));
                sqlParams.add(new SqlParameter(":FTYPE", -15, (Object)type));
                sqlParams.add(new SqlParameter(":FCOMEBALANCE", -15, (Object)"0"));
                batchParameters.add(sqlParams.toArray(new SqlParameter[sqlParams.size()]));
            }
        }
        if (batchParameters.size() == 0) {
            return;
        }
        var9_9 = null;
        try (TXHandle tx = TX.requiresNew();){
            try {
                String insertUpgrade = "INSERT INTO t_cas_balance_upgrade (fid, forgid, fstatus, fcreatedate, ftype, fcomebalance) VALUES (?, ?, ?, ?, ?, ?)";
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)insertUpgrade, batchParameters);
                tx.commit();
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u65e7\u4fe1\u606f\u63d2\u5165\u5347\u7ea7\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
    }

    private void upgradeData(String type, Map<Long, DynamicObject> startStates, Map<String, Boolean> resetJournals) throws Exception {
        String sqlUpgrade = "SELECT forgid FROM t_cas_balance_upgrade WHERE fstatus = '0' and ftype = ?";
        HashSet<Long> existUpgradeOrgIds = new HashSet<Long>(64);
        try (DataSet queryDataSet = DB.queryDataSet((String)"selectUpgradeBalanceOrg", (DBRoute)DBRoute.of((String)"fi"), (String)sqlUpgrade, (Object[])new Object[]{type});){
            for (Row row : queryDataSet) {
                Long orgId = row.getLong("forgid");
                existUpgradeOrgIds.add(orgId);
            }
        }
        String entityName = "";
        String tableName = "";
        if (TYPE_CASH.equals(type)) {
            entityName = BalanceModelMeta.CASH.getMetaName();
            tableName = BalanceModelMeta.CASH.getTableName();
        } else if (TYPE_JOURNAL.equals(type)) {
            entityName = BalanceModelMeta.JOURNAL.getMetaName();
            tableName = BalanceModelMeta.JOURNAL.getTableName();
        } else if (TYPE_STATE.equals(type)) {
            entityName = BalanceModelMeta.STATE.getMetaName();
            tableName = BalanceModelMeta.STATE.getTableName();
        }
        HashMap<Long, DynamicObject> startState = new HashMap(2);
        HashMap<String, Boolean> resetJournal = new HashMap(2);
        if (TYPE_STATE.equals(type)) {
            startState = BalanceModelBalanceHelper.resetStatement(existUpgradeOrgIds);
            startStates.putAll(startState);
        } else {
            resetJournal = BalanceModelBalanceHelper.resetJournal(existUpgradeOrgIds, type);
            resetJournals.putAll(resetJournal);
        }
        HashSet<String> successLock = new HashSet<String>(existUpgradeOrgIds.size());
        HashSet<String> failedLock = new HashSet<String>(existUpgradeOrgIds.size());
        HashSet<Long> dealOrgIds = new HashSet<Long>(existUpgradeOrgIds.size());
        this.batchLock(existUpgradeOrgIds, successLock, failedLock, dealOrgIds);
        try {
            for (Long orgId : dealOrgIds) {
                DataSet data;
                Long lastPageId = null;
                DynamicObject lastPeriod = null;
                int pageSize = 1000;
                int page = 0;
                HashSet<String> existJournalBalances = new HashSet<String>(64);
                while (!(data = ORM.create().queryDataSet(HisBalanceModelUpService.class.getName(), "cas_journalbalance", "id, org, accountbank, accountcash, currency, type, period, monthstart, monthbalance, monthdebit, monthcredit, yearstart, yearbalance, yeardebit, yearcredit", new QFilter[]{new QFilter("type", "=", (Object)type), new QFilter("org", "=", (Object)orgId)}, "id", page * pageSize, pageSize)).isEmpty()) {
                    HashSet<Long> periodIds = new HashSet<Long>(64);
                    DataSet dataCopy = data.copy();
                    for (Row row : dataCopy) {
                        periodIds.add(row.getLong("period"));
                    }
                    dataCopy.close();
                    Set<String> existKey = this.existBalanceKey(orgId, entityName);
                    DynamicObject[] periods = PeriodHelper.getPeriodByIds(periodIds);
                    Map<Long, DynamicObject> periodMap = Arrays.stream(periods).collect(Collectors.toMap(o -> o.getLong("id"), Function.identity()));
                    try (TXHandle tx = TX.requiresNew();){
                        try {
                            ArrayList<Object[]> batchUpdateParameters = new ArrayList<Object[]>(64);
                            for (Row row : data) {
                                lastPageId = row.getLong("id");
                                this.insertBatchFields(row, batchUpdateParameters, existKey, type, periodMap, existJournalBalances, startState, resetJournal);
                                Long periodId = row.getLong("period");
                                DynamicObject period = periodMap.get(periodId);
                                if (period == null || EmptyUtil.isEmpty((DynamicObject)period)) continue;
                                if (TYPE_STATE.equals(type)) {
                                    if (lastPeriod != null && !PeriodHelper.after((DynamicObject)lastPeriod, (DynamicObject)period)) continue;
                                    lastPeriod = period;
                                    continue;
                                }
                                if (lastPeriod != null && !PeriodHelper.before((DynamicObject)lastPeriod, (DynamicObject)period)) continue;
                                lastPeriod = period;
                            }
                            String insertBalance = "INSERT INTO " + tableName + "  (FID, FORGID, FACCOUNTID, FCURRENCYID, FMONTHSTART, FMONTHBALANCE, FSTARTDATE, FENDDATE, FYEAR, FMONTH, FPAYAMOUNT, FREVENUEAMOUNT, FISRESET, FISUPGRADE, FYEARSTART, FYEARBALANCE, FYEARPAYAMOUNT, FYEARRECAMOUNT) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                            if (batchUpdateParameters.size() > 0) {
                                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)insertBalance, batchUpdateParameters);
                                tx.commit();
                            }
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u65e7\u4fe1\u606f\u63d2\u5165\u65b0\u4f59\u989d\u8868\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
                        }
                    }
                    ++page;
                    data.close();
                }
                if (lastPageId != null && lastPeriod != null) {
                    TXHandle tx = TX.requiresNew();
                    Throwable throwable = null;
                    try {
                        try {
                            ArrayList<Object[]> paramList = new ArrayList<Object[]>(8);
                            paramList.add(new Object[]{TYPE_CASH, lastPageId, new Date(), lastPeriod.getDate("begindate"), type, orgId});
                            String updateUpgrade = "UPDATE t_cas_balance_upgrade SET fstatus=?, flastpageid=?, ffinishdate=?, fcaldate=? WHERE ftype=? and forgid =?";
                            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)updateUpgrade, paramList);
                            tx.commit();
                            continue;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u66f4\u65b0\u5347\u7ea7\u8868\u72b6\u6001\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
                            throw e;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                        continue;
                    }
                }
                logger.info("the next period is null or lastPageId is null or isUpdate is false, org id is:{}, type is :{}", (Object)orgId, (Object)type);
            }
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
            throw e;
        }
        finally {
            this.batchRelease(successLock);
        }
    }

    private void reCalculate(String type, Map<Long, DynamicObject> startStates, Map<String, Boolean> resetJournals) throws Exception {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String selectUpgrade = "SELECT forgid, fcaldate FROM t_cas_balance_upgrade WHERE fstatus = '1' and ftype=?";
                HashSet<Long> reCalOrgIds = new HashSet<Long>(64);
                CalculateBalanceServiceService calculateBalanceService = CalculateBalanceServiceService.getInstance();
                try (DataSet queryDataSet = DB.queryDataSet((String)"selectUpgradeBalance", (DBRoute)DBRoute.of((String)"fi"), (String)selectUpgrade, (Object[])new Object[]{type});){
                    for (Row row : queryDataSet) {
                        DynamicObject period;
                        Long orgId = row.getLong("forgid");
                        Date date = row.getDate("fcaldate");
                        RequestBalanceParameter requestBalanceParameter = new RequestBalanceParameter();
                        requestBalanceParameter.setOrgIds(Collections.singleton(orgId));
                        requestBalanceParameter.setType(type);
                        requestBalanceParameter.setStartDate(date);
                        requestBalanceParameter.setEndDate(date);
                        requestBalanceParameter.setRecomputeCurrent(false);
                        if (TYPE_STATE.equals(type)) {
                            requestBalanceParameter.setStartInitState(startStates);
                        } else {
                            requestBalanceParameter.setResetJournals(resetJournals);
                        }
                        calculateBalanceService.reCalculate(requestBalanceParameter);
                        reCalOrgIds.add(orgId);
                        if (!TYPE_STATE.equals(type) || startStates == null || startStates.size() == 0 || (period = startStates.get(orgId)) == null || EmptyUtil.isEmpty((DynamicObject)period)) continue;
                        Date startDate = period.getDate("begindate");
                        if (date.getTime() == startDate.getTime()) continue;
                        logger.info("recalculate statement data again, date:{}", (Object)startDate);
                        requestBalanceParameter = new RequestBalanceParameter();
                        requestBalanceParameter.setOrgIds(Collections.singleton(orgId));
                        requestBalanceParameter.setType(type);
                        requestBalanceParameter.setStartDate(startDate);
                        requestBalanceParameter.setEndDate(startDate);
                        requestBalanceParameter.setRecomputeCurrent(false);
                        calculateBalanceService.reCalculate(requestBalanceParameter);
                    }
                }
                if (reCalOrgIds.size() > 0) {
                    String sql = "UPDATE t_cas_balance_upgrade  SET fstatus = '2'  WHERE forgid IN(" + TmcBusinessBaseHelper.idListToString(new ArrayList(reCalOrgIds)) + ") AND ftype=?";
                    DB.execute((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{type});
                }
                tx.commit();
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u6267\u884c\u91cd\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
            }
        }
    }

    private void reCalculateWaitUp(String type, Map<Long, DynamicObject> orgPeriods) throws Exception {
        try (TXHandle tx = TX.requiresNew();){
            try {
                String selectUpgrade = "SELECT forgid, fcaldate FROM t_cas_balance_upgrade WHERE fstatus != '2' and fcomebalance = '0' and ftype=?";
                HashSet<Long> reCalOrgIds = new HashSet<Long>(64);
                CalculateBalanceServiceService calculateBalanceService = CalculateBalanceServiceService.getInstance();
                try (DataSet queryDataSet = DB.queryDataSet((String)"selectUpgradeBalance", (DBRoute)DBRoute.of((String)"fi"), (String)selectUpgrade, (Object[])new Object[]{type});){
                    for (Row row : queryDataSet) {
                        Long orgId = row.getLong("forgid");
                        DynamicObject startPeriod = orgPeriods.get(orgId);
                        if (startPeriod == null) continue;
                        Date date = startPeriod.getDate("begindate");
                        RequestBalanceParameter requestBalanceParameter = new RequestBalanceParameter();
                        requestBalanceParameter.setOrgIds(Collections.singleton(orgId));
                        requestBalanceParameter.setType(type);
                        requestBalanceParameter.setStartDate(date);
                        requestBalanceParameter.setEndDate(date);
                        requestBalanceParameter.setRecomputeCurrent(false);
                        calculateBalanceService.reCalculate(requestBalanceParameter);
                        reCalOrgIds.add(orgId);
                    }
                }
                if (reCalOrgIds.size() > 0) {
                    String sql = "UPDATE t_cas_balance_upgrade  SET fstatus = '2'  WHERE forgid IN(" + TmcBusinessBaseHelper.idListToString(new ArrayList(reCalOrgIds)) + ") AND ftype=?";
                    DB.execute((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{type});
                }
                tx.commit();
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u6267\u884c\u91cd\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
            }
        }
    }

    private void reset(String type) throws Exception {
        try {
            String selectUpgrade = "SELECT forgid, fcaldate FROM t_cas_balance_upgrade WHERE fstatus = '2' and ftype=?";
            HashSet<Long> resetOrgIds = new HashSet<Long>(64);
            try (DataSet queryDataSet = DB.queryDataSet((String)"selectUpgradeBalance", (DBRoute)DBRoute.of((String)"fi"), (String)selectUpgrade, (Object[])new Object[]{type});){
                for (Row row : queryDataSet) {
                    Long orgId = row.getLong("forgid");
                    resetOrgIds.add(orgId);
                }
            }
            var5_6 = null;
            try (TXHandle tx = TX.requiresNew();){
                try {
                    BalanceModelBalanceHelper.reset(type, resetOrgIds, null);
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("\u4f59\u989d\u6a21\u578b\u5347\u7ea7\u65f6\uff0c\u6267\u884c\u91cd\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a\n", (Throwable)e);
            throw e;
        }
    }

    private Set<String> existBalanceKey(Long orgId, String entityName) {
        DynamicObject[] balances;
        HashSet<String> existKey = new HashSet<String>(64);
        if (orgId == null) {
            return existKey;
        }
        for (DynamicObject balance : balances = BusinessDataServiceHelper.load((String)entityName, (String)"org, account, currency, year, month", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)})) {
            DynamicObject org = balance.getDynamicObject("org");
            DynamicObject account = balance.getDynamicObject("account");
            if (account == null || EmptyUtil.isEmpty((DynamicObject)account)) continue;
            Long accountId = account.getLong("id");
            DynamicObject currency = balance.getDynamicObject("currency");
            if (currency == null || EmptyUtil.isEmpty((DynamicObject)currency)) continue;
            Long currencyId = currency.getLong("id");
            int year = balance.getInt("year");
            int month = balance.getInt("month");
            String keyStr = StringUtils.joinKeyString((String)SPLIT, (Object[])new Object[]{org.getLong("id"), accountId, currencyId, year, month});
            existKey.add(keyStr);
        }
        return existKey;
    }

    private void insertBatchFields(Row row, List<Object[]> batchUpdateParameters, Set<String> existKey, String type, Map<Long, DynamicObject> periodMap, Set<String> existJournalBalances, Map<Long, DynamicObject> startState, Map<String, Boolean> resetJournal) throws Exception {
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(32);
        Long rowOrgId = row.getLong("org");
        if (rowOrgId == null || rowOrgId == 0L) {
            this.logWarn("it shows the dirty data, that would be had org data\u3002\u3002\u3002\u3002\u3002\u3002");
            return;
        }
        params.add(new SqlParameter(":FID", -5, (Object)row.getLong("id")));
        params.add(new SqlParameter(":forgid", -5, (Object)row.getLong("org")));
        Long rowAccountId = null;
        if (TYPE_CASH.equals(type)) {
            rowAccountId = row.getLong("accountcash");
            params.add(new SqlParameter(":faccountid", -5, (Object)rowAccountId));
        } else {
            rowAccountId = row.getLong("accountbank");
            params.add(new SqlParameter(":faccountid", -5, (Object)rowAccountId));
        }
        if (rowAccountId == null || rowAccountId == 0L) {
            this.logWarn("it displays the dirty data, that would be had account data\u3002\u3002\u3002\u3002\u3002\u3002");
            return;
        }
        Long rowCurrencyId = row.getLong("currency");
        params.add(new SqlParameter(":FCurrencyID", -5, (Object)rowCurrencyId));
        params.add(new SqlParameter(":FMonthStart", 3, (Object)row.getBigDecimal("monthstart")));
        params.add(new SqlParameter(":FMonthBalance", 3, (Object)row.getBigDecimal("monthbalance")));
        Long periodId = row.getLong("period");
        DynamicObject period = periodMap.get(periodId);
        if (period == null || EmptyUtil.isEmpty((DynamicObject)period)) {
            logger.warn("org:{}, account:{}, currency:{},the period is null in journal balance table, that should do continue......", new Object[]{rowOrgId, rowAccountId, rowCurrencyId});
            return;
        }
        int year = period.getInt("periodyear");
        int month = period.getInt("periodnumber");
        String key = StringUtils.joinKeyString((String)SPLIT, (Object[])new Object[]{rowOrgId, rowAccountId, rowCurrencyId, year, month});
        if (existJournalBalances.contains(key)) {
            this.logWarn("the key :{" + key + "} is exist on old balance table, so return operation\u3002\u3002\u3002\u3002\u3002");
            return;
        }
        existJournalBalances.add(key);
        if (existKey.contains(key)) {
            this.logWarn("the key :{" + key + "} is exist on new table, so not do save operation\u3002\u3002\u3002\u3002\u3002");
            return;
        }
        Date beginDate = period.getDate("begindate");
        Date endDate = period.getDate("enddate");
        params.add(new SqlParameter(":fstartdate", 91, (Object)beginDate));
        params.add(new SqlParameter(":fenddate", 91, (Object)endDate));
        params.add(new SqlParameter(":fyear", 4, (Object)year));
        params.add(new SqlParameter(":fmonth", 4, (Object)month));
        if (TYPE_STATE.equals(type)) {
            params.add(new SqlParameter(":fpayamount", 3, (Object)row.getBigDecimal("monthdebit")));
            params.add(new SqlParameter(":frevenueamount", 3, (Object)row.getBigDecimal("monthcredit")));
            this.setStateReset(startState, rowOrgId, periodId, params);
        } else {
            params.add(new SqlParameter(":fpayamount", 3, (Object)row.getBigDecimal("monthcredit")));
            params.add(new SqlParameter(":frevenueamount", 3, (Object)row.getBigDecimal("monthdebit")));
            String resetKey = StringUtils.joinKeyString((String)SPLIT, (Object[])new Object[]{type, rowOrgId, rowAccountId, rowCurrencyId, periodId});
            this.setJournalReset(resetKey, params, resetJournal);
        }
        params.add(new SqlParameter(":fisupgrade", -15, (Object)TYPE_CASH));
        params.add(new SqlParameter(":fyearstart", 3, (Object)row.getBigDecimal("yearstart")));
        params.add(new SqlParameter(":fyearbalance", 3, (Object)row.getBigDecimal("yearbalance")));
        if (TYPE_STATE.equals(type)) {
            params.add(new SqlParameter(":fyearpayamount", 3, (Object)row.getBigDecimal("yeardebit")));
            params.add(new SqlParameter(":fyearrecamount", 3, (Object)row.getBigDecimal("yearcredit")));
        } else {
            params.add(new SqlParameter(":fyearpayamount", 3, (Object)row.getBigDecimal("yearcredit")));
            params.add(new SqlParameter(":fyearrecamount", 3, (Object)row.getBigDecimal("yeardebit")));
        }
        batchUpdateParameters.add(params.toArray(new SqlParameter[params.size()]));
    }

    private void setStateReset(Map<Long, DynamicObject> startState, Long rowOrgId, Long periodId, List<SqlParameter> params) {
        Long statePeriodId;
        if (startState.size() == 0) {
            params.add(new SqlParameter(":fisreset", -15, (Object)"0"));
            return;
        }
        DynamicObject statePeriod = startState.get(rowOrgId);
        if (statePeriod != null && EmptyUtil.isNoEmpty((DynamicObject)statePeriod) && (statePeriodId = Long.valueOf(statePeriod.getLong("id"))).compareTo(periodId) == 0) {
            params.add(new SqlParameter(":fisreset", -15, (Object)TYPE_CASH));
            return;
        }
        params.add(new SqlParameter(":fisreset", -15, (Object)"0"));
    }

    private void setJournalReset(String resetKey, List<SqlParameter> params, Map<String, Boolean> resetJournal) {
        if (!resetJournal.containsKey(resetKey)) {
            params.add(new SqlParameter(":fisreset", -15, (Object)"0"));
            return;
        }
        Boolean isReset = resetJournal.get(resetKey);
        if (isReset != null && isReset.booleanValue()) {
            params.add(new SqlParameter(":fisreset", -15, (Object)TYPE_CASH));
            return;
        }
        params.add(new SqlParameter(":fisreset", -15, (Object)"0"));
    }

    private void batchLock(Set<Long> orgIds, Set<String> successLatKeys, Set<String> failedLatKeys, Set<Long> dealOrgIds) {
        try {
            ArrayList<String> orgIdList = new ArrayList<String>(orgIds.size());
            for (Long orgId : orgIds) {
                String lockStr = "BALANCEUPGRADE_" + orgId;
                orgIdList.add(lockStr);
            }
            Map lockResultMap = MutexServiceHelper.batchRequest(orgIdList, (String)"fi-cas-business", (String)"upgradeBalance");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (Boolean.TRUE.equals(next.getValue())) {
                    String[] keys = key.split(SPLIT);
                    Long orgId = Long.valueOf(keys[1]);
                    dealOrgIds.add(orgId);
                    successLatKeys.add(key);
                    continue;
                }
                failedLatKeys.add(key);
            }
            if (failedLatKeys != null && failedLatKeys.size() > 0) {
                this.logWarn(ResManager.loadKDString((String)"\u52a0\u9501\uff1a\u65e7\u4f59\u989d\u5347\u7ea7\u5230\u65b0\u4f59\u989d\u8868: %s \u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"BalanceModelUpService_0", (String)"fi-cas-business", (Object[])new Object[]{failedLatKeys}));
            }
        }
        catch (Exception e1) {
            logger.error("to get lock Exception is:", (Throwable)e1);
            throw e1;
        }
    }

    private void batchRelease(Set<String> successLatKeys) {
        try {
            if (successLatKeys.size() == 0) {
                return;
            }
            ArrayList<String> keys = new ArrayList<String>(successLatKeys.size());
            keys.addAll(successLatKeys);
            logger.info("\u91ca\u653e\u9501\uff1a\u65e7\u4f59\u989d\u5347\u7ea7\u5230\u65b0\u4f59\u989d\u8868\uff1a{}", successLatKeys);
            Map releaseResultMap = MutexServiceHelper.batchRelease(keys, (String)"fi-cas-business", (String)"upgradeBalance");
            logger.info("\u91ca\u653e\u9501\uff1a\u65e7\u4f59\u989d\u5347\u7ea7\u5230\u65b0\u4f59\u989d\u8868\u7ed3\u679c\u96c6\u4fe1\u606f: {}", (Object)SerializationUtils.toJsonString((Object)releaseResultMap));
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u91ca\u653e\u9501\uff1a\u65e7\u4f59\u989d\u5347\u7ea7\u5230\u65b0\u4f59\u989d\u8868:\u5931\u8d25", (String)"BalanceModelUpService_3", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private void logWarn(String msg) {
        logger.warn(msg);
    }
}

