/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.closeperiod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.closeperiod.abstracts.AbstractPreClosePeriodCheck;
import kd.fi.cas.business.closeperiod.plugin.CheckWithFinishInitPlugin;
import kd.fi.cas.business.pojo.CasCheckContext;
import kd.fi.cas.business.service.BalanceCalculateService;
import kd.fi.cas.helper.FinalCheckOutHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;
import kd.sdk.fi.fcm.extpoint.checkitem.CheckContext;
import kd.sdk.fi.fcm.extpoint.checkitem.CheckResult;

public class FinishInitPreCheck
extends AbstractPreClosePeriodCheck {
    private static final Log logger = LogFactory.getLog(CheckWithFinishInitPlugin.class);
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("finalCheckOutRegion");
    private BalanceCalculateService balanceCalculateService = new BalanceCalculateService();
    private static final String CACHE_PREFIX = "cp_finish_init_";

    public static AbstractPreClosePeriodCheck getInstance() {
        return Singleton.instance;
    }

    @Override
    public CasCheckContext createCasCheckContext(CheckContext checkContext) {
        CasCheckContext casCheckContext = super.createCasCheckContext(checkContext);
        casCheckContext.setOrgId(checkContext.getOrgId());
        casCheckContext.setErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u94f6\u4f01\u5bf9\u8d26\u5e73\u8861\u68c0\u67e5\u7ed3\u679c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"FinishInitPreCheck_01", (String)"fi-cas-business", (Object[])new Object[0]));
        return casCheckContext;
    }

    @Override
    public CheckResult check(CasCheckContext casCheckContext) {
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(true);
        Long orgId = casCheckContext.getOrgId();
        if (cache.contains(orgId + "")) {
            String msg = (String)cache.get(orgId + "");
            logger.info("[FinishInitCheck]orgid\uff1a{}\uff0ccheckResult\uff1a{}", (Object)orgId, (Object)msg);
            cache.remove(orgId + "");
            if (EmptyUtil.isNoEmpty((String)msg)) {
                checkResult.setIsSuccess(false);
                ArrayList<String> errorMsg = new ArrayList<String>(1);
                errorMsg.add(msg);
                checkResult.setMessages(errorMsg);
            }
            return checkResult;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod", (QFilter[])new QFilter[]{filter});
        QFilter checkOutFilter = new QFilter("org", "=", (Object)orgId);
        checkOutFilter.and("checkoutstatus", "in", Arrays.asList("1", "2", "4"));
        DynamicObject finalCheckout = BusinessDataServiceHelper.loadSingle((String)"cas_finalcheckout", (QFilter[])new QFilter[]{checkOutFilter});
        ArrayList<Long> orgIdList = new ArrayList<Long>(10);
        HashMap<Long, DynamicObject> orgDyObjMap = new HashMap<Long, DynamicObject>(16);
        if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject)) {
            Boolean checkBalance = FinalCheckOutHelper.getInstance().toCreateBalanceAdjust(finalCheckout, true);
            if (checkBalance.booleanValue()) {
                orgIdList.add(orgId);
                orgDyObjMap.put(orgId, finalCheckout);
            }
            DynamicObject recPeriod = dynamicObject.getDynamicObject("recperiod");
            filter.and(new QFilter("initperiod", "=", recPeriod.getPkValue()));
            DynamicObject recInitObject = BusinessDataServiceHelper.loadSingle((String)"cas_rec_init", (String)"id, isfinishinit", (QFilter[])new QFilter[]{filter});
            if (EmptyUtil.isEmpty((DynamicObject)recInitObject) || !recInitObject.getBoolean("isfinishinit")) {
                checkResult.setIsSuccess(false);
                ArrayList<String> errorMsg = new ArrayList<String>(1);
                errorMsg.add(ResManager.loadKDString((String)"\u5f53\u524d\u7ed3\u8d26\u671f\u95f4\u5df2\u542f\u7528\u94f6\u4f01\u5bf9\u8d26\u5e76\u4e14\u94f6\u4f01\u5bf9\u8d26\u5e73\u8861\u540e\u624d\u5141\u8bb8\u7ed3\u8d26\uff0c\u8bf7\u5148\u5b8c\u6210\u5bf9\u8d26\u521d\u59cb\u5316\u518d\u7ed3\u8d26\u3002", (String)"CheckWithFinishInitPlugin_0", (String)"fi-cas-business", (Object[])new Object[0]));
                checkResult.setMessages(errorMsg);
                return checkResult;
            }
        }
        this.balanceCalculateService.setOrgList(orgIdList);
        this.balanceCalculateService.setOrgDynamic(orgDyObjMap);
        List<DynamicObject> adjustList = this.balanceCalculateService.calc();
        ArrayList<String> errorMsg = new ArrayList<String>(1);
        if (!this.balanceCalculateService.getErrorMsgs().isEmpty()) {
            List<String> errorList = this.balanceCalculateService.getErrorMsgs().get(orgId);
            if (EmptyUtil.isNoEmpty(errorList)) {
                errorMsg.addAll(errorList);
            }
        } else {
            HashSet<Long> removeAdjustOrgIds = new HashSet<Long>(adjustList.size());
            Set orgIdSet = adjustList.stream().filter(dy -> EmptyUtil.isNoEmpty((DynamicObject)dy.getDynamicObject("org"))).map(dy -> dy.getDynamicObject("org").getLong("id")).collect(Collectors.toSet());
            Set accountIdSet = adjustList.stream().filter(dy -> EmptyUtil.isNoEmpty((Long)dy.getLong("bankaccount_id"))).map(dy -> dy.getLong("bankaccount_id")).collect(Collectors.toSet());
            HashMap idAndOrgMap = new HashMap(16);
            if (EmptyUtil.isNoEmpty(orgIdSet)) {
                DynamicObjectCollection orgList = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])new QFilter("id", "in", orgIdSet).toArray());
                orgList.forEach(org -> idAndOrgMap.put(org.getLong("id"), org));
            }
            Map accountMap = new HashMap(16);
            if (EmptyUtil.isNoEmpty(accountIdSet)) {
                accountMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (String)"id,bankaccountnumber,currency", (QFilter[])new QFilter("id", "in", accountIdSet).toArray());
            }
            for (int i = 0; i < adjustList.size(); ++i) {
                BigDecimal adjustJournalAmt = adjustList.get(i).getBigDecimal("adjustjournalamt");
                BigDecimal adjustStatementAmt = adjustList.get(i).getBigDecimal("adjuststatementamt");
                Long adjustOrgId = adjustList.get(i).getDynamicObject("org").getLong("id");
                if (adjustStatementAmt.compareTo(new BigDecimal("0")) == 0) {
                    adjustStatementAmt = new BigDecimal("0");
                }
                if (adjustJournalAmt.compareTo(new BigDecimal("0")) == 0) {
                    adjustJournalAmt = new BigDecimal("0");
                }
                logger.info("[FinishInitCheck]adjustJournalAmt\uff1a{}\uff0c adjustStatementAmt\uff1a{}", (Object)adjustJournalAmt, (Object)adjustStatementAmt);
                if (adjustJournalAmt.compareTo(adjustStatementAmt) == 0) continue;
                String curMes = "";
                Long bankAccountId = adjustList.get(i).getLong("bankaccount_id");
                DynamicObject bankAccount = (DynamicObject)accountMap.get(bankAccountId);
                if (EmptyUtil.isEmpty((DynamicObject)bankAccount)) continue;
                Long currency = adjustList.get(i).getLong("currency_id");
                DynamicObjectCollection currencyCol = bankAccount.getDynamicObjectCollection("currency");
                for (DynamicObject cur : currencyCol) {
                    Long currencyId = cur.getDynamicObject("fbasedataid").getLong("id");
                    if (currency.compareTo(currencyId) != 0) continue;
                    curMes = cur.getDynamicObject("fbasedataid").getLocaleString("name").getLocaleValue();
                }
                DynamicObject org2 = (DynamicObject)idAndOrgMap.get(adjustOrgId);
                String msg = StringUtils.formatMessage((String)ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a{0}\u3001\u8d26\u6237\uff1a{1}\u3001\u5e01\u79cd\uff1a{2}\u5bf9\u5e94\u7684\u4f59\u989d\u8c03\u8282\u8868\u8c03\u6574\u540e\u4f59\u989d\u4e0d\u5e73\uff0c\u4e0d\u80fd\u7ed3\u8d26\u3002", (String)"CheckWithFinishInitPlugin_1", (String)"fi-cas-business", (Object[])new Object[0]), (Object[])new Object[]{EmptyUtil.isNoEmpty((DynamicObject)org2) ? org2.getString("name") : "", bankAccount.getString("bankaccountnumber"), curMes});
                errorMsg.add(msg);
                logger.info("[FinishInitCheck]daily\uff1a{}\uff0cstatement\uff1a{}", (Object)adjustJournalAmt, (Object)adjustStatementAmt);
                removeAdjustOrgIds.add(adjustOrgId);
                this.removeAdjust(adjustList, removeAdjustOrgIds);
            }
        }
        if (!errorMsg.isEmpty()) {
            checkResult.setIsSuccess(false);
            checkResult.setMessages(errorMsg);
            return checkResult;
        }
        return checkResult;
    }

    private void removeAdjust(List<DynamicObject> adjustList, Set<Long> removeAdjustOrgIds) {
        if (removeAdjustOrgIds.size() == 0) {
            return;
        }
        HashSet<DynamicObject> removeAdjust = new HashSet<DynamicObject>(removeAdjustOrgIds.size());
        for (int i = 0; i < adjustList.size(); ++i) {
            DynamicObject adjust = adjustList.get(i);
            Long orgId = adjustList.get(i).getDynamicObject("org").getLong("id");
            if (!removeAdjustOrgIds.contains(orgId)) continue;
            removeAdjust.add(adjust);
        }
        if (removeAdjust.size() > 0) {
            adjustList.removeAll(removeAdjust);
        }
    }

    @Override
    public String getCacheKey(CasCheckContext casCheckContext) {
        return CACHE_PREFIX + casCheckContext.getOrgId();
    }

    static class Singleton {
        private static final FinishInitPreCheck instance = new FinishInitPreCheck();

        Singleton() {
        }
    }
}

