/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.closeperiod;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cas.business.closeperiod.abstracts.AbstractPreClosePeriodCheck;
import kd.fi.cas.business.pojo.CasCheckContext;
import kd.fi.cas.helper.GLBusinessHelper;
import kd.sdk.fi.fcm.extpoint.checkitem.CheckContext;
import kd.sdk.fi.fcm.extpoint.checkitem.CheckResult;

public class WithGLPreCheck
extends AbstractPreClosePeriodCheck {
    private static final String CACHE_PREFIX = "cp_with_gl_";

    public static AbstractPreClosePeriodCheck getInstance() {
        return Singleton.instance;
    }

    @Override
    public CasCheckContext createCasCheckContext(CheckContext checkContext) {
        CasCheckContext casCheckContext = super.createCasCheckContext(checkContext);
        casCheckContext.setOrgId(checkContext.getOrgId());
        casCheckContext.setPeriodId(checkContext.getPeriodId());
        casCheckContext.setErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u603b\u8d26\u5bf9\u8d26\u5e73\u8861\u68c0\u67e5\u7ed3\u679c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"WithGLPreCheck_01", (String)"fi-cas-business", (Object[])new Object[0]));
        return casCheckContext;
    }

    @Override
    public CheckResult check(CasCheckContext casCheckContext) {
        CheckResult checkResult = new CheckResult();
        checkResult.setIsSuccess(true);
        Long orgId = casCheckContext.getOrgId();
        Long periodId = casCheckContext.getPeriodId();
        List errorMsg = GLBusinessHelper.getCheckWithGL((Long)orgId, (Long)periodId, (Boolean)false);
        if (!errorMsg.isEmpty()) {
            checkResult.setIsSuccess(false);
            checkResult.setMessages(errorMsg);
        }
        return checkResult;
    }

    @Override
    public String getCacheKey(CasCheckContext casCheckContext) {
        return CACHE_PREFIX + casCheckContext.getOrgId() + "_" + casCheckContext.getPeriodId();
    }

    static class Singleton {
        private static final WithGLPreCheck instance = new WithGLPreCheck();

        Singleton() {
        }
    }
}

