/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.convert;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.cas.business.convert.AbstractPayBillConverter;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CodeRuleHelper;

public class AgentPayBillConverter
extends AbstractPayBillConverter {
    private static Map<String, String> fieldMapper = new HashMap<String, String>();

    public AgentPayBillConverter() {
        fieldMapper.put("org", "company");
        fieldMapper.put("payeracctbank", "accountbank");
        fieldMapper.put("currency", "currency");
        fieldMapper.put("exchangerate", "exchangerate");
        fieldMapper.put("payamount", "amount");
        fieldMapper.put("localamt", "locamt");
        fieldMapper.put("count", "count");
        fieldMapper.put("expectdealtime", "expectdealtime");
        fieldMapper.put("id", "sourcebillid");
        fieldMapper.put("payeename", "recname");
        fieldMapper.put("payeebankname", "recbank");
        fieldMapper.put("payeebanknumber", "recbanknumber");
        fieldMapper.put("payeeacctbank", "recaccountbank");
        fieldMapper.put("e_remark", "remark");
        fieldMapper.put("recprovince", "recprovince");
        fieldMapper.put("reccity", "reccity");
        fieldMapper.put("e_encryptamount", "enc_recamountfake");
        fieldMapper.put("entry.id", "sourceentryid");
        fieldMapper.put("ispersonpay", "ispersonpay");
        fieldMapper.put("isencryption", "isencryption");
    }

    @Override
    public DynamicObject convertToTargetBill(DynamicObject agentPayBill) {
        DynamicObject bankAgent = super.convertToTargetBill(agentPayBill);
        if (!this.isBizBillCommitBe() && this.isBankBillAudit()) {
            bankAgent.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
        } else {
            bankAgent.set("billstatus", (Object)BillStatusEnum.SUBMIT.getValue());
        }
        DynamicObject company = bankAgent.getDynamicObject("company");
        bankAgent.set("billno", (Object)CodeRuleHelper.generateNumber((String)"bei_bankagentpay", (DynamicObject)bankAgent, (String)company.getPkValue().toString(), null));
        bankAgent.set("bizdate", (Object)new Date());
        bankAgent.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
        bankAgent.set("createtime", (Object)new Date());
        bankAgent.set("paystate", (Object)BeBillStatusEnum.OP.getValue());
        boolean isEncrypt = bankAgent.getBoolean("isencryption");
        DynamicObjectCollection entry = bankAgent.getDynamicObjectCollection("entrys");
        for (DynamicObject row : entry) {
            row.set("status", (Object)BeBillStatusEnum.OP.getValue());
            row.set("isagencypersonpay", (Object)agentPayBill.getBoolean("isagencypersonpay"));
            row.set("recamount", (Object)AgentPayBillHelper.decodeAmount((String)((String)row.get("enc_recamountfake"))));
        }
        DynamicObject billType = agentPayBill.getDynamicObject("billtype");
        if (billType != null) {
            String billTypeName = billType.getString("name");
            if (billTypeName.contains(ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayInfoFactory_1", (String)"fi-cas-business", (Object[])new Object[0]))) {
                bankAgent.set("usecn", (Object)ResManager.loadKDString((String)"\u5de5\u8d44", (String)"PayInfoFactory_1", (String)"fi-cas-business", (Object[])new Object[0]));
            } else if (billTypeName.contains(ResManager.loadKDString((String)"\u62a5\u9500", (String)"PayInfoFactory_2", (String)"fi-cas-business", (Object[])new Object[0]))) {
                bankAgent.set("usecn", (Object)ResManager.loadKDString((String)"\u62a5\u9500", (String)"PayInfoFactory_2", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        }
        return bankAgent;
    }

    @Override
    public String getSourceEntityKey() {
        return "cas_agentpaybill";
    }

    @Override
    public String getTargetEntityKey() {
        return "bei_bankagentpay";
    }

    @Override
    public String getTargetField(String sourceField) {
        return fieldMapper.get(sourceField);
    }

    @Override
    public String getSourceField(String targetField) {
        for (Map.Entry<String, String> entry : fieldMapper.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(targetField)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    protected Map<String, String> getMapper() {
        return fieldMapper;
    }

    @Override
    public List<String> getGroupFields() {
        ArrayList<String> groupByFields = new ArrayList<String>();
        groupByFields.add("id");
        return groupByFields;
    }
}

