/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebank.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.cas.business.ebank.EBankFileCreateAPI;
import kd.fi.cas.consts.ExportDetail;
import kd.fi.cas.consts.FetchDataReponse;
import kd.fi.cas.enums.ValueTypeEnum;
import kd.fi.cas.helper.LoggerPrintHelper;
import kd.fi.cas.util.DateUtils;

public class EBankTxTFileCreateImpl
implements EBankFileCreateAPI {
    private static final Log logger = LogFactory.getLog(EBankTxTFileCreateImpl.class);
    private IFormView view = null;
    private String pageSign = null;

    public EBankTxTFileCreateImpl(IFormView view, String pageSign) {
        this.view = view;
        this.pageSign = pageSign;
    }

    @Override
    public InputStream createFileContent(FetchDataReponse response, Object ... param) throws UnsupportedEncodingException {
        logger.info(String.format("\u6839\u636e\u54cd\u5e94\u4f53\u5f00\u59cb\u521b\u5efa TxT \u6587\u4ef6\u5185\u5bb9: %s", LoggerPrintHelper.printObjectLoggerByJSON((Object[])new FetchDataReponse[]{response})));
        StringBuilder sb = new StringBuilder();
        Map failureDatas = response.getBody().getFailureDatas();
        List failureIds = failureDatas.entrySet().stream().map(o -> (Long)o.getKey()).collect(Collectors.toList());
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)this.pageSign, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", failureIds)});
        Map details = response.getBody().getDetails();
        int detailSize = Optional.ofNullable(details).map(o -> o.size()).orElseGet(() -> 0);
        this.showErrMessage(Arrays.stream(objects).map(o -> {
            String billNoStr = o.getString("billno");
            String errMsg = (String)failureDatas.get(o.getPkValue());
            return String.format("%s: %s", billNoStr, errMsg);
        }).collect(Collectors.toList()), detailSize, this.view);
        if (detailSize == 0) {
            return null;
        }
        this.createTxtInfo("header", response, sb);
        this.createTxtInfo("body", response, sb);
        this.createTxtInfo("footer", response, sb);
        String encode = response.getHeader().getCharset();
        ByteArrayInputStream inStream = new ByteArrayInputStream(sb.toString().getBytes(encode));
        return inStream;
    }

    private void createTxtInfo(String type, FetchDataReponse response, StringBuilder textReceiver) {
        logger.info(String.format("\u6839\u636e\u54cd\u5e94\u4f53\u5f00\u59cb\u521b\u5efa TxT \u6587\u4ef6\u5185\u5bb9\uff0c\u521b\u5efa\u7f51\u94f6\u5bfc\u51fa%s\u4fe1\u606f\u5b8c\u6bd5\u3002", type));
        Map details = (Map)response.getBody().getDetails().get(type);
        if (null == details) {
            return;
        }
        List headerNameList = ((Map)response.getHeader().getHeader().get(type)).entrySet().stream().filter(Objects::nonNull).map(o -> (String)o.getKey()).collect(Collectors.toList());
        for (Map.Entry detail : details.entrySet()) {
            for (int i = 0; i < headerNameList.size(); ++i) {
                ExportDetail detailObj = (ExportDetail)((Map)detail.getValue()).get(headerNameList.get(i));
                String fieldType = detailObj.getFieldType();
                Object value = detailObj.getFieldValue();
                String valueStr = null;
                if (ValueTypeEnum.TP_TEXT.getValue().equals(fieldType)) {
                    valueStr = value.toString();
                } else if (ValueTypeEnum.TP_MONEY.getValue().equals(fieldType)) {
                    int amtprecision = detailObj.getAmtprecision();
                    valueStr = this.moneyFormat("", amtprecision).format(value);
                } else if (ValueTypeEnum.TP_DATE.getValue().equals(fieldType)) {
                    String strDate = value.toString();
                    if (strDate == null || strDate.trim().isEmpty()) {
                        valueStr = "";
                    } else {
                        Date stringToDate = DateUtils.stringToDate((String)strDate, (String)"yyyy-MM-dd");
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        valueStr = df.format(stringToDate);
                    }
                } else if (ValueTypeEnum.TP_COUNT.getValue().equals(fieldType)) {
                    valueStr = value.toString();
                } else if (ValueTypeEnum.TP_SERIALNUM.getValue().equals(fieldType)) {
                    valueStr = value.toString();
                }
                if (null == valueStr || valueStr.trim().length() == 0) {
                    valueStr = "";
                }
                if ("header".equals(type) || "body".equals(type)) {
                    textReceiver.append(valueStr).append("|");
                    continue;
                }
                textReceiver.append(valueStr);
            }
            textReceiver.append("\r\n");
        }
    }

    private Format moneyFormat(String currencySign, int amtprecision) {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)Long.valueOf(RequestContext.get().getUserId()));
        fobj.getCurrencyFormat().setCurrencySymbols(currencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }
}

