/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebservice.api;

import com.alibaba.fastjson.JSON;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.ebservice.api.IEBServiceFacade;
import kd.fi.cas.business.ebservice.bean.EBResultStatusCode;
import kd.fi.cas.business.ebservice.bean.SyncStatusInfo;
import kd.fi.cas.business.ebservice.bean.SyncStatusResult;
import kd.fi.cas.business.ebservice.service.sync.IPayBillSyncStatusService;
import kd.fi.cas.business.ebservice.service.sync.PayBillSyncStatusServiceFactory;
import kd.fi.cas.errorcode.TmcErrorCode;
import kd.fi.cas.helper.MutexServiceHelper;

public class EBServiceFacadeImpl
implements IEBServiceFacade {
    private static final String OP_SYNVPAYBILLSTATUS = "syncPayBillStatus";
    private static final Log logger = LogFactory.getLog(EBServiceFacadeImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStatusResult syncPayBillStatus(String entityName, SyncStatusInfo info) {
        String id = String.valueOf(info.getPayBillId());
        logger.info("\u540c\u6b65\u4ed8\u6b3e\u5355\u72b6\u6001: SyncStatusInfo:" + JSON.toJSONString((Object)info));
        boolean lock = MutexServiceHelper.request((String)id, (String)entityName, (String)OP_SYNVPAYBILLSTATUS);
        if (!lock) {
            DynamicObject paybill = BusinessDataServiceHelper.loadSingle((Object)info.getPayBillId(), (String)entityName, (String)"billno");
            SyncStatusResult result = new SyncStatusResult();
            result.setErrMsg(new TmcErrorCode().BILL_MUTEX_LOCK_WITH_NUMBER(paybill.getString("billno")).getMessage());
            result.setStatusCode(EBResultStatusCode.ROLLBACK);
            return result;
        }
        try {
            IPayBillSyncStatusService service = PayBillSyncStatusServiceFactory.createSyncStatusService(entityName);
            SyncStatusResult result = service.syncStatus(info);
            return result;
        }
        catch (Exception e) {
            SyncStatusResult result = new SyncStatusResult();
            result.setErrMsg(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setStatusCode(EBResultStatusCode.ERROR);
            SyncStatusResult syncStatusResult = result;
            return syncStatusResult;
        }
        finally {
            MutexServiceHelper.release((String)id, (String)entityName, (String)OP_SYNVPAYBILLSTATUS);
        }
    }
}

