/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.ebservice.service.sync.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.ExceptionUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.cas.business.ebservice.bean.SyncStatusDetail;
import kd.fi.cas.business.ebservice.bean.SyncStatusInfo;
import kd.fi.cas.business.ebservice.service.sync.impl.AbstractPayBillSyncStatusService;
import kd.fi.cas.business.journal.AgentPayBookJournalBuilder;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.refund.RefundService;
import kd.fi.cas.business.writeback.AgentWriteBackConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BeBillStatusEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.message.MessageTemplateEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.RefundHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.payment.PaymentPayHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class AgentPayBillSyncStatusService
extends AbstractPayBillSyncStatusService {
    private static Log logger = LogFactory.getLog(AgentPayBillSyncStatusService.class);
    private DynamicObject agentPayBill;
    private DynamicObject srcAgentPayBill;
    private boolean hasOfRecord;
    private boolean hasSucRecord;
    private boolean hasFailRecord;
    private boolean allSucRecord;
    private Long bankBillId;
    private Set<Long> renoteEntryIds = new HashSet<Long>(10);
    private Map<Long, Boolean> entryStatusMap = new HashMap<Long, Boolean>();

    @Override
    protected void doSyncStatusMainProcess(SyncStatusInfo info) {
        logger.info("-------\u6267\u884c\u4ee3\u53d1\u5355\u540c\u6b65\u72b6\u6001\u4e3b\u6d41\u7a0b: SyncStatusInfo = " + SerializationUtils.toJsonString((Object)info));
        Long agentPayId = info.getPayBillId();
        this.bankBillId = info.getBankBillId();
        boolean isbitback = info.isBitBack();
        String bitbackopinion = info.getBitbackopinion();
        this.agentPayBill = BusinessDataServiceHelper.loadSingle((Object)agentPayId, (String)"cas_agentpaybill");
        String sql = "update T_CAS_AgentPayBill set fmodifytime = ? where fid = " + agentPayId + " and FIsCommitBE = ? and fbillstatus = ? ";
        int[] result = DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, Collections.singletonList(new Object[]{DateUtils.getCurrentDate(), "1", "E"}));
        if (result.length < 1 || result[0] == 0) {
            logger.info("-------\u6267\u884c\u4ee3\u53d1\u5355\u540c\u6b65\u72b6\u6001\u4e3b\u6d41\u7a0b\u5931\u8d25\uff0c\u4ee3\u53d1\u5355\u662f\u5426\u63d0\u4ea4\u94f6\u4f01\u4e3a\u5426: SyncStatusInfo = " + SerializationUtils.toJsonString((Object)info));
            throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u662f\u5426\u63d0\u4ea4\u94f6\u4f01\u4e3a\u5426\uff0c\u540c\u6b65\u66f4\u65b0\u4ee3\u53d1\u5355\u72b6\u6001\u5931\u8d25\u3002", (String)"AgentPayBillSyncStatusService_14", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        for (SyncStatusDetail syncStatusDetail : info.getDetailList()) {
            String bankPayStatus = syncStatusDetail.getBankEntryPayStatus();
            if (BeBillStatusEnum.OF.getValue().equals(bankPayStatus)) {
                this.hasOfRecord = true;
                continue;
            }
            if (BeBillStatusEnum.TS.getValue().equals(bankPayStatus)) {
                this.hasSucRecord = true;
                continue;
            }
            if (!BeBillStatusEnum.TF.getValue().equals(bankPayStatus)) continue;
            this.hasFailRecord = true;
        }
        logger.info(String.format("===\u4ee3\u53d1\u5355\u66f4\u65b0\u72b6\u6001(hasOfRecord):%s===", this.hasOfRecord));
        if (!this.hasOfRecord) {
            DynamicObject[] bankjournals;
            Long pkValue;
            DynamicObjectCollection entries = this.agentPayBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                this.entryStatusMap.put(entry.getLong("id"), entry.getBoolean("e_issuccess"));
            }
            boolean bl = this.agentPayBill.getBoolean("isdiffcur");
            String bankcheckflag = "";
            boolean checkflag = Boolean.FALSE;
            Date currentDate = DateUtils.getCurrentDate();
            String oldbankagentstatus = this.agentPayBill.getString("bankagentpaystatus");
            StringBuilder bankCheckFlagSb = new StringBuilder();
            ArrayList<String> bankCheckFlagList = new ArrayList<String>(10);
            String paydateStr = SystemParameterHelper.getParameterString((long)this.agentPayBill.getDynamicObject("org").getLong("id"), (String)"selectpaydate");
            Date payDate = PaymentPayHelper.confirmPayDate((DynamicObject)this.agentPayBill, (String)paydateStr);
            long orgId = this.agentPayBill.getDynamicObject("org").getLong("id");
            boolean bankAutoRefund = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"bank_auto_refund");
            for (SyncStatusDetail detail : info.getDetailList()) {
                Long entryId = detail.getPayBillEntryId();
                for (DynamicObject entry : entries) {
                    if (!entry.getPkValue().equals(entryId)) continue;
                    String state = detail.getBankEntryPayStatus();
                    String returnMsg = detail.getEbStatusMsg();
                    String exchangeRateStr = detail.getExchangeRate();
                    String actualAmountStr = detail.getActualAmount();
                    boolean isSuccess = BeBillStatusEnum.TS.getValue().equals(state);
                    logger.info("\u72b6\u6001\uff1a" + state + ",oldbankagentstatus:" + oldbankagentstatus);
                    if (isSuccess) {
                        bankcheckflag = detail.getBankDetailSeqId();
                        if (bankcheckflag != null && bankcheckflag.trim().length() > 0 && !bankCheckFlagList.contains(bankcheckflag)) {
                            bankCheckFlagList.add(bankcheckflag);
                        }
                        if (!checkflag && bankcheckflag != null && bankcheckflag.trim().length() > 0) {
                            checkflag = Boolean.TRUE;
                        }
                        if (bankAutoRefund && detail.isRenote()) {
                            this.renoteEntryIds.add(entryId);
                        }
                    }
                    if (bl && StringUtils.isNotEmpty((String)exchangeRateStr) && StringUtils.isNotEmpty((String)actualAmountStr)) {
                        BigDecimal exchangeRate = new BigDecimal(exchangeRateStr);
                        BigDecimal actualAmount = new BigDecimal(actualAmountStr);
                        String encryptAmt = entry.getString("e_encryptamount");
                        BigDecimal amt = AgentPayBillHelper.decodeAmount((String)encryptAmt);
                        BigDecimal dpAmt = amt.multiply(exchangeRate);
                        entry.set("e_fee", (Object)actualAmount.add(dpAmt.negate()));
                        entry.set("e_dpamt", (Object)actualAmount);
                        entry.set("e_dplocalamt", (Object)actualAmount.multiply(this.agentPayBill.getBigDecimal("dpexchangerate")));
                        this.agentPayBill.set("agreedrate", (Object)exchangeRate);
                    }
                    if (!isSuccess) {
                        entry.set("e_fee", (Object)BigDecimal.ZERO);
                        entry.set("e_paytime", null);
                    } else if (!this.entryStatusMap.get(entryId).booleanValue()) {
                        entry.set("e_paytime", (Object)payDate);
                    }
                    entry.set("e_issuccess", (Object)isSuccess);
                    entry.set("bankreturnmsg", (Object)returnMsg);
                    if (detail.getBankDetailSeqId() != null && detail.getBankDetailSeqId().trim().length() > 0) {
                        entry.set("e_bankcheckflag", (Object)detail.getBankDetailSeqId());
                    }
                    if (!BeBillStatusEnum.TS.getValue().equals(state)) {
                        entry.set("e_bankcheckflag", null);
                    }
                    if (!isSuccess) continue;
                    OperateServiceHelper.execOperate((String)"afterpaytrigger", (String)this.agentPayBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{this.agentPayBill}, (OperateOption)OperateOption.create());
                }
            }
            BigDecimal sucAmt = BigDecimal.ZERO;
            BigDecimal feeAmt = BigDecimal.ZERO;
            int sucCnt = 0;
            for (DynamicObject entry : entries) {
                boolean issuccess = entry.getBoolean("e_issuccess");
                if (!issuccess) continue;
                String encryptAmt = entry.getString("e_encryptamount");
                BigDecimal amt = AgentPayBillHelper.decodeAmount((String)encryptAmt);
                sucAmt = sucAmt.add(amt);
                feeAmt = feeAmt.add(entry.getBigDecimal("e_fee"));
                ++sucCnt;
                String entryBankCheckFlag = entry.getString("e_bankcheckflag");
                if (!EmptyUtil.isNoEmpty((String)entryBankCheckFlag)) continue;
                bankCheckFlagSb.append(entryBankCheckFlag);
                bankCheckFlagSb.append(',');
            }
            this.allSucRecord = entries.stream().filter(dy -> !dy.getBoolean("e_isrepaid")).allMatch(dy -> dy.getBoolean("e_issuccess"));
            this.agentPayBill.set("actpayamount", (Object)sucAmt);
            this.agentPayBill.set("actcount", (Object)sucCnt);
            logger.info(String.format("===\u4ee3\u53d1\u5355\u66f4\u65b0\u72b6\u6001(hasSucRecord):%s===", this.hasSucRecord) + String.format("===\u4ee3\u53d1\u5355\u66f4\u65b0\u72b6\u6001(hasFailRecord):%s===", this.hasFailRecord) + String.format("===\u4ee3\u53d1\u5355\u66f4\u65b0\u72b6\u6001(allSucRecord):%s===", this.allSucRecord));
            if (bl) {
                BigDecimal agreedRate = this.agentPayBill.getBigDecimal("agreedrate");
                BigDecimal dpAmt = sucAmt.multiply(agreedRate);
                this.agentPayBill.set("dpamt", (Object)dpAmt);
                this.agentPayBill.set("fee", (Object)feeAmt);
            }
            if (this.allSucRecord) {
                this.agentPayBill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
                if (CasHelper.isEmpty((Object)oldbankagentstatus) || !BeBillStatusEnum.TS.getValue().equals(oldbankagentstatus)) {
                    if ("sysdate".equals(paydateStr)) {
                        Date latestDate = entries.stream().map(e -> e.getDate("e_paytime")).max(Comparator.naturalOrder()).orElse(null);
                        this.agentPayBill.set("paytime", (Object)latestDate);
                    } else {
                        this.agentPayBill.set("paytime", (Object)payDate);
                    }
                    this.agentPayBill.set("acttradedate", (Object)currentDate);
                }
                if (CasHelper.isNotEmpty((Object)oldbankagentstatus) && (BeBillStatusEnum.TF.getValue().equals(oldbankagentstatus) || BeBillStatusEnum.NC.getValue().equals(oldbankagentstatus))) {
                    currentDate = null;
                    this.agentPayBill.set("acttradedate", null);
                } else {
                    for (DynamicObject entry : entries) {
                        if (!CasHelper.isEmpty((Object)entry.getDate("e_paytime"))) continue;
                        entry.set("e_paytime", (Object)payDate);
                    }
                }
                pkValue = (Long)this.agentPayBill.getPkValue();
                for (DynamicObject bankjournal : bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,creditamount,sourcebillid,tracedate", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)pkValue)})) {
                    bankjournal.set("tracedate", (Object)currentDate);
                }
                SaveServiceHelper.save((DynamicObject[])bankjournals);
            } else {
                this.agentPayBill.set("billstatus", (Object)BillStatusEnum.BEING.getValue());
                this.agentPayBill.set("acttradedate", null);
                pkValue = (Long)this.agentPayBill.getPkValue();
                for (DynamicObject bankjournal : bankjournals = BusinessDataServiceHelper.load((String)"cas_bankjournal", (String)"id,bankcheckflag,bankcheckflag_tag,batchno,accountbank,currency,creditamount,sourcebillid,tracedate", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)pkValue)})) {
                    bankjournal.set("tracedate", null);
                }
                SaveServiceHelper.save((DynamicObject[])bankjournals);
            }
            this.agentPayBill.set("bankagentpaystatus", (Object)info.getBankPayStatus());
            if (bankCheckFlagSb.length() > 0) {
                String[] split;
                String subFlag = bankCheckFlagSb.toString();
                logger.info("==AgentPayBillSyncStatusService==bankCheckFlagSb: before dealing with:{}", (Object)subFlag);
                if (subFlag.lastIndexOf(",") > 0) {
                    subFlag = subFlag.substring(0, bankCheckFlagSb.lastIndexOf(","));
                }
                DynamicObjectCollection bankCheckEntity = this.agentPayBill.getDynamicObjectCollection("bankcheckentity");
                for (String value : split = subFlag.split(",")) {
                    if (EmptyUtil.isEmpty((String)value) || bankCheckEntity.contains((Object)value)) continue;
                    DynamicObject entryEntity = bankCheckEntity.addNew();
                    entryEntity.set("ebankcheckflag", (Object)value);
                }
                this.agentPayBill.set("bankcheckflag", (Object)CasHelper.subFlag((String)subFlag));
                this.agentPayBill.set("bankcheckflag_tag", (Object)subFlag);
            }
            if (!BeBillStatusEnum.TS.getValue().equals(info.getBankPayStatus())) {
                this.agentPayBill.set("bankcheckflag", null);
                this.agentPayBill.set("bankcheckflag_tag", null);
                DynamicObjectCollection bankCheckEntity = this.agentPayBill.getDynamicObjectCollection("bankcheckentity");
                bankCheckEntity.clear();
            }
            this.agentPayBill.set("isrepulsed", (Object)isbitback);
            this.agentPayBill.set("repulsedreason", (Object)bitbackopinion);
            logger.info("isrepulsed \u662f\uff1a" + isbitback + ";repulsedreason \u662f\uff1a" + bitbackopinion + "");
            DynamicObject[] saveAgentBills = new DynamicObject[]{this.agentPayBill};
            RefundHelper.setSomeRefundAmtFields((DynamicObject[])saveAgentBills, (String)"cas_agentpaybill");
            SaveServiceHelper.save((DynamicObject[])saveAgentBills);
        }
    }

    @Override
    protected List<AbstractPayBillSyncStatusService.IBranchProcess> getBranchProcess() {
        return Arrays.asList(this.book(), this.updateSrcAgentBillStatus(), this.writeBack(), this.sendNoticeMessage());
    }

    private AbstractPayBillSyncStatusService.IBranchProcess book() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                logger.info(String.format("===\u4ee3\u53d1\u5355\u767b\u65e5\u8bb0\u8d26\u4fe1\u606f\uff1a%s===", SerializationUtils.toJsonString((Object)AgentPayBillSyncStatusService.this.agentPayBill)));
                if (AgentPayBillSyncStatusService.this.hasSucRecord || AgentPayBillSyncStatusService.this.hasFailRecord) {
                    AgentPayBillSyncStatusService.this.agentPayBill = BusinessDataServiceHelper.loadSingle((Object)AgentPayBillSyncStatusService.this.agentPayBill.getPkValue(), (String)AgentPayBillSyncStatusService.this.agentPayBill.getDataEntityType().getName());
                    JournalServiceAdapter bookService = new JournalServiceAdapter();
                    if (bookService.hasBooked(AgentPayBillSyncStatusService.this.agentPayBill)) {
                        bookService.validateCancelBook(AgentPayBillSyncStatusService.this.agentPayBill);
                        bookService.cancelBook(AgentPayBillSyncStatusService.this.agentPayBill);
                    }
                    logger.info("===\u4ee3\u53d1\u5f00\u59cb\u767b\u65e5\u8bb0\u8d26");
                    AgentPayBillHelper.decodeAmount((DynamicObject)AgentPayBillSyncStatusService.this.agentPayBill);
                    bookService.validateBook((IBookJournalBuilder)new AgentPayBookJournalBuilder(), AgentPayBillSyncStatusService.this.agentPayBill);
                    bookService.book(AgentPayBillSyncStatusService.this.agentPayBill);
                    AgentPayBillHelper.saveBankCheckFlag((DynamicObject)AgentPayBillSyncStatusService.this.agentPayBill);
                }
                return null;
            }

            @Override
            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u767b\u8d26", (String)"AgentPayBillSyncStatusService_6", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess updateSrcAgentBillStatus() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                if (AgentPayBillHelper.isDelegPush((DynamicObject)AgentPayBillSyncStatusService.this.agentPayBill)) {
                    Set setLongs = CasBotpHelper.getSrcBillByDestBill((Long)((Long)AgentPayBillSyncStatusService.this.agentPayBill.get("id")), (String)"cas_agentpaybill", (String)"cas_agentpaybill");
                    for (Long id : setLongs) {
                        AgentPayBillSyncStatusService.this.srcAgentPayBill = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)AgentPayBillSyncStatusService.this.agentPayBill.getDynamicObjectType());
                    }
                    AgentPayBillSyncStatusService.this.srcAgentPayBill = BusinessDataServiceHelper.loadSingle((String)"cas_agentpaybill", (QFilter[])new QFilter[]{new QFilter("billno", "=", AgentPayBillSyncStatusService.this.agentPayBill.get("sourcebillnumber"))});
                    logger.info(String.format("===\u4ee3\u53d1\u5355\u66f4\u65b0\u72b6\u6001(hasOfRecord):%s===", AgentPayBillSyncStatusService.this.hasOfRecord));
                    if (AgentPayBillSyncStatusService.this.srcAgentPayBill != null) {
                        logger.info(String.format("===\u4ee3\u53d1\u5355\u66f4\u65b0\u6e90\u5355\u72b6\u6001\uff1a%s===", SerializationUtils.toJsonString((Object)AgentPayBillSyncStatusService.this.srcAgentPayBill)));
                        AgentPayBillSyncStatusService.this.entryStatusMap.clear();
                        DynamicObjectCollection entries = AgentPayBillSyncStatusService.this.agentPayBill.getDynamicObjectCollection("entry");
                        DynamicObjectCollection srcEntries = AgentPayBillSyncStatusService.this.srcAgentPayBill.getDynamicObjectCollection("entry");
                        for (DynamicObject entry : entries) {
                            for (DynamicObject srcEntry : srcEntries) {
                                if (srcEntry.getLong("id") != entry.getLong("sourceentryid")) continue;
                                AgentPayBillSyncStatusService.this.entryStatusMap.put(srcEntry.getLong("id"), srcEntry.getBoolean("e_issuccess"));
                                srcEntry.set("e_issuccess", (Object)entry.getString("e_issuccess"));
                                srcEntry.set("bankreturnmsg", (Object)entry.getString("bankreturnmsg"));
                                srcEntry.set("e_bankcheckflag", (Object)entry.getString("e_bankcheckflag"));
                            }
                        }
                        BigDecimal actPayAmount = BigDecimal.ZERO;
                        int actCount = 0;
                        for (DynamicObject srcEntry : srcEntries) {
                            if (!srcEntry.getBoolean("e_issuccess")) continue;
                            if (srcEntry.getBigDecimal("e_amount") != null) {
                                actPayAmount = actPayAmount.add(srcEntry.getBigDecimal("e_amount"));
                            }
                            ++actCount;
                        }
                        AgentPayBillSyncStatusService.this.srcAgentPayBill.set("actpayamount", (Object)actPayAmount);
                        AgentPayBillSyncStatusService.this.srcAgentPayBill.set("actcount", (Object)actCount);
                        if (AgentPayBillSyncStatusService.this.allSucRecord) {
                            AgentPayBillSyncStatusService.this.srcAgentPayBill.set("billstatus", (Object)BillStatusEnum.PAY.getValue());
                        } else {
                            AgentPayBillSyncStatusService.this.srcAgentPayBill.set("billstatus", (Object)BillStatusEnum.BEING.getValue());
                        }
                        AgentPayBillSyncStatusService.this.srcAgentPayBill.set("bankagentpaystatus", (Object)AgentPayBillSyncStatusService.this.agentPayBill.getString("bankagentpaystatus"));
                        AgentPayBillSyncStatusService.this.srcAgentPayBill.set("bankcheckflag", (Object)CasHelper.subFlag((String)AgentPayBillSyncStatusService.this.agentPayBill.getString("bankcheckflag")));
                        AgentPayBillSyncStatusService.this.srcAgentPayBill.set("bankcheckflag_tag", (Object)AgentPayBillSyncStatusService.this.agentPayBill.getString("bankcheckflag_tag"));
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{AgentPayBillSyncStatusService.this.srcAgentPayBill});
                    }
                }
                return null;
            }

            @Override
            public String getProcessName() {
                return ResManager.loadKDString((String)"\u66f4\u65b0\u59d4\u6258\u4ee3\u53d1\u5355", (String)"AgentPayBillSyncStatusService_7", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess writeBack() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                HashMap<String, Object> params;
                DynamicObject writeBackAgentPayBill = null;
                if (AgentPayBillSyncStatusService.this.hasSucRecord || AgentPayBillSyncStatusService.this.hasFailRecord) {
                    writeBackAgentPayBill = AgentPayBillHelper.isDelegPush((DynamicObject)AgentPayBillSyncStatusService.this.agentPayBill) ? AgentPayBillSyncStatusService.this.srcAgentPayBill : AgentPayBillSyncStatusService.this.agentPayBill;
                }
                if (writeBackAgentPayBill == null || CasHelper.isEmpty((Object)writeBackAgentPayBill.getString("sourcebilltype"))) {
                    return null;
                }
                DynamicObjectCollection entries = writeBackAgentPayBill.getDynamicObjectCollection("entry");
                ArrayList<Long> payEntryPks = new ArrayList<Long>(entries.size());
                ArrayList<Long> cancelPayEntryPks = new ArrayList<Long>(entries.size());
                for (DynamicObject entry : entries) {
                    Long entryId = entry.getLong("id");
                    Boolean preStatus = (Boolean)AgentPayBillSyncStatusService.this.entryStatusMap.get(entryId);
                    if (preStatus == null) continue;
                    boolean isSuccess = entry.getBoolean("e_issuccess");
                    if (!preStatus.booleanValue() && isSuccess) {
                        payEntryPks.add(entryId);
                        continue;
                    }
                    if (!preStatus.booleanValue() || isSuccess) continue;
                    cancelPayEntryPks.add(entryId);
                }
                if (!payEntryPks.isEmpty()) {
                    params = new HashMap<String, Object>(2);
                    params.put("entryPks", payEntryPks);
                    WriteBackTaskHelper.addRealtimeTask(writeBackAgentPayBill, writeBackAgentPayBill.getString("sourcebilltype"), WriteBackOperateEnum.PAY, AgentWriteBackConsumer.class, params);
                }
                if (!cancelPayEntryPks.isEmpty()) {
                    params = new HashMap(2);
                    params.put("entryPks", cancelPayEntryPks);
                    WriteBackTaskHelper.addRealtimeTask(writeBackAgentPayBill, writeBackAgentPayBill.getString("sourcebilltype"), WriteBackOperateEnum.CANCELPAY, AgentWriteBackConsumer.class, params);
                }
                return null;
            }

            @Override
            public String getProcessName() {
                return ResManager.loadKDString((String)"\u53cd\u5199\u4e0a\u6e38\u5355\u636e", (String)"AgentPayBillSyncStatusService_8", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess sendNoticeMessage() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                try {
                    QFilter qFilter;
                    DynamicObject detail;
                    DynamicObject cashier = AgentPayBillSyncStatusService.this.agentPayBill.getDynamicObject("cashier");
                    if (EmptyUtil.isNoEmpty((DynamicObject)cashier) && EmptyUtil.isNoEmpty((Long)AgentPayBillSyncStatusService.this.bankBillId) && (detail = BusinessDataServiceHelper.loadSingle((String)"bei_bankagentpay", (String)"id,paystate,billno", (QFilter[])new QFilter[]{qFilter = new QFilter("id", "=", (Object)AgentPayBillSyncStatusService.this.bankBillId)})) != null) {
                        String payState = detail.getString("paystate");
                        if (BeBillStatusEnum.TF.getValue().equals(payState) || BeBillStatusEnum.NC.getValue().equals(payState) || "PS".equals(payState)) {
                            MessageInfo message = new MessageInfo();
                            message.setEntityNumber("bei_bankagentpay");
                            message.setMessageTag((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u94f6\u4f01\u652f\u4ed8\u7ed3\u679c", (String)"PayBillSyncStatusService_0", (String)"fi-cas-business", (Object[])new Object[0])));
                            String templateNumber = "";
                            if (BeBillStatusEnum.TF.getValue().equals(payState)) {
                                templateNumber = MessageTemplateEnum.BEI_BANKAGENTPAY_PAYFAIL.getValue();
                            } else if (BeBillStatusEnum.NC.getValue().equals(payState)) {
                                templateNumber = MessageTemplateEnum.BEI_BANKAGENTPAY_NOTCONFIRM.getValue();
                            } else if ("PS".equals(payState)) {
                                templateNumber = MessageTemplateEnum.BEI_BANKAGENTPAY_PARTPAYFAIL.getValue();
                            }
                            message.setTemplateNumber(templateNumber);
                            message.setUserIds(Collections.singletonList(cashier.getLong("id")));
                            message.setBizDataId(AgentPayBillSyncStatusService.this.bankBillId);
                            message.setContentUrl(UrlService.getDomainContextUrl() + "/index.html?formId=bei_bankagentpay&pkId=" + AgentPayBillSyncStatusService.this.bankBillId);
                            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error(String.format(ResManager.loadKDString((String)"\u94f6\u884c\u4ee3\u53d1\u5355ID\uff1a%s\u53d1\u9001\u6d88\u606f\u5931\u8d25\u3002", (String)"AgentPayBillSyncStatusService_5", (String)"fi-cas-business", (Object[])new Object[0]), AgentPayBillSyncStatusService.this.bankBillId) + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
                return null;
            }

            @Override
            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\u53d1\u9001\u6d88\u606f", (String)"AgentPayBillSyncStatusService_9", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    @Override
    protected List<AbstractPayBillSyncStatusService.IBranchProcess> getBranchProcessAfter() {
        return Stream.of(this.writeBackOther(), this.agentBillAutoRenote()).collect(Collectors.toList());
    }

    private AbstractPayBillSyncStatusService.IBranchProcess writeBackOther() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                OperateServiceHelper.execOperate((String)"synctrigger", (String)AgentPayBillSyncStatusService.this.agentPayBill.getDataEntityType().getName(), (DynamicObject[])new DynamicObject[]{AgentPayBillSyncStatusService.this.agentPayBill}, (OperateOption)OperateOption.create());
                return null;
            }

            @Override
            public String getProcessName() {
                return ResManager.loadKDString((String)"\u53cd\u5199\u96c6\u6210\u4e91\u4e0b\u63a8\u5355\u636e", (String)"AgentPayBillSyncStatusService_10", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }

    private AbstractPayBillSyncStatusService.IBranchProcess agentBillAutoRenote() {
        return new AbstractPayBillSyncStatusService.IBranchProcess(){

            @Override
            public String doBranchProcessWithoutException() {
                if (!AgentPayBillSyncStatusService.this.renoteEntryIds.isEmpty()) {
                    new RefundService().autoRenote((Long)AgentPayBillSyncStatusService.this.agentPayBill.getPkValue(), "cas_agentpaybill", AgentPayBillSyncStatusService.this.renoteEntryIds);
                }
                return "";
            }

            @Override
            public String getProcessName() {
                return ResManager.loadKDString((String)"\u4ee3\u53d1\u5355\u540c\u6b65\u72b6\u6001\u81ea\u52a8\u9000\u7968\u3002", (String)"AgentPayBillSyncStatusService_15", (String)"fi-cas-business", (Object[])new Object[0]);
            }
        };
    }
}

