/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.fundtrans;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.cas.business.helper.AcctBalanceHelper;
import kd.fi.cas.enums.AsstActTypeEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.PriorityEnum;
import kd.fi.cas.enums.SettleMentTypeEnum;
import kd.fi.cas.enums.TransferOperateEnum;
import kd.fi.cas.enums.TransferTypeEnum;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class FundTransPushService {
    private static final Log LOGGER = LogFactory.getLog(FundTransPushService.class);

    public List<Long> push(DynamicObject[] billObjs) {
        LOGGER.info("FundTransPushService push begin");
        ArrayList<Long> resultBillIds = new ArrayList<Long>(5);
        if (billObjs == null || billObjs.length == 0) {
            return resultBillIds;
        }
        Throwable throwable = null;
        try (TXHandle tx = TX.notSupported();){
            ArrayList saveSuccessPkIds = new ArrayList(10);
            ArrayList paySuccessPkIds = new ArrayList(10);
            String entityName = billObjs[0].getDataEntityType().getName();
            try {
                ArrayList<Long> errMsg;
                entityName = billObjs[0].getDataEntityType().getName();
                OperateOption opOption = OperateOption.create();
                opOption.setVariableValue("byfca", "true");
                opOption.setVariableValue("currbizappid", "cas");
                opOption.setVariableValue("ishasright", "true");
                opOption.setVariableValue("WF", String.valueOf(false));
                OperationResult saveOpResult = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])billObjs, (OperateOption)opOption);
                List list = saveSuccessPkIds = saveOpResult.getSuccessPkIds() == null ? saveSuccessPkIds : saveOpResult.getSuccessPkIds();
                if (!saveSuccessPkIds.isEmpty()) {
                    try {
                        Map<Long, Long> billAndMainOrgId = Arrays.stream(billObjs).filter(b -> b.getPkValue() != null && b.getDynamicObject("org") != null).collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getDynamicObject("org").getLong("id")));
                        boolean result = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)entityName, (String)"audit", saveSuccessPkIds, billAndMainOrgId, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
                        if (!result) {
                            LOGGER.error("voucherWhiteListOpe fail");
                        }
                    }
                    catch (Exception e2) {
                        LOGGER.error((Throwable)e2);
                    }
                }
                if (saveOpResult.isSuccess()) {
                    OperationResult payOpResult;
                    String opName = "receivingrec";
                    if ("cas_paybill".equals(entityName)) {
                        opName = "pay";
                    }
                    List list2 = paySuccessPkIds = (payOpResult = OperationServiceHelper.executeOperate((String)opName, (String)entityName, (Object[])saveSuccessPkIds.toArray(), (OperateOption)opOption)).getSuccessPkIds() == null ? paySuccessPkIds : payOpResult.getSuccessPkIds();
                    if (!payOpResult.isSuccess()) {
                        String errMsg2 = this.extractResultErrorMessage(payOpResult);
                        throw new KDBizException(this.errorOfPushAndPayMsgTip(entityName) + errMsg2);
                    }
                } else {
                    errMsg = this.extractResultErrorMessage(saveOpResult);
                    throw new KDBizException(this.errorOfPushAndPayMsgTip(entityName) + (String)((Object)errMsg));
                }
                if (saveSuccessPkIds.size() != paySuccessPkIds.size()) {
                    throw new KDBizException(this.errorOfPushAndPayMsgTip(entityName));
                }
                for (Object id : saveSuccessPkIds) {
                    resultBillIds.add((Long)id);
                }
                LOGGER.info("FundTransPushService_push end resultBillIds:{}", resultBillIds);
                errMsg = resultBillIds;
                return errMsg;
            }
            catch (Exception e3) {
                try {
                    LOGGER.error("FundTransPushService push error:", (Throwable)e3);
                    tx.markRollback();
                    if (!saveSuccessPkIds.isEmpty()) {
                        if (!paySuccessPkIds.isEmpty()) {
                            saveSuccessPkIds.removeAll(paySuccessPkIds);
                        }
                        OperateOption opOption = OperateOption.create();
                        opOption.setVariableValue("byfca", "true");
                        opOption.setVariableValue("currbizappid", "cas");
                        opOption.setVariableValue("ishasright", "true");
                        opOption.setVariableValue("isLock", "true");
                        OperationResult deleteOperate = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (Object[])saveSuccessPkIds.toArray(), (OperateOption)opOption);
                        if (!deleteOperate.isSuccess()) {
                            LOGGER.error("FundTransPushService push delete error:", (Object)this.extractResultErrorMessage(deleteOperate));
                        }
                    }
                    throw e3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    public List<Map<String, Object>> pushTransferApply(DynamicObjectCollection entries, String pushType) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (entries == null || entries.size() == 0) {
            return resultList;
        }
        try (TXHandle tx = TX.requiresNew();){
            entries.forEach(entry -> {
                HashMap resultMap = new HashMap(3);
                try {
                    DynamicObject billObj = BusinessDataServiceHelper.newDynamicObject((String)"cas_transferapply");
                    billObj.set("applydate", (Object)new Date());
                    billObj.set("transfertype", (Object)TransferTypeEnum.MAIN_TRANSFER.getValue());
                    billObj.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
                    billObj.set("creator", entry.get("e_creator"));
                    billObj.set("applyorg", entry.get("e_applyorg"));
                    billObj.set("paidstatus", (Object)PayApplyPayStatusEnum.NOTPAYING.getValue());
                    DynamicObject currency = entry.getDynamicObject("e_paycurrency");
                    billObj.set("paycurrency", (Object)currency);
                    billObj.set("payeecurrency", (Object)currency);
                    billObj.set("exchangerate", (Object)1);
                    BigDecimal amount = entry.getBigDecimal("e_transferamt");
                    billObj.set("payeeamount", (Object)amount);
                    billObj.set("payamount", (Object)amount);
                    DynamicObjectCollection transferApplyEntry = billObj.getDynamicObjectCollection("cas_transferapply_entry");
                    DynamicObject transferApply = transferApplyEntry.addNew();
                    DynamicObject payOrg = entry.getDynamicObject("e_payorg");
                    transferApply.set("e_payorg", (Object)payOrg);
                    DynamicObject defaultSettleType = BaseDataHelper.getDefaultSettleType();
                    String settlementType = defaultSettleType.getString("settlementtype");
                    if (!SettleMentTypeEnum.MONEY.getValue().equals(settlementType) && !SettleMentTypeEnum.VIRTUAL.getValue().equals(settlementType)) {
                        transferApply.set("e_settlementtype", (Object)defaultSettleType);
                    }
                    DynamicObject payerAcctBank = entry.getDynamicObject("e_payeraccbank");
                    transferApply.set("e_payeraccbank", (Object)payerAcctBank);
                    transferApply.set("e_acctshort", payerAcctBank.get("name"));
                    transferApply.set("e_payerbank", payerAcctBank.get("bank"));
                    BigDecimal balance = AcctBalanceHelper.getAccountBankCurrBalance(payOrg.getLong("id"), payerAcctBank.getLong("id"), currency.getLong("id"), new Date());
                    if (EmptyUtil.isEmpty((BigDecimal)balance)) {
                        balance = BigDecimal.ZERO;
                    }
                    transferApply.set("e_balance", (Object)balance);
                    transferApply.set("e_lastmodifytime", (Object)new Date());
                    if (payerAcctBank.getBoolean("isopenbank")) {
                        transferApply.set("e_paymentchannel", (Object)PaymentChannelEnum.ONLINEBANK.getValue());
                    } else if (payerAcctBank.getBoolean("issetbankinterface")) {
                        transferApply.set("e_paymentchannel", (Object)PaymentChannelEnum.BEI.getValue());
                    } else {
                        transferApply.set("e_paymentchannel", (Object)PaymentChannelEnum.COUNTER.getValue());
                    }
                    transferApply.set("e_expectdate", (Object)new Date());
                    transferApply.set("e_payeeamount", (Object)amount);
                    transferApply.set("e_payee", entry.get("e_payee"));
                    transferApply.set("e_payeetype", (Object)AsstActTypeEnum.COMPANY.getValue());
                    DynamicObject payeeAccountBank = entry.getDynamicObject("e_payeeaccbank");
                    transferApply.set("e_payeeaccbank", (Object)payeeAccountBank);
                    transferApply.set("e_payeeaccbankid", payeeAccountBank.getPkValue());
                    transferApply.set("e_accountname", payeeAccountBank.get("name"));
                    transferApply.set("e_payeeaccbanknum", payeeAccountBank.get("bankaccountnumber"));
                    transferApply.set("e_payeebank", payeeAccountBank.get("bank"));
                    transferApply.set("e_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
                    transferApply.set("e_usage", entry.get("e_usage"));
                    transferApply.set("e_priority", (Object)PriorityEnum.PUBLIC.getValue());
                    OperateOption opOption = OperateOption.create();
                    opOption.setVariableValue("byfca", "true");
                    opOption.setVariableValue("currbizappid", "cas");
                    opOption.setVariableValue("ishasright", "true");
                    if (TransferOperateEnum.SAVE_TRANSFER_APPLY.getValue().equals(pushType)) {
                        OperationResult saveOpResult = OperationServiceHelper.executeOperate((String)"save", (String)"cas_transferapply", (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)opOption);
                        if (saveOpResult.isSuccess()) {
                            resultMap.put("billno", saveOpResult.getBillNos().get("0"));
                        } else {
                            resultMap.put("errorMessage", this.extractResultErrorMessage(saveOpResult));
                        }
                    } else if (TransferOperateEnum.SUBMIT_TRANSFER_APPLY.getValue().equals(pushType)) {
                        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"cas_transferapply", (DynamicObject[])new DynamicObject[]{billObj}, (OperateOption)opOption);
                        if (submitResult.isSuccess()) {
                            resultMap.put("billno", submitResult.getBillNos().get("0"));
                        } else {
                            String errMsg = this.extractResultErrorMessage(submitResult);
                            resultMap.put("errorMessage", errMsg);
                        }
                    }
                    resultList.add(resultMap);
                }
                catch (Exception e) {
                    tx.markRollback();
                    resultMap.put("errorMessage", e.getMessage());
                    resultList.add(resultMap);
                    LOGGER.error("pushTransfer():", (Throwable)e);
                }
            });
            ArrayList<Map<String, Object>> arrayList = resultList;
            return arrayList;
        }
    }

    public void cancelPay(String entityName, Long[] billIds) {
        try (TXHandle tx = TX.requiresNew();){
            try {
                OperationResult deleteOpResult;
                String opName = "cancelrec";
                if ("cas_paybill".equals(entityName)) {
                    opName = "cancelpay";
                }
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
                DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])billIds, (DynamicObjectType)type);
                OperateOption cancelOpOption = OperateOption.create();
                cancelOpOption.setVariableValue("byfca", "true");
                cancelOpOption.setVariableValue("currbizappid", "cas");
                cancelOpOption.setVariableValue("ishasright", "true");
                ArrayList<DynamicObject> paidBills = new ArrayList<DynamicObject>(5);
                ArrayList<DynamicObject> otherStatusBills = new ArrayList<DynamicObject>(5);
                for (DynamicObject billData : bills) {
                    String billStatus = billData.getString("billstatus");
                    if (BillStatusEnum.PAY.getValue().equals(billStatus)) {
                        paidBills.add(billData);
                        continue;
                    }
                    otherStatusBills.add(billData);
                }
                OperateOption delOpOption = OperateOption.create();
                delOpOption.setVariableValue("byfca", "true");
                delOpOption.setVariableValue("isLock", "true");
                delOpOption.setVariableValue("ishasright", "true");
                if (!paidBills.isEmpty()) {
                    cancelOpOption.setVariableValue("WF", String.valueOf(false));
                    OperationResult cancelOpResult = OperationServiceHelper.executeOperate((String)opName, (String)entityName, (Object[])billIds, (OperateOption)cancelOpOption);
                    if (cancelOpResult.isSuccess()) {
                        OperationResult deleteOpResult2 = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (DynamicObject[])bills, (OperateOption)delOpOption);
                        if (!deleteOpResult2.isSuccess()) {
                            String errMsg = this.extractResultErrorMessage(deleteOpResult2);
                            throw new KDBizException(this.errorOfCancelPayMsgTip(entityName) + errMsg);
                        }
                    } else {
                        String errMsg = this.extractResultErrorMessage(cancelOpResult);
                        throw new KDBizException(this.errorOfCancelPayMsgTip(entityName) + errMsg);
                    }
                }
                if (!otherStatusBills.isEmpty() && !(deleteOpResult = OperationServiceHelper.executeOperate((String)"delete", (String)entityName, (DynamicObject[])bills, (OperateOption)delOpOption)).isSuccess()) {
                    String errMsg = this.extractResultErrorMessage(deleteOpResult);
                    throw new KDBizException(this.errorOfCancelPayMsgTip(entityName) + errMsg);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                LOGGER.error("error:", (Throwable)e);
                throw e;
            }
        }
    }

    private String extractResultErrorMessage(OperationResult opResult) {
        List opInfoList = opResult.getAllErrorOrValidateInfo();
        StringBuilder stringBuilder = new StringBuilder();
        for (IOperateInfo info : opInfoList) {
            stringBuilder.append(info.getMessage());
        }
        if (StringUtils.isEmpty((String)stringBuilder.toString())) {
            stringBuilder.append(opResult.getMessage());
        }
        return stringBuilder.toString();
    }

    private String errorOfCancelPayMsgTip(String entityName) {
        String msg = ResManager.loadKDString((String)"\u53d6\u6d88\u5220\u9664\u6536\u6b3e\u5355\u5931\u8d25\u3002", (String)"FundTransPushService_Err_1", (String)"fi-cas-business", (Object[])new Object[0]);
        if ("cas_paybill".equals(entityName)) {
            msg = ResManager.loadKDString((String)"\u53d6\u6d88\u5220\u9664\u4ed8\u6b3e\u5355\u5931\u8d25\u3002", (String)"FundTransPushService_Err_0", (String)"fi-cas-business", (Object[])new Object[0]);
        }
        return msg;
    }

    private String errorOfPushAndPayMsgTip(String entityName) {
        String msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u6536\u6b3e\u5355\u5931\u8d25\u3002", (String)"FundTransPushService_Err_3", (String)"fi-cas-business", (Object[])new Object[0]);
        if ("cas_paybill".equals(entityName)) {
            msg = ResManager.loadKDString((String)"\u4e0b\u63a8\u4ed8\u6b3e\u5355\u5931\u8d25\u3002", (String)"FundTransPushService_Err_2", (String)"fi-cas-business", (Object[])new Object[0]);
        }
        return msg;
    }
}

