/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.service.BalanceCountService;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.util.DateUtils;

public class AcctBalanceHelper {
    public static OperationResult onlineUpdate(Long acctBankId, Long currencyId) {
        return OperateServiceHelper.execOperateWithoutThrow((String)"downcurrentbalance", (String)"am_acctbank_schedule", (Object[])new Long[]{acctBankId}, (OperateOption)OperateOption.create());
    }

    public static DynamicObject getLastestBeBalance(Long acctBankId, Long currencyId) {
        Date curDate = DateUtils.getCurrentDate();
        QFilter[] filters = new QFilter[]{new QFilter("accountbank", "=", (Object)acctBankId), new QFilter("currency", "=", (Object)currencyId), new QFilter("bizdate", "<=", (Object)curDate), new QFilter("enddate", ">", (Object)curDate)};
        return QueryServiceHelper.queryOne((String)"bei_bankbalance", (String)"amount,bizdate,modifytime", (QFilter[])filters);
    }

    public static BigDecimal getAccountBankCurrBalance(Long orgID, Long acctBankID, Long currencyID, Date bizDate) {
        BigDecimal journalBalance = BigDecimal.ZERO;
        DynamicObject acctBank = BusinessDataServiceHelper.loadSingleFromCache((Object)acctBankID, (String)"bd_accountbanks");
        if (acctBank != null && acctBank.getBoolean("issetbankinterface")) {
            DynamicObject balance = AcctBalanceHelper.getLastestBeBalance(acctBankID, currencyID);
            if (balance != null) {
                journalBalance = balance.getBigDecimal("amount");
            }
        } else {
            DynamicObject casInit = PeriodHelper.getCasInitInfo((long)orgID);
            BalanceCountService balanceService = new BalanceCountService();
            journalBalance = balanceService.getJournalBalance(casInit, orgID, acctBankID, currencyID, bizDate);
        }
        if (journalBalance == null) {
            journalBalance = BigDecimal.ZERO;
            return journalBalance;
        }
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyID, (String)"bd_currency");
        return journalBalance.setScale(currency.getInt("amtprecision"), 4);
    }

    public static BigDecimal getAccountCashCurrBalance(Long orgID, Long acctBankID, Long currencyID, Date bizDate) {
        BalanceCountService balanceService = new BalanceCountService();
        BigDecimal cashBalance = balanceService.getCashbankBalance(orgID, acctBankID, currencyID, bizDate);
        DynamicObject currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyID, (String)"bd_currency");
        return cashBalance.setScale(currency.getInt("amtprecision"), 4);
    }
}

