/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.helper.AcctBalanceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BalanceCountHelper {
    private static final Log logger = LogFactory.getLog(BalanceCountHelper.class);

    public static BigDecimal getJournalBalamt(BigDecimal journalbalamt, DynamicObject period, Long orgId, Object accountId, Object currencyId, Date endDate) {
        QFilter[] journalBalFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("period", "=", period.getPkValue()), new QFilter("accountbank", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"2")};
        logger.info("----->>> BalanceCountHelper.getJournalBalamt(),journalBalFilters={}", (Object)JSON.toJSONString((Object)journalBalFilters));
        DynamicObject[] journalBal = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, monthstart", (QFilter[])journalBalFilters);
        if (journalBal.length > 0) {
            for (DynamicObject dynamicObject : journalBal) {
                journalbalamt = journalbalamt.add(dynamicObject.getBigDecimal("monthstart"));
            }
        }
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        QFilter journalFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", accountId)).and(new QFilter("currency", "=", currencyId)).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)));
        journalFilter.and(new QFilter("period", "!=", (Object)0L));
        QFilter[] journalFilters = new QFilter[]{journalFilter};
        logger.info("----->>> BalanceCountHelper.getJournalBalamt(),journalFilters={}", (Object)JSON.toJSONString((Object)journalFilters));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"1 as group,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                journalbalamt = journalbalamt.add(journalSum);
                logger.info("=======\u65e5\u8bb0\u8d26\u4e1a\u52a1\u6570\u636e\u91d1\u989d\uff1a" + journalSum);
            }
        }
        return journalbalamt;
    }

    public static BigDecimal getCashBalamt(BigDecimal journalbalamt, DynamicObject period, Object accountId, Object currencyId, Date endDate) {
        QFilter[] journalBalFilters = new QFilter[]{new QFilter("period", "=", period.getPkValue()), new QFilter("accountcash", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("type", "=", (Object)"1")};
        DynamicObject[] journalCashBal = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, monthstart", (QFilter[])journalBalFilters);
        if (journalCashBal.length > 0) {
            for (DynamicObject dynamicObject : journalCashBal) {
                journalbalamt = journalbalamt.add(dynamicObject.getBigDecimal("monthstart"));
            }
        }
        QFilter[] journalFilters = new QFilter[]{new QFilter("accountcash", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("bookdate", ">=", (Object)period.getDate("begindate")), new QFilter("bookdate", "<=", (Object)endDate)};
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".cashjournal"), (String)"cas_cashjournal", (String)"1 as group,debitamount-creditamount as factamt", (QFilter[])journalFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                BigDecimal journalSum = ((Row)iterator.next()).getBigDecimal("factamt");
                journalbalamt = journalbalamt.add(journalSum);
                logger.info("=======\u73b0\u91d1\u65e5\u8bb0\u8d26\u4e1a\u52a1\u6570\u636e\u91d1\u989d\uff1a" + journalSum);
            }
        }
        return journalbalamt;
    }

    public static BigDecimal getStateBalance(Long accountId, Long currencyId, Date startDate, Date endDate) {
        BigDecimal statmntbalamt = BigDecimal.ZERO;
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        QFilter[] statmntFilters = new QFilter[]{new QFilter("accountbank", "=", (Object)accountId), new QFilter("currency", "=", (Object)currencyId), new QFilter("bizdate", ">=", (Object)startDate), new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)), new QFilter("isbank", "=", (Object)"1"), new QFilter("period", "!=", (Object)0L)};
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankstatement"), (String)"cas_bankstatement", (String)"1 as group,creditamount-debitamount as factamt", (QFilter[])statmntFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                statmntbalamt = statmntbalamt.add(((Row)iterator.next()).getBigDecimal("factamt"));
            }
        }
        return statmntbalamt;
    }

    public static BigDecimal getStatmntBalamt(BigDecimal statmntbalamt, DynamicObject period, Object accountId, Object currencyId, Date endDate) {
        Date startDate = period.getDate("begindate");
        Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
        QFilter[] statmntFilters = new QFilter[]{new QFilter("accountbank", "=", accountId), new QFilter("currency", "=", currencyId), new QFilter("bizdate", ">=", (Object)startDate), new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)date, (int)1)), new QFilter("isbank", "=", (Object)"1"), new QFilter("period", "!=", (Object)0L)};
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankstatement"), (String)"cas_bankstatement", (String)"1 as group,creditamount-debitamount as factamt", (QFilter[])statmntFilters, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"group"}).sum("factamt").finish();){
            Iterator iterator = finalJournalDataSet.iterator();
            while (iterator.hasNext()) {
                statmntbalamt = statmntbalamt.add(((Row)iterator.next()).getBigDecimal("factamt"));
            }
        }
        return statmntbalamt;
    }

    public static void getStatemMapByOrg(Map<String, BigDecimal> statmMap, DynamicObject period, Date endDate, Set<Long> acountCurrByOrgs, Map<Long, Set<Long>> acctToCnyMap) {
        QFilter journalFilters = new QFilter("bizdate", "<", (Object)DateUtils.getNextDay((Date)endDate, (int)1)).and(new QFilter("isvalid", "=", (Object)"1")).and(new QFilter("isbank", "=", (Object)"1"));
        ArrayList<QFilter> acctCnyFilterList = new ArrayList<QFilter>(acountCurrByOrgs.size());
        for (Long acountCurrByOrg : acountCurrByOrgs) {
            Set<Long> cnyIdSet;
            QFilter acctCnyFilter = new QFilter("accountbank", "=", (Object)acountCurrByOrg);
            if (acctToCnyMap != null && !EmptyUtil.isEmpty(cnyIdSet = acctToCnyMap.get(acountCurrByOrg))) {
                acctCnyFilter.and("currency", "in", cnyIdSet);
            }
            acctCnyFilterList.add(acctCnyFilter);
        }
        if (!EmptyUtil.isEmpty(acctCnyFilterList)) {
            QFilter allAcctFilter = null;
            for (QFilter filter : acctCnyFilterList) {
                allAcctFilter = allAcctFilter != null ? allAcctFilter.or(filter) : filter;
            }
            journalFilters.and(allAcctFilter);
        }
        if (period != null) {
            journalFilters.and(new QFilter("bizdate", ">=", (Object)period.getDate("begindate")));
        }
        DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".statm"), (String)"cas_bankstatement", (String)"org as orgid,accountbank as accoutid,currency as cuid,creditamount-debitamount as factamt", (QFilter[])new QFilter[]{journalFilters}, null);
        Object object = null;
        try (DataSet finalStatmDataSet = balanceRawDataSet.groupBy(new String[]{"orgid", "accoutid", "cuid"}).sum("factamt").finish();){
            for (Row next : finalStatmDataSet) {
                BigDecimal statemSum = next.getBigDecimal("factamt");
                String key = next.getString("accoutid") + '-' + next.getString("cuid");
                statmMap.put(key, statemSum);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (balanceRawDataSet != null) {
                if (object != null) {
                    try {
                        balanceRawDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    balanceRawDataSet.close();
                }
            }
        }
    }

    public static void getJournalInit(Map<String, BigDecimal> journalMap, Set<Long> accounts, boolean isJournal) {
        if (accounts.size() == 0) {
            return;
        }
        String sumAmount = isJournal ? "journal" : "statm";
        QFilter initFilters = new QFilter("entrybank.bank_accountbank", "in", accounts);
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_cashmgtinit", (String)"org,entrybank.bank_accountbank as accoutid,entrybank.bank_currency as cuid, entrybank.bank_journalbalance as journal,entrybank.bank_statementbalance as statm", (QFilter[])new QFilter[]{initFilters}, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"accoutid", "cuid"}).sum(sumAmount).finish();){
            for (Row next : finalJournalDataSet) {
                BigDecimal journalSum = next.getBigDecimal(sumAmount);
                String key = next.getString("accoutid") + '-' + next.getString("cuid");
                if (isJournal) {
                    key = next.getString("org") + '-' + key;
                }
                journalMap.put(key, journalSum);
            }
        }
    }

    public static Map<String, BigDecimal> getJournalBalance(Long orgId, DynamicObject period) {
        HashMap<String, BigDecimal> journalBalanceMap = new HashMap<String, BigDecimal>();
        if (period == null) {
            logger.error("BalanceCountHelper#getJournalBalance period is null. orgId:{}", (Object)orgId);
            return journalBalanceMap;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"2"));
        DynamicObject[] journalBals = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, org,accountbank,currency,monthstart", (QFilter[])new QFilter[]{filter});
        if (journalBals != null && journalBals.length > 0) {
            for (DynamicObject journalBal : journalBals) {
                String key = BalanceCountHelper.getMapKey(journalBal.getDynamicObject("org"), journalBal.getDynamicObject("accountbank"), journalBal.getDynamicObject("currency"));
                if (CasHelper.isEmpty((Object)key)) continue;
                journalBalanceMap.put(key, journalBal.getBigDecimal("monthstart"));
            }
        }
        return journalBalanceMap;
    }

    public static Map<String, BigDecimal> getCashBalance(Long orgId, DynamicObject period) {
        HashMap<String, BigDecimal> journalBalanceMap = new HashMap<String, BigDecimal>();
        if (period == null) {
            logger.error("BalanceCountHelper#getCashBalance period is null. orgId:{}", (Object)orgId);
            return journalBalanceMap;
        }
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"1"));
        DynamicObject[] journalBals = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, org,accountcash,currency,monthstart", (QFilter[])new QFilter[]{filter});
        if (journalBals != null && journalBals.length > 0) {
            for (DynamicObject journalBal : journalBals) {
                String key = BalanceCountHelper.getMapKey(journalBal.getDynamicObject("org"), journalBal.getDynamicObject("accountcash"), journalBal.getDynamicObject("currency"));
                if (CasHelper.isEmpty((Object)key)) continue;
                journalBalanceMap.put(key, journalBal.getBigDecimal("monthstart"));
            }
        }
        return journalBalanceMap;
    }

    public static BigDecimal getStatemMonthStart(Long orgId, Long accountId, Long currencyId, DynamicObject period) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId)).and(new QFilter("currency", "=", (Object)currencyId)).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"3"));
        DynamicObjectCollection journalBals = QueryServiceHelper.query((String)"cas_journalbalance", (String)"id, org,accountbank,currency,monthstart", (QFilter[])new QFilter[]{filter}, (String)"period", (int)1);
        if (journalBals != null && journalBals.size() > 0) {
            return ((DynamicObject)journalBals.get(0)).getBigDecimal("monthstart");
        }
        return BigDecimal.ZERO;
    }

    public static Boolean isExistBalnce(Long orgId, Long accountId, Long currencyId, DynamicObject period) {
        QFilter filter = new QFilter("org", "=", (Object)orgId).and(new QFilter("accountbank", "=", (Object)accountId)).and(new QFilter("currency", "=", (Object)currencyId)).and(new QFilter("period", "=", period.getPkValue())).and(new QFilter("type", "=", (Object)"3"));
        DynamicObjectCollection journalBals = QueryServiceHelper.query((String)"cas_journalbalance", (String)"id, org,accountbank,currency,monthstart", (QFilter[])new QFilter[]{filter}, (String)"period", (int)1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)journalBals)) {
            return false;
        }
        return true;
    }

    public static String getMapKey(DynamicObject org, DynamicObject accountBank, DynamicObject currency) {
        if (CasHelper.isNotEmpty((Object)org) && CasHelper.isNotEmpty((Object)accountBank) && CasHelper.isNotEmpty((Object)currency)) {
            return org.getString("id") + '-' + accountBank.getString("id") + '-' + currency.getString("id");
        }
        return "";
    }

    public static void getJournalMapByOrg(Map<String, BigDecimal> journalMap, Long orgId, DynamicObject period, Date endDate, Set<String> acountCurrByOrgs) {
        Map<String, BigDecimal> journalBalance = BalanceCountHelper.getJournalBalance(orgId, period);
        journalMap.putAll(journalBalance);
        QFilter journalFilters = new QFilter("org", "=", (Object)orgId).and(new QFilter("bookdate", ">=", (Object)period.getDate("begindate"))).and(new QFilter("bookdate", "<", (Object)endDate));
        try (DataSet balanceRawDataSet = QueryServiceHelper.queryDataSet((String)(AcctBalanceHelper.class.getName() + ".bankjournal"), (String)"cas_bankjournal", (String)"org as orgid,accountbank as accoutid,currency as cuid,debitamount-creditamount as factamt", (QFilter[])new QFilter[]{journalFilters}, null);
             DataSet finalJournalDataSet = balanceRawDataSet.groupBy(new String[]{"orgid", "accoutid", "cuid"}).sum("factamt").finish();){
            for (Row next : finalJournalDataSet) {
                BigDecimal journalSum = next.getBigDecimal("factamt");
                String key = next.getString("orgid") + '-' + next.getString("accoutid") + '-' + next.getString("cuid");
                if (!acountCurrByOrgs.contains(key)) continue;
                BigDecimal bigDecimal = journalBalance.get(key);
                if (bigDecimal != null) {
                    journalSum = bigDecimal.add(journalSum);
                }
                journalMap.put(key, journalSum);
            }
        }
    }

    public static Set<String> getAcountCurrByOrgs(Set<Long> orgIds) {
        if (orgIds == null || orgIds.size() == 0) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        QFilter filter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company as orgid,currency.fbasedataid.id as currencyid", (QFilter[])new QFilter[]{filter});
        if (colls != null && colls.size() > 0) {
            colls.forEach(coll -> set.add(coll.getString("orgid") + '-' + coll.getString("id") + '-' + coll.getString("currencyid")));
        }
        return set;
    }

    public static Set<String> getAccountKey(String orgId, DynamicObjectCollection colls) {
        HashSet<String> set = new HashSet<String>();
        colls.forEach(coll -> set.add(orgId + '-' + coll.getString("accountbankid") + '-' + coll.getString("currencyid")));
        return set;
    }

    public static DynamicObjectCollection getAcctColl(Long orgId, List<Long> acctIds, List<Long> currenyIds) {
        QFilter filter = AccountBankHelper.getAccountBankFilterByOrg((Long)orgId);
        if (acctIds != null && !acctIds.isEmpty()) {
            filter.and(new QFilter("id", "in", acctIds));
        }
        if (currenyIds != null && !currenyIds.isEmpty()) {
            filter.and(new QFilter("currency.fbasedataid.id", "in", currenyIds));
        }
        DynamicObjectCollection acctPlainColl = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id as accountbankid,company as orgid,currency.fbasedataid.id as currencyid,bank.bank_cate.id as bankcgsetting", (QFilter[])new QFilter[]{filter});
        return acctPlainColl;
    }
}

