/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.compare.BankAutoMatchStrategy;
import kd.fi.cas.business.helper.CheckResult;
import kd.fi.cas.compare.CompareEngine;
import kd.fi.cas.compare.concurrent.MultiThreadOperationExecutor;
import kd.fi.cas.compare.data.CompareRule;
import kd.fi.cas.compare.strategy.ICompareStrategy;
import kd.fi.cas.dao.CheckMatch;
import kd.fi.cas.dao.MatchData;
import kd.fi.cas.enums.MatchPlanEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BankAutoMatchCheckHelper {
    private static final Long BASE_ORGID = 100000000000000001L;
    private static final Log logger = LogFactory.getLog(BankAutoMatchCheckHelper.class);
    private static final String[] staticMatchField = new String[]{"id", "entryentity.e_rulesname", "entryentity.e_datafilterdesc_real_TAG"};

    public static List<CheckResult> autoMatchCal(List<Map<String, Object>> dataMap) {
        List resultList = new MultiThreadOperationExecutor().doBatchOperation(new ArrayList<Map<String, Object>>(dataMap), 4, dataList -> {
            ArrayList<CheckResult> results = new ArrayList<CheckResult>();
            for (Object map : dataList) {
                CheckResult result = BankAutoMatchCheckHelper.calForThread(map);
                if (result == null) continue;
                results.add(result);
            }
            return results;
        });
        return resultList;
    }

    private static CheckResult calForThread(Object map) {
        if (map == null) {
            return null;
        }
        Map dataMap = (Map)map;
        MatchData matchData = BankAutoMatchCheckHelper.getMatchData(dataMap);
        if (matchData == null || matchData.getSrcDataList() == null || matchData.getTarDataList() == null) {
            return null;
        }
        CompareEngine engine = new CompareEngine(matchData.getSrcDataList(), matchData.getTarDataList());
        BankAutoMatchStrategy strategy = new BankAutoMatchStrategy(matchData.getRules());
        List resultList = engine.compare((ICompareStrategy)strategy);
        CheckResult result = new CheckResult();
        result.setRuleId((Long)matchData.getRuleId());
        result.setCompareResults(resultList);
        result.setBizData((Date)dataMap.get("bizdate"));
        result.setBizDataEnd((Date)dataMap.get("bizdateend"));
        result.setUnReachData((Boolean)dataMap.get("unreachdata"));
        return result;
    }

    private static MatchData getMatchData(Map<String, Object> dataMap) {
        QFilter smartListFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("orgfield", "=", dataMap.get("org")));
        CharSequence[] matchField = staticMatchField;
        DynamicObjectCollection smartmatchDCs = QueryServiceHelper.query((String)"cas_reconciliationrule", (String)String.join((CharSequence)",", matchField), (QFilter[])new QFilter[]{smartListFilter}, (String)"entryentity.seq");
        if (smartmatchDCs == null || smartmatchDCs.size() <= 0) {
            smartListFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("orgfield", "=", (Object)BASE_ORGID));
            smartmatchDCs = QueryServiceHelper.query((String)"cas_reconciliationrule", (String)String.join((CharSequence)",", matchField), (QFilter[])new QFilter[]{smartListFilter}, (String)"entryentity.seq");
        }
        if (smartmatchDCs == null || smartmatchDCs.size() <= 0) {
            return null;
        }
        logger.info("=======\u4f7f\u7528\u5bf9\u8d26\u5339\u914d\u89c4\u5219\u540d\u79f0\uff1a" + ((DynamicObject)smartmatchDCs.get(0)).getString("entryentity.e_rulesname"));
        ArrayList ruleList = new ArrayList();
        HashSet<String> detailFields = new HashSet<String>();
        HashSet<String> bizFields = new HashSet<String>();
        for (DynamicObject smartmatchDC : smartmatchDCs) {
            String matchplan = smartmatchDC.getString("entryentity.e_datafilterdesc_real_TAG");
            if (CasHelper.isEmpty((Object)matchplan)) continue;
            JSONArray matchplanArr = (JSONArray)JSONObject.parse((String)matchplan);
            List matches = matchplanArr.toJavaList(CheckMatch.class);
            ArrayList<CompareRule> rules = new ArrayList<CompareRule>(matches.size());
            for (CheckMatch sm : matches) {
                detailFields.add(sm.getBankstatement());
                bizFields.add(sm.getBankjournal());
                rules.add(BankAutoMatchCheckHelper.transRule(sm));
            }
            ruleList.add(rules);
        }
        bizFields.add("id");
        detailFields.add("id");
        bizFields.add("bankcheckflag_tag");
        logger.info("=======\u5bf9\u8d26\u5355\u5339\u914d\u5b57\u6bb5\uff1a{},\u65e5\u8bb0\u8d26\u5339\u914d\u5b57\u6bb5\uff1a{}", (Object)String.join((CharSequence)",", detailFields), (Object)String.join((CharSequence)",", bizFields));
        ArrayList srcDataList = new ArrayList();
        DynamicObjectCollection statems = QueryServiceHelper.query((String)"cas_bankstatement", (String)String.join((CharSequence)",", detailFields), (QFilter[])new QFilter[]{BankAutoMatchCheckHelper.getQfilter(dataMap, "bizdate"), new QFilter("isbank", "=", (Object)"1")});
        if (statems == null || statems.size() == 0) {
            return null;
        }
        Set<String> StatmDateFields = BankAutoMatchCheckHelper.getDateFields("cas_bankstatement");
        ArrayList ids = new ArrayList();
        statems.forEach(state -> {
            HashMap<String, String> srcDataMap = new HashMap<String, String>(detailFields.size());
            for (String detailField : detailFields) {
                Date date;
                String value = "";
                value = StatmDateFields.contains(detailField) ? ((date = state.getDate(detailField)) == null ? "" : DateUtils.formatString((Date)date, (String)"yyyy-MM-dd")) : (BankAutoMatchCheckHelper.getNoNullColunm().contains(detailField) && CasHelper.isEmpty((Object)state.getString(detailField)) ? "statm" : state.getString(detailField).trim());
                srcDataMap.put(detailField, value);
            }
            ids.add(state.getString("id"));
            srcDataList.add(srcDataMap);
        });
        logger.info("=======\u5bf9\u8d26\u5355ID:" + String.join((CharSequence)",", ids));
        ArrayList tarDataList = new ArrayList();
        DynamicObjectCollection journals = QueryServiceHelper.query((String)"cas_bankjournal", (String)String.join((CharSequence)",", bizFields), (QFilter[])new QFilter[]{BankAutoMatchCheckHelper.getQfilter(dataMap, "bookdate")});
        if (journals == null || journals.size() == 0) {
            return null;
        }
        Set<String> journalDateFields = BankAutoMatchCheckHelper.getDateFields("cas_bankjournal");
        ids.clear();
        journals.forEach(journal -> {
            HashMap<String, String> recBillMap = new HashMap<String, String>(bizFields.size());
            for (String bizField : bizFields) {
                String value = "";
                if (journalDateFields.contains(bizField)) {
                    Date date = journal.getDate(bizField);
                    value = date == null ? "" : DateUtils.formatString((Date)date, (String)"yyyy-MM-dd");
                } else if (BankAutoMatchCheckHelper.getNoNullColunm().contains(bizField) && CasHelper.isEmpty((Object)journal.getString(bizField))) {
                    value = "journal";
                } else {
                    logger.info("=======\u5bf9\u8d26\u5355bizField:{},String bizField:{}", (Object)bizField, (Object)journal.getString(bizField));
                    if ("bankcheckflag".equals(bizField)) {
                        value = journal.getString("bankcheckflag_tag").trim();
                    } else if (StringUtils.isNotBlank((CharSequence)journal.getString(bizField))) {
                        value = journal.getString(bizField).trim();
                    }
                }
                recBillMap.put(bizField, value);
            }
            ids.add(journal.getString("id"));
            tarDataList.add(recBillMap);
        });
        logger.info("=======\u65e5\u8bb0\u8d26ID:" + String.join((CharSequence)",", ids));
        MatchData md = new MatchData();
        md.setRuleId((Object)((DynamicObject)smartmatchDCs.get(0)).getLong("id"));
        md.setRules(ruleList);
        md.setSrcDataList(srcDataList);
        md.setTarDataList(tarDataList);
        return md;
    }

    private static Set<String> getDateFields(String entryName) {
        HashSet<String> dateFields = new HashSet<String>();
        MainEntityType transEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        List transFields = new EntityTypeUtil().getFilterFields((IDataEntityType)transEntityType);
        for (FilterField transField : transFields) {
            IDataEntityProperty fieldProp = transField.getFieldProp();
            if (!(fieldProp instanceof DateProp) && !(fieldProp instanceof TimeProp) && !(fieldProp instanceof DateTimeProp) && !(fieldProp instanceof ModifyDateProp) && !(fieldProp instanceof CreateDateProp)) continue;
            dateFields.add(transField.getFullFieldName());
        }
        return dateFields;
    }

    private static QFilter getQfilter(Map<String, Object> dataMap, String dateColunm) {
        boolean authorityAccount;
        QFilter filter = new QFilter("accountbank", "=", dataMap.get("accountbank")).and("currency", "=", dataMap.get("currency")).and("ischeck", "=", (Object)"0").and("isvalid", "=", (Object)"1");
        Object unreachdata = dataMap.get("unreachdata");
        if ("bookdate".equals(dateColunm) && !(authorityAccount = AccountBankHelper.isAuthorityAccount((DynamicObject)AccountBankHelper.getAccountBankById((long)((Long)dataMap.get("accountbank"))), (Long)((Long)dataMap.get("org"))))) {
            filter.and("org", "=", dataMap.get("org"));
        }
        if (CasHelper.isNotEmpty((Object)unreachdata) && !((Boolean)unreachdata).booleanValue() && dataMap.get("bizdate") != null) {
            filter.and(dateColunm, ">=", dataMap.get("bizdate"));
        }
        if (dataMap.get("bizdateend") != null) {
            filter.and(dateColunm, "<=", dataMap.get("bizdateend"));
        }
        return filter;
    }

    private static CompareRule transRule(CheckMatch sm) {
        CompareRule r = new CompareRule();
        r.setSymbol(BankAutoMatchCheckHelper.transSymbol(sm.getCondition()));
        if (CasHelper.isNotEmpty((Object)sm.getNum())) {
            r.setExtraVal((Object)Integer.valueOf(sm.getNum()));
        }
        if (MatchPlanEnum.CONTAIN.getValue().equals(sm.getCondition())) {
            r.setExtraVal((Object)",");
        }
        if (StringUtils.isNotBlank((CharSequence)sm.getIsnullmatch())) {
            r.setNullMatch((sm.getIsnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        }
        if (StringUtils.isNotBlank((CharSequence)sm.getIsallnullmatch())) {
            r.setAllNullMatch((sm.getIsallnullmatch().equals("true") ? Boolean.TRUE : Boolean.FALSE).booleanValue());
        } else if (sm.getIsnullmatch().equals("true")) {
            r.setAllNullMatch(true);
        }
        r.setPropNameSrc(sm.getBankstatement());
        r.setPropNameTgt(sm.getBankjournal());
        if (CompareRule.Symbol.STR_MATCH == r.getSymbol()) {
            if (MatchPlanEnum.LIKE.getValue().equals(sm.getCondition())) {
                r.setExtraVal((Object)1);
            } else if (MatchPlanEnum.LIKERIGHT.getValue().equals(sm.getCondition())) {
                r.setExtraVal((Object)-1);
            } else {
                r.setExtraVal((Object)0);
            }
        }
        return r;
    }

    private static CompareRule.Symbol transSymbol(String relation) {
        if (MatchPlanEnum.DIFF.getValue().equals(relation)) {
            return CompareRule.Symbol.DATE_DIFF;
        }
        if (MatchPlanEnum.LIKE.getValue().equals(relation) || MatchPlanEnum.LIKERIGHT.getValue().equals(relation) || MatchPlanEnum.LIKEBOTH.getValue().equals(relation)) {
            return CompareRule.Symbol.STR_MATCH;
        }
        if (MatchPlanEnum.CONTAIN.getValue().equals(relation)) {
            return CompareRule.Symbol.CONTAINS;
        }
        return CompareRule.Symbol.EQUALS;
    }

    private static List<String> getNoNullColunm() {
        ArrayList<String> colunms = new ArrayList<String>();
        colunms.add("bankcheckflag");
        colunms.add("bankcheckentity.ebankcheckflag");
        return colunms;
    }

    private static Pair<List<Object>, List<Object>> getMatchIdList(Map<String, Object> dataMap) {
        List<Object> orgIdList = new ArrayList(10);
        List<Object> tarIdList = new ArrayList(10);
        DynamicObjectCollection statementColl = QueryServiceHelper.query((String)"cas_bankstatement", (String)"id", (QFilter[])new QFilter[]{BankAutoMatchCheckHelper.getQfilter(dataMap, "bizdate"), new QFilter("isbank", "=", (Object)"1")});
        if (statementColl == null || statementColl.size() == 0) {
            return Pair.of(orgIdList, tarIdList);
        }
        orgIdList = statementColl.stream().map(e -> e.get("id")).collect(Collectors.toList());
        DynamicObjectCollection journalColl = QueryServiceHelper.query((String)"cas_bankjournal", (String)"id", (QFilter[])new QFilter[]{BankAutoMatchCheckHelper.getQfilter(dataMap, "bookdate")});
        if (journalColl == null || journalColl.size() == 0) {
            return Pair.of(orgIdList, tarIdList);
        }
        tarIdList = journalColl.stream().map(e -> e.get("id")).collect(Collectors.toList());
        return Pair.of(orgIdList, tarIdList);
    }
}

