/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.business.helper.AutoMatchHelper;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.SourceBillTypeEnum;

public class MatchAmountDealHelper {
    public static final Set<String> BUSINESS_TYPE = Stream.of(SourceBillTypeEnum.PAYBILL_SPAN.getValue(), SourceBillTypeEnum.PAYBILL.getValue(), SourceBillTypeEnum.PAYBILL_SYNONYM.getValue(), SourceBillTypeEnum.PAYCASHBILL.getValue(), SourceBillTypeEnum.RECBILL.getValue(), SourceBillTypeEnum.TRANSHANDLEBILL.getValue(), SourceBillTypeEnum.PAYBILL_DCEP.getValue()).collect(Collectors.toSet());
    public static final Set<String> A_BUSINESS_TYPE = Stream.of(SourceBillTypeEnum.AGENTPAYBILL.getValue(), SourceBillTypeEnum.TRANSDOWNBILL.getValue(), SourceBillTypeEnum.TRANSUPBILL.getValue()).collect(Collectors.toSet());
    private static final String MATCH_AMT = "matchamount";
    private static final String UN_MATCH_AMT = "unmatchamount";
    private static final String MATCH_FLAG = "matchflag";
    private static final String MATCH_FLAG_MSG = "matchflagmsg";
    private static final Set<String> TRACE_TYPE = Stream.of("buy", "sell").collect(Collectors.toSet());

    public static void matchManyToOne(DynamicObject businessBill, String type, BigDecimal thisMatchAmount, String billType) {
        Map<String, Object> tMatchResult;
        if (!BUSINESS_TYPE.contains(billType)) {
            return;
        }
        type = "pay".equals(type) ? "pay" : "rec";
        String matchAmt = MATCH_AMT + type;
        String unMatchAmt = UN_MATCH_AMT + type;
        BigDecimal matchAmount = businessBill.getBigDecimal(matchAmt);
        BigDecimal unMatchAmount = businessBill.getBigDecimal(unMatchAmt);
        boolean flag = Stream.of("cas_paybill_synonym", "cas_paybill_cash", "cas_paybill_spanmainpart", "cas_paybill", "cas_recbill").anyMatch(b -> b.equals(businessBill.getDataEntityType().getName()));
        if (flag) {
            String otype = "pay".equals(type) ? "rec" : "pay";
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount, businessBill.getBoolean("relateotherflow"), businessBill.getBigDecimal(MATCH_AMT + otype), businessBill.getBigDecimal(UN_MATCH_AMT + otype));
        } else {
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount);
        }
        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, matchAmt, unMatchAmt, MATCH_FLAG, MATCH_FLAG_MSG);
    }

    public static void matchOneToMany(DynamicObject businessBill, String billType, String type, BigDecimal thisMatchAmount) {
        Map<String, Object> tMatchResult;
        if (!BUSINESS_TYPE.contains(billType)) {
            return;
        }
        type = "pay".equals(type) ? "pay" : "rec";
        String matchAmt = MATCH_AMT + type;
        String unMatchAmt = UN_MATCH_AMT + type;
        BigDecimal matchAmount = businessBill.getBigDecimal(matchAmt);
        BigDecimal unMatchAmount = businessBill.getBigDecimal(unMatchAmt);
        boolean flag = Stream.of("cas_paybill_synonym", "cas_paybill_cash", "cas_paybill_spanmainpart", "cas_paybill", "cas_recbill").anyMatch(b -> b.equals(businessBill.getDataEntityType().getName()));
        if (flag) {
            String otype = "pay".equals(type) ? "rec" : "pay";
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount, businessBill.getBoolean("relateotherflow"), businessBill.getBigDecimal(MATCH_AMT + otype), businessBill.getBigDecimal(UN_MATCH_AMT + otype));
        } else {
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount);
        }
        AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, matchAmt, unMatchAmt, MATCH_FLAG, MATCH_FLAG_MSG);
    }

    public static void matchManyToOne(DynamicObject busnessBill, String billtype, BigDecimal totalamount, Object billEntryId) {
        if (!A_BUSINESS_TYPE.contains(billtype)) {
            return;
        }
        String entryName = "";
        if (SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) {
            entryName = "entrys";
        } else if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            entryName = "entry";
        }
        if (Long.parseLong(billEntryId.toString()) > 0L) {
            DynamicObjectCollection entry1 = busnessBill.getDynamicObjectCollection(entryName);
            DynamicObject first = entry1.stream().filter(y -> y.getPkValue().equals(billEntryId)).findFirst().get();
            MatchAmountDealHelper.dealWithMatchProperty(first, busnessBill, totalamount, "entry");
        } else {
            MatchAmountDealHelper.dealWithMatchProperty(busnessBill, busnessBill, totalamount, "");
        }
    }

    public static BigDecimal matchOneToMany(DynamicObject busnessBill, Long billEntryId, String billtype, BigDecimal totalAmount) {
        if (!A_BUSINESS_TYPE.contains(billtype)) {
            return BigDecimal.ZERO;
        }
        String entryName = "";
        if (SourceBillTypeEnum.TRANSUPBILL.getValue().equals(billtype) || SourceBillTypeEnum.TRANSDOWNBILL.getValue().equals(billtype)) {
            entryName = "entrys";
        } else if (SourceBillTypeEnum.AGENTPAYBILL.getValue().equals(billtype)) {
            entryName = "entry";
        }
        BigDecimal canMatchAmount = totalAmount;
        DynamicObjectCollection entrys = busnessBill.getDynamicObjectCollection(entryName);
        List selectedEntry = entrys.stream().filter(y -> billEntryId.equals(y.getLong("id"))).collect(Collectors.toList());
        canMatchAmount = selectedEntry != null && selectedEntry.size() > 0 ? MatchAmountDealHelper.dealWithMatchProperty((DynamicObject)selectedEntry.get(0), busnessBill, canMatchAmount, "entry") : MatchAmountDealHelper.dealWithMatchProperty(busnessBill, busnessBill, canMatchAmount, "");
        return canMatchAmount;
    }

    public static void matchExchangeBill(DynamicObject businessBill, String tracetype, BigDecimal thisMatchAmount) {
        if (businessBill != null && SourceBillTypeEnum.EXCHANGEBILL.getValue().equals(businessBill.getDataEntityType().getName()) && TRACE_TYPE.contains(tracetype)) {
            Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, businessBill.getBigDecimal(tracetype + MATCH_AMT), businessBill.getBigDecimal(tracetype + UN_MATCH_AMT));
            AutoMatchHelper.initMatchAmount(businessBill, tMatchResult, tracetype + MATCH_AMT, tracetype + UN_MATCH_AMT, tracetype + MATCH_FLAG, tracetype + MATCH_FLAG_MSG);
            MatchAmountDealHelper.updataExchangeBill(businessBill);
        }
    }

    public static void updataExchangeBill(DynamicObject businessBill) {
        ArrayList matchflagList = new ArrayList(TRACE_TYPE.size());
        TRACE_TYPE.stream().forEach(o -> matchflagList.add(businessBill.getString(o + MATCH_FLAG)));
        if (matchflagList.stream().allMatch(o -> AutoMatchFlagEnum.NONE.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.NONE.getValue());
        } else if (matchflagList.stream().allMatch(o -> AutoMatchFlagEnum.ALL.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.ALL.getValue());
        } else if (matchflagList.stream().anyMatch(o -> AutoMatchFlagEnum.ERROR.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.ERROR.getValue());
        } else if (matchflagList.stream().anyMatch(o -> AutoMatchFlagEnum.NONEED.getValue().equals(o))) {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.NONEED.getValue());
        } else {
            businessBill.set(MATCH_FLAG, (Object)AutoMatchFlagEnum.SOME.getValue());
        }
    }

    public static BigDecimal dealWithMatchProperty(DynamicObject dy, DynamicObject billDy, BigDecimal totalamount, String type) {
        Map<Object, Object> tMatchResult = new HashMap(4);
        BigDecimal canMatchAmount = BigDecimal.ZERO;
        BigDecimal matchAmount = dy.getBigDecimal(type + MATCH_AMT);
        BigDecimal unMatchAmount = dy.getBigDecimal(type + UN_MATCH_AMT);
        BigDecimal thisMatchAmount = BigDecimal.ZERO;
        if (totalamount.compareTo(unMatchAmount) > 0) {
            thisMatchAmount = unMatchAmount;
            canMatchAmount = totalamount.subtract(unMatchAmount);
        } else {
            thisMatchAmount = totalamount;
        }
        tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount);
        if (tMatchResult != null) {
            dy.set(type + MATCH_AMT, tMatchResult.get("matchAmount"));
            dy.set(type + UN_MATCH_AMT, tMatchResult.get("unMatchAmount"));
            dy.set(type + MATCH_FLAG, tMatchResult.get("matchFlag"));
            if (tMatchResult.containsKey("matchFlagMsg")) {
                dy.set(type + "matcherrmsg", tMatchResult.get("matchFlagMsg"));
            }
        }
        if (!type.isEmpty()) {
            matchAmount = billDy.getBigDecimal(MATCH_AMT);
            tMatchResult = AutoMatchHelper.getMatchAmount(thisMatchAmount, matchAmount, unMatchAmount = billDy.getBigDecimal(UN_MATCH_AMT));
            if (tMatchResult != null) {
                billDy.set(MATCH_AMT, tMatchResult.get("matchAmount"));
                billDy.set(UN_MATCH_AMT, tMatchResult.get("unMatchAmount"));
                billDy.set(MATCH_FLAG, tMatchResult.get("matchFlag"));
                if (tMatchResult.containsKey("matchFlagMsg")) {
                    billDy.set("matcherrmsg", tMatchResult.get("matchFlagMsg"));
                }
            }
        } else {
            dy.set("ismatchbyhead", (Object)"1");
        }
        return canMatchAmount;
    }

    public static void dealCancelMatchInfo(String type, BigDecimal amount, Long entryId, DynamicObject bizDto) {
        if (BUSINESS_TYPE.contains(bizDto.getDataEntityType().getName()) || A_BUSINESS_TYPE.contains(bizDto.getDataEntityType().getName())) {
            BigDecimal totalAmt = BigDecimal.ZERO;
            String matchAmt = MATCH_AMT + type;
            String unMatchAmt = UN_MATCH_AMT + type;
            if ("cas_recbill".equals(bizDto.getDataEntityType().getName())) {
                totalAmt = bizDto.getBigDecimal("actrecamt");
            } else if ("ifm_transhandlebill".equals(bizDto.getDataEntityType().getName())) {
                totalAmt = bizDto.getBigDecimal("actpayamt");
            } else if ("cas_agentpaybill".equals(bizDto.getDataEntityType().getName()) || "fca_transupbill".equals(bizDto.getDataEntityType().getName()) || "fca_transdownbill".equals(bizDto.getDataEntityType().getName())) {
                if (Long.compare(entryId, 0L) != 0) {
                    String entityName = "entrys";
                    String totalAmtKey = "transamt";
                    if ("cas_agentpaybill".equals(bizDto.getDataEntityType().getName())) {
                        entityName = "entry";
                        totalAmtKey = "e_amount";
                    }
                    MatchAmountDealHelper.dealCancelMatchEntryInfo(bizDto, entryId, amount, entityName, totalAmtKey);
                }
                matchAmt = MATCH_AMT;
                unMatchAmt = UN_MATCH_AMT;
                totalAmt = "cas_agentpaybill".equals(bizDto.getDataEntityType().getName()) ? bizDto.getBigDecimal("payamount") : bizDto.getBigDecimal("amount");
            } else {
                totalAmt = bizDto.getBigDecimal("totalpayamt");
            }
            MatchAmountDealHelper.dealCancelMatchObj(bizDto, matchAmt, unMatchAmt, amount, totalAmt, MATCH_FLAG, Boolean.FALSE, bizDto);
        }
    }

    private static void dealCancelMatchObj(DynamicObject bizDto, String matchAmt, String unMatchAmt, BigDecimal amount, BigDecimal totalAmt, String matchFlag, Boolean isEntry, DynamicObject billDy) {
        Map<String, Object> tMatchResult = AutoMatchHelper.getMatchAmount(amount.negate(), bizDto.getBigDecimal(matchAmt), bizDto.getBigDecimal(unMatchAmt));
        if (tMatchResult != null && tMatchResult.size() > 0) {
            bizDto.set(matchAmt, tMatchResult.get("matchAmount"));
            bizDto.set(unMatchAmt, tMatchResult.get("unMatchAmount"));
            bizDto.set(matchFlag, tMatchResult.get("matchFlag"));
            if (tMatchResult.containsKey("matchFlagMsg")) {
                if (A_BUSINESS_TYPE.contains(billDy.getDataEntityType().getName())) {
                    if (isEntry.booleanValue()) {
                        bizDto.set("entrymatcherrmsg", tMatchResult.get("matchFlagMsg"));
                    } else {
                        bizDto.set("matcherrmsg", tMatchResult.get("matchFlagMsg"));
                    }
                } else {
                    bizDto.set(MATCH_FLAG_MSG, tMatchResult.get("matchFlagMsg"));
                }
            }
        }
        String isMatchByHead = "1";
        if (bizDto.getBigDecimal(matchAmt).compareTo(BigDecimal.ZERO) == 0) {
            isMatchByHead = "0";
        }
        if (A_BUSINESS_TYPE.contains(bizDto.getDataEntityType().getName()) && !isEntry.booleanValue()) {
            bizDto.set("ismatchbyhead", (Object)isMatchByHead);
        }
    }

    public static void dealCancelMatchEntryInfo(DynamicObject bizDto, Long entryId, BigDecimal amount, String entityName, String totalAmtKey) {
        DynamicObjectCollection entry = bizDto.getDynamicObjectCollection(entityName);
        DynamicObject row = entry.stream().filter(y -> y.getPkValue().equals(entryId)).findFirst().get();
        BigDecimal totalAmt = row.getBigDecimal(totalAmtKey);
        String matchAmtKey = "entrymatchamount";
        String unMatchAmtKey = "entryunmatchamount";
        String matchFlagKey = "entrymatchflag";
        MatchAmountDealHelper.dealCancelMatchObj(row, matchAmtKey, unMatchAmtKey, amount, totalAmt, matchFlagKey, Boolean.TRUE, bizDto);
    }
}

