/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.helper;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.MultiBaseDataHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.util.EmptyUtil;
import org.apache.commons.lang3.StringUtils;

public class RecDraftHelper {
    private static final Log logger = LogFactory.getLog(RecDraftHelper.class);
    private static int BATCHNUM = 100;

    public static List<DynamicObject> fillDraft(Object[] totalRecPks, boolean isSave) {
        List recBillList = Arrays.stream(totalRecPks).collect(Collectors.toList());
        logger.info("fillDraft is start and size is:" + totalRecPks.length);
        List payIdLists = Lists.partition(recBillList, (int)BATCHNUM);
        logger.info("payIdLists size is:" + payIdLists.size());
        ArrayList<DynamicObject> allFillRecBills = new ArrayList<DynamicObject>(8);
        for (List recPks : payIdLists) {
            DynamicObject[] recBills = BusinessDataServiceHelper.load((Object[])recPks.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_recbill"));
            HashMap orgAndCS123Map = new HashMap(16);
            Arrays.stream(recBills).forEach(rec -> {
                long orgId = rec.getDynamicObject("org").getLong("id");
                if (!orgAndCS123Map.containsKey(orgId)) {
                    boolean result = SystemParameterHelper.getParameterBoolean((long)orgId, (String)"cs123");
                    orgAndCS123Map.put(orgId, result);
                }
            });
            ArrayList<DynamicObject> needFillDraftBills = new ArrayList<DynamicObject>(recBills.length);
            ArrayList<String> settletnumbers = new ArrayList<String>(recBills.length);
            for (DynamicObject recBill : recBills) {
                if (!((Boolean)orgAndCS123Map.get(recBill.getDynamicObject("org").getLong("id"))).booleanValue() || !RecDraftHelper.needFillDraft(recBill)) continue;
                needFillDraftBills.add(recBill);
                settletnumbers.add(recBill.getString("settletnumber"));
            }
            if (needFillDraftBills.size() <= 0) {
                logger.info("needFillDraftBills is null");
                continue;
            }
            DynamicObject[] receivablebills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("draftbillno", "in", settletnumbers), new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue()}), new QFilter("rptype", "=", (Object)"receivebill")});
            if (receivablebills.length > 0) {
                List saveBillIds = Arrays.stream(receivablebills).filter(rec -> BillStatusEnum.SAVE.getValue().equals(rec.getString("billstatus"))).map(rec -> rec.getPkValue()).collect(Collectors.toList());
                OperateOption create = OperateOption.create();
                create.setVariableValue("ishasright", "true");
                if (saveBillIds.size() > 0) {
                    OperateServiceHelper.execOperateWithoutThrow((String)"submit", (String)"cdm_receivablebill", (Object[])saveBillIds.toArray(), (OperateOption)create);
                }
                List submitBillIds = Arrays.stream(receivablebills).map(rec -> rec.getPkValue()).collect(Collectors.toList());
                OperateServiceHelper.execOperateWithoutThrow((String)"audit", (String)"cdm_receivablebill", (Object[])submitBillIds.toArray(), (OperateOption)create);
            }
            HashSet<String> settletnumberSet = new HashSet<String>(needFillDraftBills.size());
            ArrayList<DynamicObject> fillRecBills = new ArrayList<DynamicObject>(needFillDraftBills.size());
            ArrayList<DraftLockInfo> saveDraftAmountLockInfos = new ArrayList<DraftLockInfo>(10);
            for (DynamicObject recBill : needFillDraftBills) {
                String settletNumber = recBill.getString("settletnumber");
                QFilter otherFilter = new QFilter("draftbillno", "=", (Object)settletNumber);
                otherFilter.and(new QFilter("amount", "=", (Object)recBill.getBigDecimal("actrecamt")));
                QFilter draftFilter = RecDraftHelper.getDraftFilter(recBill.getPkValue(), null, otherFilter);
                DynamicObject[] recDraftBills = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id", (QFilter[])new QFilter[]{draftFilter});
                if (recDraftBills == null || recDraftBills.length != 1 || settletnumberSet.contains(settletNumber)) continue;
                settletnumberSet.add(settletNumber);
                List draftIdList = Arrays.stream(recDraftBills).map(draft -> draft.getLong("id")).collect(Collectors.toList());
                DynamicObject[] draftData = BusinessDataServiceHelper.load((Object[])draftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cdm_payandrecdraft_f7"));
                DynamicObjectCollection draftDataColl = MultiBaseDataHelper.generateMultiPropValue((DynamicObject)recBill, (String)"draftbill", (DynamicObject[])draftData);
                recBill.set("draftbill", (Object)draftDataColl);
                fillRecBills.add(recBill);
                Set draftBillIds = draftDataColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
                DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
                HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
                long recBillId = recBill.getLong("id");
                String dataTypeStr = recBill.getDataEntityType().getName();
                DynamicObjectCollection draftInfoEntrys = recBill.getDynamicObjectCollection("cas_draftinfo");
                HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
                HashMap draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
                ArrayList<DraftAmountLockSubInfo> draftAmountLockInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
                DraftLockInfo draftLockInfo = new DraftLockInfo();
                draftLockInfo.setSourceBillType(dataTypeStr);
                draftLockInfo.setBizBillNo(recBill.getString("billno"));
                draftLockInfo.setSourceBillId(recBillId);
                for (Long lockDraftId : draftBillIds) {
                    DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                    draftAmountLockInfo.setBillId(lockDraftId);
                    BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                    BigDecimal transAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                    draftAmountLockInfo.setDealAmount(transAmount);
                    Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                    draftAmountLockInfo.setBillLogId(billLogId);
                    draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                    draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                    if (transAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    draftAmountLockInfoList.add(draftAmountLockInfo);
                }
                if (!EmptyUtil.isNoEmpty(draftAmountLockInfoList) || draftAmountLockInfoList.size() <= 0) continue;
                draftLockInfo.getLockSubInfoList().addAll(draftAmountLockInfoList);
                saveDraftAmountLockInfos.add(draftLockInfo);
            }
            if (isSave && fillRecBills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])fillRecBills.toArray(new DynamicObject[0]));
            }
            try {
                ArrayList<LockResult> lockResults = new ArrayList(10);
                if (isSave && !CollectionUtils.isEmpty(saveDraftAmountLockInfos)) {
                    logger.info("RecDraftHelper lockBillsByLog is start," + JSON.toJSONString(saveDraftAmountLockInfos));
                    DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();
                    lockResults = draftLockServiceHelper.releaseOrLockDraft(saveDraftAmountLockInfos);
                    logger.info("RecDraftHelper lockBillsByLog is end," + JSON.toJSONString(lockResults));
                }
                if (!EmptyUtil.isEmpty(lockResults)) {
                    DynamicObject[] dataEntities;
                    for (DynamicObject data : dataEntities = needFillDraftBills.toArray(new DynamicObject[0])) {
                        RecDraftHelper.updateEntryLogIds(lockResults, data);
                    }
                    SaveServiceHelper.update((DynamicObject[])dataEntities);
                }
            }
            catch (Exception e) {
                logger.error("RecDraftHelper tx-> has error:" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw e;
            }
            allFillRecBills.addAll(fillRecBills);
        }
        return allFillRecBills;
    }

    private static void updateEntryLogIds(List<LockResult> lockResults, DynamicObject data) {
        Map<Long, LockResult> recIdAndDyMap;
        if (!EmptyUtil.isEmpty(lockResults) && EmptyUtil.isNoEmpty(recIdAndDyMap = lockResults.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getSourceBillId())).collect(Collectors.toMap(LockResult::getSourceBillId, x -> x)))) {
            long recBillId = data.getLong("id");
            DynamicObjectCollection entrys = data.getDynamicObjectCollection("cas_draftinfo");
            for (DynamicObject entry : entrys) {
                Long draftBillId = entry.getDynamicObject("draftbillinfo").getLong("id");
                LockResult lockResult = recIdAndDyMap.get(recBillId);
                if (!EmptyUtil.isNoEmpty((Object)lockResult)) continue;
                Map<Long, Long> billIdLogIdMap = lockResult.getBillIdLogIdMap();
                boolean success = lockResult.isSuccess();
                Long billLogId = billIdLogIdMap.get(draftBillId);
                if (!EmptyUtil.isNoEmpty((Long)billLogId) || !success) continue;
                entry.set("draftbilllogid", (Object)String.valueOf(billLogId));
            }
        }
    }

    public static QFilter getDraftFilter(Object recBillId, List<Long> selectedDraftIds, QFilter otherFilter) {
        DynamicObject recBillData = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill", (String)"org,currency,settletype,payername");
        DynamicObject org = (DynamicObject)recBillData.get("org");
        DynamicObject currency = (DynamicObject)recBillData.get("currency");
        Object settleType = recBillData.get("settletype");
        String payername = recBillData.getString("payername");
        QFilter billHandleFilter = new QFilter(String.join((CharSequence)".", "company", "id"), "=", (Object)org.getLong("id"));
        billHandleFilter.and(new QFilter("delivername", "=", (Object)payername));
        String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
        String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"noticeclaimallowstatus");
        List<String> allowStatusList = Arrays.asList(noticeClaimAllowStatus.split(","));
        ArrayList<String> draftBillStatusList = new ArrayList<String>();
        for (String allowStatus : allowStatusList) {
            if (EmptyUtil.isEmpty((String)allowStatus)) continue;
            draftBillStatusList.add(allowStatus);
        }
        billHandleFilter.and(new QFilter("draftbillstatus", "in", draftBillStatusList));
        billHandleFilter.and(new QFilter("source", "!=", (Object)"cas"));
        billHandleFilter.and(new QFilter("rptype", "=", (Object)"receivebill"));
        billHandleFilter.and(new QFilter("isendorsepay", "=", (Object)"0"));
        billHandleFilter.and(new QFilter("currency", "=", currency.getPkValue()));
        billHandleFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        billHandleFilter.and(new QFilter("availableamount", ">", (Object)0));
        if (settleType != null) {
            DynamicObject settleTypeObj = (DynamicObject)settleType;
            List billTypeIdList = DraftHelper.getBillTypeIdList((Object)settleTypeObj.getPkValue(), (String)settleTypeObj.getString("settlementtype"));
            billHandleFilter.and(new QFilter("draftbilltype.id", "in", (Object)billTypeIdList));
        }
        if (otherFilter != null) {
            billHandleFilter.and(otherFilter);
        }
        DynamicObject[] billHandleDataArr = BusinessDataServiceHelper.load((String)"cdm_receivablebill", (String)"id,claimnoticebillno,releatedcasbillentrys,releatedcasbillentrys.rel_billtype,availableamount,amount", (QFilter[])new QFilter[]{billHandleFilter});
        List billIdList = Arrays.stream(billHandleDataArr).filter(i -> !RecBillHepler.existsRecBill(i.getLong("id"))).filter(x -> EmptyUtil.isEmpty((String)x.getString("claimnoticebillno"))).filter(o -> o.getBigDecimal("availableamount").compareTo(o.getBigDecimal("amount")) == 0).map(i -> i.get("id")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", billIdList);
        if (selectedDraftIds != null && selectedDraftIds.size() > 0) {
            qFilter.or(new QFilter("id", "in", selectedDraftIds));
        }
        return qFilter;
    }

    public static boolean needFillDraft(DynamicObject recBillData) {
        Object settlementType = recBillData.get(String.join((CharSequence)".", "settletype", "settlementtype"));
        DynamicObjectCollection draftBillColl = recBillData.getDynamicObjectCollection("draftbill");
        String settletnumber = recBillData.getString("settletnumber");
        if (("1".equals(settlementType) || "2".equals(settlementType) || "5".equals(settlementType) || "6".equals(settlementType)) && draftBillColl.size() == 0 && StringUtils.isNotBlank((CharSequence)settletnumber)) {
            String type = "";
            switch (settlementType.toString()) {
                case "5": 
                case "6": {
                    type = "isdraft";
                    break;
                }
                case "1": {
                    type = "ischeck";
                    break;
                }
                case "2": {
                    type = "ispromissorynote";
                }
            }
            boolean isParamOpen = SystemParameterHelper.getCdmParameterBoolean((long)recBillData.getDynamicObject("org").getLong("id"), (String)type);
            return isParamOpen;
        }
        return false;
    }
}

