/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.fi.cas.business.journal.AbstractBankJournalDownload;
import kd.fi.cas.business.journal.buffer.BankJournalBuffer;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.pojo.BankJournalDownload;
import kd.fi.cas.pojo.BankJournalParameter;

public class BankJournalDownSegService
extends AbstractBankJournalDownload {
    private volatile Boolean isSyncRunning = false;
    private volatile Boolean isChangeBuffer = false;
    private BankJournalBuffer bankJournalBuffer = new BankJournalBuffer();

    public static BankJournalDownSegService getInstance() {
        return Singleton.instance;
    }

    @Override
    public void doDownloadData(BankJournalParameter bankJournalParameter) throws Exception {
        DataSet dataSet = bankJournalParameter.getDataSet();
        for (Row data : dataSet) {
            this.segLockDealData(bankJournalParameter, data);
        }
        this.flushToDatabase(bankJournalParameter.getResultIds());
    }

    @Override
    public void saveWriteBack(DynamicObject[] bankJournals, List<Object> resultIds) throws Exception {
        super.saveAndWriteBack(bankJournals, resultIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void segLockDealData(BankJournalParameter bankJournalParameter, Row data) throws Exception {
        MainEntityType entityType = bankJournalParameter.getEntityType();
        BankJournalDownload bjd = bankJournalParameter.getBjd();
        String batchNoTime = bankJournalParameter.getBatchNoTime();
        List resultIds = bankJournalParameter.getResultIds();
        BankJournalDownSegService bankJournalDownSegService = this;
        synchronized (bankJournalDownSegService) {
            this.waiteFlushToDatabase();
            Map casInitMap = SystemStatusCtrolHelper.getSystemStatusCtrol(new HashSet(bjd.getOrgIds()));
            DynamicObject bankStatement = super.convert2BankJournal(data, entityType, casInitMap, bjd.getBeginDate(), batchNoTime);
            this.bankJournalBuffer.write(bankStatement);
            if (!this.bankJournalBuffer.isSynToDatabase().booleanValue()) {
                return;
            }
            this.isChangeBuffer = true;
        }
        this.flushToDatabase(resultIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushToDatabase(List<Object> resultIds) throws Exception {
        BankJournalDownSegService bankJournalDownSegService = this;
        synchronized (bankJournalDownSegService) {
            while (this.isSyncRunning.booleanValue()) {
                this.wait(200L);
            }
            this.bankJournalBuffer.currentToSyncBuffer();
            this.isChangeBuffer = false;
            this.notifyAll();
            this.isSyncRunning = true;
        }
        this.bankJournalBuffer.flushToDatabase(resultIds, this);
        bankJournalDownSegService = this;
        synchronized (bankJournalDownSegService) {
            this.isSyncRunning = false;
            this.notifyAll();
        }
    }

    private synchronized void waiteFlushToDatabase() throws Exception {
        while (this.isChangeBuffer.booleanValue()) {
            this.wait(1000L);
        }
    }

    static class Singleton {
        private static BankJournalDownSegService instance = new BankJournalDownSegService();

        Singleton() {
        }
    }
}

