/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.journal.BankJournalDownFactory;
import kd.fi.cas.exception.BankJournalDownIException;
import kd.fi.cas.helper.MutexServiceHelper;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.pojo.BankJournalDownload;
import kd.fi.cas.pojo.BankJournalParameter;
import kd.fi.cas.util.DateUtils;

public class BankJournalDownloadService {
    private static final Log logger = LogFactory.getLog(BankJournalDownloadService.class);
    private static int INIT_CAPACITY = 1000;

    public static BankJournalDownloadService getInstance() {
        return Singleton.instance;
    }

    public List<Object> download(BankJournalDownload bjd) throws Exception {
        List orgIds = bjd.getOrgIds();
        int orgIdsSize = orgIds.size();
        ArrayList<Object> idList = new ArrayList<Object>(orgIdsSize);
        ArrayList<Long> eligibleOrgIds = new ArrayList<Long>(INIT_CAPACITY);
        logger.info(String.format("BankJournalDownloadService::Receive the request parameters: size of orgIds:%s, size of accIds:%s, begin date:%s, end data:%s", orgIdsSize, bjd.getAcctIds().size(), bjd.getBeginDate(), bjd.getEndDate()));
        for (Long orgId : orgIds) {
            Boolean isTradeMixHand = SystemParameterHelper.isTradeMixHandJournal((long)orgId);
            if (!isTradeMixHand.booleanValue()) continue;
            eligibleOrgIds.add(orgId);
        }
        if (CollectionUtils.isEmpty(eligibleOrgIds)) {
            logger.info("BankJournalDownloadService::There is no legal organization's id!!!");
            BankJournalDownIException bankJournalDownIException = new BankJournalDownIException();
            bankJournalDownIException.setErrorCode("ILLEGAL-001");
            bankJournalDownIException.setDescription(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u6ca1\u6709\u4e0b\u8f7d\u94f6\u884c\u65e5\u8bb0\u8d26\u6743\u9650\u3002", (String)"BankJournalDownloadService_0", (String)"fi-cas-business", (Object[])new Object[0]));
            idList.add(bankJournalDownIException);
            return idList;
        }
        logger.info(String.format("BankJournalDownloadService::After filtering the illegal organization's ids which size is:%s", eligibleOrgIds.size()));
        bjd.getOrgIds().clear();
        bjd.setOrgIds(eligibleOrgIds);
        List orgIdList = bjd.getOrgIds().stream().map(String::valueOf).collect(Collectors.toList());
        ArrayList<String> reqSuccessIds = new ArrayList<String>(INIT_CAPACITY);
        ArrayList<String> reqFailIds = new ArrayList<String>(INIT_CAPACITY);
        Map request = MutexServiceHelper.batchRequest(orgIdList, (String)"fi-cas-business", (String)"downbankjournal_mutex");
        try {
            for (Map.Entry entry : request.entrySet()) {
                String key = (String)entry.getKey();
                if (Boolean.TRUE.equals(entry.getValue())) {
                    reqSuccessIds.add(key);
                    continue;
                }
                reqFailIds.add(key);
            }
            logger.info("BankJournalDownloadService::These ids of organization have been locked successfully :{}", reqSuccessIds);
            logger.info("BankJournalDownloadService::These ids of organization have been locked unsuccessfully:{}", reqFailIds);
            List lockSuccessOrgIds = reqSuccessIds.stream().filter(StringUtils::isNotBlank).map(Long::valueOf).collect(Collectors.toList());
            bjd.setLockSuccessOrgIds(lockSuccessOrgIds);
            if (CollectionUtils.isEmpty(lockSuccessOrgIds)) {
                logger.info("BankJournalDownloadService:: There is no organization that had been locked!");
                ArrayList<Object> arrayList = idList;
                return arrayList;
            }
            QFilter[] qFilterArray = this.getTransDetailFilters(bjd);
            String queryParameters = "id,billno,company,company.name,accountbank.bankaccountnumber,currency.name,accountbank,currency,bizdate,description,debitamount,datasource,creditamount,transbalance,oppunit,oppbanknumber,oppbank,biztype,bankcheckflag,detailid,sortno,bizrefno,businessbillnum,biztime";
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bei_transdetail", (String)queryParameters, (QFilter[])qFilterArray, (String)"company.name,accountbank.bankaccountnumber,currency.name,biztime,sortno asc");
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal");
            String batchNoTime = DateUtils.formatString((Date)new Date(), (String)"yyyyMMddhhmmss");
            BankJournalParameter bjp = new BankJournalParameter().setBjd(bjd).setBatchNoTime(batchNoTime).setDataSet(dataSet).setEntityType(entityType).setResultIds(idList);
            BankJournalDownFactory.getInstance().getBean(false).doDownloadData(bjp);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            MutexServiceHelper.batchRelease(reqSuccessIds, (String)"fi-cas-business", (String)"downbankjournal_mutex");
            logger.info("BankJournalDownloadService::Finally, release all locked objects!");
        }
        return idList;
    }

    private QFilter[] getTransDetailFilters(BankJournalDownload bjd) {
        QFilter downloadStatusFilter = new QFilter("isdownbankjournal", "=", (Object)"0");
        QFilter orgFilter = new QFilter("company", "in", (Object)bjd.getLockSuccessOrgIds());
        QFilter acctFilter = null;
        if (!bjd.getAcctIds().isEmpty()) {
            acctFilter = new QFilter("accountbank", "in", (Object)bjd.getAcctIds());
        }
        QFilter beginBizDateFilter = null;
        if (bjd.getBeginDate() != null) {
            beginBizDateFilter = new QFilter("bizdate", ">=", (Object)bjd.getBeginDate());
        }
        QFilter endBizDateFilter = null;
        if (bjd.getEndDate() != null) {
            endBizDateFilter = new QFilter("bizdate", "<=", (Object)bjd.getEndDate());
        }
        return new QFilter[]{orgFilter, downloadStatusFilter, acctFilter, beginBizDateFilter, endBizDateFilter};
    }

    static class Singleton {
        private static BankJournalDownloadService instance = new BankJournalDownloadService();

        Singleton() {
        }
    }
}

