/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.business.journal.AbstractBookJournalBuilder;
import kd.fi.cas.business.journal.JournalEntryInfo;
import kd.fi.cas.business.journal.JournalInfo;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.DynamicObjectHelper;

public class ExchangeBillBookJournalBuilder
extends AbstractBookJournalBuilder {
    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObject exchangeBill) {
        ArrayList<JournalInfo> journalInfoList = new ArrayList<JournalInfo>();
        JournalInfo sellingInfo = this.bookSellingJournal(exchangeBill);
        journalInfoList.add(sellingInfo);
        JournalInfo buyingInfo = this.bookBuyingJournal(exchangeBill);
        journalInfoList.add(buyingInfo);
        if (exchangeBill.getBigDecimal("commissionlocalamount").compareTo(BigDecimal.ZERO) > 0) {
            JournalInfo commissionInfo = this.bookCommissionJournal(exchangeBill);
            journalInfoList.add(commissionInfo);
        }
        return journalInfoList;
    }

    private JournalInfo bookSellingJournal(DynamicObject exchangeBill) {
        boolean isBankAccount = "bd_accountbanks".equals(exchangeBill.getString("accounttype"));
        DynamicObject account = exchangeBill.getDynamicObject("sellingaccount");
        DynamicObject bankAccount = isBankAccount ? AccountBankHelper.getAccountBankById((long)account.getLong("id")) : null;
        DynamicObject cashAccount = isBankAccount ? null : account;
        JournalInfo journalSellingInfo = this.createBaseJournal(exchangeBill);
        journalSellingInfo.setCurrency(exchangeBill.getDynamicObject("sellingcurrency"));
        journalSellingInfo.setAccountBank(bankAccount);
        journalSellingInfo.setAccountCash(cashAccount);
        journalSellingInfo.setExchangeRate(exchangeBill.getBigDecimal("sellingexchangerate"));
        journalSellingInfo.setLocalAmount(exchangeBill.getBigDecimal("sellinglocalamount"));
        journalSellingInfo.setDebitAmount(BigDecimal.ZERO);
        journalSellingInfo.setCreditAmount(exchangeBill.getBigDecimal("sellamount"));
        journalSellingInfo.setDirection(2);
        journalSellingInfo.setTraceDate(exchangeBill.getDate("acttradedate"));
        journalSellingInfo.setBankCheckFlag(exchangeBill.getString("sellingbankcheckflag"));
        return journalSellingInfo;
    }

    private JournalInfo bookBuyingJournal(DynamicObject exchangeBill) {
        boolean isBankAccount = "bd_accountbanks".equals(exchangeBill.getString("accounttype"));
        DynamicObject account = exchangeBill.getDynamicObject("buyingaccount");
        DynamicObject bankAccount = isBankAccount ? AccountBankHelper.getAccountBankById((long)account.getLong("id")) : null;
        DynamicObject cashAccount = isBankAccount ? null : account;
        JournalInfo journalBuyingInfo = this.createBaseJournal(exchangeBill);
        journalBuyingInfo.setCurrency(exchangeBill.getDynamicObject("buyingcurrency"));
        journalBuyingInfo.setAccountBank(bankAccount);
        journalBuyingInfo.setAccountCash(cashAccount);
        journalBuyingInfo.setExchangeRate(exchangeBill.getBigDecimal("buyingexchangerate"));
        journalBuyingInfo.setLocalAmount(exchangeBill.getBigDecimal("buyinglocalamount"));
        journalBuyingInfo.setDebitAmount(exchangeBill.getBigDecimal("buyamount"));
        journalBuyingInfo.setCreditAmount(BigDecimal.ZERO);
        journalBuyingInfo.setDirection(1);
        journalBuyingInfo.setTraceDate(exchangeBill.getDate("acttradedate"));
        journalBuyingInfo.setBankCheckFlag(exchangeBill.getString("buybankcheckflag"));
        return journalBuyingInfo;
    }

    private JournalInfo bookCommissionJournal(DynamicObject exchangeBill) {
        boolean isBankAccount = "bd_accountbanks".equals(exchangeBill.getString("accounttype"));
        DynamicObject account = exchangeBill.getDynamicObject("paycommissionaccount");
        DynamicObject bankAccount = isBankAccount ? AccountBankHelper.getAccountBankById((long)account.getLong("id")) : null;
        DynamicObject cashAccount = isBankAccount ? null : account;
        JournalInfo journalBuyingInfo = this.createBaseJournal(exchangeBill);
        journalBuyingInfo.setCurrency(exchangeBill.getDynamicObject("commissioncurrency"));
        journalBuyingInfo.setAccountBank(bankAccount);
        journalBuyingInfo.setAccountCash(cashAccount);
        journalBuyingInfo.setExchangeRate(exchangeBill.getBigDecimal("commissionexchangerate"));
        journalBuyingInfo.setLocalAmount(exchangeBill.getBigDecimal("commissionlocalamount"));
        journalBuyingInfo.setCreditAmount(exchangeBill.getBigDecimal("commissionamount"));
        journalBuyingInfo.setDebitAmount(BigDecimal.ZERO);
        journalBuyingInfo.setDirection(2);
        journalBuyingInfo.setTraceDate(exchangeBill.getDate("acttradedate"));
        journalBuyingInfo.setBankCheckFlag(exchangeBill.getString("feebankcheckflag"));
        return journalBuyingInfo;
    }

    private JournalInfo createBaseJournal(DynamicObject exchangeBill) {
        JournalInfo journalBaseInfo = new JournalInfo();
        journalBaseInfo.setSource(2);
        journalBaseInfo.setSourceBillId(exchangeBill.getLong("id"));
        journalBaseInfo.setSourceBillNumber(exchangeBill.getString("billno"));
        journalBaseInfo.setBillno(exchangeBill.getString("billno"));
        journalBaseInfo.setSourceBillType(exchangeBill.getDataEntityType().getName());
        journalBaseInfo.setBizDate(exchangeBill.getDate("bizdate"));
        journalBaseInfo.setOrg(exchangeBill.getDynamicObject("org"));
        journalBaseInfo.setDescription(exchangeBill.getString("remark"));
        journalBaseInfo.setCashier(DynamicObjectHelper.wapDynamic((String)"bos_user", (Object)Long.valueOf(RequestContext.get().getUserId())));
        journalBaseInfo.setPreparationdate(exchangeBill.getDate("createtime"));
        journalBaseInfo.setEntry(new ArrayList<JournalEntryInfo>());
        return journalBaseInfo;
    }

    @Override
    public List<JournalInfo> getJournalInfoList(DynamicObjectCollection exchangeBillColl) {
        return null;
    }

    @Override
    public Map<Long, List<JournalInfo>> getJournalInfoLists(DynamicObjectCollection billColl, Map<Long, Exception> errorResult) {
        return new HashMap<Long, List<JournalInfo>>();
    }
}

