/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal.book.jourrnalbook.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.fi.cas.business.journal.book.jourrnalbook.check.bill.BookCheckFactory;
import kd.fi.cas.pojo.book.BookCheckResult;
import kd.fi.cas.pojo.book.BookInfo;
import kd.fi.cas.util.StringUtils;

public class BookPluginValidator
extends AbstractValidator {
    private List<BookInfo> okBookInfos;

    public List<BookInfo> getOkBookInfos() {
        return this.okBookInfos;
    }

    public void validate() {
        List<DynamicObject> bizBills = Arrays.stream(this.dataEntities).map(d -> d.getDataEntity()).collect(Collectors.toList());
        if (bizBills.size() > 0) {
            ArrayList<BookCheckResult> results = new ArrayList<BookCheckResult>();
            this.okBookInfos = BookCheckFactory.getBookCheckService(this.entityKey).doValidateBook(bizBills, results);
            Map<Long, String> resultMaps = results.stream().collect(Collectors.toMap(o -> o.getBizId(), o -> o.getInfo()));
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                String info = resultMaps.get(bill.getLong("id"));
                if (StringUtils.isEmpty((String)info)) continue;
                this.addMessage(dataEntity, info, ErrorLevel.Error);
            }
        }
    }
}

