/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.journal.book.jourrnalbook.check.bill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.cas.business.journal.AgentPayBookJournalBuilder;
import kd.fi.cas.business.journal.book.jourrnalbook.check.bill.AbstractBookCheck;
import kd.fi.cas.business.opservice.helper.AgentPayServiceHelper;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.pojo.book.BookCheckResult;
import kd.fi.cas.pojo.book.BookInfo;

public class BookCheckAgentBill
extends AbstractBookCheck {
    public static BookCheckAgentBill getInstance() {
        return Singleton.instance;
    }

    @Override
    public List<DynamicObject> checkNeedBook(List<DynamicObject> bizBills, List<BookCheckResult> results_out) {
        if (bizBills == null || bizBills.size() == 0) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList<DynamicObject> returns = new ArrayList<DynamicObject>(bizBills.size());
        for (DynamicObject bizBill : bizBills) {
            if (!AgentPayServiceHelper.isNeedBookJournal(bizBill)) continue;
            returns.add(bizBill);
        }
        return returns;
    }

    @Override
    public List<BookInfo> getBookInfos(List<DynamicObject> bizBills, Map<Long, Exception> results_out) {
        if (bizBills == null || bizBills.size() == 0) {
            return new ArrayList<BookInfo>();
        }
        DynamicObjectCollection bizBillsCols = new DynamicObjectCollection();
        bizBillsCols.addAll(bizBills);
        return this.map2List(new AgentPayBookJournalBuilder().getJournalList(bizBillsCols, results_out));
    }

    @Override
    protected List<BookInfo> check(List<BookInfo> bookInfos, List<BookCheckResult> results_out) {
        results_out.addAll(AccountBankHelper.checkBalanceAdjust(bookInfos, (boolean)true));
        return bookInfos;
    }

    static class Singleton {
        private static BookCheckAgentBill instance = new BookCheckAgentBill();

        Singleton() {
        }
    }
}

