/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice;

import java.sql.ResultSet;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.cas.business.opservice.IBankVCCheckService;
import kd.fi.cas.business.pojo.BankVCCheckInfo;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.StringUtils;

public abstract class AbstractBankVCCheckService
implements IBankVCCheckService {
    private static final Log logger = LogFactory.getLog(AbstractBankVCCheckService.class);
    protected Date checkDate = new Date();
    protected int onceCount;
    protected long orgId;
    protected long accountBankId;
    protected long currencyId;
    protected Date beginDate;
    protected Date endDate;
    protected String checkType;
    protected DynamicObject checkScheme;

    @Override
    public void doCheck(BankVCCheckInfo checkInfo) {
        this.orgId = checkInfo.getOrgId();
        this.accountBankId = checkInfo.getAccountBankId();
        this.currencyId = checkInfo.getCurrencyId();
        this.beginDate = checkInfo.getBeginDate();
        this.endDate = checkInfo.getEndDate();
        this.checkType = checkInfo.getCheckType();
        this.checkScheme = checkInfo.getCheckScheme();
        this.onceCount = checkInfo.getOnceCount();
    }

    protected int getTotalCount(String checkCondition) {
        String sql = "select count(*) as count from t_cas_bankstatement where forgid=? and faccountbankid=? and fcurrencyid=? and fischeck='0'";
        if (this.beginDate != null && this.endDate != null) {
            sql = sql + " and FbizDate>={ts'" + DateUtils.formatString((Date)this.beginDate, (String)"yyyy-MM-dd HH:mm:ss") + "'} AND FbizDate<={ts'" + DateUtils.formatString((Date)this.endDate, (String)"yyyy-MM-dd HH:mm:ss") + "'}";
        }
        if (checkCondition != null) {
            sql = sql + " and f" + checkCondition + "<>''";
        }
        int totalCount = (Integer)DB.query((DBRoute)DBRouteConst.cas, (String)sql, (Object[])new Object[]{this.orgId, this.accountBankId, this.currencyId}, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt("count");
                }
                return count;
            }
        });
        return totalCount;
    }

    protected QFilter getBaseFilter() {
        QFilter filter = new QFilter("org", "=", (Object)this.orgId);
        filter = filter.and("accountbank", "=", (Object)this.accountBankId);
        filter = filter.and("currency", "=", (Object)this.currencyId);
        if (this.beginDate != null) {
            filter = filter.and("bizdate", ">=", (Object)this.beginDate);
        }
        if (this.endDate != null) {
            filter = filter.and("bizdate", "<=", (Object)this.endDate);
        }
        filter = filter.and(new QFilter("ischeck", "=", (Object)"0"));
        return filter;
    }

    protected void updateTable(List<Object[]> paramsList, List<Object[]> entryParamsList, Set<Long> stateIdset, Set<Long> journalIdset) {
        if (paramsList != null && paramsList.size() > 0) {
            String sql = "insert into t_cas_checkedresult(fid,faccountbankid,fcurrencyid,fchecktype,fcompanyid,fstateAmount,fjournalAmount,fstateDirection,fjournalDirection,fcheckdate) values (?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)sql, paramsList);
            String entrySql = "insert into t_cas_checkedresultentry(fid,fentryid,fbizobject,fbizobjectid,fcreditamount,fdebitamount,fbizdate,forgid,foppunit,fdescription,fbankcheckflagtag,fbankcheckflagtag_tag) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRouteConst.cas, (String)entrySql, entryParamsList);
            String stateSql = "update t_cas_bankstatement set fischeck=1 where fid in " + StringUtils.setToString(stateIdset);
            DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankstatement").getDBRouteKey()), (String)stateSql, (Object[])new Object[0]);
            String journalSql = "update t_cas_bankjournal set fischeck=1 where fid in " + StringUtils.setToString(journalIdset);
            DB.execute((DBRoute)new DBRoute(MetadataServiceHelper.getDataEntityType((String)"cas_bankjournal").getDBRouteKey()), (String)journalSql, (Object[])new Object[0]);
            this.updateHwActualDate(stateIdset, journalIdset);
        }
    }

    public void updateHwActualDate(Set<Long> stateIdset, Set<Long> journalIdset) {
        ThreadPools.executeOnceIncludeRequestContext((String)"updateHwActualDate", () -> {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)stateIdset)};
            DataSet bds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_bankstatement", (String)"bizdate", (QFilter[])filters, null).groupBy().max("bizdate").finish();
            if (bds.hasNext()) {
                Date actualDate = bds.next().getDate("bizdate");
                QFilter[] filter = new QFilter[]{new QFilter("id", "in", (Object)journalIdset)};
                DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"cas_bankjournal", (String)"sourcebilltype, sourcebillid", (QFilter[])filter, null);
                while (ds.hasNext()) {
                    DynamicObject bill;
                    Row row = ds.next();
                    String sourcebilltype = row.getString("sourcebilltype");
                    String sourceBillId = row.getString("sourcebillid");
                    if (StringUtils.isNotEmpty((String)sourcebilltype) && sourcebilltype.equals("cas_recbill")) {
                        bill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourcebilltype);
                        bill.set("actualrecdate_hw", (Object)actualDate);
                        bill.set("isbanksettle", (Object)"1");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                    }
                    if (StringUtils.isNotEmpty((String)sourcebilltype) && sourcebilltype.equals("cas_paybill")) {
                        bill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)sourcebilltype);
                        bill.set("actualpaydate_hw", (Object)actualDate);
                        bill.set("isbanksettle", (Object)"1");
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((String)sourcebilltype) || !sourcebilltype.equals("gl_voucher")) continue;
                    QFilter fi = new QFilter("voucherid", "=", (Object)sourceBillId);
                    QFilter fi2 = new QFilter("billtype", "=", (Object)"cas_paybill").or(new QFilter("billtype", "=", (Object)"cas_recbill"));
                    fi = fi.and(fi2);
                    DataSet vds = QueryServiceHelper.queryDataSet((String)"ai_daptracker", (String)"ai_daptracker", (String)"sourcebillid, billtype", (QFilter[])new QFilter[]{fi}, null);
                    while (vds.hasNext()) {
                        Row row2 = vds.next();
                        String bizBillId = row2.getString("sourcebillid");
                        String billtype = row2.getString("billtype");
                        DynamicObject bill2 = BusinessDataServiceHelper.loadSingle((Object)bizBillId, (String)billtype);
                        if (StringUtils.isNotEmpty((String)billtype) && billtype.equals("cas_recbill")) {
                            bill2.set("actualrecdate_hw", (Object)actualDate);
                            bill2.set("isbanksettle", (Object)"1");
                        }
                        if (StringUtils.isNotEmpty((String)billtype) && billtype.equals("cas_paybill")) {
                            bill2.set("actualpaydate_hw", (Object)actualDate);
                            bill2.set("isbanksettle", (Object)"1");
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill2});
                    }
                }
            }
        });
    }

    protected void addEntryResult(DynamicObject obj, String bizobject, long bizObjectId, List<Object[]> entryParamsList, long headId, long orgId) {
        SqlParameter[] entryParams = new SqlParameter[12];
        entryParams[0] = new SqlParameter(":fid", -5, (Object)headId);
        entryParams[1] = new SqlParameter(":fentryid", -5, (Object)DB.genLongId((String)"t_cas_checkedresultentry"));
        entryParams[2] = new SqlParameter(":fbizobject", 12, (Object)bizobject);
        entryParams[3] = new SqlParameter(":fbizobjectid", -5, (Object)bizObjectId);
        entryParams[4] = new SqlParameter(":fcreditamount", 3, (Object)obj.getBigDecimal("creditamount"));
        entryParams[5] = new SqlParameter(":fdebitamount", 3, (Object)obj.getBigDecimal("debitamount"));
        entryParams[6] = "cas_bankjournal".equals(bizobject) ? new SqlParameter(":fbizdate", 91, (Object)obj.getDate("bookdate")) : new SqlParameter(":fbizdate", 91, (Object)obj.getDate("bizdate"));
        entryParams[7] = new SqlParameter(":forgid", -5, (Object)orgId);
        entryParams[8] = new SqlParameter(":foppunit", 12, (Object)obj.getString("oppunit"));
        entryParams[9] = new SqlParameter(":fdescription", 12, (Object)obj.getString("description"));
        if ("cas_bankjournal".equals(obj.getDataEntityType().getName())) {
            entryParams[10] = new SqlParameter(":fbankcheckflagtag", 12, (Object)obj.getString("bankcheckflag"));
            if (obj.getString("bankcheckflag") == null) {
                entryParams[10] = new SqlParameter(":fbankcheckflagtag", 12, (Object)" ");
            }
            entryParams[11] = new SqlParameter(":fbankcheckflagtag_tag", 2011, (Object)obj.getString("bankcheckflag_tag"));
            if (obj.getString("bankcheckflag_tag") == null) {
                entryParams[11] = new SqlParameter(":fbankcheckflagtag_tag", 2011, (Object)" ");
            }
        } else {
            entryParams[10] = new SqlParameter(":fbankcheckflagtag", 12, (Object)obj.getString("bankcheckflag"));
            if (obj.getString("bankcheckflag") == null) {
                entryParams[10] = new SqlParameter(":fbankcheckflagtag", 12, (Object)" ");
            }
            entryParams[11] = new SqlParameter(":fbankcheckflagtag_tag", 2011, (Object)obj.getString("bankcheckflag"));
            if (obj.getString("bankcheckflag") == null) {
                entryParams[11] = new SqlParameter(":fbankcheckflagtag_tag", 2011, (Object)" ");
            }
        }
        entryParamsList.add(entryParams);
    }
}

