/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.fi.cas.business.errorcode.AgentPayErrorCode;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.factory.AgentPayBillFactory;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.PaymentChannelEnum;
import kd.fi.cas.enums.ProceedsTypeEnum;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.AccountCashHelper;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.CheckUtils;

public class AgentPayBeforeSubmitImpl
extends AbstractOpService {
    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(53);
        lst.add("billstatus");
        lst.add("org");
        lst.add("bizdate");
        lst.add("payeracctbank");
        lst.add("currency");
        lst.add("basecurrency");
        lst.add("payamount");
        lst.add("localamt");
        lst.add("exchangerate");
        lst.add("expectdealtime");
        lst.add("settletype");
        lst.add("count");
        lst.add("billtype");
        lst.add("org");
        lst.add("sourcebillnumber");
        lst.add("accountcash");
        lst.add("openorg");
        lst.add("modifier");
        lst.add("ispersonpay");
        lst.add("payeetype");
        lst.add("payeename");
        lst.add("payeeacctbank");
        lst.add("payeebankname");
        lst.add("e_amount");
        lst.add("e_encryptamount");
        lst.add("payeebanknumber");
        lst.add("e_localamt");
        lst.add("e_encryptlocalamt");
        lst.add("sourcebillid");
        lst.add("isencryption");
        lst.add("e_encryptamount");
        lst.add("e_amount");
        lst.add("paymentterm");
        lst.add("paymentfps");
        lst.add("paymentareacode");
        lst.add("informrecemail");
        lst.add("inforpayment");
        lst.add("paymentchannel");
        lst.add("isdiffcur");
        lst.add("dpcurrency");
        lst.add("dpexchangerate");
        lst.add("dpamt");
        lst.add("dplocalamt");
        lst.add("lossamt");
        lst.add("agreedrate");
        lst.add("iscrosspay");
        lst.add("contractno");
        lst.add("crosstrantype");
        lst.add("paycountry");
        lst.add("reccountry");
        lst.add("payerbank");
        lst.add("recswiftcode");
        lst.add("paymenttype");
        lst.add("description");
        lst.add("delegorg");
        lst.add("feepayer");
        lst.add("feeactbank");
        lst.add("feecurrency");
        lst.add("mobile");
        lst.add("recemail");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        AgentPayBillHelper.decodeAmount((DynamicObject)info);
        if (!info.getString("billstatus").equals(BillStatusEnum.SAVE.getValue())) {
            throw new KDBizException(new AgentPayErrorCode().STATUS_CANNOT_SUBMIT(), new Object[0]);
        }
        DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
        if (entry.isEmpty()) {
            throw new KDBizException(new ErrorCode("ENTRY_CANNOT_EMPTY", ResManager.loadKDString((String)"\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_0", (String)"fi-cas-business", (Object[])new Object[0])), new Object[0]);
        }
        List<String> selector = this.getSelector();
        if (info.get("delegorg") != null) {
            DynamicObject org = info.getDynamicObject("org");
            if (org != null && info.getDynamicObject("delegorg").getPkValue().equals(org.getPkValue())) {
                info.set("delegorg", null);
            } else {
                if (info.getDynamicObject("settletype") != null || info.getDynamicObject("payeracctbank") != null || info.getDynamicObject("accountcash") != null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u59d4\u6258\u5176\u4ed6\u516c\u53f8\u4ed8\u6b3e\uff0c\u4e0d\u9700\u8981\u4ed8\u6b3e\u8d26\u6237\u53ca\u7ed3\u7b97\u65b9\u5f0f\u3002", (String)"AgentPaySubmitImpl_7", (String)"fi-cas-business", (Object[])new Object[0]));
                }
                selector.remove("payeracctbank");
                selector.remove("accountcash");
            }
        } else if (BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
            selector.remove("payeracctbank");
            CheckUtils.setPropMustInput((DynamicObject)info, (boolean)true, (String[])new String[]{"accountcash"});
            if (!DynamicObjectHelper.isEmpty((DynamicObject)info, (String)"payeracctbank")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u662f\u73b0\u91d1\uff0c\u94f6\u884c\u8d26\u6237\u5e94\u8be5\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        } else {
            selector.remove("accountcash");
            CheckUtils.setPropMustInput((DynamicObject)info, (boolean)true, (String[])new String[]{"payeracctbank"});
            if (!DynamicObjectHelper.isEmpty((DynamicObject)info, (String)"accountcash")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u7c7b\u578b\u975e\u73b0\u91d1\uff0c\u73b0\u91d1\u8d26\u6237\u5e94\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_2", (String)"fi-cas-business", (Object[])new Object[0]));
            }
        }
        if (info.getBoolean("isencryption")) {
            selector.remove("e_localamt");
        }
        String checkEmpty = CheckUtils.checkEmpty((DynamicObject)info, selector);
        if (info.get("delegorg") == null && CasHelper.isEmpty((Object)info.getString("settletype"))) {
            checkEmpty = checkEmpty.concat(ResManager.loadKDString((String)"\u7ed3\u7b97\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_8", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (checkEmpty.length() > 0) {
            throw new KDBizException(new ErrorCode("FIELDS_MUSTINPUT", checkEmpty), new Object[0]);
        }
        this.checkBeiPaymentChannel(info);
        for (int i = 0; i < entry.size(); ++i) {
            BigDecimal amount = ((DynamicObject)entry.get(i)).getBigDecimal("e_amount");
            if (BigDecimal.ZERO.compareTo(amount) <= 0) continue;
            throw new KDBizException(new ErrorCode("NEGATIVE_AMOUNT", ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u91d1\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"AgentPaySubmitImpl_3", (String)"fi-cas-business", (Object[])new Object[0])), new Object[]{i + 1});
        }
        if (info.getBigDecimal("exchangerate").doubleValue() <= 0.0) {
            throw new KDBizException(new AgentPayErrorCode().EXCHANGERATE_MUST_MORETHRANZERO(), new Object[0]);
        }
        Collection supportedCurrencys = null;
        DynamicObject accountCash = info.getDynamicObject("accountcash");
        DynamicObject payerAcctBank = info.getDynamicObject("payeracctbank");
        if (payerAcctBank != null) {
            supportedCurrencys = AccountBankHelper.getCurrencyPks((long)((Long)payerAcctBank.getPkValue()));
        } else if (accountCash != null) {
            supportedCurrencys = AccountCashHelper.getCurrencyListByCashAcct((long)((Long)accountCash.getPkValue()));
        }
        Long payCurId = info.getLong("currency.id");
        if (info.getBoolean("isdiffcur")) {
            payCurId = info.getLong("dpcurrency.id");
        }
        if (supportedCurrencys != null && !supportedCurrencys.contains(payCurId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8d26\u6237\u4e0d\u652f\u6301\u5f53\u524d\u5e01\u79cd\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AgentPaySubmitImpl_4", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        AgentPayBillFactory.getSaveService().validate(info);
        CheckUtils.checkBizTypeEmpty((DynamicObject)info);
        if (info.getBoolean("isencryption")) {
            CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_encryptamount");
        } else {
            CheckUtils.checkAmtEqualEAmt((DynamicObject)info, (String)"payamount", (String)"e_amount");
        }
    }

    private void checkBeiPaymentChannel(DynamicObject info) {
        DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
        boolean isCrossPay = info.getBoolean("iscrosspay");
        DynamicObject crossTranType = info.getDynamicObject("crosstrantype");
        if (isCrossPay && crossTranType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8de8\u5883\u652f\u4ed8\u65f6\uff0c\u4ea4\u6613\u7c7b\u578b\u5fc5\u586b\u3002", (String)"AgentPaySubmitImpl_14", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        for (int i = 0; i < entry.size(); ++i) {
            if (!PaymentChannelEnum.BEI.getValue().equals(info.getString("paymentchannel"))) continue;
            if (!isCrossPay || isCrossPay && !crossTranType.getString("number").equals("BOCHK05")) {
                if (StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeeacctbank")) && !BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                }
                if (!StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeebankname")) || BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_6", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
            }
            if (!crossTranType.getString("number").equals("BOCHK05")) continue;
            String term = ((DynamicObject)entry.get(i)).getString("paymentterm");
            if (ProceedsTypeEnum.ZERO.getValue().equals(term)) {
                if (StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeeacctbank")) && !BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_5", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                }
                if (StringUtils.isBlank((CharSequence)((DynamicObject)entry.get(i)).getString("payeebankname")) && !BaseDataHelper.isSettleTypeCash((DynamicObject)info.getDynamicObject("settletype"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u94f6\u4f01\u4e92\u8054\u6536\u6b3e\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_6", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                }
            } else {
                if (ProceedsTypeEnum.ONE.getValue().equals(term) && CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("paymentfps"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4ebaFPS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_9", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                }
                if (ProceedsTypeEnum.TWO.getValue().equals(term)) {
                    if (CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("mobile"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4eba\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_11", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    }
                    if (CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("paymentareacode"))) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u4eba\u5730\u533a\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_10", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                    }
                } else if (ProceedsTypeEnum.three.getValue().equals(term) && CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("recemail"))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6536\u6b3e\u65b9\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AgentPaySubmitImpl_12", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
                }
            }
            if (!((DynamicObject)entry.get(i)).getBoolean("inforpayment") || !CasHelper.isEmpty((Object)((DynamicObject)entry.get(i)).getString("informrecemail"))) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u8bf7\u586b\u5199\u901a\u77e5\u6536\u6b3e\u4eba\u90ae\u7bb1\uff1b\u5982\u4e0d\u9700\u901a\u77e5\u6536\u6b3e\u4eba\uff0c\u8bf7\u5173\u95ed\u901a\u77e5\u6536\u6b3e\u4eba\u6309\u94ae\u3002", (String)"AgentPaySubmitImpl_13", (String)"fi-cas-business", (Object[])new Object[0]), i + 1));
        }
    }
}

