/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.impl.BillPropertyValueHandle;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.BaseDataHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.DynamicObjectHelper;
import kd.fi.cas.util.CheckUtils;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.StringUtils;

public class AgentPaySaveImpl
extends AbstractOpService {
    @Override
    public List<String> getSelector() {
        ArrayList<String> selectors = new ArrayList<String>(22);
        selectors.add("billstatus");
        selectors.add("e_amount");
        selectors.add("e_encryptamount");
        selectors.add("e_localamt");
        selectors.add("e_encryptlocalamt");
        selectors.add("count");
        selectors.add("billtype");
        selectors.add("sourcebillnumber");
        selectors.add("org");
        selectors.add("delegorg");
        selectors.add("ispersonpay");
        selectors.add("payeetype");
        selectors.add("payeeacctbank");
        selectors.add("billno");
        selectors.add("payeename");
        selectors.add("payee");
        selectors.add("settletype");
        selectors.add("payeracctbank");
        selectors.add("payquotation");
        selectors.add("dppayquotation");
        selectors.add("agreedquotation");
        selectors.add("basecurrency");
        selectors.add("e_dpamt");
        selectors.add("e_dplocalamt");
        selectors.add("matchflag");
        selectors.add("matchamount");
        selectors.add("unmatchamount");
        selectors.add("entrymatchamount");
        selectors.add("entryunmatchamount");
        selectors.add("entrymatchflag");
        selectors.add("sourcebilltype");
        selectors.add("entry.e_encryptamount");
        selectors.add("entry.e_refundamt");
        selectors.add("entry.e_remainrefundamt");
        selectors.add("totalrefundedamt");
        selectors.add("totalremainrefundamt");
        selectors.add("localrefundedamt");
        selectors.add("localremainrefundamt");
        selectors.add("payquotation");
        selectors.add("exchangerate");
        selectors.add("payeebank");
        selectors.add("recprovince");
        selectors.add("reccity");
        selectors.add("iscrosspay");
        selectors.add("entry.seq");
        return selectors;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        AgentPayBillHelper.decodeAmount((DynamicObject)info);
        DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)info, (String)"description");
        DynamicObject org = info.getDynamicObject("org");
        DynamicObject delegOrg = info.getDynamicObject("delegorg");
        if (org != null && delegOrg != null && delegOrg.getPkValue().equals(org.getPkValue())) {
            info.set("delegorg", null);
        }
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        String sourcebillnumber;
        DynamicObject dyBilltype;
        Object coll;
        List value;
        super.process(info);
        String billStatus = info.getString("billstatus");
        boolean isDiffCur = info.getBoolean("isdiffcur");
        BigDecimal payAmount = info.getBigDecimal("dpamt");
        BigDecimal fee = info.getBigDecimal("fee");
        BigDecimal matchAmount = info.getBigDecimal("matchamount");
        if ("D".equalsIgnoreCase(billStatus)) {
            if (isDiffCur) {
                info.set("unmatchamount", (Object)payAmount.add(fee).subtract(matchAmount));
            } else {
                BigDecimal actPayAmount = info.getBigDecimal("actpayamount");
                info.set("unmatchamount", (Object)actPayAmount.subtract(matchAmount));
            }
        } else {
            info.set("unmatchamount", (Object)payAmount.subtract(matchAmount));
        }
        String matchFlag = info.getString("matchflag");
        if (EmptyUtil.isEmpty((String)matchFlag)) {
            info.set("matchflag", (Object)"0");
        }
        new BillPropertyValueHandle(info);
        boolean isencryption = Boolean.FALSE;
        String billtypeId = String.valueOf(info.getDynamicObject("billtype").getLong("id"));
        if (StringUtils.isNotEmpty((String)billtypeId) && (value = (coll = (dyBilltype = BusinessDataServiceHelper.loadSingle((Object)billtypeId, (String)"bos_billtype")).getDynamicObjectCollection("fieldcontrolentry")).stream().filter(field -> "isencryption".equals(field.get("fieldkey").toString())).map(dy -> dy.get("defaultvalue").toString()).collect(Collectors.toList())).size() == 1) {
            isencryption = value.get(0) != null && "true".equals(value.get(0));
        }
        info.set("isencryption", (Object)isencryption);
        DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
        info.set("count", (Object)entry.size());
        for (DynamicObject row : entry) {
            BigDecimal localAmount;
            BigDecimal amount = row.getBigDecimal("e_amount");
            if (BigDecimal.ZERO.compareTo(amount) != 0) {
                row.set("e_encryptamount", (Object)AgentPayBillHelper.encodeAmount((BigDecimal)amount));
                if (CasHelper.isEmpty((Object)row.getString("entrymatchflag")) || "0".equalsIgnoreCase(row.getString("entrymatchflag"))) {
                    row.set("entryunmatchamount", (Object)amount);
                    row.set("entrymatchflag", (Object)"0");
                }
            }
            if ((localAmount = row.getBigDecimal("e_localamt")).compareTo(BigDecimal.ZERO) != 0) {
                row.set("e_encryptlocalamt", (Object)AgentPayBillHelper.encodeAmount((BigDecimal)localAmount));
            }
            if (isencryption) {
                row.set("e_amount", null);
                row.set("e_localamt", null);
            }
            row.set("payeeacctbank", (Object)CheckUtils.bankNumberCheck((String)row.getString("payeeacctbank")));
            row.set("payeename", (Object)CheckUtils.removeSpaces((String)row.getString("payeename")));
            row.set("payeebankname", (Object)CheckUtils.removeSpaces((String)row.getString("payeebankname")));
            DynamicObjectHelper.subStringPropMaxLenth((DynamicObject)row, (String)"e_remark");
        }
        if (BaseDataHelper.isSettleTypeMatch((DynamicObject)info.getDynamicObject("settletype")) || info.get("delegorg") != null) {
            info.set("matchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
            for (DynamicObject row : entry) {
                row.set("entrymatchflag", (Object)AutoMatchFlagEnum.NONEED.getValue());
            }
        }
        if (StringUtils.isNotEmpty((String)(sourcebillnumber = info.getString("sourcebillnumber"))) && sourcebillnumber.length() > 255) {
            sourcebillnumber = sourcebillnumber.substring(0, 252) + "...";
            info.set("sourcebillnumber", (Object)sourcebillnumber);
        }
        DynamicObject accountBank = info.getDynamicObject("payeracctbank");
        DynamicObject accountCash = info.getDynamicObject("accountcash");
        if (accountBank != null) {
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)info, (String)"openorg", (Object)accountBank.get("openorg"));
        } else if (accountCash != null) {
            DynamicObjectHelper.setValueIfAbsent((DynamicObject)info, (String)"openorg", (Object)accountCash.get("openorg"));
        }
        DynamicObjectHelper.setValueIfAbsent((DynamicObject)info, (String)"dpcurrency", (Object)info.get("currency"));
        DynamicObjectHelper.setValueIfAbsent((DynamicObject)info, (String)"dpamt", (Object)info.get("payamount"));
        DynamicObjectHelper.setValueIfAbsent((DynamicObject)info, (String)"dpexchangerate", (Object)info.get("exchangerate"));
    }
}

