/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.journal.IBookJournalBuilder;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.journal.RecBillBookJournalbuilder;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.helper.DraftHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.MutexServiceHelper;

public class CasRecManualBookImpl
extends AbstractOpService {
    private static final Log logger = LogFactory.getLog(CasRecManualBookImpl.class);
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(60);
        lst.add("org");
        lst.add("billno");
        lst.add("id");
        lst.add("biztype");
        lst.add("bizdate");
        lst.add("billstatus");
        lst.add("txt_description");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("accountbank");
        lst.add("accountcash");
        lst.add("payeebank");
        lst.add("payer");
        lst.add("payerformid");
        lst.add("payeracctbank");
        lst.add("payeraccformid");
        lst.add("payername");
        lst.add("payeracctbanknum");
        lst.add("payerbankname");
        lst.add("f7_payerbank");
        lst.add("cashier");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("isagent");
        lst.add("isvoucher");
        lst.add("accountcash");
        lst.add("actrecamt");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("bankcheckflag");
        lst.add("bankcheckflag_tag");
        lst.add("entry");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("realreccompany");
        lst.add("e_receivableamt");
        lst.add("e_sourcebillentryid");
        lst.add("e_unsettledamt");
        lst.add("e_settledamt");
        lst.add("e_material");
        lst.add("e_expenseitem");
        lst.add("e_corebillno");
        lst.add("e_corebillentryseq");
        lst.add("e_sourcebillid");
        lst.add("e_settleorg");
        lst.add("confirmlogo");
        lst.add("sourcetype");
        lst.add("acttradedate");
        lst.add("createtime");
        lst.add("openorg");
        lst.add("e_settleorg");
        lst.add("e_dividestatus");
        lst.add("recorg");
        lst.add("e_orgsdividebatch");
        lst.add("fee");
        lst.add("inneraccount");
        lst.add("draftbill");
        lst.add("hotaccount");
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry"));
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DynamicObject[] infos) throws KDException {
        StringJoiner errorMsg = new StringJoiner(";\r\n");
        ArrayList<String> requestIds = new ArrayList<String>();
        ArrayList<String> requestFailIds = new ArrayList<String>();
        try {
            List billnos = Arrays.stream(infos).map(e -> e.get("billno").toString()).collect(Collectors.toList());
            Map lockResultMap = MutexServiceHelper.batchRequest(billnos, (String)"fi-cas-business", (String)"casRecmanualBook");
            for (Map.Entry next : lockResultMap.entrySet()) {
                String key = (String)next.getKey();
                if (((Boolean)next.getValue()).booleanValue()) {
                    requestIds.add(key);
                    continue;
                }
                requestFailIds.add(key);
            }
            if (requestFailIds.size() > 0) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ReceivErrorCode_25", (String)"fi-cas-business", (Object[])new Object[0]), JSON.toJSONString(requestFailIds)));
            }
            this.dealBook(infos, errorMsg);
        }
        catch (Exception e2) {
            logger.error("e is:", (Throwable)e2);
        }
        finally {
            MutexServiceHelper.batchRelease(requestIds, (String)"fi-cas-business", (String)"casRecmanualBook");
        }
        if (errorMsg.length() > 0) {
            throw new KDBizException(errorMsg.toString());
        }
    }

    private void dealBook(DynamicObject[] infos, StringJoiner errorMsg) {
        for (DynamicObject info : infos) {
            String billStatus = info.getString("billstatus");
            String billId = info.get("billno").toString();
            if (!"D".equalsIgnoreCase(billStatus)) {
                errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u53ea\u6709\u6536\u6b3e\u72b6\u6001\u7684\u5355\u636e\u53ef\u4ee5\u624b\u52a8\u767b\u8d26\u3002", (String)"ReceivErrorCode_29", (String)"fi-cas-business", (Object[])new Object[0]), billId));
                continue;
            }
            try {
                if (!this.isNeedBook(info, errorMsg, billId)) continue;
                logger.info(String.format("bill %s start to book", billId));
                if (this.journalServiceAdapter.hasBooked(info)) {
                    this.journalServiceAdapter.validateCancelBook(info);
                    this.journalServiceAdapter.cancelBook(info);
                }
                this.journalServiceAdapter.validateBook((IBookJournalBuilder)new RecBillBookJournalbuilder(), info);
                this.journalServiceAdapter.book(info);
                logger.info(String.format("bill %s book end", billId));
            }
            catch (Exception e) {
                logger.error("rec manualbook has exception:", (Throwable)e);
                errorMsg.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%s\u201d\u624b\u52a8\u767b\u8d26\u5931\u8d25\u3002", (String)"ReceivErrorCode_26", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            }
        }
    }

    private boolean isNeedBook(DynamicObject info, StringJoiner errorMsg, String billId) {
        boolean isVirtualRec;
        Boolean isFromCdm = this.param.getParams().containsKey("draftbillno");
        if (isFromCdm.booleanValue()) {
            errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u6536\u7968\u767b\u8bb0\u65e0\u9700\u767b\u8d26\u3002", (String)"ReceivErrorCode_21", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            return false;
        }
        boolean settlePromise = DraftHelper.isSettlePromise((Object)info.get("settletype"));
        if (settlePromise) {
            errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u5546\u4e1a\u627f\u5151\u6c47\u7968\u6216\u94f6\u884c\u627f\u5151\u6c47\u7968\u4e0d\u9700\u8981\u767b\u8d26\u3002", (String)"ReceivErrorCode_22", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            return false;
        }
        DynamicObject receivingType = info.getDynamicObject("receivingtype");
        boolean bl = isVirtualRec = receivingType != null && "107".equals(receivingType.getString("number"));
        if (isVirtualRec) {
            errorMsg.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u865a\u62df\u6536\u6b3e\u65e0\u9700\u767b\u8d26\u3002", (String)"ReceivErrorCode_23", (String)"fi-cas-business", (Object[])new Object[0]), billId));
            return false;
        }
        return true;
    }
}

