/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.opservice.AbstractBankVCCheckService;
import kd.fi.cas.business.pojo.BankVCCheckInfo;

public abstract class Many2ManyServiceImpl
extends AbstractBankVCCheckService {
    protected String checkCondition;

    @Override
    public void doCheck(BankVCCheckInfo checkInfo) {
        this.checkCondition = this.getCheckCondition();
        super.doCheck(checkInfo);
        int totalCount = this.getTotalCount(this.checkCondition);
        if (totalCount > 0) {
            if (totalCount <= this.onceCount) {
                QFilter multiFilter = this.getMultiFilter(this.checkCondition);
                this.doCheckMulti(this.checkCondition, multiFilter, multiFilter);
            } else {
                try (DataSet stateSet = QueryServiceHelper.queryDataSet((String)(this.getClass() + " checkMulti"), (String)"cas_bankstatement", (String)("id," + this.checkCondition), (QFilter[])this.getMultiFilter(this.checkCondition).toArray(), (String)this.checkCondition);){
                    QFilter journalFilter;
                    QFilter stateFilter;
                    Iterator stateRows = stateSet.iterator();
                    String tempCheckCondition = null;
                    int dataCount = 0;
                    String beginCondition = null;
                    String endCondition = null;
                    ArrayList<Long> stateIdList = new ArrayList<Long>();
                    Row stateRow = null;
                    while (stateRows.hasNext()) {
                        stateRow = (Row)stateRows.next();
                        stateIdList.add(stateRow.getLong("id"));
                        if (++dataCount == 1) {
                            beginCondition = stateRow.getString(this.checkCondition);
                        }
                        tempCheckCondition = stateRow.getString(this.checkCondition);
                        if (dataCount % this.onceCount != 0) continue;
                        endCondition = tempCheckCondition;
                        stateFilter = new QFilter("id", "in", stateIdList);
                        journalFilter = this.getMultiFilter(this.checkCondition).and(this.checkCondition, ">=", (Object)beginCondition).and(this.checkCondition, "<=", (Object)endCondition);
                        this.doCheckMulti(this.checkCondition, stateFilter, journalFilter);
                        stateIdList = new ArrayList();
                        beginCondition = endCondition;
                    }
                    if (stateIdList.size() > 0) {
                        endCondition = tempCheckCondition;
                        stateFilter = new QFilter("id", "in", stateIdList);
                        journalFilter = this.getMultiFilter(this.checkCondition).and(this.checkCondition, ">=", (Object)beginCondition).and(this.checkCondition, "<=", (Object)endCondition);
                        this.doCheckMulti(this.checkCondition, stateFilter, journalFilter);
                    }
                }
            }
        }
    }

    protected void doCheckMulti(String checkCondition, QFilter stateFilter, QFilter journalFilter) {
        String selector = "id,org,accountbank,currency,bizdate,creditamount,debitamount,oppunit,description," + checkCondition;
        if (!"bankcheckflag".equals(checkCondition)) {
            selector = selector + ",bankcheckflag";
        }
        DynamicObjectCollection stateColl = QueryServiceHelper.query((String)"cas_bankstatement", (String)selector, (QFilter[])stateFilter.toArray(), (String)checkCondition);
        DynamicObjectCollection journalColl = QueryServiceHelper.query((String)"cas_bankjournal", (String)(selector + ",bankcheckflag_tag,bookdate"), (QFilter[])journalFilter.toArray(), (String)checkCondition);
        if (stateColl.size() > 0 && journalColl.size() > 0) {
            List<Object> journalList;
            HashMap stateMap = new HashMap(stateColl.size(), 1.0f);
            int size = stateColl.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject state = (DynamicObject)stateColl.get(i);
                String key = state.getString(checkCondition);
                if (key == null) continue;
                if (!stateMap.containsKey(key)) {
                    ArrayList<DynamicObject> stateList = new ArrayList<DynamicObject>();
                    stateList.add(state);
                    stateMap.put(key, stateList);
                    continue;
                }
                ((List)stateMap.get(key)).add(state);
            }
            HashMap journalMap = new HashMap(journalColl.size(), 1.0f);
            int size2 = journalColl.size();
            for (int i = 0; i < size2; ++i) {
                DynamicObject journal = (DynamicObject)journalColl.get(i);
                String key = journal.getString(checkCondition);
                if (key == null) continue;
                if (!journalMap.containsKey(key)) {
                    journalList = new ArrayList<DynamicObject>();
                    journalList.add(journal);
                    journalMap.put(key, journalList);
                    continue;
                }
                ((List)journalMap.get(key)).add(journal);
            }
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            ArrayList<Object[]> entryParamsList = new ArrayList<Object[]>();
            HashSet<Long> stateIdset = new HashSet<Long>();
            HashSet<Long> journalIdset = new HashSet<Long>();
            journalList = null;
            List stateList = null;
            for (Map.Entry key : stateMap.entrySet()) {
                journalList = (List)journalMap.get(key.getKey());
                if (journalList == null || !this.judgeAmtAndDirction(stateList = (List)key.getValue(), journalList)) continue;
                this.addMultiVCResult(paramsList, entryParamsList, stateList, journalList, stateIdset, journalIdset);
            }
            this.updateTable(paramsList, entryParamsList, stateIdset, journalIdset);
        }
    }

    protected QFilter getMultiFilter(String checkCondition) {
        return this.getBaseFilter().and(new QFilter(checkCondition, "<>", (Object)""));
    }

    private boolean judgeAmtAndDirction(List<DynamicObject> stateList, List<DynamicObject> journalList) {
        int i;
        if (stateList.size() == 0 || journalList.size() == 0) {
            return false;
        }
        BigDecimal stateSumCredit = BigDecimal.ZERO;
        BigDecimal stateSumDebit = BigDecimal.ZERO;
        BigDecimal journalSumCredit = BigDecimal.ZERO;
        BigDecimal journalSumDebit = BigDecimal.ZERO;
        int stateSize = stateList.size();
        for (i = 0; i < stateSize; ++i) {
            DynamicObject state = stateList.get(i);
            stateSumCredit = stateSumCredit.add(state.getBigDecimal("creditamount"));
            stateSumDebit = stateSumDebit.add(state.getBigDecimal("debitamount"));
        }
        int journalSize = journalList.size();
        for (i = 0; i < journalSize; ++i) {
            DynamicObject journal = journalList.get(i);
            journalSumCredit = journalSumCredit.add(journal.getBigDecimal("creditamount"));
            journalSumDebit = journalSumDebit.add(journal.getBigDecimal("debitamount"));
        }
        return stateSumCredit.compareTo(journalSumDebit) == 0 && stateSumDebit.compareTo(journalSumCredit) == 0;
    }

    private void addMultiVCResult(List<Object[]> paramsList, List<Object[]> entryParamsList, List<DynamicObject> stateList, List<DynamicObject> journalList, Set<Long> stateIdset, Set<Long> journalIdset) {
        long orgId;
        long bizObjectId;
        DynamicObject obj;
        int i;
        long id = DB.genLongId((String)"t_cas_checkedresult");
        SqlParameter[] params = new SqlParameter[10];
        params[0] = new SqlParameter(":fid", -5, (Object)id);
        params[1] = new SqlParameter(":faccountbankid", -5, (Object)this.accountBankId);
        params[2] = new SqlParameter(":fcurrencyid", -5, (Object)this.currencyId);
        params[3] = new SqlParameter(":fchecktype", 12, (Object)this.checkType);
        long companyId = 0L;
        BigDecimal stateAmount = BigDecimal.ZERO;
        BigDecimal journalAmount = BigDecimal.ZERO;
        String stateDirection = null;
        String journalDirection = null;
        int stateSize = stateList.size();
        for (i = 0; i < stateSize; ++i) {
            obj = stateList.get(i);
            bizObjectId = obj.getLong("id");
            orgId = obj.getLong("org");
            this.addEntryResult(obj, "cas_bankstatement", bizObjectId, entryParamsList, id, orgId);
            stateIdset.add(bizObjectId);
            stateAmount = stateAmount.add(obj.getBigDecimal("debitamount").intValue() != 0 ? obj.getBigDecimal("debitamount") : obj.getBigDecimal("creditamount"));
            if (i != 0) continue;
            companyId = orgId;
            stateDirection = obj.getBigDecimal("debitamount").intValue() != 0 ? "debit" : "credit";
        }
        int journalSize = journalList.size();
        for (i = 0; i < journalSize; ++i) {
            obj = journalList.get(i);
            bizObjectId = obj.getLong("id");
            orgId = obj.getLong("org");
            this.addEntryResult(obj, "cas_bankjournal", bizObjectId, entryParamsList, id, orgId);
            journalIdset.add(bizObjectId);
            journalAmount = journalAmount.add(obj.getBigDecimal("debitamount").intValue() != 0 ? obj.getBigDecimal("debitamount") : obj.getBigDecimal("creditamount"));
            if (i != 0) continue;
            journalDirection = obj.getBigDecimal("debitamount").intValue() != 0 ? "debit" : "credit";
        }
        params[4] = new SqlParameter(":fcompanyid", -5, (Object)companyId);
        params[5] = new SqlParameter(":fstateAmount", 3, (Object)stateAmount);
        params[6] = new SqlParameter(":fjournalAmount", 3, (Object)journalAmount);
        params[7] = new SqlParameter(":fstateDirection", 12, stateDirection);
        params[8] = new SqlParameter(":fjournalDirection", 12, journalDirection);
        params[9] = new SqlParameter(":fcheckdate", 91, (Object)this.checkDate);
        paramsList.add(params);
    }

    public abstract String getCheckCondition();
}

