/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.helper.PayBillHepler;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.AutoMatchFlagEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.HotAccountEnum;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;

public class PaymentDeleteImpl
extends AbstractOpService {
    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(20);
        lst.add("billno");
        lst.add("billstatus");
        lst.add("sourcetype");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("actpayamt");
        lst.add("draftbill");
        lst.add("applyorg");
        lst.add("hotaccount");
        lst.add("paymenttype");
        lst.add("paymentchannel");
        lst.add("bankpaystatus");
        lst.add("isvoucher");
        lst.add("e_payableAmt");
        lst.add("e_actAmt");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("settletype");
        lst.add(String.join((CharSequence)".", "settletype", "settlementtype"));
        lst.add("settletnumber");
        lst.add("feepay");
        lst.add("sourcebillnumber");
        lst.add("matchflag");
        lst.add("entry.e_corebilltype");
        lst.add("entry.e_corebillno");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        String billStatus;
        String sourceBillType = info.getString("sourcebilltype");
        String hotAccount = info.getString("hotaccount");
        String matchFlag = info.getString("matchflag");
        if (!(AutoMatchFlagEnum.NONE.getValue().equals(matchFlag) || AutoMatchFlagEnum.NONEED.getValue().equals(matchFlag) || "true".equals(this.param.get("byclaim")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5339\u914d\u8fc7\u7684\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u5220\u9664", (String)"PaymentDeleteImpl_13", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (HotAccountEnum.HOTBILL.getValue().equals(hotAccount)) {
            if (info.getBoolean("isvoucher")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u5148\u5220\u9664\u51ed\u8bc1\u3002", (String)"PaymentDeleteImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
            }
            return;
        }
        if (!("true".equals(this.param.get("byfca")) && ("fca_transupbill".equals(sourceBillType) || "fca_transdownbill".equals(sourceBillType)) || (billStatus = info.getString("billstatus")).equals(BillStatusEnum.SAVE.getValue()))) {
            throw new KDBizException(new PaymentErrorCode().STATUS_CANNOT_DELETE(), new Object[0]);
        }
        if (!CasHelper.isEmpty((Object)info.get("applyorg")) && "cas_paybill".equals(info.get("sourcebilltype"))) {
            throw new KDBizException(new PaymentErrorCode().WTRCBILL_CANNOT_DELETE(), new Object[0]);
        }
        if ("cas_recbill".equals(sourceBillType) && !"1".equals(this.param.get("delrecpay"))) {
            throw new KDBizException(new PaymentErrorCode().HASSRCBILL_CANNOT_DELETE(), new Object[0]);
        }
        Object tmcValidator = this.param.get("tmc_tm");
        if (tmcValidator == null && ("tm_businessbill".equals(sourceBillType) || "tm_structdeposit".equals(sourceBillType) || "tm_rateswap".equals(sourceBillType) || "tm_bond_fix".equals(sourceBillType) || "tm_bond_float".equals(sourceBillType) || "tm_forex_options".equals(sourceBillType))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u751f\u6210\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u76f4\u63a5\u5220\u9664\u3002", (String)"PaymentDeleteImpl_0", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        Object feepaydelete = this.param.get("feepaydelete");
        if (info.getBoolean("feepay") && (feepaydelete == null || !"1".equals(feepaydelete))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u662f\u4e1a\u52a1\u5355\u636e\uff08\u5355\u636e\u7f16\u53f7%s\uff09\u5173\u8054\u751f\u6210\u7684\u624b\u7eed\u8d39\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664\uff0c\u5982\u9700\u5220\u9664\u8bf7\u5728\u539f\u4e1a\u52a1\u5355\u636e\u4e0a\u8fdb\u884c\u53d6\u6d88\u4ed8\u6b3e\u5904\u7406\u3002", (String)"PaymentDeleteImpl_2", (String)"fi-cas-business", (Object[])new Object[0]), info.getString("sourcebillnumber")));
        }
        String billNo = info.getString("billno");
        QFilter qFilter = new QFilter("entry.e_corebilltype", "=", (Object)"cas_paybill").and("entry.e_corebillno", "=", (Object)billNo).and("billstatus", "=", (Object)"D");
        DynamicObjectCollection recBills = QueryServiceHelper.query((String)"cas_recbill", (String)"billno,entry.e_corebilltype,entry.e_corebillno", (QFilter[])new QFilter[]{qFilter});
        if (recBills != null && recBills.size() != 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject recBill : recBills) {
                sb.append(recBill.getString("billno")).append("\u3001");
            }
            sb.deleteCharAt(sb.lastIndexOf("\u3001"));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u5355%1$s\u5df2\u88ab\u6536\u6b3e\u5355%2$s\u5173\u8054\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u8be5\u5355\u636e\uff0c\u5982\u6709\u9700\u6c42\u8bf7\u53d6\u6d88\u6536\u6b3e\u3002", (String)"PaymentDeleteImpl_3", (String)"fi-cas-business", (Object[])new Object[0]), billNo, sb.toString()));
        }
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        String sourceBillType = info.getString("sourcebilltype");
        Object ignoreValidator = this.param.get("cdm_drafttradebill_ignore");
        Object dealbypsdValidator = this.param.get("dealbypsd");
        if (ignoreValidator == null && "cdm_drafttradebill".equals(sourceBillType)) {
            Long draftTradeBillId = info.getLong("sourcebillid");
            HashSet<Long> draftTradeBillIdSet = new HashSet<Long>();
            draftTradeBillIdSet.add(draftTradeBillId);
            if (dealbypsdValidator != null && "y".equals(dealbypsdValidator.toString())) {
                PayBillHepler.callCancleDraw(draftTradeBillIdSet, true);
            } else {
                PayBillHepler.callCancleDraw(draftTradeBillIdSet, false);
            }
            this.param.put("isdelbydraft", (Object)"1");
            this.param.put("cdm_drafttradebill_ignore", (Object)"1");
        }
        String hotAccount = info.getString("hotaccount");
        if (HotAccountEnum.HOTBILL.getValue().equals(hotAccount)) {
            RecBillHepler.checkJournal(info);
            return;
        }
        DynamicObjectCollection draftbillColl = info.getDynamicObjectCollection("draftbill");
        BigDecimal actpayamt = info.getBigDecimal("actpayamt");
        if (draftbillColl.size() > 0) {
            List draftBillIds = draftbillColl.stream().filter(v -> v.getDynamicObject("fbasedataid") != null).map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_draftbillf7", (String)"amount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftBillIds)});
            BigDecimal amount = BigDecimal.ZERO;
            for (int i = 0; i < draftBills.length; ++i) {
                DynamicObject temp = draftBills[i];
                amount = amount.add(temp.getBigDecimal("amount"));
            }
            if (actpayamt.compareTo(amount) < 0) {
                CasBotpHelper.deleteRation((Object)info.getPkValue(), (String[])new String[]{"cas_recbill"});
            }
        }
        if ("cas_payapplybill".equals(sourceBillType) || "cas_transferapply".equals(sourceBillType) || "lc_arrival".equals(sourceBillType) || "tm_businessbill".equals(sourceBillType) || "fr_glreim_paybill".equals(sourceBillType)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            if (this.param.getParams().containsKey("isPayScheBack")) {
                paramMap.put("isPayScheBack", this.param.getParams().get("isPayScheBack"));
                paramMap.put("payScheOPType", this.param.getParams().get("payScheOPType"));
                paramMap.put("payScheRelease", this.param.getParams().get("payScheRelease"));
                paramMap.put("delPayApplyBillIds", this.param.getParams().get("delPayApplyBillIds"));
            }
            WriteBackTaskHelper.addRealtimeTask(info, info.getString("sourcebilltype"), WriteBackOperateEnum.DELETE, PaymentDisposeConsumer.class, paramMap);
        }
    }
}

