/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.cas.business.errorcode.PaymentErrorCode;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.util.EmptyUtil;

public class PaymentUnAuditImpl
extends AbstractOpService {
    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("billno");
        lst.add("billstatus");
        lst.add("sourcetype");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("entrance");
        lst.add("entrustorg");
        lst.add("org");
        lst.add("e_payableAmt");
        lst.add("e_lockAmt");
        lst.add("e_unlockAmt");
        return lst;
    }

    @Override
    public void validate(DynamicObject info) throws KDException {
        String billStatus = info.getString("billstatus");
        String isLock = "false";
        if (EmptyUtil.isNoEmpty((Object)this.param) && EmptyUtil.isNoEmpty((Object)this.param.getParams()) && this.param.getParams().containsKey("islock")) {
            isLock = (String)this.param.getParams().get("islock");
        }
        if (!billStatus.equals(BillStatusEnum.AUDIT.getValue())) {
            throw new KDBizException(new PaymentErrorCode().STATUS_CANNOT_UNAUDIT(), new Object[0]);
        }
        ArrayList<String> businessIds = new ArrayList<String>(1);
        businessIds.add(info.getString("id"));
        List lockedIds = TxCheckUtil.getLocked(businessIds);
        if (!"true".equals(isLock) && lockedIds.contains(info.getString("id"))) {
            String error = ResManager.loadKDString((String)"\u8fd8\u5728\u5206\u5e03\u5f0f\u4e8b\u52a1\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"PaymentCancelPayValidator_5", (String)"fi-cas-opplugin", (Object[])new Object[0]);
            throw new KDBizException(error);
        }
        DynamicObject entrustorg = info.getDynamicObject("entrustorg");
        if (!CasHelper.isEmpty((Object)entrustorg)) {
            QFilter statusFilter = new QFilter("billstatus", "!=", (Object)BillStatusEnum.CHARGEBANK.getValue());
            DynamicObject payMent = QueryServiceHelper.queryOne((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", info.getPkValue()), statusFilter});
            if (payMent != null) {
                String msg = ResManager.loadKDString((String)"\u5df2\u4e0b\u63a8\u59d4\u6258\u4ed8\u6b3e\u5355\uff0c\u8bf7\u53d6\u6d88\u59d4\u6258\u540e\u518d\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"PaymentUnAuditImpl_1", (String)"fi-cas-business", (Object[])new Object[0]);
                throw new KDBizException(msg);
            }
        }
    }

    @Override
    public void process(DynamicObject info) throws KDException {
        super.process(info);
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"cas_paybill", (Long[])new Long[]{info.getLong("id")});
        if (!targetBills.isEmpty()) {
            for (Map.Entry key : targetBills.entrySet()) {
                if (!"pur_pay".equals(key.getKey())) continue;
                HashSet targetSet = (HashSet)key.getValue();
                TXHandle tx = TX.requiresNew((String)"delete pur_apy");
                Throwable throwable = null;
                try {
                    DeleteServiceHelper.delete((String)"pur_pay", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)targetSet)});
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (tx == null) continue;
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    tx.close();
                }
            }
        }
    }
}

