/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.opservice.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.cas.business.errorcode.ReceivErrorCode;
import kd.fi.cas.business.helper.RecBillHepler;
import kd.fi.cas.business.journal.JournalServiceAdapter;
import kd.fi.cas.business.opservice.AbstractOpService;
import kd.fi.cas.business.opservice.impl.ValidateReclateOperation;
import kd.fi.cas.business.paysche.bean.DraftAmountLockSubInfo;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.business.paysche.bean.LockResult;
import kd.fi.cas.business.paysche.serive.DraftLockServiceHelper;
import kd.fi.cas.business.service.oplog.OpLogFactory;
import kd.fi.cas.business.service.oplog.recoplog.IRecBillOpLog;
import kd.fi.cas.business.writeback.WriteBackValidateHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.enums.LogBizStatusEnum;
import kd.fi.cas.enums.LogBizTypeEnum;
import kd.fi.cas.enums.PayAndRecBizTypeEnum;
import kd.fi.cas.helper.BillStatusHelper;
import kd.fi.cas.helper.CasBotpHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.EntityPropertyHelper;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.helper.SettleRecordQueryHelperForCas;
import kd.fi.cas.helper.SystemParameterHelper;
import kd.fi.cas.helper.VoucherBookHelper;
import kd.fi.cas.util.EmptyUtil;

public class RecBillCancelRecImpl
extends AbstractOpService {
    public static final String PARA_VOUCHERIDS = "voucherIds:";
    private JournalServiceAdapter journalServiceAdapter = new JournalServiceAdapter();
    private Map<DynamicObject, Map<String, HashSet<Long>>> destMap = new HashMap<DynamicObject, Map<String, HashSet<Long>>>();
    private Log logger = LogFactory.getLog(RecBillCancelRecImpl.class);
    private DraftLockServiceHelper draftLockServiceHelper = new DraftLockServiceHelper();

    @Override
    public List<String> getSelector() {
        ArrayList<String> lst = new ArrayList<String>(40);
        lst.add("billno");
        lst.add("biztype");
        lst.add("bizdate");
        lst.add("billstatus");
        lst.add("txt_description");
        lst.add("receivingtype");
        lst.add("payertype");
        lst.add("org");
        lst.add("accountbank");
        lst.add("payeebank");
        lst.add("payer");
        lst.add("payerformid");
        lst.add("payeracctbank");
        lst.add("payeraccformid");
        lst.add("payername");
        lst.add("payeracctbanknum");
        lst.add("f7_payerbank");
        lst.add("cashier");
        lst.add("payeedate");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("isagent");
        lst.add("isrefund");
        lst.add("accountcash");
        lst.add("actrecamt");
        lst.add("currency");
        lst.add("exchangerate");
        lst.add("localamt");
        lst.add("settletype");
        lst.add("settletnumber");
        lst.add("isvoucher");
        lst.add("confirmlogo");
        lst.add("e_actamt");
        lst.add("e_localamt");
        lst.add("e_fundflowitem");
        lst.add("e_remark");
        lst.add("realreccompany");
        lst.add("e_sourcebillid");
        lst.add("e_sourcebillentryid");
        lst.add("confirmlogo");
        lst.add("sourcetype");
        lst.add("e_settleorg");
        lst.add("e_dividestatus");
        lst.add("recorg");
        lst.add("e_orgsdividebatch");
        lst.add("issupplecontract");
        lst.add("isorgsdivide");
        lst.add("openorg");
        lst.add("draftbill");
        lst.add("isused");
        lst.add(String.join((CharSequence)".", "draftbill", "fbasedataid", "id"));
        lst.addAll(EntityPropertyHelper.getEntryPropertys((String)"cas_recbill", (String)"entry"));
        lst.add("cas_draftinfo");
        lst.add("transamount");
        lst.add("draftbillinfo");
        lst.add("draftbilllogid");
        return lst;
    }

    @Override
    public void validate(DynamicObject recBill) throws KDException {
        if (!BillStatusHelper.isRightStatus((String)"cas_recbill", (Long)recBill.getLong("id"), (BillStatusEnum)BillStatusEnum.PAY).booleanValue()) {
            throw new KDException(new ReceivErrorCode().STATUS_CANNOT_CANCELREC(), new Object[0]);
        }
        Boolean isUsed = recBill.getBoolean("isused");
        if (isUsed.booleanValue()) {
            throw new KDException(new ReceivErrorCode().USED_CANNOT_CANCELREC(recBill.getString("billno")), new Object[0]);
        }
        List<String> targetStrings = Arrays.asList("cas_recbill", "cas_paybill", "ap_finapbill");
        Map<String, HashSet<Long>> targetBills = new ValidateReclateOperation(recBill).targetBillReverseOpValidate(targetStrings);
        this.destMap.put(recBill, targetBills);
        this.journalServiceAdapter.validateCancelBook(recBill);
        if (!"true".equals(this.param.get("byfca")) && "fca_transdownbill".equals(recBill.getString("sourcebilltype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u62e8\u5355\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_0", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!"true".equals(this.param.get("byfca")) && "fca_transupbill".equals(recBill.getString("sourcebilltype"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0a\u5212\u5355\u751f\u6210\u7684\u6536\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_5", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        if (!this.canCancelReBill(targetBills)) {
            throw new KDBizException(new ReceivErrorCode().CDM_CANNOT_CANCELREC(), new Object[0]);
        }
        DynamicObject org = recBill.getDynamicObject("org");
        DynamicObjectCollection draftbillColl = recBill.getDynamicObjectCollection("draftbill");
        if (draftbillColl.size() > 0) {
            List draftBillIds = draftbillColl.stream().map(v -> v.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            Object[] draftBills = BusinessDataServiceHelper.load((String)"cdm_drafttradebill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("entrys.draftbill.id", "in", draftBillIds)});
            if (EmptyUtil.isNoEmpty((Object[])draftBills)) {
                throw new KDBizException(new ReceivErrorCode().CDM_CANNOT_CANCELREC(), new Object[0]);
            }
            QFilter tQFilter = new QFilter("id", "in", draftBillIds);
            QFilter casSource = new QFilter("source", "=", (Object)"cas");
            QFilter orCasSource = new QFilter("source", "!=", (Object)"cas");
            orCasSource.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
            String appId = AppMetadataCache.getAppInfo((String)"cdm").getId();
            String noticeClaimAllowStatus = (String)SystemParamServiceHelper.getAppParameter((String)appId, (String)"08", (Long)org.getLong("id"), (String)"noticeclaimallowstatus");
            List<String> allowStatusList = Arrays.asList(noticeClaimAllowStatus.split(","));
            ArrayList<String> draftBillStatusList = new ArrayList<String>();
            for (String allowStatus : allowStatusList) {
                if (EmptyUtil.isEmpty((String)allowStatus)) continue;
                draftBillStatusList.add(allowStatus);
            }
            orCasSource.and("draftbillstatus", "in", draftBillStatusList);
            orCasSource.and("draftbilltranstatus", "=", (Object)"success");
            tQFilter.and(casSource.or(orCasSource));
            DynamicObject[] draftDataArr = BusinessDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id", (QFilter[])new QFilter[]{tQFilter});
            if (draftDataArr == null || draftBillIds.size() != draftDataArr.length) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u4e0d\u5728\u5141\u8bb8\u6536\u6b3e\u5173\u8054\u7684\u7968\u636e\u72b6\u6001\u8303\u56f4\u5185\uff0c\u6682\u4e0d\u652f\u6301\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_6", (String)"fi-cas-business", (Object[])new Object[0]), String.join((CharSequence)recBill.getString("billno"), "\u3010", "\u3011")));
            }
        }
        Set srcBill = CasBotpHelper.getSrcBillByDestBill((Long)recBill.getLong("id"), (String)recBill.getDataEntityType().getName(), (String)"cas_paybill");
        if (CasHelper.isEmpty((Object)recBill.getString("sourcebilltype")) && !CasHelper.isEmpty((Object)srcBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6536\u6b3e\u5355\u5df2\u5173\u8054\u4ed8\u6b3e\u5355\u4e0d\u5141\u8bb8\u53d6\u6d88\u6536\u6b3e\u3002", (String)"RecBillCancelRecImpl_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        this.settleValidate(recBill);
        boolean validataVoucher = this.validataVoucher(recBill);
        if (!validataVoucher) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u6b3e\u5931\u8d25\uff0c\u56e0\u4e3a\u53d6\u6d88\u6536\u6b3e\u65f6\u51b2\u9500\u51ed\u8bc1\u5931\u8d25\uff1a\u51ed\u8bc1\u4e0d\u662f\u5df2\u8fc7\u8d26\u72b6\u6001\u3002", (String)"RecBillCancelRecImpl_4", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private void settleValidate(DynamicObject recBill) {
        boolean exists = SettleRecordQueryHelperForCas.isExistsSettlesByMain((String)"ar_settlerecord", (String)"cas_recbill", (Object[])new Object[]{recBill.getPkValue()}, null);
        boolean exists2 = SettleRecordQueryHelperForCas.isExistsSettlesByAsst((String)"ar_settlerecord", (String)"cas_recbill", (Object[])new Object[]{recBill.getPkValue()}, null);
        if (exists || exists2) {
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"AutoUnSettleValidate", (String)"unSettleValidate", (Object[])new Object[]{recBill});
            WriteBackValidateHelper.WriteBackResultDeal(recBill, result, recBill.getString("sourcebilltype"), WriteBackOperateEnum.UNSETTLEVALIDATE);
        }
    }

    private boolean canCancelReBill(Map<String, HashSet<Long>> targetBills) {
        for (Map.Entry<String, HashSet<Long>> entry : targetBills.entrySet()) {
            DynamicObject[] tarBills;
            String targetKey = entry.getKey();
            HashSet<Long> targetPks = entry.getValue();
            if (!"cdm_receivablebill".equals(targetKey)) continue;
            for (DynamicObject tarBill : tarBills = BusinessDataServiceHelper.load((Object[])targetPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)targetKey))) {
                if (BillStatusEnum.SAVE.getValue().equals(tarBill.get("billstatus")) || !"cas".equals(tarBill.getString("source"))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean validataVoucher(DynamicObject recBill) {
        int CS114 = SystemParameterHelper.getParameterInteger((long)recBill.getDynamicObject("org").getLong("id"), (String)"cs114");
        if (CS114 == 1) {
            Set vouchers = DapVoucherUtil.getBuildVch(Collections.singleton(recBill.getPkValue()), (String)"cas_recbill");
            if (vouchers == null || vouchers.size() == 0) {
                return Boolean.TRUE;
            }
            String voucherKey = PARA_VOUCHERIDS + recBill.getPkValue();
            this.param.put(voucherKey, (Object)vouchers);
            return VoucherBookHelper.checkVoucherIsPost((Set)vouchers);
        }
        return Boolean.TRUE;
    }

    @Override
    public void process(DynamicObject recBill) throws KDException {
        int cs = SystemParameterHelper.getParameterInteger((long)recBill.getDynamicObject("org").getLong("id"), (String)"cs114");
        List<Long> reverVouIds = null;
        switch (cs) {
            case 1: {
                reverVouIds = this.cancelRecReverseVoucher(recBill);
                this.cancelProcess(recBill, reverVouIds);
                this.draftBillHandle(recBill);
                break;
            }
            case 2: {
                DynamicObject revPayIds = this.redOrderOffset(recBill);
                this.param.put("newbill", (Object)revPayIds);
                break;
            }
            case 3: {
                this.cancelProcess(recBill, reverVouIds);
                this.draftBillHandle(recBill);
            }
        }
        if (recBill.getDynamicObject("receivingtype").get("biztype").equals(PayAndRecBizTypeEnum.SETTLCENTER_COLLECT.getValue())) {
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"ifm", (String)"InnerAcctCancelRecService", (String)"cancelRec", (Object[])new Object[]{recBill.getPkValue()});
        }
        try {
            IRecBillOpLog<?> settleOpImp = new OpLogFactory().getRecBillOpLogImpl("cancelRecOp");
            settleOpImp.doRecOpLog(recBill);
        }
        catch (Exception e) {
            this.logger.info(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        try (TXHandle tx = TX.requiresNew();){
            CasBotpHelper.deleteRation((DBRoute)DBRouteConst.TMC, (String)"cdm_receivablebill", (Long[])new Long[0], (Long)recBill.getLong("id"));
        }
    }

    private void cancelProcess(DynamicObject recBill, List<Long> reverVouIds) {
        try {
            recBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            recBill.set("cashier", null);
            recBill.set("payeedate", null);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
            Map<String, HashSet<Long>> map = this.destMap.get(recBill);
            if (map != null) {
                for (Map.Entry<String, HashSet<Long>> entry : map.entrySet()) {
                    DynamicObject[] draftbills;
                    String targetKey = entry.getKey();
                    HashSet<Long> targetPks = entry.getValue();
                    if ("cas_recbill".equals(targetKey) || "cas_paybill".equals(targetKey) || "ap_finapbill".equals(targetKey)) {
                        DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)targetKey), (Object[])targetPks.toArray(new Long[0]));
                        CasBotpHelper.deleteRation((Object)recBill.getPkValue(), (String[])new String[]{targetKey});
                    }
                    if (!"cdm_receivablebill".equals(targetKey) || (draftbills = BusinessDataServiceHelper.load((String)targetKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", targetPks).and("source", "=", (Object)"cas")})) == null || draftbills.length <= 0) continue;
                    recBill.set("settletnumber", null);
                    recBill.set("draftbill", null);
                    OperateServiceHelper.execOperate((String)"casdel", (String)targetKey, (Object[])Arrays.asList(draftbills).stream().map(item -> item.getPkValue()).toArray(), (OperateOption)OperateOption.create(), (boolean)true);
                }
            }
            this.journalServiceAdapter.cancelBook(recBill);
        }
        catch (Exception e) {
            if (reverVouIds != null && reverVouIds.size() > 0) {
                OperateServiceHelper.execOperate((String)"delete", (String)"gl_voucher", (Object[])reverVouIds.toArray(), (OperateOption)OperateOption.create());
            }
            throw new KDBizException(e.getMessage());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recBill});
    }

    private List<Long> cancelRecReverseVoucher(DynamicObject recBill) {
        Object voucerOp = this.param.get("voucerOp");
        String voucherKey = PARA_VOUCHERIDS + recBill.getPkValue();
        if (this.param.get(voucherKey) == null) {
            return null;
        }
        Set voucherIds = (Set)this.param.get(voucherKey);
        return VoucherBookHelper.reverseVoucher((Set)voucherIds, (Object)voucerOp);
    }

    private DynamicObject redOrderOffset(DynamicObject recBill) {
        DynamicObject oldRecBill = BusinessDataServiceHelper.loadSingle((Object)recBill.getPkValue(), (String)"cas_recbill");
        if (oldRecBill == null) {
            return null;
        }
        DynamicObject newRecBill = RecBillHepler.dealReverse(oldRecBill);
        if (newRecBill == null) {
            return null;
        }
        CasBotpHelper.saveRelation((String)"cas_recbill", (Long)recBill.getLong("id"), (String)"cas_recbill", (Long)newRecBill.getLong("id"));
        return newRecBill;
    }

    private List<LockResult> draftBillHandle(DynamicObject recBillData) {
        List<LockResult> resultList = new ArrayList<LockResult>(8);
        DynamicObjectCollection draftDataColl = recBillData.getDynamicObjectCollection("draftbill");
        DynamicObjectCollection draftInfoEntrys = recBillData.getDynamicObjectCollection("cas_draftinfo");
        if (draftDataColl != null && draftDataColl.size() > 0) {
            ArrayList<DraftLockInfo> lockOrReleaseInfoList = new ArrayList<DraftLockInfo>(1);
            DraftLockInfo draftLockInfo = new DraftLockInfo();
            draftLockInfo.setSourceBillId(recBillData.getLong("id"));
            draftLockInfo.setSourceBillType(recBillData.getDataEntityType().getName());
            Set draftIdSet = draftDataColl.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            DynamicObject[] draftBills = BusinessDataServiceHelper.load((String)"cdm_payandrecdraft_f7", (String)"id,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", draftIdSet)});
            HashMap draftIdAvailableAmountMap = Arrays.stream(draftBills).collect(Collectors.toMap(v -> v.getLong("id"), o -> o.getBigDecimal("availableamount"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdLogIdMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getLong("draftbilllogid"), (o1, o2) -> o1, HashMap::new));
            HashMap draftIdTranAmountAmountMap = draftInfoEntrys.stream().collect(Collectors.toMap(v -> v.getDynamicObject("draftbillinfo").getLong("id"), o -> o.getBigDecimal("transamount"), (o1, o2) -> o1, HashMap::new));
            ArrayList<DraftAmountLockSubInfo> draftAmountLockSubInfoList = new ArrayList<DraftAmountLockSubInfo>(8);
            for (Long lockDraftId : draftIdSet) {
                DraftAmountLockSubInfo draftAmountLockInfo = new DraftAmountLockSubInfo();
                draftAmountLockInfo.setBillId(lockDraftId);
                BigDecimal availableAmount = draftIdAvailableAmountMap.get(lockDraftId) == null ? BigDecimal.ZERO : (BigDecimal)draftIdAvailableAmountMap.get(lockDraftId);
                BigDecimal transAmount = draftIdTranAmountAmountMap.get(lockDraftId) == null ? availableAmount : (BigDecimal)draftIdTranAmountAmountMap.get(lockDraftId);
                draftAmountLockInfo.setDealAmount(transAmount);
                Long billLogId = draftIdLogIdMap.get(lockDraftId) == null ? Long.valueOf(0L) : (Long)draftIdLogIdMap.get(lockDraftId);
                draftAmountLockInfo.setBillLogId(billLogId);
                draftAmountLockInfo.setBillTradeStatus(LogBizStatusEnum.PROCESS.getValue());
                draftAmountLockInfo.setBillTrade(LogBizTypeEnum.ENDORSE.getValue());
                if (transAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                draftAmountLockSubInfoList.add(draftAmountLockInfo);
            }
            draftLockInfo.getLockSubInfoList().addAll(draftAmountLockSubInfoList);
            lockOrReleaseInfoList.add(draftLockInfo);
            if (!CollectionUtils.isEmpty(lockOrReleaseInfoList)) {
                resultList = this.draftLockServiceHelper.releaseOrLockDraft(lockOrReleaseInfoList);
            }
        }
        return resultList;
    }
}

