/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche;

import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.cas.business.paysche.bean.DraftLockInfo;
import kd.fi.cas.helper.OperateServiceHelper;
import kd.fi.cas.util.EmptyUtil;

public class PayScheHelper {
    private static Log logger = LogFactory.getLog(PayScheHelper.class);

    public static Map<Long, List<String>> writeBackPayBill(DynamicObject[] payScheBills) {
        OperateOption create;
        HashMap<Long, List<String>> delMap = new HashMap<Long, List<String>>(payScheBills.length);
        ArrayList payBillids = new ArrayList();
        for (DynamicObject payScheBill : payScheBills) {
            DynamicObjectCollection entrys = payScheBill.getDynamicObjectCollection("entrys");
            entrys.stream().filter(p -> StringUtil.equals((String)p.getString("e_billtype"), (String)"schebill")).forEach(o -> payBillids.add(o.getString("e_payid")));
        }
        DynamicObject[] payBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", payBillids), new QFilter("iswaitsche", "=", (Object)"1")}, (String)"createtime desc");
        if (payBills.length > 0) {
            payBills = BusinessDataServiceHelper.load((Object[])Arrays.stream(payBills).map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_paybill"));
        }
        ArrayList<DynamicObject> payBillList = new ArrayList<DynamicObject>(Arrays.asList(payBills));
        Collections.sort(payBillList, new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject arg0, DynamicObject arg1) {
                Date date1 = arg0.getDate("createtime");
                Date date2 = arg1.getDate("createtime");
                return -date1.compareTo(date2);
            }
        });
        List payBillIds = payBillList.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
        Set<Object> saveObjs = new HashSet(16);
        ArrayList<Object> delObjIds = new ArrayList<Object>(16);
        for (DynamicObject payScheBill : payScheBills) {
            ArrayList delEntryIds = new ArrayList();
            delMap.put(payScheBill.getLong("id"), delEntryIds);
            BigDecimal totalAmt = BigDecimal.ZERO;
            totalAmt = payScheBill.getString("schedulstatus").equals("yetchargeback") ? payScheBill.getBigDecimal("applyamt") : payScheBill.getBigDecimal("amount").add(payScheBill.getBigDecimal("draftamt"));
            DynamicObjectCollection payScheEntrys = payScheBill.getDynamicObjectCollection("entrys");
            payScheEntrys.stream().filter(o -> StringUtil.equals((String)o.getString("e_billtype"), (String)"schebill"));
            ArrayList<DynamicObject> payScheEntryList = new ArrayList<DynamicObject>();
            for (Object id : payBillIds) {
                for (DynamicObject dynamicObject : payScheEntrys) {
                    if (!id.toString().equals(dynamicObject.getString("e_payid"))) continue;
                    payScheEntryList.add(dynamicObject);
                }
            }
            block4: for (DynamicObject payScheEntry : payScheEntryList) {
                String billType = payScheEntry.getString("e_billtype");
                if (!StringUtil.equals((String)billType, (String)"schebill")) continue;
                String payId = payScheEntry.getString("e_payid");
                String payEntryId = payScheEntry.getString("e_payentryid");
                for (DynamicObject payBill : payBillList) {
                    if (!payId.equals(payBill.getString("id"))) continue;
                    DynamicObject baseCurrency = payBill.getDynamicObject("basecurrency");
                    BigDecimal exchangeRate = payBill.getBigDecimal("exchangerate");
                    ArrayList<DynamicObject> waitDelEntry = new ArrayList<DynamicObject>(10);
                    DynamicObjectCollection entryEntitys = payBill.getDynamicObjectCollection("entry");
                    for (DynamicObject entryEntity : entryEntitys) {
                        if (!entryEntity.getString("id").equals(payEntryId)) continue;
                        BigDecimal substractAmt = entryEntity.getBigDecimal("e_payableamt").compareTo(totalAmt) > 0 ? totalAmt : entryEntity.getBigDecimal("e_payableamt");
                        totalAmt = totalAmt.subtract(substractAmt);
                        entryEntity.set("e_payableamt", (Object)entryEntity.getBigDecimal("e_payableamt").subtract(substractAmt));
                        payBill.set("actpayamt", (Object)payBill.getBigDecimal("actpayamt").subtract(substractAmt));
                        if (null != baseCurrency) {
                            entryEntity.set("e_localamt", (Object)entryEntity.getBigDecimal("e_payableamt").multiply(exchangeRate).setScale(baseCurrency.getInt("amtprecision"), 4));
                            payBill.set("localamt", (Object)payBill.getBigDecimal("actpayamt").multiply(exchangeRate).setScale(baseCurrency.getInt("amtprecision"), RoundingMode.HALF_UP));
                        } else {
                            entryEntity.set("e_localamt", (Object)entryEntity.getBigDecimal("e_payableamt").multiply(exchangeRate));
                            payBill.set("localamt", (Object)payBill.getBigDecimal("actpayamt").multiply(exchangeRate));
                        }
                        if (entryEntity.getBigDecimal("e_payableamt").compareTo(BigDecimal.ZERO) == 0) {
                            waitDelEntry.add(entryEntity);
                        }
                        if (totalAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                        break;
                    }
                    entryEntitys.removeAll(waitDelEntry);
                    waitDelEntry.stream().forEach(o -> delEntryIds.add(o.getString("id")));
                    if (payBill.getDynamicObjectCollection("entry").size() == 0) {
                        delObjIds.add(payBill.getPkValue());
                    } else {
                        saveObjs.add(payBill);
                    }
                    if (totalAmt.compareTo(BigDecimal.ZERO) > 0) continue;
                    continue block4;
                }
            }
        }
        if (!(saveObjs = saveObjs.stream().filter(p -> p.getDynamicObjectCollection("entry").size() > 0).collect(Collectors.toSet())).isEmpty()) {
            create = OperateOption.create();
            create.setVariableValue("isSchePush", "true");
            OperateServiceHelper.execOperate((String)"save", (String)"cas_paybill", (DynamicObject[])saveObjs.toArray(new DynamicObject[saveObjs.size()]), (OperateOption)create);
        }
        if (!delObjIds.isEmpty()) {
            create = OperateOption.create();
            create.setVariableValue("isdelbypaysche", "true");
            OperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])delObjIds.toArray(), (OperateOption)create);
        }
        return delMap;
    }

    public static void synPaySche(DynamicObject[] paymentBills, String methodName) {
        try {
            Set<Long> billIds = ((Stream)Arrays.stream(paymentBills).parallel()).map(d -> d.getLong("id")).collect(Collectors.toSet());
            Set<Long> schePayBills = PayScheHelper.getSchePayBills(billIds);
            if (EmptyUtil.isEmpty(schePayBills)) {
                return;
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("payBillIds", JSON.toJSONString(new ArrayList<Long>(schePayBills)));
            params.put("status", paymentBills[0].getString("billstatus"));
            DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)methodName, (Object[])new Object[]{JSON.toJSONString(params)});
        }
        catch (Exception ex) {
            logger.error("\u540c\u6b65\u4fe1\u606f\u5230\u4ed8\u6b3e\u6392\u7a0b\u5355\u5931\u8d25\uff1a" + ex);
            throw ex;
        }
    }

    private static Set<Long> getSchePayBills(Set<Long> billIds) {
        return (Set)DispatchServiceHelper.invokeBizService((String)"tmc", (String)"psd", (String)"tmcPayScheService", (String)"getSchePayBills", (Object[])new Object[]{billIds});
    }

    public static void changeDraftLock(List<DraftLockInfo> lockInfoList) {
        if (CollectionUtils.isEmpty(lockInfoList)) {
            return;
        }
        boolean isExistLockBillIdList = false;
        for (DraftLockInfo dli : lockInfoList) {
            List<Long> lockBillIdList = dli.getLockBillIdList();
            if (lockBillIdList.size() <= 0) continue;
            isExistLockBillIdList = true;
            break;
        }
        if (!isExistLockBillIdList) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"changeBillLockInfo", (Object[])new Object[]{JSON.toJSONString(lockInfoList)});
    }

    public static void releaseOrLockDraft(List<DraftLockInfo> lockInfoList) {
        if (CollectionUtils.isEmpty(lockInfoList)) {
            return;
        }
        DispatchServiceHelper.invokeBizService((String)"tmc", (String)"cdm", (String)"LockDraftService", (String)"lockOrReleaseBill", (Object[])new Object[]{JSON.toJSONString(lockInfoList)});
    }
}

