/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.push.IPushPayBillExecutor;
import kd.fi.cas.business.paysche.push.executor.CombinePushPayBillExecutor;
import kd.fi.cas.business.paysche.push.executor.SinglePushPayBillExecutor;

public class PushPayBillExecutorFactory {
    public static List<IPushPayBillExecutor> getExecutors(List<PaySchePayInfo> payInfoList) {
        ArrayList<IPushPayBillExecutor> executorList = new ArrayList<IPushPayBillExecutor>();
        executorList.addAll(PushPayBillExecutorFactory.getMergeExecutor(payInfoList));
        executorList.addAll(PushPayBillExecutorFactory.getSinglePushExecutor(payInfoList));
        return executorList;
    }

    public static List<IPushPayBillExecutor> getMergeExecutor(List<PaySchePayInfo> payInfoList) {
        if ((payInfoList = new ArrayList<PaySchePayInfo>(payInfoList).stream().filter(PaySchePayInfo::isMergeFlag).collect(Collectors.toList())).size() == 0) {
            return new ArrayList<IPushPayBillExecutor>();
        }
        Map<String, DynamicObject> sourceBillMap = PushPayBillExecutorFactory.getSourceBillMap(payInfoList);
        Map<String, List<PaySchePayInfo>> batchPayInfoMap = payInfoList.stream().collect(Collectors.groupingBy(PaySchePayInfo::getBatchSeqNo));
        ArrayList<IPushPayBillExecutor> executorList = new ArrayList<IPushPayBillExecutor>(batchPayInfoMap.size());
        for (Map.Entry<String, List<PaySchePayInfo>> entry : batchPayInfoMap.entrySet()) {
            List<PaySchePayInfo> mergePayInfoList = entry.getValue();
            HashSet<String> sourceBillKeySet = new HashSet<String>(mergePayInfoList.size());
            for (PaySchePayInfo paySchePayInfo : mergePayInfoList) {
                String sourceBillKey = PushPayBillExecutorFactory.getSourceBillMapKey(paySchePayInfo.getSourceBillType(), paySchePayInfo.getSourceBillId());
                sourceBillKeySet.add(sourceBillKey);
            }
            List<DynamicObject> sourceBillList = sourceBillKeySet.stream().map(sourceBillMap::get).collect(Collectors.toList());
            StringBuilder sb = new StringBuilder();
            if (sourceBillList != null && !sourceBillList.isEmpty()) {
                for (DynamicObject dynamicObject : sourceBillList) {
                    if (dynamicObject == null) continue;
                    sb.append(dynamicObject.getPkValue()).append("\r\n");
                }
            }
            executorList.add(new CombinePushPayBillExecutor(sourceBillList, mergePayInfoList));
        }
        return executorList;
    }

    public static List<IPushPayBillExecutor> getSinglePushExecutor(List<PaySchePayInfo> payInfoList) {
        if ((payInfoList = new ArrayList<PaySchePayInfo>(payInfoList).stream().filter(o -> !o.isMergeFlag()).collect(Collectors.toList())).size() == 0) {
            return new ArrayList<IPushPayBillExecutor>();
        }
        Map<String, DynamicObject> sourceBillMap = PushPayBillExecutorFactory.getSourceBillMap(payInfoList);
        ArrayList<IPushPayBillExecutor> executorList = new ArrayList<IPushPayBillExecutor>(10);
        for (PaySchePayInfo paySchePayInfo : payInfoList) {
            String sourceBillKey = PushPayBillExecutorFactory.getSourceBillMapKey(paySchePayInfo.getSourceBillType(), paySchePayInfo.getSourceBillId());
            DynamicObject sourceBill = sourceBillMap.get(sourceBillKey);
            SinglePushPayBillExecutor pushExecutor = new SinglePushPayBillExecutor(sourceBill, paySchePayInfo);
            executorList.add(pushExecutor);
        }
        return executorList;
    }

    private static Map<String, DynamicObject> getSourceBillMap(List<PaySchePayInfo> payInfoList) {
        Map<String, List<PaySchePayInfo>> billTypeGrpMap = payInfoList.stream().collect(Collectors.groupingBy(PaySchePayInfo::getSourceBillType));
        HashMap<String, DynamicObject> sourceBillMap = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, List<PaySchePayInfo>> entry : billTypeGrpMap.entrySet()) {
            DynamicObject[] sourceBillArr;
            String sourceBillType = entry.getKey();
            Object[] sourceBillIdArr = entry.getValue().stream().map(PaySchePayInfo::getSourceBillId).toArray();
            for (DynamicObject sourceBill : sourceBillArr = BusinessDataServiceHelper.load((Object[])sourceBillIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)sourceBillType))) {
                String key = PushPayBillExecutorFactory.getSourceBillMapKey(sourceBillType, sourceBill.getPkValue());
                sourceBillMap.put(key, sourceBill);
            }
        }
        return sourceBillMap;
    }

    private static String getSourceBillMapKey(String sourceBillType, Object sourceBillId) {
        String splitSymbol = "_";
        return sourceBillType + "_" + sourceBillId;
    }
}

