/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push.action;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.fi.cas.business.paysche.push.IPushPayBillAction;
import kd.fi.cas.business.paysche.push.PushContext;
import kd.fi.cas.helper.CodeRuleHelper;

public class InitPayBillInfoAction
implements IPushPayBillAction {
    private PushContext context;

    public InitPayBillInfoAction(PushContext context) {
        this.context = context;
    }

    @Override
    public void execute() {
        for (DynamicObject payBill : this.context.getPayBillList()) {
            if (payBill.getPkValue() == null || Long.parseLong(payBill.getPkValue().toString()) == 0L) {
                payBill.set("id", (Object)DB.genLongId((String)payBill.getDataEntityType().getAlias()));
            }
            DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryList) {
                if (entry.get("id") != null && Long.parseLong(entry.getString("id")) != 0L) continue;
                entry.set("id", (Object)DB.genLongId((String)entryList.getDynamicObjectType().getAlias()));
            }
            if (payBill.getString("billno") != null) continue;
            String orgId = payBill.getDynamicObject("org").getString("id");
            String billNo = CodeRuleHelper.generateNumber((String)"cas_paybill", (DynamicObject)payBill, (String)orgId, null);
            payBill.set("billno", (Object)billNo);
        }
    }
}

