/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.push.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.cas.business.paysche.bean.PaySchePayInfo;
import kd.fi.cas.business.paysche.push.PushContext;
import kd.fi.cas.business.paysche.push.action.PushAction;

public class MultiPushAndCombineAction
extends PushAction {
    private PushContext context;
    private List<DynamicObject> sourceBillList;

    public MultiPushAndCombineAction(PushContext context, List<DynamicObject> sourceBillList) {
        this.context = context;
        this.sourceBillList = sourceBillList;
    }

    @Override
    public void execute() {
        ArrayList<DynamicObject> billPayBillList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> fundPayBillList = new ArrayList<DynamicObject>();
        Map<Long, List<PaySchePayInfo>> sourceBillIdGroupedInfo = this.context.getPayInfoList().stream().collect(Collectors.groupingBy(PaySchePayInfo::getSourceBillId));
        for (DynamicObject sourceBill : this.sourceBillList) {
            List<PaySchePayInfo> payInfoList = sourceBillIdGroupedInfo.get(sourceBill.getLong("id"));
            for (int i = 0; i < payInfoList.size(); ++i) {
                PaySchePayInfo payInfo = payInfoList.get(i);
                String sourceEntryId = payInfo.getSourceEntryId();
                if (payInfo.hasFundAmt()) {
                    DynamicObject fundPay = this.doPush(sourceBill, sourceEntryId);
                    fundPayBillList.add(fundPay);
                }
                if (!payInfo.hasBillAmt()) continue;
                DynamicObject billPay = this.doPush(sourceBill, sourceEntryId);
                billPayBillList.add(billPay);
            }
        }
        this.validateTargetPayBill(fundPayBillList);
        this.validateTargetPayBill(billPayBillList);
        if (fundPayBillList.size() > 0) {
            DynamicObject fundPay = this.combine(fundPayBillList);
            this.context.setFundPayBill(fundPay);
        }
        if (billPayBillList.size() > 0) {
            DynamicObject billPay = this.combine(billPayBillList);
            this.context.setBillPayBill(billPay);
        }
        if (this.context.getFundPayBill() == null && this.context.getBillPayBill() == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25", (String)"MultiPushAndCombineAction_01", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private void validateTargetPayBill(List<DynamicObject> payBillList) {
        for (DynamicObject payBill : payBillList) {
            Long sourceBillId = payBill.getLong("sourcebillid");
            String sourceBillType = payBill.getString("sourcebilltype");
            DynamicObjectCollection targetRows = payBill.getDynamicObjectCollection("billhead_lk");
            if (targetRows == null || targetRows.size() <= 0) continue;
            String errMsg = ResManager.loadKDString((String)"\u4ed8\u6b3e\u5931\u8d25\uff0c\u56e0\u4e3a\u5408\u5e76\u4ed8\u6b3e\u7684\u6392\u7a0b\u5355\u5bf9\u5e94\u7684\u4e1a\u52a1\u6e90\u5355[\u7c7b\u578b\uff1a%1$s\uff0cID\uff1a%2$s]\u975e\u5206\u5f55\u4e0b\u63a8\u3002", (String)"MultiPushAndCombineAction_02", (String)"fi-cas-business", (Object[])new Object[0]);
            throw new KDBizException(String.format(errMsg, sourceBillType, String.valueOf(sourceBillId)));
        }
    }

    private DynamicObject combine(List<DynamicObject> payBillList) {
        DynamicObject headBill = payBillList.get(0);
        DynamicObjectCollection entryList = headBill.getDynamicObjectCollection("entry");
        for (int i = 1; i < payBillList.size(); ++i) {
            DynamicObject targetBill = payBillList.get(i);
            entryList.addAll((Collection)targetBill.getDynamicObjectCollection("entry"));
        }
        return headBill;
    }
}

