/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paysche.serive;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.cas.business.helper.PaymentFillPropHelper;
import kd.fi.cas.business.paysche.bean.ChangeLinkInfo;
import kd.fi.cas.business.paysche.bean.ReleaseAmtInfo;
import kd.fi.cas.enums.PayScheOpType;
import kd.fi.cas.helper.OperateServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class ReleaseAmountService {
    private static Log logger = LogFactory.getLog(ReleaseAmountService.class);
    private List<DynamicObject> payBillList;
    private List<ReleaseAmtInfo> releaseAmtInfoList;
    private Set<Long> deletedPayIdSet;
    private Set<Long> deletedPayEntryIdSet;
    private PayScheOpType opType;
    private List<ChangeLinkInfo> changedLinkInfoList;
    private List<DynamicObject> releaseRecordList;
    private Set<Long> delPayApplyBillIds;
    Map<Long, BigDecimal> releaseEntryAmount = new HashMap<Long, BigDecimal>(16);
    List<DynamicObject> bakNeedDelPayBillList;

    public ReleaseAmountService(List<DynamicObject> payBillList, List<ReleaseAmtInfo> releaseAmtInfoList, PayScheOpType opType) {
        this.payBillList = payBillList;
        this.releaseAmtInfoList = releaseAmtInfoList;
        this.deletedPayIdSet = new HashSet<Long>();
        this.deletedPayEntryIdSet = new HashSet<Long>();
        this.changedLinkInfoList = new ArrayList<ChangeLinkInfo>();
        this.releaseRecordList = new ArrayList<DynamicObject>();
        this.opType = opType;
        this.delPayApplyBillIds = new HashSet<Long>(16);
        this.bakNeedDelPayBillList = new ArrayList<DynamicObject>(payBillList.size());
    }

    public void releaseAmt() {
        this.releaseAmt(false);
    }

    public void releaseAmt(boolean isDoPay) {
        MainEntityType recordType = EntityMetadataCache.getDataEntityType((String)"cas_paysche_record");
        for (ReleaseAmtInfo releaseInfo : this.releaseAmtInfoList) {
            BigDecimal releaseAmt = releaseInfo.getReleaseAmt();
            List waitReleasePayBillList = this.payBillList.stream().filter(o -> releaseInfo.getPayBillIdList().contains(o.getLong("id"))).sorted((o1, o2) -> -o1.getDate("createtime").compareTo(o2.getDate("createtime"))).collect(Collectors.toList());
            for (DynamicObject payBill : waitReleasePayBillList) {
                long payId = payBill.getLong("id");
                DynamicObject currency = payBill.getDynamicObject("currency");
                DynamicObjectCollection payBillEntryList = payBill.getDynamicObjectCollection("entry");
                for (DynamicObject payEntry : payBillEntryList) {
                    long entryId = payEntry.getLong("id");
                    boolean containsEntry = releaseInfo.getPayEntryIdList().contains(entryId);
                    if (!containsEntry) continue;
                    BigDecimal amtBefore = payEntry.getBigDecimal("e_payableamt");
                    BigDecimal currReleaseAmt = releaseAmt.abs().compareTo(amtBefore.abs()) > 0 ? amtBefore : releaseAmt;
                    long sourceEntryId = payEntry.getLong("e_sourcebillentryid");
                    BigDecimal entryAmount = this.releaseEntryAmount.get(sourceEntryId);
                    if (entryAmount == null) {
                        this.releaseEntryAmount.put(sourceEntryId, BigDecimal.ZERO);
                    }
                    entryAmount = this.releaseEntryAmount.get(sourceEntryId);
                    entryAmount = entryAmount.add(currReleaseAmt);
                    this.releaseEntryAmount.put(sourceEntryId, entryAmount);
                    releaseAmt = releaseAmt.subtract(currReleaseAmt);
                    BigDecimal amountAfter = amtBefore.subtract(currReleaseAmt);
                    payEntry.set("e_payableamt", (Object)amountAfter);
                    DynamicObject releaseRecord = new DynamicObject((DynamicObjectType)recordType);
                    releaseRecord.set("optype", (Object)this.opType.getValue());
                    releaseRecord.set("paybatchid", (Object)releaseInfo.getBatchPayId());
                    releaseRecord.set("payscheid", (Object)releaseInfo.getPayScheId());
                    releaseRecord.set("payid", (Object)payId);
                    releaseRecord.set("payentryid", (Object)entryId);
                    releaseRecord.set("currency", (Object)currency);
                    releaseRecord.set("payamount", (Object)currReleaseAmt);
                    releaseRecord.set("amountbefore", (Object)amtBefore);
                    releaseRecord.set("amountafter", (Object)amountAfter);
                    releaseRecord.set("createtime", (Object)new Date());
                    this.releaseRecordList.add(releaseRecord);
                    if (releaseAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                    break;
                }
                for (DynamicObject entry : payBillEntryList) {
                    boolean isDeleted = entry.getBigDecimal("e_payableamt").compareTo(BigDecimal.ZERO) == 0;
                    if (!isDeleted) continue;
                    this.deletedPayEntryIdSet.add(entry.getLong("id"));
                }
                this.delPayApplyBillIds.addAll(payBillEntryList.stream().filter(o -> o.getBigDecimal("e_payableamt").compareTo(BigDecimal.ZERO) == 0).map(v -> v.getLong("e_sourcebillid")).collect(Collectors.toSet()));
                payBillEntryList.removeIf(o -> o.getBigDecimal("e_payableamt").compareTo(BigDecimal.ZERO) == 0);
            }
            this.deletedPayIdSet.addAll(this.payBillList.stream().filter(o -> o.getDynamicObjectCollection("entry").size() == 0).map(o -> o.getLong("id")).collect(Collectors.toList()));
            this.payBillList.removeIf(o -> o.getDynamicObjectCollection("entry").size() == 0);
        }
        this.fixPayBillInfo(this.payBillList);
        try (TXHandle tx = TX.requiresNew();){
            try {
                if (this.releaseRecordList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])this.releaseRecordList.toArray(new DynamicObject[0]));
                }
                if (this.payBillList.size() > 0) {
                    OperationResult result;
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("isSchePush", "true");
                    option.setVariableValue("strictvalidation", "true");
                    this.addOperationParams(this.releaseEntryAmount, option);
                    option.setVariableValue("isStrict", "false");
                    if (PayScheOpType.BACK.getValue().equals(this.opType.getValue()) || PayScheOpType.DELETE.getValue().equals(this.opType.getValue())) {
                        option.setVariableValue("backReason", this.getBackReason());
                    }
                    if (!(result = OperateServiceHelper.execOperate((String)"save", (String)"cas_paybill", (DynamicObject[])this.payBillList.toArray(new DynamicObject[0]), (OperateOption)option)).isSuccess()) {
                        throw new KDBizException(OperateServiceHelper.decodeErrorMsg((OperationResult)result));
                    }
                }
                if (!this.deletedPayIdSet.isEmpty()) {
                    if (isDoPay) {
                        DynamicObject[] needDelPayBills;
                        QFilter qFilter = new QFilter("id", "in", this.deletedPayIdSet);
                        for (DynamicObject needDelPayBill : needDelPayBills = BusinessDataServiceHelper.load((String)"cas_paybill", (String)"id,actpayamt,entry.id,entry.e_payableamt", (QFilter[])qFilter.toArray())) {
                            DynamicObject cloneDelPayBill = (DynamicObject)OrmUtils.clone((Object)needDelPayBill, (IDataEntityType)needDelPayBill.getDataEntityType(), (boolean)true, (boolean)false);
                            this.bakNeedDelPayBillList.add(cloneDelPayBill);
                        }
                        for (DynamicObject needDelPayBill : needDelPayBills) {
                            needDelPayBill.set("actpayamt", (Object)BigDecimal.ZERO);
                            DynamicObjectCollection entryList = needDelPayBill.getDynamicObjectCollection("entry");
                            for (DynamicObject entryObj : entryList) {
                                entryObj.set("e_payableamt", (Object)BigDecimal.ZERO);
                            }
                        }
                        SaveServiceHelper.update((DynamicObject[])needDelPayBills);
                    } else {
                        OperationResult result = this.doDelOldPayBills();
                        if (!result.isSuccess()) {
                            throw new KDBizException(OperateServiceHelper.decodeErrorMsg((OperationResult)result));
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                tx.markRollback();
                this.deletedPayIdSet.clear();
                this.deletedPayEntryIdSet.clear();
                throw e;
            }
        }
    }

    private String getBackReason() {
        ReleaseAmtInfo releaseAmtInfo;
        if (this.releaseAmtInfoList == null || (releaseAmtInfo = this.releaseAmtInfoList.get(0)) == null || StringUtils.isBlank((CharSequence)releaseAmtInfo.getBackReason())) {
            String reason = ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u9000\u5355", (String)"ReleaseAmountService_01", (String)"fi-cas-business", (Object[])new Object[0]);
            if ("delete".equals(this.opType.getOp())) {
                reason = ResManager.loadKDString((String)"\u6392\u7a0b\u5355\u5220\u9664", (String)"ReleaseAmountService_02", (String)"fi-cas-business", (Object[])new Object[0]);
            }
            return reason;
        }
        return releaseAmtInfo.getBackReason();
    }

    public List<ChangeLinkInfo> getChangedLinkInfoList() {
        return this.changedLinkInfoList;
    }

    public Set<Long> getDeletedPayEntryIdSet() {
        return this.deletedPayEntryIdSet;
    }

    public Set<Long> getReleaseAmountPayScheIdSet() {
        return this.releaseAmtInfoList.stream().map(ReleaseAmtInfo::getPayScheId).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private void fixPayBillInfo(List<DynamicObject> payBillList) {
        for (DynamicObject payBill : payBillList) {
            PaymentFillPropHelper.fillProp(payBill);
        }
    }

    private void addOperationParams(Map<Long, BigDecimal> releaseEntryAmount, OperateOption option) {
        if (releaseEntryAmount.size() <= 0) {
            return;
        }
        String releaseEntry = JSONObject.toJSONString(releaseEntryAmount);
        String delPayAllyBillIdStr = JSONObject.toJSONString(this.delPayApplyBillIds);
        option.setVariableValue("isPayScheBack", "true");
        option.setVariableValue("payScheRelease", releaseEntry);
        option.setVariableValue("payScheOPType", this.opType.getOp());
        option.setVariableValue("delPayApplyBillIds", delPayAllyBillIdStr);
    }

    public OperationResult doDelOldPayBills() {
        if (this.deletedPayIdSet.isEmpty()) {
            OperationResult result = new OperationResult();
            result.setSuccess(true);
            return result;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("strictvalidation", "true");
        option.setVariableValue("isdelbypaysche", "true");
        option.setVariableValue("entityname", "cas_paybill");
        option.setVariableValue("dealbypsd", "y");
        this.addOperationParams(this.releaseEntryAmount, option);
        option.setVariableValue("isStrict", "false");
        String reason = this.getBackReason();
        option.setVariableValue("reason", reason);
        return OperateServiceHelper.execOperate((String)this.opType.getOp(), (String)"cas_paybill", (Object[])this.deletedPayIdSet.toArray(), (OperateOption)option);
    }

    public void rollbackReleaseAmt() {
        if (!this.releaseRecordList.isEmpty()) {
            Map<Long, List<DynamicObject>> recordGroupByPayBill = this.releaseRecordList.stream().collect(Collectors.groupingBy(r -> r.getLong("payid")));
            ArrayList<DynamicObject> payBillList = new ArrayList<DynamicObject>(recordGroupByPayBill.size());
            for (Map.Entry<Long, List<DynamicObject>> recordEn : recordGroupByPayBill.entrySet()) {
                DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)recordEn.getKey(), (String)"cas_paybill");
                DynamicObjectCollection entryList = payBill.getDynamicObjectCollection("entry");
                List<DynamicObject> recordList = recordEn.getValue();
                block1: for (DynamicObject record : recordList) {
                    for (DynamicObject payEntry : entryList) {
                        if (record.getLong("payentryid") != payEntry.getLong("id")) continue;
                        payEntry.set("e_payableamt", (Object)record.getBigDecimal("amountbefore"));
                        continue block1;
                    }
                }
                payBillList.add(payBill);
            }
            this.fixPayBillInfo(payBillList);
            SaveServiceHelper.save((DynamicObject[])payBillList.toArray(new DynamicObject[0]));
            if (CollectionUtils.isNotEmpty(this.bakNeedDelPayBillList)) {
                SaveServiceHelper.update((DynamicObject[])this.bakNeedDelPayBillList.toArray(new DynamicObject[0]));
            }
        }
    }
}

