/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.paywarning;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.paywarning.PayWarningResult;
import kd.fi.cas.business.paywarning.TransDetailFilterInfo;
import kd.fi.cas.enums.PayWarmNodeEnum;
import kd.fi.cas.helper.AgentPayBillHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.CasPluginHelper;
import kd.fi.cas.helper.SimpleBeanFactory;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class PayWarningHelper {
    private static final Log logger = LogFactory.getLog(PayWarningHelper.class);

    public static void ctlSubmitOpUnSaveCase(DynamicObject info, String entityKey, AbstractFormPlugin plugin, String beforeOpKey) {
        String afterOpKey = PayWarmNodeEnum.getName((String)beforeOpKey);
        PayWarningHelper helper = (PayWarningHelper)SimpleBeanFactory.getBean(PayWarningHelper.class);
        long beginTime = System.currentTimeMillis();
        Collection<PayWarningResult> results = helper.getEarlyWarningResults(info, entityKey, afterOpKey);
        long endTime = System.currentTimeMillis();
        logger.info(String.format("\u4ed8\u6b3e\u9884\u8b66\u6027\u80fd\u76d1\u63a7\uff0c\u5355\u636e\u7c7b\u578b\uff1a%s\uff0c\u8017\u65f6\uff1a%sms", entityKey, endTime - beginTime));
        HashMap map = new HashMap();
        results.forEach(each -> {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)map.get(each.getBillno());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>();
            }
            list.add(each.getDetailInfo());
            map.put(each.getBillno(), list);
        });
        if (results.isEmpty()) {
            plugin.getView().invokeOperation(afterOpKey);
        } else {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("parentFormID", entityKey);
            m.put("payWarningMap", map);
            CasPluginHelper.createShowDynForm((String)"cas_paywarning", m, (AbstractFormPlugin)plugin, (String)beforeOpKey);
        }
    }

    public static void ctlSubmitAndcommitbe(List<Object> pks, String entityKey, AbstractFormPlugin plugin, String beforeOpKey) {
        String afterOpKey = PayWarmNodeEnum.getName((String)beforeOpKey);
        PayWarningHelper helper = (PayWarningHelper)SimpleBeanFactory.getBean(PayWarningHelper.class);
        long beginTime = System.currentTimeMillis();
        Collection<PayWarningResult> results = PayWarningHelper.getEarlyWarningResults(pks, entityKey, afterOpKey);
        long endTime = System.currentTimeMillis();
        logger.info(String.format("\u4ed8\u6b3e\u9884\u8b66\u6027\u80fd\u76d1\u63a7\uff0c\u5355\u636e\u7c7b\u578b\uff1a%s\uff0c\u6570\u91cf\uff1a%s\uff0c\u8017\u65f6\uff1a%sms", entityKey, pks.size(), endTime - beginTime));
        HashMap map = new HashMap();
        results.forEach(each -> {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)map.get(each.getBillno());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>();
            }
            list.add(each.getDetailInfo());
            map.put(each.getBillno(), list);
        });
        if (results.isEmpty()) {
            plugin.getView().invokeOperation(afterOpKey);
        } else {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("parentFormID", entityKey);
            m.put("payWarningMap", map);
            CasPluginHelper.createShowDynForm((String)"cas_paywarning", m, (AbstractFormPlugin)plugin, (String)beforeOpKey);
        }
    }

    private Collection<PayWarningResult> getEarlyWarningResults(DynamicObject info, String entityKey, String opKey) {
        HashSet<PayWarningResult> results = new HashSet<PayWarningResult>(16);
        QFilter filters = new QFilter("billtype", "=", (Object)entityKey).and(new QFilter("entry.org", "in", (Object)new Object[]{info.getDynamicObject("org").getPkValue(), 0L})).and(new QFilter("enable", "=", (Object)"1"));
        if (PayWarmNodeEnum.SUBMIT.getName().equals(opKey)) {
            filters.and(new QFilter("issubmit", "=", (Object)"1"));
        } else if (PayWarmNodeEnum.COMMITBE.getName().equals(opKey)) {
            filters.and(new QFilter("iscombei", "=", (Object)"1"));
        }
        DynamicObjectCollection warningSettings = QueryServiceHelper.query((String)"cas_paywarnset", (String)PayWarningHelper.getSettingSelectors(), (QFilter[])new QFilter[]{filters});
        if (warningSettings == null || warningSettings.size() == 0) {
            return results;
        }
        DynamicObjectCollection entryDOCs = info.getDynamicObjectCollection("entry");
        for (DynamicObject entryDOC : entryDOCs) {
            for (DynamicObject setting : warningSettings) {
                results.addAll(PayWarningHelper.getPayWarningInfos(info, entryDOC, setting));
            }
        }
        return results;
    }

    private static Collection<PayWarningResult> getEarlyWarningResults(List<Object> pks, String entityKey, String opKey) {
        HashSet<PayWarningResult> results = new HashSet<PayWarningResult>(16);
        for (Object pk : pks) {
            DynamicObjectCollection bizBills = QueryServiceHelper.query((String)entityKey, (String)PayWarningHelper.getSelectors(entityKey), (QFilter[])new QFilter[]{new QFilter("id", "=", pk)});
            if (CollectionUtils.isEmpty((Collection)bizBills)) {
                return results;
            }
            QFilter filters = new QFilter("billtype", "=", (Object)entityKey).and(new QFilter("entry.org", "in", (Object)new Object[]{((DynamicObject)bizBills.get(0)).getLong("org"), 0L})).and(new QFilter("enable", "=", (Object)"1"));
            if (PayWarmNodeEnum.SUBMIT.getName().equals(opKey)) {
                filters.and(new QFilter("issubmit", "=", (Object)"1"));
            } else if (PayWarmNodeEnum.COMMITBE.getName().equals(opKey)) {
                filters.and(new QFilter("iscombei", "=", (Object)"1"));
            }
            DynamicObjectCollection warningSettings = QueryServiceHelper.query((String)"cas_paywarnset", (String)PayWarningHelper.getSettingSelectors(), (QFilter[])new QFilter[]{filters});
            if (warningSettings == null || warningSettings.size() == 0) {
                return results;
            }
            for (DynamicObject bizBill : bizBills) {
                for (DynamicObject setting : warningSettings) {
                    results.addAll(PayWarningHelper.getPayWarningInfos(bizBill, null, setting));
                }
            }
        }
        return results;
    }

    private static String getSettingSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(10);
        selectors.add("billtype");
        selectors.add("checkdays");
        selectors.add("issamepayee");
        selectors.add("issamepayeebanknum");
        selectors.add("issamepayerbanknum");
        selectors.add("issamepayamt");
        selectors.add("issameusage");
        selectors.add("issamesettletype");
        selectors.add("issubmit");
        selectors.add("iscombei");
        return String.join((CharSequence)",", selectors);
    }

    private static String getSelectors(String billType) {
        ArrayList<String> lst = new ArrayList<String>(10);
        lst.add("org");
        if ("cas_paybill".equals(billType)) {
            lst.add("billno");
            lst.add("recaccbankname");
            lst.add("payeename");
            lst.add("payeebanknum");
            lst.add("payeracctbank.bankaccountnumber");
            lst.add("settletype.id");
            lst.add("actpayamt");
            lst.add("usage");
        } else if ("cas_agentpaybill".equals(billType)) {
            lst.add("billno");
            lst.add("entry.seq");
            lst.add("entry.payeename");
            lst.add("entry.payeeacctbank");
            lst.add("payeracctbank.bankaccountnumber");
            lst.add("settletype.id");
            lst.add("entry.e_encryptamount");
            lst.add("entry.e_remark");
        }
        return String.join((CharSequence)",", lst);
    }

    private static Set<PayWarningResult> getPayWarningInfos(DynamicObject payableBill, DynamicObject entryInfo, DynamicObject warningConf) {
        int checkDays = warningConf.getInt("checkdays");
        Date currentDate = DateUtils.getDataFormat((Date)new Date(), (boolean)true);
        Date beginDate = DateUtils.getNextDay((Date)currentDate, (int)(checkDays * -1));
        Date endDate = DateUtils.getDataFormat((Date)currentDate, (boolean)false);
        String billType = warningConf.getString("billtype");
        TransDetailFilterInfo filter = PayWarningHelper.getFilter(payableBill, entryInfo, beginDate, endDate, billType);
        List<Map<String, Object>> list = PayWarningHelper.getTransDetails(filter, warningConf);
        HashSet<PayWarningResult> results = new HashSet<PayWarningResult>(list.size());
        for (Map<String, Object> detail : list) {
            PayWarningResult payWarningResult = new PayWarningResult();
            payWarningResult.setEntityKey(billType);
            payWarningResult.setDetailPk(detail.get("pk"));
            payWarningResult.setDetailInfo(detail);
            if ("cas_paybill".equals(billType)) {
                payWarningResult.setBillno(payableBill.getString("billno"));
            } else if (!EmptyUtil.isEmpty((DynamicObject)entryInfo)) {
                payWarningResult.setBillno(payableBill.getString("billno") + "|" + entryInfo.get("seq"));
            } else {
                payWarningResult.setBillno(payableBill.getString("billno") + "|" + payableBill.getString("entry.seq"));
            }
            results.add(payWarningResult);
        }
        return results;
    }

    private static List<Map<String, Object>> getTransDetails(TransDetailFilterInfo filter, DynamicObject warningConf) {
        String selector;
        DynamicObjectCollection coll;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        QFilter beginDateFilter = new QFilter("bizdate", ">=", (Object)filter.getBeginDate());
        QFilter endDateFilter = new QFilter("bizdate", "<=", (Object)filter.getEndDate());
        QFilter detailQueryFilters = new QFilter("debitamount", ">", (Object)0).and(beginDateFilter).and(endDateFilter);
        if (warningConf.getBoolean("issamepayee")) {
            detailQueryFilters.and("oppunit", "=", (Object)filter.getPayee());
        }
        if (warningConf.getBoolean("issamepayeebanknum")) {
            detailQueryFilters.and("oppbanknumber", "=", (Object)filter.getPayeeBankNum());
        }
        if (warningConf.getBoolean("issamepayerbanknum")) {
            detailQueryFilters.and("accountbank.bankaccountnumber", "=", (Object)filter.getPayerBankNum());
        }
        if (warningConf.getBoolean("issamepayamt")) {
            detailQueryFilters.and("debitamount", "=", (Object)filter.getPayAmt());
        }
        if (warningConf.getBoolean("issameusage")) {
            detailQueryFilters.and("description", "=", (Object)filter.getUsage());
        }
        if ((coll = QueryServiceHelper.query((String)"bei_transdetail_cas", (String)(selector = "id,bizdate, oppunit, oppbanknumber, accountbank.bankaccountnumber, debitamount, description,bizrefno"), (QFilter[])new QFilter[]{detailQueryFilters})) != null && coll.size() > 0) {
            list = new ArrayList();
            for (DynamicObject transdetail : coll) {
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("bizDate", transdetail.getDate("bizdate"));
                m.put("payee", transdetail.getString("oppunit"));
                m.put("payeeBankNum", transdetail.getString("oppbanknumber"));
                m.put("payerBankNum", transdetail.getString("accountbank.bankaccountnumber"));
                m.put("payAmt", transdetail.getBigDecimal("debitamount"));
                m.put("usage", transdetail.getString("description"));
                m.put("bizrefno", transdetail.getString("bizrefno"));
                m.put("pk", transdetail.getLong("id"));
                list.add(m);
            }
        }
        return list;
    }

    private static TransDetailFilterInfo getFilter(DynamicObject bizbill, DynamicObject entryInfo, Date beginDate, Date endDate, String billType) {
        TransDetailFilterInfo filter = new TransDetailFilterInfo();
        filter.setBeginDate(beginDate);
        filter.setEndDate(endDate);
        Object settletype = bizbill.get("settletype.id");
        if ("PlainObject".equals(bizbill.getDynamicObjectType().getName())) {
            if ("cas_paybill".equals(billType)) {
                String recAccBankName = bizbill.getString("recaccbankname");
                if (CasHelper.isEmpty((Object)recAccBankName)) {
                    filter.setPayee(bizbill.getString("payeename"));
                } else {
                    filter.setPayee(recAccBankName);
                }
                filter.setPayeeBankNum(bizbill.getString("payeebanknum"));
                filter.setPayerBankNum(bizbill.getString("payeracctbank.bankaccountnumber"));
                filter.setSettletype(settletype == null ? "" : settletype.toString());
                filter.setPayAmt(bizbill.getBigDecimal("actpayamt"));
                filter.setUsage(bizbill.getString("usage"));
            } else {
                filter.setPayee(bizbill.getString("entry.payeename"));
                filter.setPayeeBankNum(bizbill.getString("entry.payeeacctbank"));
                filter.setPayerBankNum(bizbill.getString("payeracctbank.bankaccountnumber"));
                filter.setSettletype(settletype == null ? "" : settletype.toString());
                String encryptAmount = bizbill.getString("entry.e_encryptamount");
                BigDecimal amount = AgentPayBillHelper.decodeAmount((String)encryptAmount);
                filter.setPayAmt(amount);
                filter.setUsage(bizbill.getString("entry.e_remark"));
            }
        } else if (!EmptyUtil.isEmpty((String)billType) && billType.equals(bizbill.getDynamicObjectType().getName())) {
            if ("cas_paybill".equals(billType)) {
                String recAccBankName = bizbill.getString("recaccbankname");
                if (CasHelper.isEmpty((Object)recAccBankName)) {
                    filter.setPayee(bizbill.getString("payeename"));
                } else {
                    filter.setPayee(recAccBankName);
                }
                filter.setPayeeBankNum(bizbill.getString("payeebanknum"));
                filter.setPayerBankNum(bizbill.getString("payeracctbank.bankaccountnumber"));
                filter.setSettletype(settletype == null ? "" : settletype.toString());
                filter.setPayAmt(bizbill.getBigDecimal("actpayamt"));
                filter.setUsage(bizbill.getString("usage"));
            } else {
                filter.setPayee(entryInfo.getString("payeename"));
                filter.setPayeeBankNum(entryInfo.getString("payeeacctbank"));
                filter.setPayerBankNum(bizbill.get("payeracctbank.bankaccountnumber") + "");
                filter.setSettletype(settletype == null ? "" : settletype.toString());
                String encryptAmount = entryInfo.getString("e_encryptamount");
                BigDecimal amount = AgentPayBillHelper.decodeAmount((String)encryptAmount);
                filter.setPayAmt(amount);
                filter.setUsage(entryInfo.getString("e_remark"));
            }
        }
        return filter;
    }
}

