/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.recpayrule;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.recpayrule.IRecPayRuleService;
import kd.fi.cas.compare.concurrent.SplitThreadOperationExecutor;

public class PersistenceInvocationHandler
implements InvocationHandler {
    private static final Log LOGGER = LogFactory.getLog(PersistenceInvocationHandler.class);
    private IRecPayRuleService recPayRuleService;
    private ReentrantLock lock = new ReentrantLock(true);

    public PersistenceInvocationHandler(IRecPayRuleService recPayRuleService) {
        this.recPayRuleService = recPayRuleService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List resultBeanList = (List)method.invoke((Object)this.recPayRuleService, args);
        ArrayList saveList = new ArrayList(10);
        resultBeanList.forEach(matchResultBean -> {
            if (!Objects.equals(matchResultBean.getNewRuleName(), matchResultBean.getOldRuleName())) {
                DynamicObject detail = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bei_transdetail_cas"));
                detail.set("id", matchResultBean.getId());
                detail.set("rulename", (Object)matchResultBean.getNewRuleName());
                saveList.add(detail);
            }
        });
        this.lock.lock();
        try (TXHandle tx = TX.requiresNew();){
            new SplitThreadOperationExecutor().doBatchOperation(saveList, 1000, splitDataList -> {
                LOGGER.info("\u5f02\u6b65\u8c03\u7528\u66f4\u65b0\u5f00\u59cb,{}:{}:{}", new Object[]{splitDataList.size(), Thread.currentThread().getName(), Thread.currentThread().getId()});
                if (!splitDataList.isEmpty()) {
                    SaveServiceHelper.update((DynamicObject[])splitDataList.toArray(new DynamicObject[0]));
                }
                return null;
            });
        }
        finally {
            this.lock.unlock();
        }
        return resultBeanList;
    }
}

