/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.refund;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.consts.DBRouteConst;
import kd.fi.cas.helper.AgentPayBillHelper;

public class CasRefundUpgrade
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CasRefundUpgrade.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        result.setLog("kd.fi.cas.business.refund.CasRefundUpgrade");
        try {
            result.setLog(ResManager.loadKDString((String)"\u5f00\u59cb\u6267\u884c\u51fa\u7eb3\u591a\u6b21\u9000\u6b3e\u9000\u7968\u5386\u53f2\u6570\u636e\u5347\u7ea7\u3002", (String)"CasRefundUpgrade_1", (String)"fi-cas-business", (Object[])new Object[0]));
            CasRefundUpgrade.updatePayBill();
            CasRefundUpgrade.updateAgentBill();
            result.setLog(ResManager.loadKDString((String)"\u6267\u884c\u51fa\u7eb3\u591a\u6b21\u9000\u6b3e\u9000\u7968\u5386\u53f2\u6570\u636e\u5347\u7ea7\u5b8c\u6bd5\u3002", (String)"CasRefundUpgrade_2", (String)"fi-cas-business", (Object[])new Object[0]));
        }
        catch (Exception e) {
            logger.error("refund update history error", (Throwable)e);
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        return result;
    }

    private static void updatePayBill() {
        block47: {
            String sql = "SELECT MIN(fid) as minid,MAX(fid) as maxid FROM T_CAS_PaymentBill where fbillstatus in ('F','I')";
            try (DataSet minMaxSet = DB.queryDataSet((String)"queryPayIdMinMax", (DBRoute)DBRouteConst.cas, (String)sql);){
                if (!minMaxSet.hasNext()) break block47;
                Row minMaxRow = minMaxSet.next();
                Long minid = minMaxRow.getLong("minid");
                Long maxid = minMaxRow.getLong("maxid");
                logger.info("\u9000\u6b3e\u9000\u7968\u66f4\u65b0\u4ed8\u6b3e\u5355\u5386\u53f2\u6570\u636e,\u6700\u5927id:" + maxid + ",\u6700\u5c0fid:" + minid);
                if (minid == null || maxid == null) {
                    return;
                }
                long size = (maxid - minid) / 1000L;
                if (size == 0L) {
                    size = 1L;
                }
                long start = minid;
                int batchNo = 0;
                while (start <= maxid) {
                    long end = start + size;
                    if (end > maxid) {
                        end = maxid;
                    }
                    try (TXHandle tx = TX.requiresNew();){
                        String sqlNeedUpdateIds = "SELECT a.fid,a.fexchangerate,e.fpayquotation FROM T_CAS_PaymentBill a inner join T_CAS_PaymentBill_e e on a.fid = e.fid where a.fbillstatus in ('F','I') and a.fid >= ? and a.fid <= ?";
                        Object[] param = new Object[]{start, end};
                        ArrayList<Object[]> headParamList = null;
                        try (DataSet canRefundPayBills = DB.queryDataSet((String)"queryCanRefundPayBills", (DBRoute)DBRouteConst.cas, (String)sqlNeedUpdateIds, (Object[])param);){
                            logger.info("\u66f4\u65b0\u4ed8\u6b3e\u5355\u6279\u6b21:" + batchNo);
                            ArrayList<Object[]> entryParamList = new ArrayList<Object[]>(1000);
                            headParamList = new ArrayList<Object[]>(1000);
                            for (Row billRow : canRefundPayBills) {
                                Long payId = billRow.getLong("fid");
                                String entryQuerySql = "select fentryid,fpayableamount,frefundamt from T_CAS_PaymentBillEntry where fid = ?";
                                DataSet entryDataSet = DB.queryDataSet((String)"queryCanRefundEntrys", (DBRoute)DBRouteConst.cas, (String)entryQuerySql, (Object[])new Object[]{payId});
                                BigDecimal payableAmountSum = BigDecimal.ZERO;
                                BigDecimal totalRefundedAmt = BigDecimal.ZERO;
                                for (Row entryRow : entryDataSet) {
                                    Long entryId = entryRow.getLong("fentryid");
                                    BigDecimal payableAmount = entryRow.getBigDecimal("fpayableamount");
                                    BigDecimal refundAmt = entryRow.getBigDecimal("frefundamt");
                                    BigDecimal remainRefundAmt = payableAmount.subtract(refundAmt);
                                    payableAmountSum = payableAmountSum.add(payableAmount);
                                    totalRefundedAmt = totalRefundedAmt.add(refundAmt);
                                    entryParamList.add(new Object[]{remainRefundAmt, entryId});
                                }
                                String payQuotation = billRow.getString("fpayquotation");
                                Object[] billUpdateParams = CasRefundUpgrade.buildBillParams(billRow, payableAmountSum, totalRefundedAmt, payId, payQuotation);
                                headParamList.add(billUpdateParams);
                                entryDataSet.close();
                            }
                            if (!headParamList.isEmpty()) {
                                String billUpdateSql = "update T_CAS_PaymentBill set ftotalrefundedamt = ?,ftotalremainrefundamt = ?,flocalrefundedamt = ?,flocalremainrefundamt = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)billUpdateSql, headParamList);
                            }
                            if (!entryParamList.isEmpty()) {
                                String entryUpdateSql = "update T_CAS_PaymentBillEntry set feremainrefundamt = ? where fentryid = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)entryUpdateSql, entryParamList);
                            }
                        }
                        tx.commit();
                        logger.info("\u66f4\u65b0\u4ed8\u6b3e\u5355\u7b2c" + batchNo + "\u6279\u6b21,\u5b8c\u6210\u66f4\u65b0\u7684\u6570\u91cf:" + headParamList.size());
                        ++batchNo;
                    }
                    start = end + 1L;
                }
            }
        }
    }

    private static void updateAgentBill() {
        block47: {
            String sql = "SELECT MIN(fid) as minid,MAX(fid) as maxid FROM T_CAS_AgentPayBillEntry where fissuccess = '1'";
            try (DataSet minMaxSet = DB.queryDataSet((String)"queryAgentIdMinMax", (DBRoute)DBRouteConst.cas, (String)sql);){
                if (!minMaxSet.hasNext()) break block47;
                Row minMaxRow = minMaxSet.next();
                Long maxid = minMaxRow.getLong("maxid");
                Long minid = minMaxRow.getLong("minid");
                logger.info("\u9000\u6b3e\u9000\u7968\u66f4\u65b0\u4ee3\u53d1\u5355\u5386\u53f2\u6570\u636e,\u6700\u5927id:" + maxid + ",\u6700\u5c0fid:" + minid);
                if (minid == null || maxid == null) {
                    return;
                }
                long size = (maxid - minid) / 1000L;
                if (size == 0L) {
                    size = 1L;
                }
                int batchNo = 0;
                long start = minid;
                while (start <= maxid) {
                    long end = start + size;
                    if (end > maxid) {
                        end = maxid;
                    }
                    try (TXHandle tx = TX.requiresNew();){
                        String queryAgentBillSql = "SELECT a.fid as fid,a.fexchangerate as fexchangerate FROM T_CAS_AgentPayBill a inner join T_CAS_AgentPayBillEntry e on a.fid = e.fid where a.fid >= ? and a.fid <= ? and e.fissuccess = '1' group by a.fid,a.fexchangerate";
                        try (DataSet agentBillSet = DB.queryDataSet((String)"queryNeedUpdateAgentBills", (DBRoute)DBRouteConst.cas, (String)queryAgentBillSql, (Object[])new Object[]{start, end});){
                            logger.info("\u66f4\u65b0\u4ee3\u53d1\u5355\u6279\u6b21:" + batchNo);
                            ArrayList<Object[]> headParamList = new ArrayList<Object[]>(1000);
                            ArrayList<Object[]> entryParamList = new ArrayList<Object[]>(1000);
                            for (Row agentRow : agentBillSet) {
                                Long agentId = agentRow.getLong("fid");
                                String needUpdateEntrySql = "select fid,fentryid,famount,frefundamt from T_CAS_AgentPayBillEntry where fissuccess = '1' and fid = ?";
                                DataSet agentEntrySet = DB.queryDataSet((String)"queryNeedUpdateAgentEntrys", (DBRoute)DBRouteConst.cas, (String)needUpdateEntrySql, (Object[])new Object[]{agentId});
                                BigDecimal amtSum = BigDecimal.ZERO;
                                BigDecimal totalRefundedAmt = BigDecimal.ZERO;
                                for (Row agentEntry : agentEntrySet) {
                                    Long entryId = agentEntry.getLong("fentryid");
                                    BigDecimal amt = AgentPayBillHelper.decodeAmount((String)agentEntry.getString("famount"));
                                    BigDecimal refundAmt = agentEntry.getBigDecimal("frefundamt");
                                    BigDecimal remainRefundAmt = amt.subtract(refundAmt);
                                    amtSum = amtSum.add(amt);
                                    totalRefundedAmt = totalRefundedAmt.add(refundAmt);
                                    entryParamList.add(new Object[]{remainRefundAmt, entryId});
                                }
                                DynamicObject agentDyObj = BusinessDataServiceHelper.loadSingle((Object)agentId, (String)"cas_agentpaybill", (String)"payquotation");
                                Object[] billUpdateParams = CasRefundUpgrade.buildBillParams(agentRow, amtSum, totalRefundedAmt, agentId, agentDyObj.getString("payquotation"));
                                headParamList.add(billUpdateParams);
                                agentEntrySet.close();
                            }
                            if (!headParamList.isEmpty()) {
                                String billUpdateSql = "update T_CAS_AgentPayBill set ftotalrefundedamt = ?,ftotalremainrefundamt = ?,flocalrefundedamt = ?,flocalremainrefundamt = ? where fid = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)billUpdateSql, headParamList);
                            }
                            logger.info("\u5b8c\u6210\u66f4\u65b0\u4ee3\u53d1\u5355\u5355\u5934\u7b2c" + batchNo + "\u6279\u6b21,\u66f4\u65b0\u6570\u91cf:" + headParamList.size());
                            if (!entryParamList.isEmpty()) {
                                String entryUpdateSql = "update T_CAS_AgentPayBillEntry set feremainrefundamt = ? where fentryid = ?";
                                DB.executeBatch((DBRoute)DBRouteConst.cas, (String)entryUpdateSql, entryParamList);
                            }
                            logger.info("\u5b8c\u6210\u66f4\u65b0\u4ee3\u53d1\u5355\u5206\u5f55\u7b2c" + batchNo + "\u6279\u6b21,\u66f4\u65b0\u7684\u6570\u91cf:" + entryParamList.size());
                        }
                        tx.commit();
                    }
                    start = end + 1L;
                }
            }
        }
    }

    private static Object[] buildBillParams(Row billRow, BigDecimal amtSum, BigDecimal totalRefundedAmt, Long billId, String payQuotation) {
        BigDecimal localRemainRefundAmt;
        BigDecimal localRefundedAmt;
        BigDecimal exchangeRate = billRow.getBigDecimal("fexchangerate");
        if (exchangeRate == null || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        BigDecimal totalRemainRefundAmt = amtSum.subtract(totalRefundedAmt);
        if ("0".equals(payQuotation)) {
            localRefundedAmt = totalRefundedAmt.multiply(exchangeRate);
            localRemainRefundAmt = totalRemainRefundAmt.multiply(exchangeRate);
        } else {
            localRefundedAmt = totalRefundedAmt.divide(exchangeRate, 10, RoundingMode.DOWN);
            localRemainRefundAmt = totalRemainRefundAmt.divide(exchangeRate, 10, RoundingMode.DOWN);
        }
        return new Object[]{totalRefundedAmt, totalRemainRefundAmt, localRefundedAmt, localRemainRefundAmt, billId};
    }

    public static class AgentEntryData {
        private Long entryId;
        private BigDecimal amount;
        private BigDecimal refundAmt;

        public AgentEntryData(Long entryId, BigDecimal amount, BigDecimal refundAmt) {
            this.entryId = entryId;
            this.amount = amount;
            this.refundAmt = refundAmt;
        }

        public Long getEntryId() {
            return this.entryId;
        }

        public void setEntryId(Long entryId) {
            this.entryId = entryId;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public BigDecimal getRefundAmt() {
            return this.refundAmt;
        }

        public void setRefundAmt(BigDecimal refundAmt) {
            this.refundAmt = refundAmt;
        }
    }
}

