/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.schedule;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.journal.BankJournalDownloadService;
import kd.fi.cas.pojo.BankJournalDownload;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BankJournalDownloadSchedule {
    private static final Log logger = LogFactory.getLog(BankJournalDownloadSchedule.class);
    private static final int PERIOD_ZERO = 0;
    private static final int PERIOD_ONE = 1;
    private static final int MAX_PERIOD = 90;

    public static BankJournalDownloadSchedule getInstance() {
        return Singleton.instance;
    }

    public void download(List<Long> accountBankIds, int period) throws Exception {
        Date endDate;
        Date beginDate;
        if (period > 90) {
            period = 90;
        }
        if (period == 0) {
            beginDate = DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)new Date(), (int)0), (boolean)true);
            endDate = DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)new Date(), (int)0), (boolean)false);
        } else {
            beginDate = DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)new Date(), (int)period), (boolean)true);
            endDate = DateUtils.getDataFormat((Date)DateUtils.getLastDay((Date)new Date(), (int)1), (boolean)false);
        }
        logger.info(String.format("BankJournalDownloadSchedule::Receive parameters from download task: size of accountBankIds:%s, period:%s", accountBankIds.size(), period));
        DynamicObject[] accountBanks = BusinessDataServiceHelper.load((String)"bd_accountbanks", (String)"company", (QFilter[])new QFilter[]{new QFilter("id", "in", accountBankIds)});
        List orgIds = Arrays.stream(accountBanks).filter(d -> EmptyUtil.isNoEmpty((Object)d.get("company"))).map(d -> {
            DynamicObject dynamicObject = (DynamicObject)d.get("company");
            return (Long)dynamicObject.getPkValue();
        }).collect(Collectors.toList());
        logger.info(String.format("BankJournalDownloadSchedule::Search organization's ids that depends on account's id: size of account bank %s size of orgIds:%s", accountBanks.length, orgIds.size()));
        BankJournalDownload bjd = new BankJournalDownload().setOrgIds(orgIds).setAcctIds(accountBankIds).setBeginDate(beginDate).setEndDate(endDate);
        BankJournalDownloadService.getInstance().download(bjd);
    }

    static class Singleton {
        private static BankJournalDownloadSchedule instance = new BankJournalDownloadSchedule();

        Singleton() {
        }
    }
}

