/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.tmc.balancemodel.BalanceValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.cas.business.balancemodel.calculate.dto.RequestBalanceParameter;
import kd.fi.cas.business.balancemodel.calculate.dto.ResponseBalances;
import kd.fi.cas.business.balancemodel.calculate.service.CalculateBalanceServiceService;
import kd.fi.cas.business.balancemodel.calculate.service.ICalculateBalanceService;
import kd.fi.cas.business.balancemodel.log.enums.BalanceType;
import kd.fi.cas.business.balancemodel.service.BalanceDataService;
import kd.fi.cas.business.balancemodel.service.balance.BalanceQueryType;
import kd.fi.cas.business.balancemodel.service.report.ReportBalanceService;
import kd.fi.cas.business.helper.BalanceCountHelper;
import kd.fi.cas.business.pojo.CalcuteBalancerRequestParam;
import kd.fi.cas.business.service.IBalanceCountService;
import kd.fi.cas.helper.AccountBankHelper;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.helper.PeriodHelper;
import kd.fi.cas.helper.SystemStatusCtrolHelper;
import kd.fi.cas.util.DateUtils;
import kd.fi.cas.util.EmptyUtil;

public class BalanceCountService
implements IBalanceCountService {
    private static final Log logger = LogFactory.getLog(BalanceCountService.class);
    ICalculateBalanceService calculateBalanceService = CalculateBalanceServiceService.getInstance();
    private static String JOURNAL = "journal";
    private static String STATM = "statm";

    @Override
    public BigDecimal getJournalBalanceByAccount(Long accountId, Long currencyId, Date endDate) {
        Set userAuthorityOrgs = AccountBankHelper.getUserAuthorityOrgs((Long)accountId);
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"cas_cashmgtinit", (String)"org,isfinishinit,startperiod,currentperiod,entrybank.bank_journalbalance", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)userAuthorityOrgs)});
        BigDecimal balanceSum = BigDecimal.ZERO;
        if (inits != null && inits.length > 0) {
            for (DynamicObject init : inits) {
                if (!init.getBoolean("isfinishinit")) continue;
                BigDecimal orgBalance = BigDecimal.ZERO;
                DynamicObject org = init.getDynamicObject("org");
                DynamicObject startPeriod = init.getDynamicObject("startperiod");
                DynamicObject currentPeriod = init.getDynamicObject("currentperiod");
                if (startPeriod == null || currentPeriod == null) {
                    logger.info("===BalanceCountService===getJournalBalanceByAccount==initcash of startperiod or currentperiod is null");
                    continue;
                }
                Date beginDate = startPeriod.getDate("begindate");
                if (endDate.before(beginDate)) {
                    logger.info("===BalanceCountService===getJournalBalanceByAccount==endDate before beginDate. endDate:{}, beginDate:{}", (Object)endDate, (Object)beginDate);
                    continue;
                }
                Date date = DateUtils.getDataFormat((Date)endDate, (boolean)true);
                DynamicObject beginPeriod = PeriodHelper.getBeginPeriod((Long)org.getLong("id"), (DynamicObject)currentPeriod, (Date)date);
                if (beginPeriod == null) {
                    logger.info("===BalanceCountService===getJournalBalanceByAccount==get journal period is null");
                    continue;
                }
                BigDecimal journalBalamt = BalanceCountHelper.getJournalBalamt(orgBalance, beginPeriod, org.getLong("id"), accountId, currencyId, endDate);
                balanceSum = balanceSum.add(journalBalamt);
            }
        }
        logger.info("===BalanceCountService===getJournalBalanceByAccount==result balance:{}", (Object)balanceSum);
        return balanceSum;
    }

    @Override
    public BigDecimal getJournalBalance(DynamicObject initObj, Long orgId, Long accountId, Long currencyId, Date endDate) {
        BigDecimal journalbalamt = new BigDecimal("0");
        if (initObj == null) {
            return journalbalamt;
        }
        if (!initObj.getBoolean("isfinishinit")) {
            Map<String, BigDecimal> initBalMap = this.getInitBalance(orgId, accountId, currencyId);
            journalbalamt = initBalMap.get(JOURNAL);
            return journalbalamt;
        }
        DynamicObject startperiod = initObj.getDynamicObject("startperiod");
        DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
        if (initObj.getBoolean("isfinishinit")) {
            if (startperiod == null || currentperiod == null) {
                return journalbalamt;
            }
            DynamicObject period = startperiod;
            Date currentEndDate = currentperiod.getDate("enddate");
            Date startDate = startperiod.getDate("begindate");
            if (endDate.after(currentEndDate)) {
                period = currentperiod;
            } else {
                if (endDate.before(startDate)) {
                    return journalbalamt;
                }
                period = PeriodHelper.getPeriodByDate((long)orgId, (Date)endDate);
            }
            if (period != null) {
                journalbalamt = BalanceCountHelper.getJournalBalamt(journalbalamt, period, orgId, accountId, currencyId, endDate);
            }
        }
        return journalbalamt;
    }

    @Override
    public BigDecimal getStatmBalance(Long orgId, Long accountId, Long currencyId, Date endDate) {
        QFilter finishinitFilter;
        BigDecimal statmntbalamt = new BigDecimal("0");
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject recEdc = BusinessDataServiceHelper.loadSingle((String)"cas_rec_edc", (String)"id, recperiod,startperiod,currentperiod", (QFilter[])new QFilter[]{orgFilter});
        if (recEdc == null) {
            logger.info("===getStatmBalance***the balance setting is null");
            return statmntbalamt;
        }
        DynamicObject recPeriod = recEdc.getDynamicObject("recperiod");
        if (recPeriod == null) {
            logger.info("===getStatmBalance***the balance setting recPeriod is null");
            return statmntbalamt;
        }
        QFilter periodFilter = new QFilter("initperiod", "=", recPeriod.getPkValue());
        Object[] recInitObject = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id, org, entrybank, entrybank.bank_currency, initperiod, entrybank.bank_accountbank , entrybank.bank_statementbalance", (QFilter[])new QFilter[]{orgFilter, periodFilter, finishinitFilter = new QFilter("isfinishinit", "=", (Object)"1")});
        if (EmptyUtil.isEmpty((Object[])recInitObject)) {
            logger.info("===getStatmBalance===the init balance setting is null");
            return statmntbalamt;
        }
        Date beginDate = recPeriod.getDate("begindate");
        if (endDate.before(beginDate)) {
            logger.info("===getStatmBalance===end date before begin data. end Data:{}, begin date:{}", (Object)endDate, (Object)beginDate);
            return new BigDecimal("0");
        }
        DynamicObject period = PeriodHelper.getBeginPeriod((Long)orgId, (DynamicObject)recPeriod, (Date)endDate);
        statmntbalamt = BalanceCountHelper.getStatemMonthStart(orgId, accountId, currencyId, period);
        if (!BalanceCountHelper.isExistBalnce(orgId, accountId, currencyId, period).booleanValue()) {
            DynamicObjectCollection entryBank = recInitObject[0].getDynamicObjectCollection("entrybank");
            for (DynamicObject recInit : entryBank) {
                Long account = recInit.getDynamicObject("bank_accountbank").getLong("id");
                Long currency = recInit.getDynamicObject("bank_currency").getLong("id");
                if (!accountId.equals(account) || !currencyId.equals(currency)) continue;
                statmntbalamt = recInit.getBigDecimal("bank_statementbalance");
            }
        }
        statmntbalamt = BalanceCountHelper.getStatmntBalamt(statmntbalamt, period, accountId, currencyId, endDate);
        logger.info("===getStatmBalance===start balance:{}", (Object)statmntbalamt);
        return statmntbalamt;
    }

    @Override
    public Map<String, BigDecimal> getInitBalance(Long orgId, Long accountId, Long currencyId) {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        BigDecimal journalbalamt = new BigDecimal("0");
        BigDecimal statmntbalamt = new BigDecimal("0");
        QFilter[] initFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("entrybank.bank_accountbank", "=", (Object)accountId), new QFilter("entrybank.bank_currency", "=", (Object)currencyId)};
        DynamicObjectCollection cashmgtinitColls = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id, entrybank.bank_journalbalance, entrybank.bank_statementbalance, entrybank.bank_accountbank, entrybank.bank_currency", (QFilter[])initFilters, (String)"id");
        if (cashmgtinitColls != null && cashmgtinitColls.size() > 0) {
            for (DynamicObject cashmgtinit : cashmgtinitColls) {
                journalbalamt = cashmgtinit.getBigDecimal("entrybank.bank_journalbalance");
                statmntbalamt = cashmgtinit.getBigDecimal("entrybank.bank_statementbalance");
            }
        }
        map.put(JOURNAL, journalbalamt);
        map.put(STATM, statmntbalamt);
        return map;
    }

    public Map<String, BigDecimal> getJournalBalanceBatch(Set<Long> orgIds, List<Long> acctIds, List<Long> currencyIds, Date endDate) {
        if (orgIds == null || orgIds.size() == 0) {
            return null;
        }
        HashMap<String, BigDecimal> journalMap = new HashMap<String, BigDecimal>();
        HashSet<Long> notFinishinitOrg = new HashSet<Long>();
        for (Long orgId : orgIds) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
            DynamicObject startperiod = initObj.getDynamicObject("startperiod");
            DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
            if (CasHelper.isEmpty((Object)currentperiod)) continue;
            if (initObj.getBoolean("isfinishinit") && startperiod != null && currentperiod != null) {
                DynamicObjectCollection acctColl = BalanceCountHelper.getAcctColl(orgId, acctIds, currencyIds);
                Set<String> acountCurrByOrgs = BalanceCountHelper.getAccountKey(String.valueOf(orgId), acctColl);
                DynamicObject period = startperiod;
                Date currentEndDate = currentperiod.getDate("enddate");
                Date startDate = startperiod.getDate("begindate");
                if (endDate.compareTo(currentEndDate) >= 0) {
                    period = currentperiod;
                } else {
                    if (endDate.compareTo(startDate) <= 0) continue;
                    period = PeriodHelper.getPeriodByDate((long)orgId, (Date)endDate);
                }
                BalanceCountHelper.getJournalMapByOrg(journalMap, orgId, period, endDate, acountCurrByOrgs);
                continue;
            }
            notFinishinitOrg.add(orgId);
        }
        BalanceCountHelper.getJournalInit(journalMap, notFinishinitOrg, true);
        return journalMap;
    }

    @Override
    public Map<String, BigDecimal> getStatmBalanceBatch(Set<Long> accounts, Date endDate) {
        return this.getStatmBalanceBatch(accounts, null, endDate);
    }

    @Override
    public Map<String, BigDecimal> getStatmBalanceBatch(Set<Long> accounts, Map<Long, Set<Long>> acctToCnyMap, Date endDate) {
        if (accounts == null || accounts.size() == 0) {
            logger.info("======BalanceCountService==getStatmBalanceBatch==account is null");
            return null;
        }
        HashMap<String, BigDecimal> statmMap = new HashMap<String, BigDecimal>();
        Iterator<Long> iterator = accounts.iterator();
        HashSet<Long> removeAccIds = new HashSet<Long>(16);
        HashSet<Long> removeAccountIds = new HashSet<Long>(16);
        HashMap<Long, DynamicObject> recDecAccounts = new HashMap<Long, DynamicObject>(16);
        while (iterator.hasNext()) {
            Set<Long> cnyIdSet;
            Long account = iterator.next();
            QFilter filter = new QFilter("accountbank", "=", (Object)account).and(new QFilter("type", "=", (Object)"3"));
            if (acctToCnyMap != null && !EmptyUtil.isEmpty(cnyIdSet = acctToCnyMap.get(account))) {
                filter.and("currency", "in", cnyIdSet);
            }
            DynamicObject accountBank = AccountBankHelper.getAccountBankById((long)account);
            Object[] inits = BusinessDataServiceHelper.load((String)"cas_rec_edc", (String)"org,isfinishinit,startperiod,currentperiod,recperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", accountBank.getDynamicObject("createorg").getPkValue())});
            logger.info("======BalanceCountService==getStatmBalanceBatch==org:{}", (Object)accountBank.getDynamicObject("createorg"));
            if (EmptyUtil.isEmpty((Object[])inits)) {
                logger.info("======BalanceCountService==getStatmBalanceBatch==cas_rec_edc is null");
                String key = accountBank.getString("id") + "-zeroDesc";
                statmMap.put(key, BigDecimal.ONE);
                removeAccIds.add(account);
                continue;
            }
            DynamicObject recPeriod = inits[0].getDynamicObject("recperiod");
            Object recPeriodId = null;
            if (recPeriod != null && EmptyUtil.isNoEmpty((DynamicObject)recPeriod)) {
                logger.error("======BalanceCountService==getStatmBalanceBatch==recPeriod is null");
                recPeriodId = recPeriod.getPkValue();
            }
            QFilter periodFilter = new QFilter("initperiod", "=", recPeriodId);
            QFilter finishinitFilter = new QFilter("isfinishinit", "=", (Object)"1");
            QFilter orgFilter = new QFilter("org", "=", accountBank.getDynamicObject("createorg").getPkValue());
            Object[] recInitObject = BusinessDataServiceHelper.load((String)"cas_rec_init", (String)"id, org, entrybank, entrybank.bank_currency, initperiod, entrybank.bank_accountbank , entrybank.bank_statementbalance", (QFilter[])new QFilter[]{orgFilter, periodFilter, finishinitFilter});
            if (EmptyUtil.isEmpty((Object[])recInitObject)) {
                logger.info("======BalanceCountService==getStatmBalanceBatch==search cas_rec_init is null");
                String key = accountBank.getString("id") + "-zeroDesc";
                BigDecimal decimalNumb = new BigDecimal(2);
                statmMap.put(key, decimalNumb);
                removeAccIds.add(account);
                continue;
            }
            Date recPeriodBegin = recPeriod.getDate("begindate");
            if (endDate.before(recPeriodBegin)) {
                logger.info("======BalanceCountService==getStatmBalanceBatch==end date before period begin date. end date:{}, begin date:{}", (Object)endDate, (Object)recPeriodBegin);
                String key = accountBank.getString("id") + "-zeroDesc";
                BigDecimal decimalNumb = new BigDecimal(3);
                statmMap.put(key, decimalNumb);
                removeAccIds.add(account);
                continue;
            }
            if (accountBank != null) {
                filter.and(new QFilter("org", "=", accountBank.getDynamicObject("createorg").getPkValue()));
            }
            DynamicObject period = PeriodHelper.getBeginPeriod((Long)accountBank.getDynamicObject("createorg").getLong("id"), (DynamicObject)inits[0].getDynamicObject("recperiod"), (Date)endDate);
            filter.and(new QFilter("period", "=", period.getPkValue()));
            DynamicObject[] statemBals = BusinessDataServiceHelper.load((String)"cas_journalbalance", (String)"id, org,accountbank,period,currency,monthstart", (QFilter[])new QFilter[]{filter});
            if (!CasHelper.isEmpty((DynamicObject[])statemBals)) {
                for (DynamicObject statemBal : statemBals) {
                    BigDecimal statmntBalamt = BalanceCountHelper.getStatmntBalamt(statemBal.getBigDecimal("monthstart"), inits[0].getDynamicObject("recperiod"), account, statemBal.getDynamicObject("currency").getLong("id"), endDate);
                    if (inits != null && inits.length > 0) {
                        DynamicObject startPeriod = inits[0].getDynamicObject("startperiod");
                        DynamicObject currentPeriod = inits[0].getDynamicObject("currentperiod");
                        if (startPeriod == null || currentPeriod == null) {
                            statmntBalamt = BigDecimal.ZERO;
                        } else {
                            Date beginDate = startPeriod.getDate("begindate");
                            if (endDate.before(beginDate)) {
                                String key = account + "-" + statemBal.getDynamicObject("currency").getString("id") + "-zeroDesc";
                                BigDecimal decimalNumb = new BigDecimal(3);
                                statmMap.put(key, decimalNumb);
                                statmntBalamt = BigDecimal.ZERO;
                            }
                        }
                    }
                    String acctCnykey = account + "-" + statemBal.getDynamicObject("currency").getString("id");
                    statmMap.put(acctCnykey, statmntBalamt);
                    logger.info("{}:statmntBalamt\u91d1\u989d{}", (Object)acctCnykey, (Object)statmntBalamt);
                }
                iterator.remove();
                if (accountBank != null) {
                    Set<Long> cnySet = acctToCnyMap.get(account);
                    DynamicObjectCollection currencyCol = accountBank.getDynamicObjectCollection("currency");
                    for (DynamicObject cur : currencyCol) {
                        String curTemp;
                        Long currencyId;
                        DynamicObject baseData = cur.getDynamicObject("fbasedataid");
                        if (baseData == null || !cnySet.contains(currencyId = Long.valueOf(baseData.getLong("id"))) || null != statmMap.get(curTemp = account + "-" + currencyId)) continue;
                        BigDecimal statmntBalamt = BalanceCountHelper.getStatmntBalamt(new BigDecimal("0"), inits[0].getDynamicObject("startperiod"), account, cur.getDynamicObject("fbasedataid").getLong("id"), endDate);
                        if (inits != null && inits.length > 0) {
                            DynamicObject startPeriod = inits[0].getDynamicObject("startperiod");
                            DynamicObject currentPeriod = inits[0].getDynamicObject("currentperiod");
                            if (startPeriod == null || currentPeriod == null) {
                                statmntBalamt = BigDecimal.ZERO;
                            } else {
                                Date beginDate = startPeriod.getDate("begindate");
                                if (endDate.before(beginDate)) {
                                    String key = curTemp + "-zeroDesc";
                                    BigDecimal decimalNumb = new BigDecimal(3);
                                    statmMap.put(key, decimalNumb);
                                    statmntBalamt = BigDecimal.ZERO;
                                }
                            }
                        }
                        logger.info("{} statmntBalamt\u91d1\u989d1::{}", (Object)curTemp, (Object)statmntBalamt);
                        statmMap.put(curTemp, statmntBalamt);
                    }
                }
            }
            CalcuteBalancerRequestParam cbrp = new CalcuteBalancerRequestParam();
            cbrp.setStatemBals(statemBals);
            cbrp.setRecInitObject((DynamicObject[])recInitObject);
            cbrp.setRemoveAccountIds(removeAccountIds);
            cbrp.setAccount(account);
            cbrp.setAcctToCnyMap(acctToCnyMap);
            cbrp.setRecDecAccounts(recDecAccounts);
            cbrp.setInits((DynamicObject[])inits);
            cbrp.setStatmMap(statmMap);
            cbrp.setEndDate(endDate);
            this.calculateNoBalanceAccount(cbrp);
        }
        accounts.removeAll(removeAccIds);
        this.calculateNoInitAccountBalance(recDecAccounts, removeAccountIds, acctToCnyMap, statmMap, endDate);
        accounts.removeAll(removeAccountIds);
        if (!accounts.isEmpty()) {
            BalanceCountHelper.getStatemMapByOrg(statmMap, null, endDate, accounts, acctToCnyMap);
        }
        return statmMap;
    }

    private void calculateNoBalanceAccount(CalcuteBalancerRequestParam cbrp) {
        DynamicObject[] statemBals = cbrp.getStatemBals();
        DynamicObject[] recInitObject = cbrp.getRecInitObject();
        Set<Long> removeAccountIds = cbrp.getRemoveAccountIds();
        Long account = cbrp.getAccount();
        Map<Long, DynamicObject> recDecAccounts = cbrp.getRecDecAccounts();
        DynamicObject[] inits = cbrp.getInits();
        Map<String, BigDecimal> statmMap = cbrp.getStatmMap();
        Date endDate = cbrp.getEndDate();
        if (statemBals != null && statemBals.length != 0) {
            return;
        }
        DynamicObjectCollection entryBank = recInitObject[0].getDynamicObjectCollection("entrybank");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryBank) || entryBank.size() <= 0) {
            return;
        }
        HashMap<Long, DynamicObject> entryBanks = new HashMap<Long, DynamicObject>(entryBank.size());
        for (DynamicObject recInit : entryBank) {
            DynamicObject bankAccount = recInit.getDynamicObject("bank_accountbank");
            Long initAccountBank = bankAccount.getLong("id");
            entryBanks.putIfAbsent(initAccountBank, recInit);
        }
        if (entryBanks.containsKey(account)) {
            DynamicObject bank = (DynamicObject)entryBanks.get(account);
            Long currencyId = bank.getDynamicObject("bank_currency").getLong("id");
            Map<Long, Set<Long>> acctToCnyMap = cbrp.getAcctToCnyMap();
            Set<Long> cnySet = acctToCnyMap.get(account);
            if (cnySet.contains(currencyId)) {
                BigDecimal statmntBalamt = this.getStatementBalamt(bank, account, endDate, inits[0]);
                String strKey = account + "-" + currencyId;
                statmMap.put(strKey, statmntBalamt);
                removeAccountIds.add(account);
            }
        } else {
            recDecAccounts.putIfAbsent(account, inits[0]);
        }
    }

    private void calculateNoInitAccountBalance(Map<Long, DynamicObject> recDecAccounts, Set<Long> removeAccountIds, Map<Long, Set<Long>> acctToCnyMap, Map<String, BigDecimal> statmMap, Date endDate) {
        if (recDecAccounts.size() <= 0) {
            return;
        }
        Map accountBankMap = BusinessDataServiceHelper.loadFromCache((String)"bd_accountbanks", (QFilter[])new QFilter[]{new QFilter("id", "in", recDecAccounts.keySet())});
        for (DynamicObject accountBank : accountBankMap.values()) {
            Long account = accountBank.getLong("id");
            DynamicObject initRecDec = recDecAccounts.get(account);
            removeAccountIds.add(account);
            Set<Long> cnySet = acctToCnyMap.get(account);
            for (Long currencyId : cnySet) {
                BigDecimal statmentAmount = this.getStatementBalanceAmount(initRecDec, account, currencyId, endDate);
                String strKey = account + "-" + currencyId;
                statmMap.put(strKey, statmentAmount);
            }
        }
    }

    private BigDecimal getStatementBalamt(DynamicObject bank, Long account, Date endDate, DynamicObject initRecDec) {
        BigDecimal statmntBalamt = BalanceCountHelper.getStatmntBalamt(bank.getBigDecimal("bank_statementbalance"), initRecDec.getDynamicObject("recperiod"), account, bank.getDynamicObject("bank_currency").getLong("id"), endDate);
        if (EmptyUtil.isNoEmpty((DynamicObject)initRecDec)) {
            DynamicObject startPeriod = initRecDec.getDynamicObject("startperiod");
            DynamicObject currentPeriod = initRecDec.getDynamicObject("currentperiod");
            if (startPeriod == null || currentPeriod == null) {
                statmntBalamt = BigDecimal.ZERO;
            } else {
                Date beginDate = startPeriod.getDate("begindate");
                if (endDate.before(beginDate)) {
                    statmntBalamt = BigDecimal.ZERO;
                }
            }
        }
        logger.info("\u4ece\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u521d\u4f59\u989d\u8ba1\u7b97\u4f59\u989d \uff1a{}", (Object)statmntBalamt);
        return statmntBalamt;
    }

    private BigDecimal getStatementBalanceAmount(DynamicObject initRecDec, Long account, Long currency, Date endDate) {
        BigDecimal statmntBalamt = BalanceCountHelper.getStatmntBalamt(BigDecimal.ZERO, initRecDec.getDynamicObject("recperiod"), account, currency, endDate);
        if (EmptyUtil.isNoEmpty((DynamicObject)initRecDec)) {
            DynamicObject startPeriod = initRecDec.getDynamicObject("startperiod");
            DynamicObject currentPeriod = initRecDec.getDynamicObject("currentperiod");
            if (startPeriod == null || currentPeriod == null) {
                statmntBalamt = BigDecimal.ZERO;
            } else {
                Date beginDate = startPeriod.getDate("begindate");
                if (endDate.before(beginDate)) {
                    statmntBalamt = BigDecimal.ZERO;
                }
            }
        }
        logger.info("\u4ece\u5bf9\u8d26\u521d\u59cb\u5316\u671f\u521d\u4f59\u989d\u8ba1\u7b97\u4f59\u989d \uff1a{}", (Object)statmntBalamt);
        return statmntBalamt;
    }

    @Override
    public BigDecimal getCashbankBalance(Long orgId, Long accountId, Long currencyId, Date endDate) {
        DynamicObject casInit = PeriodHelper.getCasInitInfo((long)orgId);
        BigDecimal cashBalamt = new BigDecimal("0");
        if (casInit == null) {
            return cashBalamt;
        }
        if (!casInit.getBoolean("isfinishinit")) {
            cashBalamt = this.getInitCashBalance(orgId, accountId, currencyId);
            return cashBalamt;
        }
        DynamicObject startperiod = casInit.getDynamicObject("startperiod");
        DynamicObject currentperiod = casInit.getDynamicObject("currentperiod");
        if (casInit.getBoolean("isfinishinit") && currentperiod != null && startperiod != null) {
            DynamicObject period = startperiod;
            Date currentEndDate = currentperiod.getDate("enddate");
            Date startDate = startperiod.getDate("begindate");
            if (endDate.after(currentEndDate)) {
                period = currentperiod;
            } else {
                if (endDate.before(startDate)) {
                    return cashBalamt;
                }
                period = PeriodHelper.getPeriodByDate((long)orgId, (Date)endDate);
            }
            logger.info("========\u73b0\u91d1\u65e5\u8bb0\u8d26\u4f59\u989d\u8ba1\u7b97\u7684\u671f\u521d\u671f\u95f4\u4e3a\uff1a" + period.getString("number"));
            if (period != null) {
                cashBalamt = BalanceCountHelper.getCashBalamt(cashBalamt, period, accountId, currencyId, endDate);
            }
        }
        return cashBalamt;
    }

    public BigDecimal getInitCashBalance(Long orgId, Long accountId, Long currencyId) {
        BigDecimal cashBalamt = new BigDecimal("0");
        QFilter[] initFilters = new QFilter[]{new QFilter("entrycash.cash_accountcash", "=", (Object)accountId), new QFilter("entrycash.cash_currency", "=", (Object)currencyId)};
        DynamicObjectCollection cashmgtinitColls = QueryServiceHelper.query((String)"cas_cashmgtinit", (String)"id, entrycash.cash_balance", (QFilter[])initFilters, (String)"id");
        if (cashmgtinitColls != null && cashmgtinitColls.size() > 0) {
            for (DynamicObject cashmgtinit : cashmgtinitColls) {
                cashBalamt = cashmgtinit.getBigDecimal("entrycash.cash_balance");
            }
        }
        return cashBalamt;
    }

    public Map<String, BigDecimal> getJournalBalanceBatch(Set<Long> orgIds, Date endDate) {
        if (orgIds == null || orgIds.size() == 0) {
            return null;
        }
        HashMap<String, BigDecimal> journalMap = new HashMap<String, BigDecimal>();
        Set<String> acountCurrByOrgs = BalanceCountHelper.getAcountCurrByOrgs(orgIds);
        HashSet<Long> notFinishinitOrg = new HashSet<Long>();
        for (Long orgId : orgIds) {
            DynamicObject initObj = PeriodHelper.getCasInitInfo((long)orgId);
            DynamicObject startperiod = initObj.getDynamicObject("startperiod");
            DynamicObject currentperiod = initObj.getDynamicObject("currentperiod");
            if (CasHelper.isEmpty((Object)currentperiod)) continue;
            if (initObj.getBoolean("isfinishinit")) {
                DynamicObject period = startperiod;
                Date currentEndDate = currentperiod.getDate("enddate");
                Date startDate = startperiod.getDate("begindate");
                if (endDate.compareTo(currentEndDate) >= 0) {
                    period = currentperiod;
                } else {
                    if (endDate.compareTo(startDate) <= 0) continue;
                    period = PeriodHelper.getPeriodByDate((long)orgId, (Date)endDate);
                }
                BalanceCountHelper.getJournalMapByOrg(journalMap, orgId, period, endDate, acountCurrByOrgs);
                continue;
            }
            notFinishinitOrg.add(orgId);
        }
        BalanceCountHelper.getJournalInit(journalMap, notFinishinitOrg, true);
        return journalMap;
    }

    public BigDecimal getBizDateBalance(long orgId, long bankacctId, long currencyId, Date bizDate) {
        BigDecimal balanceAmout = BigDecimal.ZERO;
        DynamicObject startPeriod = SystemStatusCtrolHelper.getStartPeriod((long)orgId);
        if (startPeriod.getDate("begindate").after(DateUtils.getDataFormat((Date)bizDate, (boolean)true))) {
            return balanceAmout;
        }
        Date bookDate = DateUtils.getDataFormat((Date)bizDate, (boolean)true);
        try {
            balanceAmout = this.queryByBalanceModel(BalanceType.JOURNAL, orgId, bankacctId, currencyId, bookDate, bookDate);
        }
        catch (Exception e) {
            logger.error("error:", (Throwable)e);
        }
        return balanceAmout;
    }

    public BigDecimal queryByBalanceModel(BalanceType balanceType, long orgId, long acctId, long curId, Date startDate, Date endDate) {
        BigDecimal balance = BigDecimal.ZERO;
        RequestBalanceParameter parameter = new RequestBalanceParameter();
        parameter.setType(balanceType.getValue());
        parameter.setCurrencyIds(Collections.singleton(curId));
        parameter.setOrgIds(Collections.singleton(orgId));
        parameter.setStartDate(startDate);
        parameter.setEndDate(endDate);
        parameter.setAccountIds(Collections.singleton(acctId));
        try {
            List<ResponseBalances> balances = BalanceDataService.getInstance().getBalances(Collections.singletonList(parameter), BalanceQueryType.ENDDATE);
            if (balances != null && balances.size() > 0) {
                balance = balances.get(0).getBalance().getMonthStart();
            }
        }
        catch (Exception exception) {
            logger.error("BalanceCountService.getMonthBalance(),error:", (Throwable)exception);
        }
        return balance;
    }

    public List<BalanceValue> getBankJournalBal(int balanceType, int timeType, int balanceQueryType, Date startDate, Date endDate, Long peirodFrom, Long periodTo, Set<Long> cashAcctIds, Set<Long> bankAcctIds, Set<Long> currencyIds, Set<Long> orgIds) throws Exception {
        return ReportBalanceService.getInstance().getJournalBalances(1, balanceType, timeType, balanceQueryType, startDate, endDate, peirodFrom, periodTo, cashAcctIds, bankAcctIds, currencyIds, orgIds);
    }
}

