/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.PayApplyPayStatusEnum;
import kd.fi.cas.enums.PayStatusEnum;
import kd.fi.cas.refund.RefundEntryInfo;
import kd.fi.cas.refund.RefundPayBillInfo;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.cas.refund.SourceBillInfo;
import kd.fi.cas.util.EmptyUtil;
import kd.fi.cas.util.FiCacheHelper;

public class PaySynTransferApplyService {
    private static final Log logger = LogFactory.getLog(PaySynTransferApplyService.class);
    private static final String LOCKKEY_PREFIX = "PaySynTransferApplyService/cacheEntryPayStatus/";

    private String getLockkey(Long applyBillId) {
        return LOCKKEY_PREFIX + String.valueOf(applyBillId);
    }

    public void synPayInfo(Object params) {
        if (params instanceof List) {
            Map applyMap = (Map)((List)params).get(0);
            String operate = applyMap.get("operate").toString();
            if (this.isValidate(operate)) {
                this.doValidate(applyMap);
            } else {
                this.synPayInfoSingle(applyMap);
            }
        } else if (params instanceof RefundRenoteOrCancelParam) {
            String operate = ((RefundRenoteOrCancelParam)params).getOperate();
            this.throwIfNoSupport(operate);
            List<Map<String, Object>> synPayInfos = this.convert2Map((RefundRenoteOrCancelParam)params);
            if (this.isValidate(operate)) {
                return;
            }
            for (Map<String, Object> synPayInfo : synPayInfos) {
                this.synPayInfoSingle(synPayInfo);
            }
        }
    }

    private void throwNoSupport(String opName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"cas_transferapply");
        throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u751f\u6210\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u652f\u6301%2$s\u3002", (String)"PaySynTransferApplyService_3", (String)"fi-cas-business", (Object[])new Object[0]), entityType.getDisplayName().getLocaleValue(), opName));
    }

    private void throwIfNoSupport(String op) {
        if (WriteBackOperateEnum.REFUND.getValue().equals(op) || WriteBackOperateEnum.REFUNDVALIDATE.getValue().equals(op)) {
            this.throwNoSupport(WriteBackOperateEnum.getName(WriteBackOperateEnum.REFUND.getValue()));
        }
        if (WriteBackOperateEnum.CANCELRENOTEVALIDATE.getValue().equals(op) || WriteBackOperateEnum.CANCELRENOTE.getValue().equals(op)) {
            this.throwNoSupport(ResManager.loadKDString((String)"\u53d6\u6d88\u9000\u7968", (String)"PaySynTransferApplyService_1", (String)"fi-cas-business", (Object[])new Object[0]));
        }
    }

    private boolean isValidate(String op) {
        return op != null && op.endsWith("Validate");
    }

    private boolean isSaveOrSubmitValidate(String op) {
        return WriteBackOperateEnum.SAVEVALIDATE.getValue().equals(op) || WriteBackOperateEnum.SUBMITVALIDATE.getValue().equals(op);
    }

    private void doValidate(Map<String, Object> applyMap) {
        String operate = applyMap.get("operate").toString();
        if (this.isSaveOrSubmitValidate(operate)) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synPayInfoSingle(Map<String, Object> applyMap) {
        block45: {
            String operate = applyMap.get("operate").toString();
            try (TXHandle h = TX.required();){
                if (WriteBackOperateEnum.SAVE.getValue().equals(operate) || WriteBackOperateEnum.SUBMIT.getValue().equals(operate)) {
                    this.saveOrSubmitSyn(applyMap);
                    return;
                }
                boolean isSuccess = (Boolean)applyMap.get("issuccess");
                boolean isPay = StringUtils.equals((CharSequence)WriteBackOperateEnum.PAY.getValue(), (CharSequence)operate);
                final Long sourcePk = (Long)applyMap.get("sourcepk");
                final Long sourceEntryPk = (Long)applyMap.get("sourceentrypk");
                Long targetPk = (Long)applyMap.get("targetpk");
                String pkInfoStr = "sourcepk:" + sourcePk + "sourceentrypk:" + sourceEntryPk + "targetpk:" + targetPk + "operate:" + operate;
                logger.info("\u8c03\u62e8\u7533\u8bf7\u5355\u540c\u6b65\u4ed8\u6b3e\u5355\u4fe1\u606f\uff0c{}", (Object)pkInfoStr);
                if (isPay && !isSuccess) {
                    logger.info("\u5df2\u652f\u4ed8\u4f46\u652f\u4ed8\u672a\u6210\u529f\uff0c{}", (Object)pkInfoStr);
                    return;
                }
                DynamicObject transferApplyData = BusinessDataServiceHelper.loadSingle((Object)sourcePk, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_transferapply"));
                if (transferApplyData != null) {
                    DynamicObjectCollection transferInfoEntry = transferApplyData.getDynamicObjectCollection("cas_transferapply_entry");
                    Optional<DynamicObject> currPayInfoOptional = transferInfoEntry.stream().filter(e -> e.get("id").equals(sourceEntryPk)).findFirst();
                    if (!currPayInfoOptional.isPresent()) {
                        logger.info("\u8c03\u62e8\u7533\u8bf7\u660e\u7ec6\u5206\u5f55\u4e0d\u5b58\u5728\uff0c{}", (Object)pkInfoStr);
                        return;
                    }
                    DynamicObject currPayInfo = currPayInfoOptional.get();
                    if (!this.idemPotencyValidate(operate, currPayInfo)) {
                        logger.info("\u8c03\u62e8\u7533\u8bf7\u5355\u540c\u6b65\u4ed8\u6b3e\u5355\u91cd\u590d\u6267\u884c\uff0c{}", (Object)pkInfoStr);
                        return;
                    }
                    final Map<String, Object> backPayInfoMap = this.backupEntryStatus(currPayInfo);
                    this.setEntryStatus(applyMap, operate, currPayInfo);
                    String lockKey = this.getLockkey(sourcePk);
                    DLock dLock = DLock.createReentrant((String)lockKey);
                    boolean isLock = dLock.tryLock(30000L);
                    logger.info("entryId:{},isLock:{}", (Object)sourceEntryPk, (Object)isLock);
                    try {
                        JSONObject entryPayStatus = this.cacheEntryPayStatus(transferApplyData.getPkValue().toString(), currPayInfo.getPkValue().toString(), currPayInfo.getString("e_paystatus"));
                        this.setHeadStatus(transferApplyData, entryPayStatus);
                        try (TXHandle tx = TX.requiresNew();){
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transferApplyData});
                        }
                    }
                    finally {
                        dLock.unlock();
                    }
                    TX.addCommitListener((CommitListener)new CommitListener(){

                        public void onRollbacked() {
                            PaySynTransferApplyService.this.rolllback(sourcePk, sourceEntryPk, backPayInfoMap);
                        }

                        public void onEnded(boolean rollbacked) {
                        }

                        public void onCommitted() {
                        }
                    });
                    logger.info("\u53cd\u5199\u8c03\u62e8\u7533\u8bf7\u5355\u7ed3\u675f\uff0c{}", (Object)pkInfoStr);
                    break block45;
                }
                logger.info("\u8c03\u62e8\u7533\u8bf7\u5355\u4e0d\u5b58\u5728\uff0c{}", (Object)pkInfoStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rolllback(Long sourcePk, Long entryPk, Map<String, Object> backPayInfoMap) {
        logger.error("onRollbacked, pkId:{}", (Object)sourcePk);
        String entryPkId = String.valueOf(entryPk);
        String applyId = String.valueOf(sourcePk);
        String lockKey = this.getLockkey(sourcePk);
        DLock dLock = DLock.createReentrant((String)lockKey);
        dLock.tryLock(30000L);
        try {
            String successStatusCache = (String)FiCacheHelper.getSessionlessCacheInstance().get(lockKey);
            if (EmptyUtil.isNoEmpty((String)successStatusCache)) {
                JSONObject jsonObject = JSONObject.parseObject((String)successStatusCache);
                jsonObject.remove((Object)entryPkId);
                if (jsonObject.isEmpty()) {
                    FiCacheHelper.getSessionlessCacheInstance().remove(applyId);
                } else {
                    FiCacheHelper.getSessionlessCacheInstance().put(lockKey, (Object)jsonObject.toString(), 180);
                }
            }
            try (TXHandle tx = TX.requiresNew();){
                DynamicObjectCollection transferInfoEntry;
                Optional<DynamicObject> currPayInfoOptional;
                DynamicObject transferApplyData = BusinessDataServiceHelper.loadSingle((Object)applyId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"cas_transferapply"));
                if (transferApplyData != null && (currPayInfoOptional = (transferInfoEntry = transferApplyData.getDynamicObjectCollection("cas_transferapply_entry")).stream().filter(e -> e.getString("id").equals(entryPkId)).findFirst()).isPresent()) {
                    DynamicObject payInfo = currPayInfoOptional.get();
                    for (Map.Entry<String, Object> entry : backPayInfoMap.entrySet()) {
                        payInfo.set(entry.getKey(), entry.getValue());
                    }
                    this.setHeadStatus(transferApplyData, new JSONObject());
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{transferApplyData});
                }
            }
        }
        finally {
            dLock.unlock();
        }
    }

    private Map<String, Object> backupEntryStatus(DynamicObject currPayInfo) {
        HashMap<String, Object> backPayInfoMap = new HashMap<String, Object>(16);
        backPayInfoMap.put("e_paystatus", currPayInfo.get("e_paystatus"));
        backPayInfoMap.put("e_paybillno", currPayInfo.get("e_paybillno"));
        backPayInfoMap.put("e_statusexplain", currPayInfo.get("e_statusexplain"));
        backPayInfoMap.put("e_backbill", currPayInfo.get("e_backbill"));
        backPayInfoMap.put("e_paydate", currPayInfo.get("e_paydate"));
        backPayInfoMap.put("e_settletnumber", currPayInfo.get("e_settletnumber"));
        return backPayInfoMap;
    }

    private void setEntryStatus(Map<String, Object> applyMap, String operate, DynamicObject currPayInfo) {
        currPayInfo.set("e_statusexplain", (Object)"");
        if (StringUtils.equals((CharSequence)WriteBackOperateEnum.REFUND.getValue(), (CharSequence)operate) || StringUtils.equals((CharSequence)WriteBackOperateEnum.RENOTE.getValue(), (CharSequence)operate)) {
            currPayInfo.set("e_backbill", (Object)"1");
            currPayInfo.set("e_statusexplain", applyMap.get("refunddes"));
        }
        if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELREFUND.getValue(), (CharSequence)operate) || StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELRENOTE.getValue(), (CharSequence)operate)) {
            currPayInfo.set("e_backbill", (Object)"0");
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.PAY.getValue(), (CharSequence)operate)) {
            currPayInfo.set("e_paystatus", (Object)PayStatusEnum.PAYMENTSUCCESS.getValue());
            currPayInfo.set("e_paydate", applyMap.get("paydate"));
            boolean isCommitBe = (Boolean)applyMap.get("iscommitbe");
            if (isCommitBe) {
                currPayInfo.set("e_statusexplain", applyMap.get("bankreturnmsg"));
            }
            currPayInfo.set("e_settletnumber", applyMap.get("settletnumber"));
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELPAY.getValue(), (CharSequence)operate)) {
            currPayInfo.set("e_paystatus", (Object)PayStatusEnum.PAYING.getValue());
            currPayInfo.set("e_paydate", null);
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CHARGEBACK.getValue(), (CharSequence)operate)) {
            currPayInfo.set("e_statusexplain", applyMap.get("reason"));
            currPayInfo.set("e_paystatus", (Object)PayStatusEnum.CLANCEL.getValue());
            currPayInfo.set("e_paydate", null);
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.DELETE.getValue(), (CharSequence)operate)) {
            currPayInfo.set("e_paystatus", (Object)PayStatusEnum.NOTPAYING.getValue());
            currPayInfo.set("e_paybillno", null);
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.SYNCSTATUS.getValue(), (CharSequence)operate)) {
            boolean isCommitBe = (Boolean)applyMap.get("iscommitbe");
            logger.info("\u94f6\u884c\u8fd4\u56de\u4fe1\u606f\uff1a{}\uff0cisCommitBe\uff1a{}", applyMap.get("bankreturnmsg"), (Object)isCommitBe);
            if (isCommitBe) {
                currPayInfo.set("e_statusexplain", applyMap.get("bankreturnmsg"));
            }
        }
    }

    private List<Map<String, Object>> convert2Map(RefundRenoteOrCancelParam param) {
        String operate = param.getOperate();
        List refundPayInfos = param.getRefundPayInfos();
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(refundPayInfos.size());
        List paybillIds = refundPayInfos.stream().map(v -> v.getTargetPk()).collect(Collectors.toList());
        DynamicObjectCollection ids = QueryServiceHelper.query((String)"cas_paybill", (String)String.join((CharSequence)",", "id", "sourceentryid"), (QFilter[])new QFilter[]{new QFilter("id", "in", paybillIds)});
        HashMap<Long, Long> paybllid2entryid = new HashMap<Long, Long>(10);
        for (DynamicObject idDO : ids) {
            paybllid2entryid.put(idDO.getLong("id"), idDO.getLong("sourceentryid"));
        }
        for (RefundPayBillInfo refundPayInfo : refundPayInfos) {
            List entryInfos = refundPayInfo.getEntryInfos();
            for (RefundEntryInfo entryInfo : entryInfos) {
                if ((WriteBackOperateEnum.RENOTEVALIDATE.getValue().equals(operate) || WriteBackOperateEnum.RENOTE.getValue().equals(operate)) && entryInfo.getEntryRemainRefundAmt().compareTo(BigDecimal.ZERO) > 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"%s\u4e0d\u5141\u8bb8\u90e8\u5206\u9000\u7968\u3002", (String)"PaySynTransferApplyService_0", (String)"fi-cas-business", (Object[])new Object[]{entryInfo.getTargetBillNo()}));
                }
                Long sourceentrypk = (Long)paybllid2entryid.get(refundPayInfo.getTargetPk());
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                map.put("operate", operate);
                List sourceInfos = entryInfo.getSourceInfos();
                SourceBillInfo sourceBillInfo = (SourceBillInfo)sourceInfos.get(0);
                map.put("sourcepk", sourceBillInfo.getSourcePk());
                map.put("sourceentrypk", sourceentrypk);
                map.put("targetpk", refundPayInfo.getTargetPk());
                map.put("targetbillno", entryInfo.getTargetBillNo());
                map.put("sourceentity", sourceBillInfo.getSourceEntity());
                map.put("amount", entryInfo.getAmount());
                map.put("bizdate", entryInfo.getBizdate());
                map.put("currencypk", entryInfo.getCurrencyPk());
                map.put("isdiffcur", entryInfo.getDiffCur());
                map.put("dpamt", entryInfo.getDpAmt());
                map.put("dpcurrency", entryInfo.getDpCurrency());
                map.put("refundamt", entryInfo.getRefundAmt());
                map.put("settletnumber", null);
                map.put("paydate", entryInfo.getPaydate());
                map.put("description", null);
                map.put("issuccess", true);
                params.add(map);
            }
        }
        return params;
    }

    private void setHeadStatus(DynamicObject payApplyData, JSONObject entryPayStatusCache) {
        DynamicObjectCollection transferApplyEntry = payApplyData.getDynamicObjectCollection("cas_transferapply_entry");
        HashSet<String> statusSet = new HashSet<String>(transferApplyEntry.size());
        for (DynamicObject entry : transferApplyEntry) {
            if (entryPayStatusCache.getString(entry.getPkValue().toString()) != null) {
                statusSet.add(entryPayStatusCache.getString(entry.getPkValue().toString()));
                continue;
            }
            statusSet.add(entry.getString("e_paystatus"));
        }
        if (statusSet.contains(PayStatusEnum.NOTPAYING.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.NOTPAYING.getValue());
        } else if (statusSet.contains(PayStatusEnum.PAYING.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.PAYING.getValue());
        } else if (statusSet.contains(PayStatusEnum.PAYMENTSUCCESS.getValue())) {
            payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.SUCCESS.getValue());
        }
        if (statusSet.contains(PayStatusEnum.CLANCEL.getValue())) {
            payApplyData.set("backbillflag", (Object)Character.valueOf('1'));
            if (statusSet.size() == 1) {
                payApplyData.set("paidstatus", (Object)PayApplyPayStatusEnum.NOTPAYING.getValue());
            }
        }
        boolean containsPaySucceed = statusSet.contains(PayStatusEnum.PAYMENTSUCCESS.getValue());
        statusSet.removeIf(status -> status.equals(PayStatusEnum.PAYMENTSUCCESS.getValue()) || status.equals(PayStatusEnum.CLANCEL.getValue()));
        if (containsPaySucceed && !statusSet.isEmpty()) {
            payApplyData.set("partpay", (Object)Character.valueOf('1'));
        } else {
            payApplyData.set("partpay", (Object)Character.valueOf('0'));
        }
    }

    private void saveOrSubmitSyn(Map<String, Object> applyMap) {
        DynamicObject payBillData = (DynamicObject)applyMap.get("info");
        DynamicObjectCollection entry = payBillData.getDynamicObjectCollection("entry");
        Set sourceBillIdSet = entry.stream().map(e -> e.getLong("e_sourcebillid")).collect(Collectors.toSet());
        if (!sourceBillIdSet.isEmpty()) {
            DynamicObject[] transferApplyDatas = BusinessDataServiceHelper.load((String)"cas_transferapply", (String)"id, paidstatus,partpay, backbillflag, cas_transferapply_entry.e_sourcebillentryid,cas_transferapply_entry.e_paystatus, cas_transferapply_entry.e_paybillno,cas_transferapply_entry.e_paystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIdSet)});
            Map<Long, DynamicObject> transferApplyBillMap = Arrays.stream(transferApplyDatas).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
            ArrayList<DynamicObject> needSaveList = new ArrayList<DynamicObject>(1);
            for (DynamicObject row : entry) {
                DynamicObject transferApplyData = transferApplyBillMap.get(row.getLong("e_sourcebillid"));
                if (transferApplyData == null) continue;
                long sourceEntryPk = row.getLong("e_sourcebillentryid");
                DynamicObjectCollection transferInfoEntry = transferApplyData.getDynamicObjectCollection("cas_transferapply_entry");
                Optional<DynamicObject> currPayInfoOptional = transferInfoEntry.stream().filter(e -> e.get("id").equals(sourceEntryPk)).findFirst();
                if (!currPayInfoOptional.isPresent()) continue;
                DynamicObject currPayInfo = currPayInfoOptional.get();
                currPayInfo.set("e_paystatus", (Object)PayStatusEnum.PAYING.getValue());
                currPayInfo.set("e_paybillno", payBillData.get("billno"));
                this.setHeadStatus(transferApplyData, new JSONObject());
                needSaveList.add(transferApplyData);
            }
            if (!needSaveList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])needSaveList.toArray(new DynamicObject[0]));
            }
        }
    }

    private boolean idemPotencyValidate(String operate, DynamicObject payInfoEntry) {
        Boolean result = Boolean.TRUE;
        String payStatus = payInfoEntry.getString("e_paystatus");
        if ((StringUtils.equals((CharSequence)WriteBackOperateEnum.REFUND.getValue(), (CharSequence)operate) || StringUtils.equals((CharSequence)WriteBackOperateEnum.RENOTE.getValue(), (CharSequence)operate)) && payInfoEntry.getBoolean("e_backbill")) {
            result = Boolean.FALSE;
        }
        if ((StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELREFUND.getValue(), (CharSequence)operate) || StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELRENOTE.getValue(), (CharSequence)operate)) && !payInfoEntry.getBoolean("e_backbill")) {
            result = Boolean.FALSE;
        } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.PAY.getValue(), (CharSequence)operate) && PayStatusEnum.PAYMENTSUCCESS.getValue().equals(payStatus)) {
            result = Boolean.FALSE;
        } else if (!StringUtils.equals((CharSequence)WriteBackOperateEnum.CANCELPAY.getValue(), (CharSequence)operate) || !PayStatusEnum.PAYING.getValue().equals(payStatus)) {
            if (StringUtils.equals((CharSequence)WriteBackOperateEnum.CHARGEBACK.getValue(), (CharSequence)operate) && PayStatusEnum.CLANCEL.getValue().equals(payStatus)) {
                result = Boolean.FALSE;
            } else if (StringUtils.equals((CharSequence)WriteBackOperateEnum.DELETE.getValue(), (CharSequence)operate) && PayStatusEnum.NOTPAYING.getValue().equals(payStatus)) {
                result = Boolean.FALSE;
            }
        }
        return result;
    }

    private JSONObject cacheEntryPayStatus(String pkId, String entryPkId, String status) {
        String lockKey = LOCKKEY_PREFIX + pkId;
        String successStatusCache = (String)FiCacheHelper.getSessionlessCacheInstance().get(lockKey);
        JSONObject jsonObject = EmptyUtil.isEmpty((String)successStatusCache) ? new JSONObject() : JSONObject.parseObject((String)successStatusCache);
        jsonObject.put(entryPkId, (Object)status);
        FiCacheHelper.getSessionlessCacheInstance().put(lockKey, (Object)jsonObject.toString(), 180);
        return jsonObject;
    }
}

