/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.writeback.PaymentDisposeConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.ar.ArWriteBackHelper;
import kd.fi.cas.business.writeback.ar.bean.Result;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.helper.CasHelper;

@Deprecated
public class RefundAndRenoteTxService
extends EventualConsistencyService {
    private static final Log logger = LogFactory.getLog(RefundAndRenoteTxService.class);

    public DtxResponse execute(Object arg0, Object arg1) throws Exception {
        CommonParam commonParam = (CommonParam)arg0;
        Object payBillId = commonParam.get((Object)"paybillid");
        Object recBillId = commonParam.get((Object)"recbillid");
        DynamicObject payBill = BusinessDataServiceHelper.loadSingle((Object)payBillId, (String)"cas_paybill");
        DynamicObject recBill = BusinessDataServiceHelper.loadSingle((Object)recBillId, (String)"cas_recbill");
        BigDecimal refundAmt = recBill.getBigDecimal("actrecamt");
        BigDecimal actRecAmtFee = refundAmt.add(recBill.getBigDecimal("fee"));
        BigDecimal actpayamt = payBill.getBigDecimal("actpayamt");
        Boolean isfullrefund = Boolean.TRUE;
        if (actRecAmtFee.compareTo(actpayamt) != 0) {
            isfullrefund = Boolean.FALSE;
        }
        Boolean isSettle = Boolean.FALSE;
        DynamicObject payType = payBill.getDynamicObject("paymenttype");
        if (payType != null && payType.getBoolean("ispartpayment")) {
            isSettle = Boolean.TRUE;
        }
        if (isSettle.booleanValue()) {
            Result apPayUnSettleResult = ArWriteBackHelper.cancelSettle(payBill);
            this.isResultFail(apPayUnSettleResult);
            Result payRecSettleResult = ArWriteBackHelper.payRecSettle(payBill, recBill);
            this.isResultFail(payRecSettleResult);
            if (!isfullrefund.booleanValue()) {
                Result apPaySettleResult = ArWriteBackHelper.apPaySettle(payBill);
                this.isResultFail(apPaySettleResult);
            }
        }
        WriteBackOperateEnum writeBackOperateEnum = BillStatusEnum.REFUND.getValue().equals(payBill.getString("billstatus")) ? WriteBackOperateEnum.REFUND : WriteBackOperateEnum.RENOTE;
        String sourcebilltype = payBill.getString("sourcebilltype");
        if (CasHelper.isNotEmpty((Object)sourcebilltype)) {
            Serializable param;
            if ("ap_finapbill".equals(sourcebilltype) || "ar_finarbill".equals(sourcebilltype)) {
                param = ArWriteBackHelper.buildRefundRenoteParam(payBill, recBill.getLong("id"), writeBackOperateEnum);
                ArWriteBackHelper.writerBackAP(param, "RefundAndRenoteECService");
            } else {
                param = new HashMap();
                param.put("isfullrefund", isfullrefund);
                WriteBackTaskHelper.addRealtimeTask(payBill, sourcebilltype, writeBackOperateEnum, PaymentDisposeConsumer.class, (Map<String, Object>)((Object)param));
            }
        }
        return null;
    }

    private void isResultFail(Result result) {
        if (!"0".equals(result.getCode())) {
            throw new KDBizException(result.getErrorInfo());
        }
    }
}

