/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.business.errorcode.JournalErrorCode;
import kd.fi.cas.business.journal.BookJournalLogger;
import kd.fi.cas.business.journal.VoucherBookService;
import kd.fi.cas.enums.mq.MQBusStatusEnum;
import kd.fi.cas.enums.mq.MQMessageStatusEnum;
import kd.fi.cas.helper.MutexServiceHelper;

public class VoucherBookConsumer
implements MessageConsumer {
    private static final String OP_VOCHERBOOKCONSUMER = "voucherBookConsumer";
    private static Log logger = LogFactory.getLog(VoucherBookConsumer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try {
            Map params = (Map)message;
            VoucherBookService voucherBookService = new VoucherBookService();
            String action = (String)params.get("action");
            Long[] voucherPks = (Long[])params.get("voucherPks");
            Object recordPk = params.get("recordPk");
            BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26MQ\u6d88\u8d39\u8005,\u6267\u884c\u52a8\u4f5c\uff1a%s", (String)"VoucherBookConsumer_0", (String)"fi-cas-business", (Object[])new Object[0]), action + Arrays.asList(voucherPks)));
            if (recordPk != null) {
                String recordId = String.valueOf(recordPk);
                BookJournalLogger.log(String.format(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26MQ\u6d88\u8d39\u8005\uff0c\u6d88\u606fID\uff1a%s\u3002", (String)"VoucherBookConsumer_2", (String)"fi-cas-business", (Object[])new Object[0]), recordId));
                DynamicObject record = BusinessDataServiceHelper.loadSingle(recordPk, (String)"cas_mq_record", (String)"msgstatus");
                String msgstatus = record.getString("msgstatus");
                if (!MQMessageStatusEnum.SEND.getValue().equals(msgstatus) && !MQMessageStatusEnum.REP.getValue().equals(msgstatus)) {
                    acker.ack(messageId);
                    return;
                }
                ArrayList<String> requestIds = new ArrayList<String>(voucherPks.length);
                ArrayList<String> requestFailIds = new ArrayList<String>(voucherPks.length);
                List lockIds = Arrays.asList(voucherPks).stream().map(s -> s.toString()).collect(Collectors.toList());
                Map lockResultMap = MutexServiceHelper.batchRequest(lockIds, (String)"gl_voucher", (String)OP_VOCHERBOOKCONSUMER);
                try {
                    for (Map.Entry next : lockResultMap.entrySet()) {
                        String key = (String)next.getKey();
                        if (((Boolean)next.getValue()).booleanValue()) {
                            requestIds.add(key);
                            continue;
                        }
                        requestFailIds.add(key);
                    }
                    if (requestIds.size() <= 0) {
                        throw new KDBizException(new JournalErrorCode().JOURNAL_MQ_LOCK_ERROR(), new Object[0]);
                    }
                    if (requestFailIds.size() > 0) {
                        HashMap<String, Object> failMessage = new HashMap<String, Object>();
                        failMessage.put("action", action);
                        Long[] failVouvhers = (Long[])requestFailIds.stream().map(o -> Long.parseLong(o)).toArray(Long[]::new);
                        failMessage.put("voucherPks", failVouvhers);
                        Long failRecordPk = DB.genLongId((String)EntityMetadataCache.getDataEntityType((String)"cas_mq_record").getAlias());
                        failMessage.put("recordPk", failRecordPk);
                        this.saveMQRecord(action, failMessage, failRecordPk);
                    }
                    try {
                        this.updateRecordStatus(recordPk, MQMessageStatusEnum.REC, null, null);
                        Set<DynamicObject> errorVbooks = null;
                        if (requestIds.size() > 0) {
                            Long[] sucVouvhers = (Long[])requestIds.stream().map(o -> Long.parseLong(o)).toArray(Long[]::new);
                            if ("book".equals(action)) {
                                errorVbooks = voucherBookService.book(sucVouvhers);
                            } else if ("delete".equals(action)) {
                                errorVbooks = voucherBookService.delete(sucVouvhers);
                            }
                        }
                        this.updateRecordStatus(recordPk, MQMessageStatusEnum.FIN, MQBusStatusEnum.SUCC, errorVbooks);
                    }
                    catch (Exception e) {
                        this.updateRecordStatus(recordPk, MQMessageStatusEnum.FIN, MQBusStatusEnum.FAIL, e);
                    }
                }
                finally {
                    MutexServiceHelper.batchRelease(requestIds, (String)"gl_voucher", (String)OP_VOCHERBOOKCONSUMER);
                }
            } else if ("book".equals(action)) {
                voucherBookService.book(voucherPks);
            } else if ("delete".equals(action)) {
                voucherBookService.delete(voucherPks);
            }
            acker.ack(messageId);
        }
        catch (Exception e) {
            try {
                BookJournalLogger.error(ResManager.loadKDString((String)"\u51ed\u8bc1\u767b\u8d26\u6d88\u8d39\u670d\u52a1\u5f02\u5e38\uff1a", (String)"VoucherBookConsumer_1", (String)"fi-cas-business", (Object[])new Object[0]), e);
            }
            finally {
                acker.deny(messageId);
            }
        }
    }

    private void updateRecordStatus(Object recordPk, MQMessageStatusEnum msgStatus, MQBusStatusEnum busStatus, Object errInfo) {
        try {
            DynamicObject mqRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cas_mq_record"));
            mqRecord.set("id", recordPk);
            mqRecord.set("msgstatus", (Object)msgStatus.getValue());
            if (busStatus != null) {
                mqRecord.set("businessstatus", (Object)busStatus.getValue());
            }
            mqRecord.set("modifytime", (Object)new Date());
            if (errInfo != null) {
                String errormsgTag = SerializationUtils.toJsonString((Object)errInfo);
                TextProp property = (TextProp)mqRecord.getDataEntityType().getProperties().get((Object)"errormsg");
                int maxLenth = property.getMaxLenth();
                String errormsg = "";
                if (errormsgTag != null && errormsgTag.length() > maxLenth) {
                    errormsg = errormsgTag.substring(0, maxLenth);
                }
                mqRecord.set("errormsg", (Object)errormsg);
                mqRecord.set("errormsg_tag", (Object)errormsgTag);
            }
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.update((DynamicObject)mqRecord);
            }
        }
        catch (Exception e) {
            logger.error("mqRecord updateStatus error:", (Throwable)e);
            throw e;
        }
    }

    private void saveMQRecord(String operate, Map<String, Object> message, Long recordPk) {
        try {
            DynamicObject voucherBookMq = BusinessDataServiceHelper.newDynamicObject((String)"cas_mq_record");
            voucherBookMq.set("id", (Object)recordPk);
            voucherBookMq.set("billno", (Object)recordPk);
            voucherBookMq.set("businesstype", (Object)"voucherbook");
            voucherBookMq.set("billstatus", (Object)"C");
            voucherBookMq.set("msgstatus", (Object)"send");
            voucherBookMq.set("businessstatus", (Object)"todo");
            voucherBookMq.set("operate", (Object)operate);
            voucherBookMq.set("createtime", (Object)new Date());
            voucherBookMq.set("modifytime", (Object)new Date());
            String msgInfoTag = SerializationUtils.toJsonString(message);
            TextProp property = (TextProp)voucherBookMq.getDataEntityType().getProperties().get((Object)"msginfo");
            int maxLenth = property.getMaxLenth();
            String msgInfo = "";
            if (msgInfoTag != null && msgInfoTag.length() > maxLenth) {
                msgInfo = msgInfoTag.substring(0, maxLenth);
            }
            voucherBookMq.set("msginfo", (Object)msgInfo);
            voucherBookMq.set("msginfo_tag", (Object)msgInfoTag);
            String operateinfo = SerializationUtils.toJsonString((Object)message.get("voucherPks"));
            property = (TextProp)voucherBookMq.getDataEntityType().getProperties().get((Object)"operateinfo");
            maxLenth = property.getMaxLenth();
            if (operateinfo != null && operateinfo.length() > maxLenth) {
                operateinfo = operateinfo.substring(0, maxLenth);
            }
            voucherBookMq.set("operateinfo", (Object)operateinfo);
            try (TXHandle tx = TX.requiresNew();){
                OperationServiceHelper.executeOperate((String)"save", (String)"cas_mq_record", (DynamicObject[])new DynamicObject[]{voucherBookMq}, (OperateOption)OperateOption.create());
            }
        }
        catch (Exception e) {
            logger.error("mqRecord save error:", (Throwable)e);
            throw e;
        }
    }
}

