/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.cas.business.service.IWriteBackService;
import kd.fi.cas.business.writeback.WriteBackTaskConsumer;
import kd.fi.cas.business.writeback.WriteBackTaskHelper;
import kd.fi.cas.business.writeback.consts.WriteBackOperateEnum;
import kd.fi.cas.helper.CasHelper;
import kd.fi.cas.info.WriteBackTaskInfo;
import kd.fi.cas.util.EmptyUtil;

public class WriteBackServiceImpl
implements IWriteBackService {
    private static final Log logger = LogFactory.getLog(WriteBackServiceImpl.class);
    private OperateOption option;

    public static WriteBackServiceImpl getInstance() {
        return Singleton.instance;
    }

    @Override
    public <T extends WriteBackTaskConsumer> void write(DynamicObject bill, WriteBackOperateEnum op, Class<T> consumer, String source) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("isNew", true);
        if (EmptyUtil.isEmpty((DynamicObject)bill) || EmptyUtil.isEmpty((Object)((Object)op)) || EmptyUtil.isEmpty((String)source)) {
            return;
        }
        param.put("operate", op.getValue());
        param.put("info", bill);
        WriteBackTaskHelper.addRealtimeTask(bill, source, op, consumer, param);
    }

    @Override
    public <T extends WriteBackTaskConsumer> void batchWrite(List<DynamicObject> bills, WriteBackOperateEnum op, Class<T> consumer) {
        ArrayList<WriteBackTaskInfo> taskInfos = new ArrayList<WriteBackTaskInfo>(10);
        for (DynamicObject bill : bills) {
            String sourceBillType = bill.getString("sourcebilltype");
            if (!StringUtils.isNotBlank((CharSequence)sourceBillType)) continue;
            WriteBackTaskInfo taskInfo = new WriteBackTaskInfo();
            taskInfo.setBillId((Long)bill.getPkValue());
            taskInfo.setDataEntity(bill.getDataEntityType().getName());
            taskInfo.setSourceEntity(sourceBillType);
            HashMap<String, Object> param = new HashMap<String, Object>(4);
            param.put("isNew", true);
            param.put("operate", op.getValue());
            param.put("info", bill);
            taskInfo.setParam(param);
            taskInfos.add(taskInfo);
        }
        if (!taskInfos.isEmpty()) {
            WriteBackTaskHelper.batchAddRealtimeTaskList(taskInfos, op, consumer);
        }
    }

    @Override
    public <T extends WriteBackTaskConsumer> String validate(DynamicObject bill, WriteBackOperateEnum op, Class<T> consumer, String source) {
        return this.validate(bill, op, consumer, source, true);
    }

    @Override
    public <T extends WriteBackTaskConsumer> String validate(DynamicObject bill, WriteBackOperateEnum op, Class<T> consumer, String source, boolean isNew) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("isNew", isNew);
        if (EmptyUtil.isEmpty((DynamicObject)bill) || EmptyUtil.isEmpty((Object)((Object)op)) || EmptyUtil.isEmpty((String)source)) {
            return null;
        }
        param.put("operate", op.getValue());
        param.put("info", bill);
        param.put("isPayScheBack", "false");
        param.put("payScheRelease", "");
        param.put("payScheOPType", "");
        param.put("delPayApplyBillIds", "");
        if (this.option != null && this.option.containsVariable("isPayScheBack") && "true".equals(this.option.getVariableValue("isPayScheBack"))) {
            param.put("isPayScheBack", "true");
            param.put("payScheRelease", this.option.getVariableValue("payScheRelease"));
            param.put("payScheOPType", this.option.getVariableValue("payScheOPType"));
            param.put("delPayApplyBillIds", this.option.getVariableValue("delPayApplyBillIds"));
        }
        String message = "";
        try {
            Object obj = WriteBackTaskHelper.addRealtimeTask(bill, source, op, consumer, param);
            if (CasHelper.isEmpty((Object)obj)) {
                return null;
            }
            if (obj instanceof OperationResult) {
                OperationResult operationResult = (OperationResult)obj;
                List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                StringBuilder buf = new StringBuilder();
                int len = allErrorOrValidateInfo.size();
                for (int i = 0; i < 5 && i < len; ++i) {
                    buf.append(((IOperateInfo)allErrorOrValidateInfo.get(i)).getMessage());
                }
                message = buf.toString();
            } else {
                message = String.valueOf(obj);
            }
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        if (EmptyUtil.isNoEmpty((String)message)) {
            return message;
        }
        return null;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    static final class Singleton {
        private static WriteBackServiceImpl instance = new WriteBackServiceImpl();

        Singleton() {
        }
    }
}

