/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.cas.business.service.freeze;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.cas.business.paysche.bean.RpcStatus;
import kd.fi.cas.business.service.bean.freeze.FreezeDetailInfo;
import kd.fi.cas.business.service.bean.freeze.FreezeDetailResult;
import kd.fi.cas.business.service.bean.freeze.FreezeInfo;
import kd.fi.cas.business.service.bean.freeze.FreezeOperate;
import kd.fi.cas.business.service.bean.freeze.FreezeResult;
import kd.fi.cas.business.service.freeze.FreezeServiceFacade;
import kd.fi.cas.enums.BillStatusEnum;
import kd.fi.cas.errorcode.TmcErrorCode;
import kd.fi.cas.helper.MutexServiceHelper;

public abstract class AbstractFreezeService
implements FreezeServiceFacade {
    public static final String OP_FREEZE = "freeze";
    protected Map<Long, Long> sourceBillInfoMap = new HashMap<Long, Long>(10);
    protected Map<Long, String> sourceBillNoMap = new HashMap<Long, String>(10);
    protected Set<Long> sourceBillEntryIds = new HashSet<Long>(10);
    protected Map<Long, BigDecimal> sourceBillOpAmtMap = new HashMap<Long, BigDecimal>(10);
    protected Map<Long, BigDecimal> freezeLeftAmtMap = new HashMap<Long, BigDecimal>(10);
    protected Map<Long, List<String>> sourceBillErrInfoMap = new HashMap<Long, List<String>>(10);

    @Override
    public FreezeResult operate() {
        FreezeResult result;
        block18: {
            DynamicObject[] sourceBills;
            result = new FreezeResult(RpcStatus.SUCCESS);
            FreezeInfo freezeInfo = this.getFreezeInfo();
            List<FreezeDetailInfo> infoDetails = freezeInfo.getDetails();
            if (infoDetails == null || infoDetails.size() <= 0) {
                return result;
            }
            ArrayList<Long> sourceBillIds = new ArrayList<Long>(infoDetails.size());
            for (FreezeDetailInfo freezeDetailInfo : infoDetails) {
                this.sourceBillEntryIds.add(freezeDetailInfo.getBillEntryId());
                this.sourceBillInfoMap.put(freezeDetailInfo.getBillEntryId(), freezeDetailInfo.getBillId());
                this.freezeLeftAmtMap.put(freezeDetailInfo.getBillEntryId(), freezeDetailInfo.getFreezeAmt());
                sourceBillIds.add(freezeDetailInfo.getBillId());
            }
            for (DynamicObject sourceBill : sourceBills = BusinessDataServiceHelper.load((String)freezeInfo.getEntityName(), (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)})) {
                this.sourceBillNoMap.put(sourceBill.getLong("id"), sourceBill.getString("billno"));
            }
            QFilter qFilter = new QFilter(this.getSourceBillTypeFieldName(), "=", (Object)freezeInfo.getEntityName());
            QFilter sourceEntryFilter = new QFilter("entry." + this.getSourceBillIdFieldName(), "in", this.sourceBillEntryIds);
            QFilter billStatusFilter = new QFilter("billstatus", "in", (Object)new String[]{BillStatusEnum.SAVE.getValue(), BillStatusEnum.SUBMIT.getValue(), BillStatusEnum.AUDIT.getValue(), BillStatusEnum.BEING.getValue()});
            CharSequence[] selProps = new String[]{"id", "billno", this.getSourceBillIdFieldName()};
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)String.join((CharSequence)",", selProps), (QFilter[])new QFilter[]{qFilter, sourceEntryFilter, billStatusFilter});
            if (targetBills != null && targetBills.length > 0) {
                List<String> requestIds = this.batchLock(targetBills);
                List<Object> requestIdList = requestIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                try {
                    targetBills = BusinessDataServiceHelper.load((Object[])requestIdList.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)this.getEntityName()));
                    FreezeOperate operate = freezeInfo.getOperate();
                    if (operate == FreezeOperate.freezeValidate) {
                        FreezeResult freezeResult = this.freezeValidate(targetBills);
                        return freezeResult;
                    }
                    if (operate == FreezeOperate.freeze) {
                        FreezeResult valiResult = this.freezeValidate(targetBills);
                        if (!freezeInfo.isPartSuccFlag() && valiResult.getStatus() == RpcStatus.ERROR) {
                            FreezeResult freezeResult = valiResult;
                            return freezeResult;
                        }
                        this.freeze(targetBills);
                        break block18;
                    }
                    if (operate == FreezeOperate.unfreeze) {
                        this.unfreeze(targetBills);
                        break block18;
                    }
                    FreezeResult valiResult = new FreezeResult(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u6807\u8bc6\uff1a", (String)"AbstractFreezeService_0", (String)"fi-cas-business", (Object[])new Object[0]), new Object[]{operate}));
                    return valiResult;
                }
                catch (Exception e) {
                    throw e;
                }
                finally {
                    MutexServiceHelper.batchRelease(requestIds, (String)this.getEntityName(), (String)OP_FREEZE);
                }
            }
        }
        ArrayList<FreezeDetailResult> resultDetails = new ArrayList<FreezeDetailResult>(this.sourceBillEntryIds.size());
        for (Long sourceBillEntryId : this.sourceBillEntryIds) {
            FreezeDetailResult resultDetail = new FreezeDetailResult();
            List<String> errors = this.sourceBillErrInfoMap.get(sourceBillEntryId);
            if (errors != null && errors.size() > 0) {
                resultDetail.setStatus(RpcStatus.ERROR);
                resultDetail.setErrMsg(String.join((CharSequence)"", errors));
            } else {
                resultDetail.setStatus(RpcStatus.SUCCESS);
                BigDecimal freezeAmt = this.sourceBillOpAmtMap.get(sourceBillEntryId);
                resultDetail.setFreezeAmt(freezeAmt == null ? BigDecimal.ZERO : freezeAmt);
            }
            resultDetail.setBillEntryId(sourceBillEntryId);
            resultDetail.setBillId(this.sourceBillInfoMap.get(sourceBillEntryId));
            resultDetails.add(resultDetail);
        }
        result.setDetails(resultDetails);
        return result;
    }

    private List<String> batchLock(DynamicObject[] targetBills) {
        ArrayList<String> requestIds = new ArrayList<String>();
        List targetBillIds = Arrays.stream(targetBills).map(DataEntityBase::getPkValue).map(String::valueOf).collect(Collectors.toList());
        Map request = MutexServiceHelper.batchRequest(targetBillIds, (String)this.getEntityName(), (String)OP_FREEZE);
        for (Map.Entry lockEntry : request.entrySet()) {
            String id = (String)lockEntry.getKey();
            Boolean value = (Boolean)lockEntry.getValue();
            for (DynamicObject info : targetBills) {
                if (!info.getString("id").equals(id)) continue;
                if (!value.booleanValue()) {
                    DynamicObjectCollection entry = info.getDynamicObjectCollection("entry");
                    for (DynamicObject row : entry) {
                        long sourceBillEntryId = row.getLong(this.getSourceBillIdFieldName());
                        if (!this.sourceBillEntryIds.contains(sourceBillEntryId)) continue;
                        String errInfo = new TmcErrorCode().BILL_MUTEX_LOCK_WITH_NUMBER(info.getString("billno")).getMessage() + "\uff1b";
                        List<String> errors = this.sourceBillErrInfoMap.get(sourceBillEntryId);
                        if (errors == null) {
                            errors = new ArrayList<String>(10);
                        }
                        errors.add(errInfo);
                        this.sourceBillErrInfoMap.put(sourceBillEntryId, errors);
                    }
                    continue;
                }
                requestIds.add(id);
            }
        }
        return requestIds;
    }

    abstract String getEntityName();

    abstract String getSourceBillIdFieldName();

    abstract String getSourceBillTypeFieldName();
}

